/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.gwt.AbstractGwtModuleMojo;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseMojo
extends AbstractGwtModuleMojo {
    private File outputDirectory;
    private String additionalPageParameters;
    protected ArchiverManager archiverManager;
    private File gwtDevJarPath;

    public void setAdditionalPageParameters(String parameters) {
        this.additionalPageParameters = StringUtils.replace((String)parameters, (String)"&", (String)"&amp;");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.unpackNativeLibraries();
        for (String module : this.getModules()) {
            this.createLaunchConfigurationForHostedModeBrowser(module);
        }
    }

    protected void unpackNativeLibraries() throws MojoFailureException {
        URLClassLoader cl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URL[] urls = cl.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].getFile().endsWith(".zip")) continue;
            File file = new File(urls[i].getFile());
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
                unArchiver.setSourceFile(file);
                unArchiver.setDestDirectory(file.getParentFile());
                unArchiver.extract();
                unArchiver.setOverwrite(false);
                this.getLog().info((CharSequence)"Unpack native libraries required to run hosted browser");
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Failed to unpack native libraries required to run hosted browser");
            }
            break;
        }
    }

    private void createLaunchConfigurationForHostedModeBrowser(String module) throws MojoExecutionException {
        File launchFile = new File(this.getProject().getBasedir(), module + ".launch");
        if (launchFile.exists()) {
            return;
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(EclipseMojo.class, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        List<String> sources = this.getProjectSourceDirectories();
        context.put("sources", sources);
        context.put("module", module);
        int idx = module.lastIndexOf(46);
        String page = module.substring(idx + 1) + ".html";
        if (this.additionalPageParameters != null) {
            page = page + "?" + this.additionalPageParameters;
        }
        context.put("page", page);
        int basedir = this.getProject().getBasedir().getAbsolutePath().length();
        context.put("out", this.outputDirectory.getAbsolutePath().substring(basedir + 1));
        context.put("project", this.getProjectName());
        File path = this.getPlatformDependentGWTDevJar();
        context.put("gwtDevJarPath", path.getAbsolutePath());
        try {
            FileWriter configWriter = new FileWriter(launchFile);
            Template template = cfg.getTemplate("launch.fm");
            template.process(context, (Writer)configWriter);
            ((Writer)configWriter).flush();
            ((Writer)configWriter).close();
            this.getLog().info((CharSequence)("Write launch configuration for GWT module : " + launchFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to write launch configuration", (Exception)ioe);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Unable to merge freemarker template", (Exception)((Object)te));
        }
    }

    protected List<String> getProjectSourceDirectories() {
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(this.getProject().getBuild().getSourceDirectory());
        if (this.generateDirectory.exists()) {
            sources.add(this.generateDirectory.getAbsolutePath());
        }
        return sources;
    }

    protected String getProjectName() {
        File dotProject = new File(this.getProject().getBasedir(), ".project");
        try {
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new FileReader(dotProject));
            return dom.getChild("name").getValue();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Failed to read the .project file");
            return this.getProject().getArtifactId();
        }
    }

    protected File getPlatformDependentGWTDevJar() {
        if (this.gwtDevJarPath == null) {
            URLClassLoader cl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
            URL[] urls = cl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                if (urls[i].getFile().indexOf("gwt-dev") < 0 || !urls[i].getFile().endsWith(".jar")) continue;
                this.gwtDevJarPath = new File(urls[i].getFile());
                break;
            }
            if (this.gwtDevJarPath == null) {
                this.getLog().error((CharSequence)"Failed to retrieve the path of gwt-dev-XX.jar");
            } else {
                this.getLog().info((CharSequence)("gwt-dev-XX.jar found at " + this.gwtDevJarPath.getAbsolutePath()));
            }
        }
        return this.gwtDevJarPath;
    }
}

