/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.gwt.EclipseMojo;
import org.codehaus.mojo.gwt.TestTemplate;

public class EclipseTestMojo
extends EclipseMojo {
    private File testOutputDirectory;
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.unpackNativeLibraries();
        new TestTemplate(this.getProject(), this.includes, this.excludes, new TestTemplate.CallBack(){

            public void doWithTest(File sourceDir, String test) throws MojoExecutionException {
                EclipseTestMojo.this.createLaunchConfigurationForGwtTestCase(sourceDir, test);
            }
        });
    }

    private void createLaunchConfigurationForGwtTestCase(File testSrc, String test) throws MojoExecutionException {
        File testFile = new File(testSrc, test);
        String fqcn = test.replace(File.separatorChar, '.').substring(0, test.lastIndexOf(46));
        File launchFile = new File(this.getProject().getBasedir(), fqcn + ".launch");
        if (launchFile.exists() && launchFile.lastModified() > testFile.lastModified()) {
            return;
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(EclipseTestMojo.class, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        List<String> sources = this.getProjectSourceDirectories();
        sources.add(0, testSrc.getAbsolutePath());
        context.put("sources", sources);
        context.put("test", fqcn);
        int basedir = this.getProject().getBasedir().getAbsolutePath().length();
        context.put("out", this.testOutputDirectory.getAbsolutePath().substring(basedir + 1));
        context.put("project", this.getProjectName());
        context.put("gwtDevJarPath", this.getPlatformDependentGWTDevJar().getAbsolutePath());
        try {
            FileWriter configWriter = new FileWriter(launchFile);
            Template template = cfg.getTemplate("test-launch.fm");
            template.process(context, (Writer)configWriter);
            ((Writer)configWriter).flush();
            ((Writer)configWriter).close();
            this.getLog().info((CharSequence)("Write launch configuration for GWT test : " + launchFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to write launch configuration", (Exception)ioe);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Unable to merge freemarker template", (Exception)((Object)te));
        }
    }
}

