/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.gwt.AbstractGwtMojo;
import org.codehaus.plexus.util.DirectoryScanner;

public class GenerateAsyncMojo
extends AbstractGwtMojo {
    private String servicePattern;
    private String rpcExtension;
    private boolean failOnError;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"GenerateAsyncMojo#execute()");
        List sourceRoots = this.getProject().getCompileSourceRoots();
        boolean generated = false;
        for (String sourceRoot : sourceRoots) {
            try {
                generated |= this.scanAndGenerateAsync(new File(sourceRoot));
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Failed to generate Async interface", e);
                if (!this.failOnError) continue;
                throw new MojoExecutionException("Failed to generate Async interface", e);
            }
        }
        if (generated) {
            this.addCompileSourceRoot(this.generateDirectory);
        }
    }

    private boolean scanAndGenerateAsync(File file) throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(file);
        scanner.setIncludes(new String[]{this.servicePattern});
        scanner.scan();
        String[] sources = scanner.getIncludedFiles();
        if (sources.length == 0) {
            return false;
        }
        for (String source : sources) {
            this.generateAsync(new File(file, source), source);
        }
        return true;
    }

    private void generateAsync(File source, String name) throws Exception {
        JavaMethod[] methods;
        String[] imports;
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.getClassLibrary().addClassLoader(this.getProjectClassLoader());
        builder.addSource((Reader)new FileReader(source));
        name = name.substring(0, name.length() - 5) + "Async";
        JavaClass clazz = builder.getClasses()[0];
        JavaClass[] implemented = clazz.getImplementedInterfaces();
        boolean isRemoteService = false;
        for (JavaClass implement : implemented) {
            if (!"com.google.gwt.user.client.rpc.RemoteService".equals(implement.getFullyQualifiedName())) continue;
            isRemoteService = true;
            break;
        }
        if (!isRemoteService) {
            return;
        }
        File out = new File(this.generateDirectory, name + ".java");
        out.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(out);
        JavaSource javaSource = builder.getSources()[0];
        writer.println("package " + javaSource.getPackage() + ";");
        writer.println();
        for (String string : imports = javaSource.getImports()) {
            if ("com.google.gwt.user.client.rpc.RemoteService".equals(string)) continue;
            writer.println("import " + string + ";");
        }
        writer.println("import com.google.gwt.core.client.GWT;");
        writer.println("import com.google.gwt.user.client.rpc.AsyncCallback;");
        writer.println("import com.google.gwt.user.client.rpc.ServiceDefTarget;");
        writer.println();
        String className = clazz.getName();
        writer.println("public interface " + className + "Async");
        writer.println("{");
        for (JavaMethod method : methods = clazz.getMethods()) {
            writer.println("");
            writer.println("    /**");
            writer.println("     * GWT-RPC service  asynchronous (client-side) interface");
            writer.println("     * @see " + clazz.getFullyQualifiedName());
            writer.println("     */");
            writer.print("    void " + method.getName() + "( ");
            JavaParameter[] params = method.getParameters();
            for (int j = 0; j < params.length; ++j) {
                JavaParameter param = params[j];
                if (j > 0) {
                    writer.print(", ");
                }
                writer.print(param.getType().getJavaClass().getName() + " " + param.getName());
            }
            if (params.length > 0) {
                writer.print(", ");
            }
            if (method.getReturns().isVoid()) {
                writer.println("AsyncCallback<Void> callback );");
            } else {
                writer.println("AsyncCallback<" + method.getReturns().getJavaClass().getName() + "> callback );");
            }
            writer.println();
        }
        writer.println();
        writer.println("    /**");
        writer.println("     * Utility class to get the RPC Async interface from client-side code");
        writer.println("     */");
        writer.println("    public static class Util ");
        writer.println("    { ");
        writer.println("        private static " + className + "Async instance;");
        writer.println();
        writer.println("        public static " + className + "Async getInstance()");
        writer.println("        {");
        writer.println("            if ( instance == null )");
        writer.println("            {");
        writer.println("                instance = (" + className + "Async) GWT.create( " + className + ".class );");
        writer.println("                ServiceDefTarget target = (ServiceDefTarget) instance;");
        writer.print("                target.setServiceEntryPoint( GWT.getModuleBaseURL() + \"" + className + "\"");
        if (this.rpcExtension != null && this.rpcExtension.length() > 0) {
            writer.print(" + " + this.rpcExtension);
        }
        writer.println(" );");
        writer.println("            }");
        writer.println("            return instance;");
        writer.println("        }");
        writer.println("    }");
        writer.println("}");
        writer.close();
    }
}

