/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.surefire.booter.output.ForkingStreamConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.StandardOutputConsumer;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.CommandLineUtils;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.Commandline;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.mojo.gwt.AbstractGwtMojo;
import org.codehaus.plexus.util.StringUtils;

public class I18NCreatorMojo
extends AbstractGwtMojo {
    private String[] resourceBundles;
    private int timeOut;
    private String resourceBundle;
    private boolean constantsWithLookup;
    private boolean messages;

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundles = new String[]{resourceBundle};
    }

    public void execute() throws MojoExecutionException {
        for (String bundle : this.resourceBundles) {
            this.runI18NSync(bundle);
        }
    }

    private void runI18NSync(String bundle) throws MojoExecutionException {
        URL[] pluginClasspath;
        this.getLog().info((CharSequence)("Running I18NSync to generate message bundles from " + bundle));
        String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.addAll(this.getProject().getCompileSourceRoots());
        List resources = this.getProject().getResources();
        for (Resource resource : resources) {
            classpath.add(resource.getDirectory());
        }
        for (URL url : pluginClasspath = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs()) {
            classpath.add(url.getFile());
        }
        try {
            Commandline cli = new Commandline();
            cli.setExecutable(jvm);
            cli.createArg(false).setLine("-classpath");
            cli.createArg(false).setLine(StringUtils.join(classpath.iterator(), (String)File.pathSeparator));
            cli.createArg(false).setLine("com.google.gwt.i18n.tools.I18NSync");
            cli.createArg(false).setLine("-out");
            File file = new File(this.generateDirectory, bundle.replace('.', File.separatorChar));
            file.getParentFile().mkdirs();
            cli.createArg(false).setLine(this.generateDirectory.getAbsolutePath());
            if (this.constantsWithLookup) {
                cli.createArg(false).setLine("-createConstantsWithLookup");
            }
            if (this.messages) {
                cli.createArg(false).setLine("-createMessages");
            }
            cli.createArg(false).setLine(bundle);
            this.getLog().debug((CharSequence)("execute : " + cli.toString()));
            ForkingStreamConsumer systemOut = new ForkingStreamConsumer((OutputConsumer)new StandardOutputConsumer());
            ForkingStreamConsumer systemErr = new ForkingStreamConsumer((OutputConsumer)new StandardOutputConsumer());
            int status = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)systemOut, (StreamConsumer)systemErr, (int)this.timeOut);
            if (status != 0) {
                throw new MojoExecutionException("Failed to run I18NSync : returned " + status);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run I18NSync", e);
        }
    }
}

