/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.gwt.AbstractGwtMojo;
import org.codehaus.mojo.gwt.GwtModule;
import org.codehaus.mojo.gwt.GwtModuleReader;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public abstract class AbstractGwtModuleMojo
extends AbstractGwtMojo
implements GwtModuleReader {
    public static final String GWT_MODULE_EXTENSION = ".gwt.xml";
    private String[] modules;
    private String module;

    public String[] getModules() {
        if (this.module != null) {
            return new String[]{this.module};
        }
        if (this.modules == null) {
            HashSet<String> mods = new HashSet<String>();
            List sourcePaths = this.getProject().getCompileSourceRoots();
            for (String sourcePath : sourcePaths) {
                File sourceDirectory = new File(sourcePath);
                if (!sourceDirectory.exists()) continue;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(sourceDirectory.getAbsolutePath());
                scanner.setIncludes(new String[]{"**/*.gwt.xml"});
                scanner.scan();
                mods.addAll(Arrays.asList(scanner.getIncludedFiles()));
            }
            List resources = this.getProject().getResources();
            for (Resource resource : resources) {
                File resourceDirectoryFile = new File(resource.getDirectory());
                if (!resourceDirectoryFile.exists()) continue;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(resource.getDirectory());
                scanner.setIncludes(new String[]{"**/*.gwt.xml"});
                scanner.scan();
                mods.addAll(Arrays.asList(scanner.getIncludedFiles()));
            }
            if (mods.isEmpty()) {
                this.getLog().warn((CharSequence)"GWT plugin is configured to detect modules, but none where found.");
            }
            this.modules = new String[mods.size()];
            int i = 0;
            for (String fileName : mods) {
                String path = fileName.substring(0, fileName.length() - GWT_MODULE_EXTENSION.length());
                this.modules[i++] = path.replace(File.separatorChar, '.');
            }
            if (this.modules.length > 0) {
                this.getLog().info((CharSequence)("auto discovered modules " + Arrays.asList(this.modules)));
            }
        }
        return this.modules;
    }

    public GwtModule readModule(String name) throws MojoExecutionException {
        String modulePath = name.replace('.', '/') + GWT_MODULE_EXTENSION;
        List sourceRoots = this.getProject().getCompileSourceRoots();
        for (String sourceRoot : sourceRoots) {
            File root = new File(sourceRoot);
            File xml = new File(root, modulePath);
            if (!xml.exists()) continue;
            this.getLog().debug((CharSequence)("GWT module " + name + " found in " + root));
            return this.readModule(name, xml);
        }
        List resources = this.getProject().getResources();
        for (Resource resource : resources) {
            File root = new File(resource.getDirectory());
            File xml = new File(root, modulePath);
            if (!xml.exists()) continue;
            this.getLog().debug((CharSequence)("GWT module " + name + " found in " + root));
            return this.readModule(name, xml);
        }
        try {
            Collection<File> classpath = this.classpathBuilder.buildClasspathList(this.getProject(), "compile", null, this.getProjectArtifacts());
            URL[] urls = new URL[classpath.size()];
            int i = 0;
            for (File file : classpath) {
                urls[i++] = file.toURI().toURL();
            }
            InputStream stream = new URLClassLoader(urls).getResourceAsStream(modulePath);
            if (stream != null) {
                return this.readModule(name, stream);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        throw new MojoExecutionException("GWT Module " + name + " not found in project sources or resources.");
    }

    private GwtModule readModule(String name, File file) throws MojoExecutionException {
        try {
            return this.readModule(name, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to read module file " + file);
        }
    }

    private GwtModule readModule(String name, InputStream xml) throws MojoExecutionException {
        try {
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((InputStream)xml));
            return new GwtModule(name, dom, this);
        }
        catch (Exception e) {
            String error = "Failed to read module XML file " + xml;
            this.getLog().error((CharSequence)error);
            throw new MojoExecutionException(error, e);
        }
    }

    protected void addCompileSourceRoot(File path) {
        this.getProject().addCompileSourceRoot(path.getAbsolutePath());
    }
}

