/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.eclipse;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.AbstractGwtModuleMojo;
import org.codehaus.mojo.gwt.EmbeddedServer;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.eclipse.EclipseUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class EclipseMojo
extends AbstractGwtModuleMojo {
    private EclipseUtil eclipseUtil;
    private String extraJvmArgs;
    private MavenProject executedProject;
    private File buildOutputDirectory;
    private File hostedWebapp;
    private String additionalPageParameters;
    private boolean noserver;
    private int port;
    private String whitelist;
    private String blacklist;
    private String bindAddress;
    private boolean useGoogleEclispePlugin;

    public void setAdditionalPageParameters(String parameters) {
        this.additionalPageParameters = StringUtils.replace((String)parameters, (String)"&", (String)"&amp;");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        GwtRuntime runtime = this.getGwtRuntime();
        if (!this.noserver && runtime.getVersion().getEmbeddedServer() == EmbeddedServer.JETTY) {
            this.setupExplodedWar();
        } else {
            this.getLog().info((CharSequence)"noServer is set! Skipping exploding war file...");
        }
        for (String module : this.getModules()) {
            this.createLaunchConfigurationForHostedModeBrowser(runtime, module);
        }
    }

    protected void setupExplodedWar() throws MojoExecutionException {
        try {
            File classes = new File(this.hostedWebapp, "WEB-INF/classes");
            if (!this.buildOutputDirectory.getAbsolutePath().equals(classes.getAbsolutePath())) {
                this.getLog().warn((CharSequence)"Your POM <build><outputdirectory> must match your hosted webapp WEB-INF/classes folder for GWT Hosted browser to see your classes.");
            }
            File lib = new File(this.hostedWebapp, "WEB-INF/lib");
            this.getLog().info((CharSequence)("create exploded Jetty webapp in " + this.hostedWebapp));
            lib.mkdirs();
            List artifacts = this.getProject().getRuntimeArtifacts();
            for (Artifact artifact : artifacts) {
                if (artifact.getFile().isDirectory()) continue;
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)lib);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to create Jetty exploded webapp", (Exception)ioe);
        }
    }

    private void createLaunchConfigurationForHostedModeBrowser(GwtRuntime runtime, String module) throws MojoExecutionException {
        String args;
        File launchFile = new File(this.getProject().getBasedir(), this.readModule(module).getPath() + ".launch");
        if (launchFile.exists()) {
            this.getLog().info((CharSequence)("launch file exists " + launchFile.getName() + " skip generation "));
            return;
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(EclipseMojo.class, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        LinkedList<String> sources = new LinkedList<String>(this.executedProject.getCompileSourceRoots());
        List resources = this.executedProject.getResources();
        for (Resource resource : resources) {
            sources.add(resource.getDirectory());
        }
        context.put("sources", sources);
        context.put("module", module);
        context.put("runtime", runtime);
        context.put("localRepository", this.localRepository.getBasedir());
        int idx = module.lastIndexOf(46);
        String page = module.substring(idx + 1) + ".html";
        if (this.additionalPageParameters != null) {
            page = page + "?" + this.additionalPageParameters;
        }
        context.put("modulePath", this.readModule(module).getPath());
        context.put("page", page);
        int basedir = this.getProject().getBasedir().getAbsolutePath().length();
        context.put("out", this.getOutputDirectory().getAbsolutePath().substring(basedir + 1));
        context.put("war", this.hostedWebapp.getAbsolutePath().substring(basedir + 1));
        String string = args = this.noserver ? "-noserver -port " + this.port : "";
        if (this.blacklist != null) {
            args = args + " -blacklist " + this.blacklist;
        }
        if (this.whitelist != null) {
            args = args + " -whitelist " + this.whitelist;
        }
        if (this.bindAddress != null) {
            args = args + " -bindAddress " + this.bindAddress;
        }
        context.put("additionalArguments", args);
        context.put("extraJvmArgs", this.getExtraJvmArgs());
        context.put("project", this.eclipseUtil.getProjectName(this.getProject()));
        context.put("gwtDevJarPath", runtime.getGwtDevJar().getAbsolutePath().replace('\\', '/'));
        try {
            XmlStreamWriter configWriter = WriterFactory.newXmlWriter((File)launchFile);
            String templateName = this.useGoogleEclispePlugin ? "google.fm" : "launch.fm";
            Template template = cfg.getTemplate(templateName, "UTF-8");
            template.process(context, (Writer)configWriter);
            configWriter.flush();
            configWriter.close();
            this.getLog().info((CharSequence)("Write launch configuration for GWT module : " + launchFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to write launch configuration", (Exception)ioe);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Unable to merge freemarker template", (Exception)((Object)te));
        }
    }

    protected String getExtraJvmArgs() {
        String extra = this.extraJvmArgs;
        try {
            if (Os.isFamily((String)"mac") && !this.extraJvmArgs.contains("-XstartOnFirstThread") && !this.getGwtRuntime().getVersion().supportOOPHM()) {
                this.getLog().debug((CharSequence)("Adding -XstartOnFirstThread because of version: " + (Object)((Object)this.getGwtRuntime().getVersion()) + " and os:" + "mac"));
                extra = extra + " -XstartOnFirstThread";
            }
        }
        catch (MojoExecutionException ex) {
            throw new RuntimeException(ex);
        }
        return extra;
    }
}

