/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.gwt.AbstractGwtModuleMojo;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.shell.ForkedProcessExecutionException;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGwtShellMojo
extends AbstractGwtModuleMojo {
    private File gen;
    private String logLevel;
    private String style;
    private String extraJvmArgs;
    private String jvm;
    private int timeOut;
    protected StreamConsumer out = new StreamConsumer(){

        public void consumeLine(String line) {
            AbstractGwtShellMojo.this.getLog().info((CharSequence)line);
        }
    };
    protected StreamConsumer err = new StreamConsumer(){

        public void consumeLine(String line) {
            AbstractGwtShellMojo.this.getLog().error((CharSequence)line);
        }
    };

    public final void execute() throws MojoExecutionException, MojoFailureException {
        GwtRuntime runtime = this.getGwtRuntime();
        this.doExecute(runtime);
    }

    protected abstract void doExecute(GwtRuntime var1) throws MojoExecutionException, MojoFailureException;

    public String getExtraJvmArgs() {
        String extra = this.extraJvmArgs;
        try {
            if (Os.isFamily((String)"mac") && !this.extraJvmArgs.contains("-XstartOnFirstThread") && !this.getGwtRuntime().getVersion().supportOOPHM()) {
                this.getLog().debug((CharSequence)("Adding -XstartOnFirstThread because of version: " + (Object)((Object)this.getGwtRuntime().getVersion()) + " and os:" + "mac"));
                extra = extra + " -XstartOnFirstThread";
            }
        }
        catch (MojoExecutionException ex) {
            throw new RuntimeException(ex);
        }
        return extra;
    }

    public File getGen() {
        return this.gen;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getStyle() {
        return this.style;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    protected void postProcessClassPath(Collection<File> classpath) {
    }

    private List<String> getJvmArgs() {
        ArrayList<String> extra = new ArrayList<String>();
        String userExtraJvmArgs = this.getExtraJvmArgs();
        if (userExtraJvmArgs != null) {
            for (String extraArg : userExtraJvmArgs.split(" ")) {
                extra.add(extraArg);
            }
        }
        try {
            if (Os.isFamily((String)"mac") && !this.extraJvmArgs.contains("-XstartOnFirstThread") && !this.getGwtRuntime().getVersion().supportOOPHM()) {
                this.getLog().debug((CharSequence)("Adding -XstartOnFirstThread because of version: " + (Object)((Object)this.getGwtRuntime().getVersion()) + " and os:" + "mac"));
                extra.add("-XstartOnFirstThread");
            }
        }
        catch (MojoExecutionException ex) {
            throw new RuntimeException(ex);
        }
        return extra;
    }

    private String getJavaCommand() throws MojoExecutionException {
        File jvmFile;
        if (StringUtils.isEmpty((String)this.jvm)) {
            this.jvm = System.getProperty("java.home");
        }
        if (!(jvmFile = new File(this.jvm)).exists()) {
            throw new MojoExecutionException("the configured jvm " + this.jvm + " doesn't exists please check your environnement");
        }
        if (jvmFile.isDirectory()) {
            return jvmFile.getAbsolutePath() + File.separator + "bin" + File.separator + "java";
        }
        return this.jvm;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public class JavaCommand {
        private String className;
        private GwtRuntime runtime;
        private List<File> classpath = new LinkedList<File>();
        private List<String> args = new ArrayList<String>();
        private Properties systemProperties = new Properties();
        private Properties env = new Properties();

        public JavaCommand(String className, GwtRuntime runtime) {
            this.className = className;
            this.runtime = runtime;
        }

        public JavaCommand withinScope(String scope) throws MojoExecutionException {
            this.classpath.addAll(AbstractGwtShellMojo.this.classpathBuilder.buildClasspathList(AbstractGwtShellMojo.this.getProject(), scope, this.runtime, AbstractGwtShellMojo.this.getProjectArtifacts()));
            AbstractGwtShellMojo.this.postProcessClassPath(this.classpath);
            return this;
        }

        public JavaCommand withinClasspath(File ... path) {
            for (File file : path) {
                this.classpath.add(file);
            }
            return this;
        }

        public JavaCommand arg(String arg) {
            this.args.add(arg);
            return this;
        }

        public JavaCommand arg(boolean condition, String arg) {
            if (condition) {
                this.args.add(arg);
            }
            return this;
        }

        public JavaCommand systemProperty(String name, String value) {
            this.systemProperties.setProperty(name, value);
            return this;
        }

        public JavaCommand environment(String name, String value) {
            this.env.setProperty(name, value);
            return this;
        }

        public void execute() throws MojoExecutionException {
            ArrayList<String> command = new ArrayList<String>();
            command.addAll(AbstractGwtShellMojo.this.getJvmArgs());
            command.add("-classpath");
            ArrayList<String> path = new ArrayList<String>(this.classpath.size());
            for (File file : this.classpath) {
                path.add(file.getAbsolutePath());
            }
            command.add(StringUtils.join(path.iterator(), (String)File.pathSeparator));
            if (this.systemProperties != null) {
                for (Map.Entry entry : this.systemProperties.entrySet()) {
                    command.add("-D" + entry.getKey() + "=" + entry.getValue());
                }
            }
            command.add(this.className);
            command.addAll(this.args);
            try {
                String[] arguments = command.toArray(new String[command.size()]);
                Commandline commandline = Os.isFamily((String)"windows") ? new Commandline((Shell)new JavaShell()) : new Commandline();
                commandline.setExecutable(AbstractGwtShellMojo.this.getJavaCommand());
                commandline.addArguments(arguments);
                if (this.env != null) {
                    for (Map.Entry<Object, Object> entry : this.env.entrySet()) {
                        commandline.addEnvironment((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                AbstractGwtShellMojo.this.getLog().debug((CharSequence)("Execute command :\n" + commandline.toString()));
                int status = AbstractGwtShellMojo.this.timeOut > 0 ? CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)AbstractGwtShellMojo.this.out, (StreamConsumer)AbstractGwtShellMojo.this.err, (int)AbstractGwtShellMojo.this.timeOut) : CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)AbstractGwtShellMojo.this.out, (StreamConsumer)AbstractGwtShellMojo.this.err);
                if (status != 0) {
                    throw new ForkedProcessExecutionException("Command [[\n" + commandline.toString() + "\n]] failed with status " + status);
                }
            }
            catch (CommandLineTimeOutException e) {
                if (AbstractGwtShellMojo.this.timeOut > 0) {
                    AbstractGwtShellMojo.this.getLog().warn((CharSequence)("Forked JVM has been killed on time-out after " + AbstractGwtShellMojo.this.timeOut + " seconds"));
                    return;
                }
                throw new MojoExecutionException("Time-out on command line execution :\n" + command);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to execute command line :\n" + command);
            }
        }

        public void withinClasspathFirst(File oophmJar) {
            this.classpath.add(0, oophmJar);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaShell
    extends Shell {
        private JavaShell() {
        }

        protected List<String> getRawCommandLine(String executable, String[] arguments) {
            ArrayList<String> commandLine = new ArrayList<String>();
            if (executable != null) {
                commandLine.add(executable);
            }
            for (String arg : arguments) {
                if (this.isQuotedArgumentsEnabled()) {
                    char[] escapeChars = this.getEscapeChars(this.isSingleQuotedExecutableEscaped(), this.isDoubleQuotedExecutableEscaped());
                    commandLine.add(StringUtils.quoteAndEscape((String)arg, (char)this.getArgumentQuoteDelimiter(), (char[])escapeChars, (char[])this.getQuotingTriggerChars(), (char)'\\', (boolean)false));
                    continue;
                }
                commandLine.add(arg);
            }
            return commandLine;
        }
    }
}

