package org.codehaus.mojo.gwt.shell;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on gwt-maven-plugin.<br/> Call <pre>  mvn gwt:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Dec 03 21:08:41 CET 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:gwt-maven-plugin:2.1.0-1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven GWT Plugin", 0 );
        append( sb, "Maven plugin for the Google Web Toolkit.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 18 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "browser".equals( goal ) )
        {
            append( sb, "gwt:browser", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "browser (Default: C:\\Program Files\\Internet Explorer\\iexplore.exe)", 2 );
                append( sb, "Path to the browser executable.", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "server (Default: ie)", 2 );
                append( sb, "Name of the BrowserManagerServer to lauch (typically, \'ie8\')", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "webXml (Default: ${basedir}/src/main/webapp/WEB-INF/web.xml)", 2 );
                append( sb, "Source web.xml deployment descriptor that is used for GWT shell and for deployment WAR to \'merge\' servlet entries.", 3 );
                append( sb, "", 0 );

                append( sb, "webXmlServletPathAsIs (Default: false)", 2 );
                append( sb, "Specifies whether or not to add the module name as a prefix to the servlet path when merging web.xml. If you set this to false the exact path from the GWT module will be used, nothing else will be prepended.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "clean".equals( goal ) )
        {
            append( sb, "gwt:clean", 0 );
            append( sb, "Cleanup the webapp directory for GWT module compilation output", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile".equals( goal ) )
        {
            append( sb, "gwt:compile", 0 );
            append( sb, "Invokes the GWTCompiler for the project source. See compiler options : http://code.google.com/intl/fr-FR/webtoolkit/doc/latest/DevGuideCompilingAndDebugging.html#DevGuideCompilerOptions", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "compileReport (Default: false)", 2 );
                append( sb, "add -compileReport parameter to the compiler command line\nCan be set from command line using \'-Dgwt.compiler.compileReport=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compileSourcesArtifacts", 2 );
                append( sb, "Artifacts to be included as source-jars in GWTCompiler Classpath. Removes the restriction that source code must be bundled inside of the final JAR when dealing with external utility libraries not designed exclusivelly for GWT. The plugin will download the source.jar if necessary. This option is a workaround to avoid packaging sources inside the same JAR when splitting and application into modules. A smaller JAR can then be used on server classpath and distributed without sources (that may not be desirable).", 3 );
                append( sb, "", 0 );

                append( sb, "disableCastChecking (Default: false)", 2 );
                append( sb, "EXPERIMENTAL: Disables run-time checking of cast operations.\nCan be set from command line using \'-Dgwt.disableCastChecking=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "disableClassMetadata (Default: false)", 2 );
                append( sb, "EXPERIMENTAL: Disables some java.lang.Class methods (e.g. getName()).\nCan be set from command line using \'-Dgwt.disableClassMetadata=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "draftCompile (Default: false)", 2 );
                append( sb, "Enable faster, but less-optimized, compilations.\nCan be set from command line using \'-Dgwt.draftCompile=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "enableAssertions (Default: false)", 2 );
                append( sb, "Whether or not to enable assertions in generated scripts (-ea).", 3 );
                append( sb, "", 0 );

                append( sb, "extra (Default: ${project.build.directory}/extra)", 2 );
                append( sb, "The directory into which extra, non-deployed files will be written.", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "extraParam (Default: false)", 2 );
                append( sb, "add -extra parameter to the compiler command line\nCan be set from command line using \'-Dgwt.extraParam=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "Don\'t try to detect if GWT compilation is up-to-date and can be skipped.\nCan be set from command line using \'-Dgwt.compiler.force=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "localWorkers", 2 );
                append( sb, "On GWT 1.6+, number of parallel processes used to compile GWT premutations. Defaults to platform available processors number.\nCan be unset from command line using \'-Dgwt.compiler.localWorkers=n\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "optimizationLevel (Default: -1)", 2 );
                append( sb, "add -optimize parameter to the compiler command line the value must be between 0 and 9 by default -1 so no arg to the compiler\nCan be set from command line using \'-Dgwt.compiler.optimizationLevel=n\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "soyc (Default: false)", 2 );
                append( sb, "Deprecated. you must use compileReport option", 3 );
                append( sb, "", 0 );
                append( sb, "Ask GWT to create the Story of Your Compile (SOYC)\nCan be set from command line using \'-Dgwt.compiler.soyc=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "soycDetailed (Default: false)", 2 );
                append( sb, "add -XsoycDetailed parameter to the compiler command line\nCan be set from command line using \'-Dgwt.compiler.soycDetailed=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "strict (Default: false)", 2 );
                append( sb, "add -strict parameter to the compiler command line\nCan be set from command line using \'-Dgwt.compiler.strict=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "treeLogger (Default: false)", 2 );
                append( sb, "Logs output in a graphical tree view.\nCan be set from command line using \'-Dgwt.treeLogger=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "validateOnly (Default: false)", 2 );
                append( sb, "Validate all source code, but do not compile.\nCan be set from command line using \'-Dgwt.validateOnly=true\'.\n", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "workDir", 2 );
                append( sb, "The temp directory is used for temporary compiled files (defaults is system temp directory).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile-report".equals( goal ) )
        {
            append( sb, "gwt:compile-report", 0 );
            append( sb, "see http://code.google.com/webtoolkit/doc/latest/DevGuideCompileReport.html#Usage", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extra (Default: ${project.build.directory}/extra)", 2 );
                append( sb, "The directory into which extra, non-deployed files will be written.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "css".equals( goal ) )
        {
            append( sb, "gwt:css", 0 );
            append( sb, "Creates CSS interfaces for css files. Will use the utility tool provided in gwt sdk which create a corresponding Java interface for accessing the classnames used in the file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "cssFile", 2 );
                append( sb, "Shortcut for a single cssFile", 3 );
                append( sb, "", 0 );

                append( sb, "cssFiles", 2 );
                append( sb, "List of resourceBundles that should be used to generate CSS interfaces.", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "debug".equals( goal ) )
        {
            append( sb, "gwt:debug", 0 );
            append( sb, "Extends the gwt goal and runs the project in the GWT Hosted mode with a debugger port hook (optionally suspended).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appEngineArtifactId (Default: appengine-java-sdk)", 2 );
                append( sb, "groupId to download appengine sdk from maven repo\n", 3 );
                append( sb, "", 0 );

                append( sb, "appEngineGroupId (Default: com.google.appengine)", 2 );
                append( sb, "groupId to download appengine sdk from maven repo\n", 3 );
                append( sb, "", 0 );

                append( sb, "appEngineHome (Default: ${project.build.directory}/appengine-sdk/)", 2 );
                append( sb, "Location to find appengine sdk or to unzip downloaded one see appEngineVersion\n", 3 );
                append( sb, "", 0 );

                append( sb, "appEngineVersion (Default: 1.3.8)", 2 );
                append( sb, "set the appengine sdk to use\nArtifact will be downloaded with groupId : appEngineGroupId and artifactId appEngineArtifactId\n", 3 );
                append( sb, "", 0 );

                append( sb, "attachDebugger (Default: false)", 2 );
                append( sb, "Attach to the debugger application at the specified debugPort.", 3 );
                append( sb, "", 0 );

                append( sb, "bindAddress", 2 );
                append( sb, "Set GWT shell bindAddress.\nCan be set from command line using \'-Dgwt.bindAddress=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "blacklist", 2 );
                append( sb, "Set GWT shell protocol/host blacklist.\nCan be set from command line using \'-Dgwt.blacklist=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "buildOutputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "Location of the compiled classes.", 3 );
                append( sb, "", 0 );

                append( sb, "contextXml", 2 );
                append( sb, "Source Tomcat context.xml for GWT shell - copied to /gwt/localhost/ROOT.xml (used as the context.xml for the SHELL - requires Tomcat 5.0.x format - hence no default).", 3 );
                append( sb, "", 0 );

                append( sb, "copyWebapp (Default: false)", 2 );
                append( sb, "Copies the contents of warSourceDirectory to hostedWebapp.\nCan be set from command line using \'-Dgwt.copyWebapp=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "debugPort (Default: 8000)", 2 );
                append( sb, "Port to listen for debugger connection on.", 3 );
                append( sb, "", 0 );

                append( sb, "debugSuspend (Default: true)", 2 );
                append( sb, "Whether or not to suspend execution until a debugger connects.", 3 );
                append( sb, "", 0 );

                append( sb, "executedProject", 2 );
                append( sb, "The MavenProject executed by the \'compile\' phase", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "hostedWebapp (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location of the hosted-mode web application structure.", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "noServer (Default: false)", 2 );
                append( sb, "Prevents the embedded GWT Tomcat server from running (even if a port is specified).\nCan be set from command line using \'-Dgwt.noserver=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8888)", 2 );
                append( sb, "Runs the embedded GWT server on the specified port.", 3 );
                append( sb, "", 0 );

                append( sb, "runClasspathExcludes", 2 );
                append( sb, "List of Pattern jars to exclude from the classPath when running dev mode\n", 3 );
                append( sb, "", 0 );

                append( sb, "runTarget", 2 );
                append( sb, "URL that should be automatically opened in the GWT shell. For example com.myapp.gwt.Module/Module.html.\nWhen the host page is outside the module \'public\' folder (for example, at webapp root), the module MUST be specified (using a single <module> in configuration or by setting -Dgwt.module=..) and the runTarget parameter can only contain the host page URI.\n\nWhen the GWT module host page is part of the module \'public\' folder, the runTarget MAY define the full GWT module path (com.myapp.gwt.Module/Module.html) that will be automatically converted according to the rename-to directive into renamed/Module.html.\n", 3 );
                append( sb, "", 0 );

                append( sb, "runTimeOut", 2 );
                append( sb, "Forked process execution timeOut (in seconds). Primary used for integration-testing.", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "Specifies a different embedded web server to run (must implement ServletContainerLauncher)", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "systemProperties", 2 );
                append( sb, "List of System properties to pass when running the hosted mode.", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "tomcat (Default: ${project.build.directory}/tomcat)", 2 );
                append( sb, "Specify the location on the filesystem for the generated embedded Tomcat directory.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "webXml (Default: ${basedir}/src/main/webapp/WEB-INF/web.xml)", 2 );
                append( sb, "Source web.xml deployment descriptor that is used for GWT shell and for deployment WAR to \'merge\' servlet entries.", 3 );
                append( sb, "", 0 );

                append( sb, "webXmlServletPathAsIs (Default: false)", 2 );
                append( sb, "Specifies whether or not to add the module name as a prefix to the servlet path when merging web.xml. If you set this to false the exact path from the GWT module will be used, nothing else will be prepended.", 3 );
                append( sb, "", 0 );

                append( sb, "whitelist", 2 );
                append( sb, "Set GWT shell protocol/host whitelist.\nCan be set from command line using \'-Dgwt.whitelist=...\'\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "eclipse".equals( goal ) )
        {
            append( sb, "gwt:eclipse", 0 );
            append( sb, "Goal which creates Eclipse lauch configurations for GWT modules.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalPageParameters", 2 );
                append( sb, "Additional parameters to append to the module URL. For example, gwt-log users will set \'log_level=DEBUG\'", 3 );
                append( sb, "", 0 );

                append( sb, "bindAddress", 2 );
                append( sb, "Set GWT shell bindAddress.\nCan be set from command line using \'-Dgwt.bindAddress=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "blacklist", 2 );
                append( sb, "Set GWT shell protocol/host blacklist.\nCan be set from command line using \'-Dgwt.blacklist=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "buildOutputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "Location of the compiled classes.", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "hostedWebapp (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location of the hosted-mode web application structure.", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "noserver (Default: false)", 2 );
                append( sb, "Run without hosted mode server", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "Port of the HTTP server used when noserver is set", 3 );
                append( sb, "", 0 );

                append( sb, "useGoogleEclispePlugin (Default: true)", 2 );
                append( sb, "Setup a launch configuration for using the Google Eclipse Plugin. This is the recommended setup, as the home-made launch configuration has many limitations. This parameter is only for backward compatibility, the standard lauch configuration template will be removed in a future release.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "whitelist", 2 );
                append( sb, "Set GWT shell protocol/host whitelist.\nCan be set from command line using \'-Dgwt.whitelist=...\'\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "eclipseTest".equals( goal ) )
        {
            append( sb, "gwt:eclipseTest", 0 );
            append( sb, "Deprecated. use google eclipse plugin http://code.google.com/intl/fr-FR/eclipse/docs/users_guide.html", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Goal which creates Eclipse lauch configurations for GWTTestCases.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of ant-style exclusion patterns for GWT integration tests", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "htmlunit (Default: FF3)", 2 );
                append( sb, "Configure options to run tests with HTMLUnit. The value must descrivbe the browser emulation to be used, FF2, FF3, IE6, IE7, or IE8 (possible multiple values separated by comas).", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/GwtTest*.java,**/Gwt*Suite.java)", 2 );
                append( sb, "Comma separated list of ant-style inclusion patterns for GWT integration tests. For example, can be set to **\\/*GwtTest.java to match all test class following this naming convention. Surefire plugin may then ne configured to exclude such tests.\nIt is recommended to use a TestSuite to run GwtTests, as they require some huge setup and are very slow. Running inside a suite allow to execute the setup only once. The default value is defined with this best practice in mind.\n", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: manual)", 2 );
                append( sb, "Configure test mode. Can be set to \'manual\', \'htmlunit\', \'selenium\' or \'remoteweb\'.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: target/www-test)", 2 );
                append( sb, "output directory for code generated by GWT for tests", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "productionMode (Default: false)", 2 );
                append( sb, "run tests using production mode rather than development (a.k.a. hosted) mode.", 3 );
                append( sb, "", 0 );

                append( sb, "remoteweb", 2 );
                append( sb, "Configure options to run tests RemoteWebBrowser. The value must describe remote web URL, like \'rmi://myhost/ie8\'\nYou must start BrowserManagerServer before running tests with this option (gwt:browser).\n", 3 );
                append( sb, "", 0 );

                append( sb, "reportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2 );
                append( sb, "Directory for test reports, defaults to surefire one to match the surefire-report plugin", 3 );
                append( sb, "", 0 );

                append( sb, "selenium", 2 );
                append( sb, "Configure options to run tests with Selenium. The value must describe the Selenium Remote Control target", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Set this to \'true\' to bypass unit tests entirely. Its use is NOT RECOMMENDED, especially if you enable it using the \'maven.test.skip\' property, because maven.test.skip disables both running the tests and compiling the tests. Consider using the skipTests parameter instead.", 3 );
                append( sb, "", 0 );

                append( sb, "skipExec", 2 );
                append( sb, "DEPRECATED This old parameter is just like skipTests, but bound to the old property maven.test.skip.exec. Use -DskipTests instead; it\'s shorter.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "Set this to \'true\' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "testFailureIgnore", 2 );
                append( sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "", 0 );

                append( sb, "testOutputDirectory (Default: ${project.build.directory}/www-test)", 2 );
                append( sb, "Location of the file.", 3 );
                append( sb, "", 0 );

                append( sb, "testTimeOut (Default: 60)", 2 );
                append( sb, "Time out (in seconds) for test execution in dedicated JVM", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "webMode (Default: false)", 2 );
                append( sb, "run tests using web mode rather than developer (a.k.a. hosted) mode", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generateAsync".equals( goal ) )
        {
            append( sb, "gwt:generateAsync", 0 );
            append( sb, "Goal which generate Asyn interface.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Stop the build on error", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "Pattern for GWT service interface", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "returnRequest (Default: false)", 2 );
                append( sb, "Return a com.google.gwt.http.client.Request on async interface to allow cancellation.", 3 );
                append( sb, "", 0 );

                append( sb, "rpcPattern (Default: {0})", 2 );
                append( sb, "A (MessageFormat) Pattern to get the GWT-RPC servlet URL based on service interface name. For example to \'{0}.rpc\' if you want to map GWT-RPC calls to \'*.rpc\' in web.xml, for example when using Spring dispatch servlet to handle RPC requests.", 3 );
                append( sb, "", 0 );

                append( sb, "servicePattern (Default: **/*Service.java)", 2 );
                append( sb, "Pattern for GWT service interface", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "gwt:help", 0 );
            append( sb, "Display help information on gwt-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0gwt:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "i18n".equals( goal ) )
        {
            append( sb, "gwt:i18n", 0 );
            append( sb, "Creates I18N interfaces for constants and messages files.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "i18nConstantsBundle", 2 );
                append( sb, "Shortcut for a single i18nConstantsBundle", 3 );
                append( sb, "", 0 );

                append( sb, "i18nConstantsBundles", 2 );
                append( sb, "List of resourceBundles that should be used to generate i18n Constants interfaces.", 3 );
                append( sb, "", 0 );

                append( sb, "i18nConstantsWithLookupBundle", 2 );
                append( sb, "Shortcut for a single i18nConstantsWithLookupBundle", 3 );
                append( sb, "", 0 );

                append( sb, "i18nConstantsWithLookupBundles", 2 );
                append( sb, "List of resourceBundles that should be used to generate i18n ConstantsWithLookup interfaces.", 3 );
                append( sb, "", 0 );

                append( sb, "i18nMessagesBundle", 2 );
                append( sb, "Shortcut for a single i18nMessagesBundle", 3 );
                append( sb, "", 0 );

                append( sb, "i18nMessagesBundles", 2 );
                append( sb, "List of resourceBundles that should be used to generate i18n Messages interfaces.", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "mergewebxml".equals( goal ) )
        {
            append( sb, "gwt:mergewebxml", 0 );
            append( sb, "Merges GWT servlet elements into deployment descriptor (and non GWT servlets into shell).\nIf you use scanRemoteServiceRelativePathAnnotation you must bind this mojo to at least compile phase Because the classpath scanner need to see compile classes\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "mergedWebXml (Default: ${project.build.directory}/web.xml)", 2 );
                append( sb, "Location on filesystem where merged web.xml will be created. The maven-war-plugin must be configured to use this path as webXml parameter", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "packageNamePerModule", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "scanRemoteServiceRelativePathAnnotation (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "webXml (Default: ${basedir}/src/main/webapp/WEB-INF/web.xml)", 2 );
                append( sb, "Source web.xml deployment descriptor that is used for GWT shell and for deployment WAR to \'merge\' servlet entries.", 3 );
                append( sb, "", 0 );

                append( sb, "webXmlServletPathAsIs (Default: false)", 2 );
                append( sb, "Specifies whether or not to add the module name as a prefix to the servlet path when merging web.xml. If you set this to false the exact path from the GWT module will be used, nothing else will be prepended.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resources".equals( goal ) )
        {
            append( sb, "gwt:resources", 0 );
            append( sb, "Copy GWT java source code and module descriptor as resources in the build outputDirectory. Alternative to declaring a <resource> in the POM with finer filtering as the module descriptor is read to detect sources to be copied.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "run".equals( goal ) )
        {
            append( sb, "gwt:run", 0 );
            append( sb, "Goal which run a GWT module in the GWT Hosted mode.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appEngineArtifactId (Default: appengine-java-sdk)", 2 );
                append( sb, "groupId to download appengine sdk from maven repo\n", 3 );
                append( sb, "", 0 );

                append( sb, "appEngineGroupId (Default: com.google.appengine)", 2 );
                append( sb, "groupId to download appengine sdk from maven repo\n", 3 );
                append( sb, "", 0 );

                append( sb, "appEngineHome (Default: ${project.build.directory}/appengine-sdk/)", 2 );
                append( sb, "Location to find appengine sdk or to unzip downloaded one see appEngineVersion\n", 3 );
                append( sb, "", 0 );

                append( sb, "appEngineVersion (Default: 1.3.8)", 2 );
                append( sb, "set the appengine sdk to use\nArtifact will be downloaded with groupId : appEngineGroupId and artifactId appEngineArtifactId\n", 3 );
                append( sb, "", 0 );

                append( sb, "bindAddress", 2 );
                append( sb, "Set GWT shell bindAddress.\nCan be set from command line using \'-Dgwt.bindAddress=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "blacklist", 2 );
                append( sb, "Set GWT shell protocol/host blacklist.\nCan be set from command line using \'-Dgwt.blacklist=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "buildOutputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "Location of the compiled classes.", 3 );
                append( sb, "", 0 );

                append( sb, "contextXml", 2 );
                append( sb, "Source Tomcat context.xml for GWT shell - copied to /gwt/localhost/ROOT.xml (used as the context.xml for the SHELL - requires Tomcat 5.0.x format - hence no default).", 3 );
                append( sb, "", 0 );

                append( sb, "copyWebapp (Default: false)", 2 );
                append( sb, "Copies the contents of warSourceDirectory to hostedWebapp.\nCan be set from command line using \'-Dgwt.copyWebapp=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "executedProject", 2 );
                append( sb, "The MavenProject executed by the \'compile\' phase", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "hostedWebapp (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location of the hosted-mode web application structure.", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "noServer (Default: false)", 2 );
                append( sb, "Prevents the embedded GWT Tomcat server from running (even if a port is specified).\nCan be set from command line using \'-Dgwt.noserver=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8888)", 2 );
                append( sb, "Runs the embedded GWT server on the specified port.", 3 );
                append( sb, "", 0 );

                append( sb, "runClasspathExcludes", 2 );
                append( sb, "List of Pattern jars to exclude from the classPath when running dev mode\n", 3 );
                append( sb, "", 0 );

                append( sb, "runTarget", 2 );
                append( sb, "URL that should be automatically opened in the GWT shell. For example com.myapp.gwt.Module/Module.html.\nWhen the host page is outside the module \'public\' folder (for example, at webapp root), the module MUST be specified (using a single <module> in configuration or by setting -Dgwt.module=..) and the runTarget parameter can only contain the host page URI.\n\nWhen the GWT module host page is part of the module \'public\' folder, the runTarget MAY define the full GWT module path (com.myapp.gwt.Module/Module.html) that will be automatically converted according to the rename-to directive into renamed/Module.html.\n", 3 );
                append( sb, "", 0 );

                append( sb, "runTimeOut", 2 );
                append( sb, "Forked process execution timeOut (in seconds). Primary used for integration-testing.", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "Specifies a different embedded web server to run (must implement ServletContainerLauncher)", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "systemProperties", 2 );
                append( sb, "List of System properties to pass when running the hosted mode.", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "tomcat (Default: ${project.build.directory}/tomcat)", 2 );
                append( sb, "Specify the location on the filesystem for the generated embedded Tomcat directory.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "webXml (Default: ${basedir}/src/main/webapp/WEB-INF/web.xml)", 2 );
                append( sb, "Source web.xml deployment descriptor that is used for GWT shell and for deployment WAR to \'merge\' servlet entries.", 3 );
                append( sb, "", 0 );

                append( sb, "webXmlServletPathAsIs (Default: false)", 2 );
                append( sb, "Specifies whether or not to add the module name as a prefix to the servlet path when merging web.xml. If you set this to false the exact path from the GWT module will be used, nothing else will be prepended.", 3 );
                append( sb, "", 0 );

                append( sb, "whitelist", 2 );
                append( sb, "Set GWT shell protocol/host whitelist.\nCan be set from command line using \'-Dgwt.whitelist=...\'\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "sdkInstall".equals( goal ) )
        {
            append( sb, "gwt:sdkInstall", 0 );
            append( sb, "Install a GWT (home built) SDK in local repository", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "source-jar".equals( goal ) )
        {
            append( sb, "gwt:source-jar", 0 );
            append( sb, "Add GWT java source code and module descriptor as resources to project jar. Alternative to gwt:resources for better Eclipse projects synchronization.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "Name of the generated JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "soyc".equals( goal ) )
        {
            append( sb, "gwt:soyc", 0 );
            append( sb, "Deprecated. You must now use the CompileReport, SoycDashboard is not anymore supported will be removed in 2.1.2", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "(no description available)", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "extra (Default: ${project.build.directory}/extra)", 2 );
                append( sb, "The directory into which extra, non-deployed files will be written.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test".equals( goal ) )
        {
            append( sb, "gwt:test", 0 );
            append( sb, "Mimic surefire to run GWTTestCases during integration-test phase, until SUREFIRE-508 is fixed", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of ant-style exclusion patterns for GWT integration tests", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArgs (Default: -Xmx512m)", 2 );
                append( sb, "Extra JVM arguments that are passed to the GWT-Maven generated scripts (for compiler, shell, etc - typically use -Xmx512m here, or -XstartOnFirstThread, etc).\nCan be set from command line using \'-Dgwt.extraJvmArgs=...\', defaults to setting max Heap size to be large enough for most GWT use cases.\n", 3 );
                append( sb, "", 0 );

                append( sb, "gen (Default: ${project.build.directory}/.generated)", 2 );
                append( sb, "Location on filesystem where GWT will write generated content for review (-gen option to GWTCompiler).\nCan be set from command line using \'-Dgwt.gen=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateDirectory (Default: ${project.build.directory}/generated-sources/gwt)", 2 );
                append( sb, "Folder where generated-source will be created (automatically added to compile classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "gwtSdkFirstInClasspath (Default: false)", 2 );
                append( sb, "The forked command line will use gwt sdk jars first in classpath. see issue http://code.google.com/p/google-web-toolkit/issues/detail?id=5290", 3 );
                append( sb, "", 0 );

                append( sb, "htmlunit (Default: FF3)", 2 );
                append( sb, "Configure options to run tests with HTMLUnit. The value must descrivbe the browser emulation to be used, FF2, FF3, IE6, IE7, or IE8 (possible multiple values separated by comas).", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/GwtTest*.java,**/Gwt*Suite.java)", 2 );
                append( sb, "Comma separated list of ant-style inclusion patterns for GWT integration tests. For example, can be set to **\\/*GwtTest.java to match all test class following this naming convention. Surefire plugin may then ne configured to exclude such tests.\nIt is recommended to use a TestSuite to run GwtTests, as they require some huge setup and are very slow. Running inside a suite allow to execute the setup only once. The default value is defined with this best practice in mind.\n", 3 );
                append( sb, "", 0 );

                append( sb, "inplace (Default: false)", 2 );
                append( sb, "Select the place where GWT application is built. In inplace mode, the warSourceDirectory is used to match the same use case of the war:inplace http://maven.apache.org/plugins/maven-war-plugin/inplace-mojo.html goal.", 3 );
                append( sb, "", 0 );

                append( sb, "jvm", 2 );
                append( sb, "Option to specify the jvm (or path to the java executable) to use with the forking scripts. For the default, the jvm will be the same as the one used to run Maven.", 3 );
                append( sb, "", 0 );

                append( sb, "logLevel (Default: INFO)", 2 );
                append( sb, "GWT logging level (-logLevel ERROR, WARN, INFO, TRACE, DEBUG, SPAM, or ALL).\nCan be set from command line using \'-Dgwt.logLevel=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: manual)", 2 );
                append( sb, "Configure test mode. Can be set to \'manual\', \'htmlunit\', \'selenium\' or \'remoteweb\'.", 3 );
                append( sb, "", 0 );

                append( sb, "module", 2 );
                append( sb, "A single GWT module. Shortcut for <modules> or option to specify a single module from command line", 3 );
                append( sb, "", 0 );

                append( sb, "modules", 2 );
                append( sb, "The project GWT modules. If not set, the plugin will scan the project for .gwt.xml files.", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: target/www-test)", 2 );
                append( sb, "output directory for code generated by GWT for tests", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "productionMode (Default: false)", 2 );
                append( sb, "run tests using production mode rather than development (a.k.a. hosted) mode.", 3 );
                append( sb, "", 0 );

                append( sb, "remoteweb", 2 );
                append( sb, "Configure options to run tests RemoteWebBrowser. The value must describe remote web URL, like \'rmi://myhost/ie8\'\nYou must start BrowserManagerServer before running tests with this option (gwt:browser).\n", 3 );
                append( sb, "", 0 );

                append( sb, "reportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2 );
                append( sb, "Directory for test reports, defaults to surefire one to match the surefire-report plugin", 3 );
                append( sb, "", 0 );

                append( sb, "selenium", 2 );
                append( sb, "Configure options to run tests with Selenium. The value must describe the Selenium Remote Control target", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Set this to \'true\' to bypass unit tests entirely. Its use is NOT RECOMMENDED, especially if you enable it using the \'maven.test.skip\' property, because maven.test.skip disables both running the tests and compiling the tests. Consider using the skipTests parameter instead.", 3 );
                append( sb, "", 0 );

                append( sb, "skipExec", 2 );
                append( sb, "DEPRECATED This old parameter is just like skipTests, but bound to the old property maven.test.skip.exec. Use -DskipTests instead; it\'s shorter.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "Set this to \'true\' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "", 0 );

                append( sb, "style (Default: OBF)", 2 );
                append( sb, "GWT JavaScript compiler output style (-style OBF[USCATED], PRETTY, or DETAILED).\nCan be set from command line using \'-Dgwt.style=...\'\n", 3 );
                append( sb, "", 0 );

                append( sb, "testFailureIgnore", 2 );
                append( sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "", 0 );

                append( sb, "testTimeOut (Default: 60)", 2 );
                append( sb, "Time out (in seconds) for test execution in dedicated JVM", 3 );
                append( sb, "", 0 );

                append( sb, "timeOut", 2 );
                append( sb, "Forked process execution timeOut. Usefull to avoid maven to hang in continuous integration server.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Location of the web application static resources (same as maven-war-plugin parameter)", 3 );
                append( sb, "", 0 );

                append( sb, "webappDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2 );
                append( sb, "Location on filesystem where GWT will write output files (-out option to GWTCompiler).", 3 );
                append( sb, "", 0 );

                append( sb, "webMode (Default: false)", 2 );
                append( sb, "run tests using web mode rather than developer (a.k.a. hosted) mode", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
