package org.codehaus.mojo.hibernate3.exporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on hibernate3-maven-plugin. Call <pre>  mvn hibernate3:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Jan 21 00:40:48 CET 2009
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:hibernate3-maven-plugin:2.2", 0 );
        append( sb, "", 0 );

        append( sb, "Hibernate3 Maven Plugin 2.2", 0 );
        append( sb, "Maven plugin based on the hibernate-tools project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 8 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "hbm2cfgxml".equals( goal ) )
        {
            append( sb, "hibernate3:hbm2cfgxml", 0 );
            append( sb, "Generates hibernate.cfg.xml", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hbm2dao".equals( goal ) )
        {
            append( sb, "hibernate3:hbm2dao", 0 );
            append( sb, "Base class for the different hibernate3 goals based on the Ant tasks of hibernate tools.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hbm2ddl".equals( goal ) )
        {
            append( sb, "hibernate3:hbm2ddl", 0 );
            append( sb, "Generates database schema.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hbm2doc".equals( goal ) )
        {
            append( sb, "hibernate3:hbm2doc", 0 );
            append( sb, "Generates HTML documentation for the database schema.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hbm2hbmxml".equals( goal ) )
        {
            append( sb, "hibernate3:hbm2hbmxml", 0 );
            append( sb, "Generates a set of hbm.xml files", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hbm2java".equals( goal ) )
        {
            append( sb, "hibernate3:hbm2java", 0 );
            append( sb, "Generates Java classes from set of *.hbm.xml files", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hbmtemplate".equals( goal ) )
        {
            append( sb, "hibernate3:hbmtemplate", 0 );
            append( sb, "Generic exporter that can be controlled by a user provided template or class.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "componentProperties", 2 );
                append( sb, "Parameter that holds component properties defined by the user. More information can be found at the Component Properties Configuration page.", 3 );
                append( sb, "", 0 );

                append( sb, "components", 2 );
                append( sb, "Parameter that holds components definitions specified by the user.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "hibernate3:help", 0 );
            append( sb, "Display help information on hibernate3-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0hibernate3:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
