/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.hibernate3.ExporterMojo;
import org.codehaus.mojo.hibernate3.HibernateUtils;
import org.codehaus.mojo.hibernate3.configuration.ComponentConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.xml.sax.EntityResolver;

public abstract class AbstractComponentConfiguration
implements ComponentConfiguration {
    private ExporterMojo exporterMojo;

    public Configuration getConfiguration(ExporterMojo exporterMojo) throws MojoExecutionException {
        this.setExporterMojo(exporterMojo);
        this.validateParameters();
        Configuration configuration = this.createConfiguration();
        if (configuration == null) {
            throw new MojoExecutionException("Couldn't create Configuration object");
        }
        this.doConfiguration(configuration);
        configuration.buildMappings();
        return configuration;
    }

    protected abstract Configuration createConfiguration();

    protected void doConfiguration(Configuration configuration) {
        Properties propertyFile;
        URL configurationUrl;
        String namingStrategy;
        Object object;
        String entityResolver = this.getExporterMojo().getComponentProperty("entityresolver");
        if (entityResolver != null && (object = HibernateUtils.getClass(entityResolver, this.getClass())) != null) {
            configuration.setEntityResolver((EntityResolver)object);
        }
        if ((namingStrategy = this.getExporterMojo().getComponentProperty("namingstrategy")) != null) {
            Object object2 = HibernateUtils.getClass(namingStrategy, this.getClass());
            if (object2 != null) {
                this.getExporterMojo().getLog().info((CharSequence)("Using as namingstrategy " + namingStrategy));
                configuration.setNamingStrategy((NamingStrategy)object2);
            } else {
                this.getExporterMojo().getLog().error((CharSequence)("Couldn't resolve " + namingStrategy));
            }
        }
        if ((configurationUrl = this.getConfigurationFile()) != null) {
            configuration.configure(configurationUrl);
        }
        if ((propertyFile = this.getPropertyFile()) != null) {
            configuration.setProperties(propertyFile);
        }
    }

    protected URL getConfigurationFile() {
        String configurationFile = this.getExporterMojo().getComponentProperty("configurationfile", "src/main/resources/hibernate.cfg.xml");
        String configurationResource = this.getExporterMojo().getComponentProperty("configurationresource", "hibernate.cfg.xml");
        File basedir = this.getExporterMojo().getProject().getBasedir();
        this.getExporterMojo().getLog().debug((CharSequence)("basedir: " + basedir));
        URL config = null;
        try {
            File configfile = HibernateUtils.getFile(basedir, configurationFile);
            if (configfile == null) {
                this.getExporterMojo().getLog().info((CharSequence)(configurationFile + " not found within the project. Trying absolute path."));
                configfile = HibernateUtils.getFile(null, configurationFile);
            }
            if (configfile != null) {
                config = configfile.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            this.getExporterMojo().getLog().warn((CharSequence)"Configuration file path was malformed", (Throwable)e);
        }
        if (config == null) {
            config = Thread.currentThread().getContextClassLoader().getResource(configurationResource);
        }
        if (config != null) {
            this.getExporterMojo().getLog().info((CharSequence)("Configuration XML file loaded: " + config.toString()));
            return config;
        }
        this.getExporterMojo().getLog().info((CharSequence)"No hibernate configuration file loaded.");
        return null;
    }

    protected Properties getPropertyFile() {
        String propertyFile = this.getExporterMojo().getComponentProperty("propertyfile", "src/main/resources/database.properties");
        String propertyResource = this.getExporterMojo().getComponentProperty("propertyresource", "database.properties");
        InputStream propInputStream = null;
        File propFile = HibernateUtils.getFile(this.getExporterMojo().getProject().getBasedir(), propertyFile);
        if (propFile == null) {
            this.getExporterMojo().getLog().info((CharSequence)(propertyFile + " not found within the project. Trying absolute path."));
            propFile = HibernateUtils.getFile(null, propertyFile);
        }
        if (propFile != null) {
            try {
                propInputStream = new FileInputStream(propFile);
            }
            catch (IOException ioe) {
                this.getExporterMojo().getLog().info((CharSequence)("No hibernate properties file loaded from " + propFile.getPath() + ": " + ioe.getMessage()));
            }
        }
        if (Thread.currentThread().getContextClassLoader().getResource(propertyResource) != null) {
            propInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyResource);
        }
        if (propInputStream != null) {
            try {
                this.getExporterMojo().getLog().info((CharSequence)("Configuration Properties file loaded: " + propFile));
                Properties properties = new Properties();
                properties.load(propInputStream);
                return properties;
            }
            catch (IOException ioe) {
                this.getExporterMojo().getLog().info((CharSequence)("No hibernate properties file loaded: " + ioe.getMessage()));
            }
        }
        this.getExporterMojo().getLog().info((CharSequence)"No hibernate properties file loaded.");
        return null;
    }

    public ExporterMojo getExporterMojo() {
        return this.exporterMojo;
    }

    public void setExporterMojo(ExporterMojo exporterMojo) {
        this.exporterMojo = exporterMojo;
    }

    protected void validateParameters() throws MojoExecutionException {
    }
}

