/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.AbstractTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.Define;
import org.codehaus.mojo.idlj.PackagePrefix;
import org.codehaus.mojo.idlj.Source;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacorbTranslator
extends AbstractTranslator
implements CompilerTranslator {
    private void invokeCompiler(Class<?> compilerClass, List<String> args) throws MojoExecutionException {
        if (!JacorbTranslator.isFork()) {
            this.invokeCompilerInProcess(compilerClass, args);
        } else {
            File javaHome = new File(System.getProperty("java.home"));
            File javaBin = new File(new File(javaHome, "bin"), "java");
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            URL[] classPathUrls = cl.getURLs();
            ArrayList<String> binArgs = new ArrayList<String>();
            binArgs.add(javaBin.getPath());
            binArgs.add("-classpath");
            String classPath = "" + new File(classPathUrls[0].getPath().replaceAll("%20", " "));
            for (URL url : classPathUrls) {
                classPath = classPath + File.pathSeparator + new File(url.getPath().replaceAll("%20", " "));
            }
            binArgs.add(classPath);
            binArgs.add(compilerClass.getName());
            for (String arg : args) {
                binArgs.add(arg);
            }
            Object[] argArray = binArgs.toArray(new String[binArgs.size()]);
            if (this.isDebug()) {
                this.getLog().debug((CharSequence)StringUtils.join((Object[])argArray, (String)" "));
            }
            try {
                Process p = Runtime.getRuntime().exec((String[])argArray);
                JacorbTranslator.redirectStream(p.getErrorStream(), System.err);
                JacorbTranslator.redirectStream(p.getInputStream(), System.out);
                p.waitFor();
                if (this.isFailOnError() && p.exitValue() != 0) {
                    throw new MojoExecutionException("IDL Compilation failure");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error forking compiler", (Exception)e);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Thread interrupted unexpectedly", (Exception)e);
            }
        }
    }

    @Override
    protected int runCompiler(Class<?> compilerClass, String ... arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method compileMethod = compilerClass.getMethod("compile", String[].class);
        compileMethod.invoke(compilerClass, new Object[]{arguments});
        return 0;
    }

    @Override
    public void invokeCompiler(String sourceDirectory, File[] includeDirs, String targetDirectory, String idlFile, Source source) throws MojoExecutionException {
        Class<?> compilerClass;
        ArrayList<String> args = new ArrayList<String>();
        args.add("-sloppy_names");
        args.add("-I" + sourceDirectory);
        if (includeDirs != null) {
            for (File includeDir : includeDirs) {
                args.add("-I" + includeDir.getPath());
            }
        }
        args.add("-d");
        args.add(targetDirectory);
        if (source.emitSkeletons() != null && !source.emitSkeletons().booleanValue()) {
            args.add("-noskel");
        }
        if (source.emitStubs() != null && !source.emitStubs().booleanValue()) {
            args.add("-nostub");
        }
        if (source.getPackagePrefix() != null) {
            args.add("-i2jpackage");
            args.add(":" + source.getPackagePrefix());
        }
        if (source.getPackagePrefixes() != null) {
            for (PackagePrefix prefix : source.getPackagePrefixes()) {
                args.add("-i2jpackage");
                args.add(prefix.getType() + ":" + prefix.getPrefix() + "." + prefix.getType());
            }
        }
        if (source.getDefines() != null) {
            for (Define define : source.getDefines()) {
                String arg = "-D" + define.getSymbol();
                if (define.getValue() != null) {
                    arg = arg + "=" + define.getValue();
                }
                args.add(arg);
            }
        }
        if (source.getAdditionalArguments() != null) {
            for (String addArg : source.getAdditionalArguments()) {
                args.add(addArg);
            }
        }
        args.add(idlFile);
        try {
            compilerClass = this.getClassLoaderFacade().loadClass("org.jacorb.idl.parser");
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("JacORB IDL compiler not found", (Exception)e);
        }
        this.invokeCompiler(compilerClass, args);
    }

    public static void redirectStream(final InputStream in, final OutputStream out) {
        Thread stdoutTransferThread = new Thread(){

            public void run() {
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out), true);
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        pw.println(line);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        stdoutTransferThread.start();
    }
}

