package org.codehaus.mojo.jasperreports;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jasperreports-maven-plugin.<br/> Call <pre>  mvn jasperreports:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Aug 30 16:29:24 PDT 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:jasperreports-maven-plugin:1.0-beta-2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven JasperReports Plugin", 0 );
        append( sb, "Compile Jasper report design file", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "compile-reports".equals( goal ) )
        {
            append( sb, "jasperreports:compile-reports", 0 );
            append( sb, "Compiles JasperReports xml definition files.\nMuch of this was inspired by the JRAntCompileTask, while trying to make it slightly cleaner and easier to use with Maven\'s mojo api.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalClasspath", 2 );
                append( sb, "Any additional classpath entry you might want to add to the JasperReports compiler. Not recommended for general use, plugin dependencies should be used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalProperties", 2 );
                append( sb, "Additional JRProperties", 3 );
                append( sb, "", 0 );

                append( sb, "classpathElements", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "compiler (Default: net.sf.jasperreports.engine.design.JRJavacCompiler)", 2 );
                append( sb, "Uses the Javac compiler by default. This is different from the original JasperReports ant task, which uses the JDT compiler by default.", 3 );
                append( sb, "", 0 );

                append( sb, "javaDirectory", 2 );
                append( sb, "This is where the generated java sources are stored.", 3 );
                append( sb, "", 0 );

                append( sb, "keepJava (Default: false)", 2 );
                append( sb, "Deprecated. There seems to be an issue with the compiler plugin so don\'t expect this to work yet - the dependencies will have disappeared.", 3 );
                append( sb, "", 0 );
                append( sb, "Since the JasperReports compiler deletes the compiled classes, one might want to set this to true, if they want to handle the generated java source in their application. Mind that this will not work if the mojo is bound to the compile or any other later phase. (As one might need to do if they use classes from their project in their report design)", 3 );
                append( sb, "", 0 );

                append( sb, "keepSerializedObject (Default: true)", 2 );
                append( sb, "Deprecated. Not implemented", 3 );
                append( sb, "", 0 );
                append( sb, "Not used for now - just a TODO - the idea being that one might want to set this to false if they want to handle the generated java source in their application.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "This is where the .jasper files are written.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileExt (Default: .jasper)", 2 );
                append( sb, "The extension of the compiled report files. Creates files with a .jasper extension by default.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: src/main/jasperreports)", 2 );
                append( sb, "This is where the xml report design files should be.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceFileExt (Default: .jrxml)", 2 );
                append( sb, "The extension of the source files to look for. Finds files with a .jrxml extension by default.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlValidation (Default: true)", 2 );
                append( sb, "Wether the xml design files must be validated.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jasperreports:help", 0 );
            append( sb, "Display help information on jasperreports-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jasperreports:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
