/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.JavaCCUtil;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.javacc.jjtree.JJTree;

public class JJTreeMojo
extends AbstractMojo {
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private Boolean nodeFactory;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean staticOption;
    private Boolean visitor;
    private String nodePackage;
    private String visitorException;
    private String nodePrefix;
    private String sourceDirectory;
    private String outputDirectory;
    private String timestampDirectory;
    private int staleMillis;
    private Set includes;
    private Set excludes;
    private String packageName;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Set staleGrammars;
        if (this.nodePackage != null) {
            this.packageName = StringUtils.replace((String)this.nodePackage, (char)'.', (char)File.separatorChar);
        }
        if (!this.sourceDirectory.startsWith(File.separator)) {
            this.sourceDirectory = this.project.getBasedir().getAbsolutePath() + File.separator + this.sourceDirectory;
        }
        if (!FileUtils.fileExists((String)this.outputDirectory)) {
            FileUtils.mkdir((String)this.outputDirectory);
        }
        if (!FileUtils.fileExists((String)this.timestampDirectory)) {
            FileUtils.mkdir((String)this.timestampDirectory);
        }
        if (this.includes == null) {
            this.includes = Collections.singleton("**/*");
        }
        if (this.excludes == null) {
            this.excludes = Collections.EMPTY_SET;
        }
        if ((staleGrammars = this.computeStaleGrammars()).isEmpty()) {
            this.getLog().info((CharSequence)("Nothing to process - all grammars in " + this.sourceDirectory + " are up to date."));
            if (this.project != null) {
                this.project.addCompileSourceRoot(this.outputDirectory);
            }
            return;
        }
        Iterator i = staleGrammars.iterator();
        while (i.hasNext()) {
            File jjTreeFile = (File)i.next();
            try {
                JJTree jjtree = new JJTree();
                jjtree.main(this.generateArgumentList(jjTreeFile.getAbsolutePath()));
                String timestampFilePath = jjTreeFile.getAbsolutePath().replace(this.sourceDirectory, "");
                FileUtils.copyFile((File)jjTreeFile, (File)new File(this.timestampDirectory + File.separator + timestampFilePath));
            }
            catch (Exception e) {
                throw new MojoExecutionException("JJTree execution failed", e);
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }

    private String getOutputDirectory(String jjtreeInput) throws MojoExecutionException {
        if (this.packageName != null) {
            return this.outputDirectory + File.separator + this.packageName;
        }
        String declaredPackage = JavaCCUtil.getDeclaredPackage(new File(jjtreeInput));
        if (declaredPackage != null) {
            return this.outputDirectory + File.separator + declaredPackage;
        }
        return this.outputDirectory;
    }

    private String[] generateArgumentList(String jjTreeFilename) throws MojoExecutionException {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.buildNodeFiles != null) {
            argsList.add("-BUILD_NODE_FILES=" + this.buildNodeFiles.toString());
        }
        if (this.multi != null) {
            argsList.add("-MULTI=" + this.multi);
        }
        if (this.nodeDefaultVoid != null) {
            argsList.add("-NODE_DEFAULT_VOID=" + this.nodeDefaultVoid);
        }
        if (this.nodeFactory != null) {
            argsList.add("-NODE_FACTORY=" + this.nodeFactory);
        }
        if (this.nodePackage != null) {
            argsList.add("-NODE_PACKAGE=" + this.nodePackage);
        }
        if (this.nodePrefix != null) {
            argsList.add("-NODE_PREFIX=" + this.nodePrefix);
        }
        if (this.nodeScopeHook != null) {
            argsList.add("-NODE_SCOPE_HOOK=" + this.nodeScopeHook);
        }
        if (this.nodeUsesParser != null) {
            argsList.add("-NODE_USES_PARSER=" + this.nodeUsesParser);
        }
        if (this.visitor != null) {
            argsList.add("-VISITOR=" + this.visitor);
        }
        if (this.staticOption != null) {
            argsList.add("-STATIC=" + this.staticOption);
        }
        if (this.visitorException != null) {
            argsList.add("-VISITOR_EXCEPTION='" + this.visitorException + "'");
        }
        argsList.add("-OUTPUT_DIRECTORY:" + this.getOutputDirectory(jjTreeFilename));
        argsList.add(jjTreeFilename);
        this.getLog().debug((CharSequence)("argslist: " + argsList.toString()));
        return argsList.toArray(new String[argsList.size()]);
    }

    private Set computeStaleGrammars() throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".jjt", ".jjt");
        SuffixMapping mappingCAP = new SuffixMapping(".JJT", ".JJT");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        File outDir = new File(this.timestampDirectory);
        HashSet staleSources = new HashSet();
        File sourceDir = new File(this.sourceDirectory);
        try {
            staleSources.addAll(scanner.getIncludedSources(sourceDir, outDir));
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale grammars to reprocess.", (Exception)((Object)e));
        }
        return staleSources;
    }
}

