/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.LegacyGrammarDirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractPreprocessorMojo
extends AbstractMojo {
    private MavenProject project;

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected abstract String[] getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract File getTimestampDirectory();

    protected abstract int getStaleMillis();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"This goal has been deprecated. Please update your plugin configuration.");
        GrammarInfo[] grammarInfos = this.scanForGrammars();
        if (grammarInfos == null) {
            this.getLog().info((CharSequence)("Skipping non-existing source directory: " + this.getSourceDirectory()));
            return;
        }
        if (grammarInfos.length <= 0) {
            this.getLog().info((CharSequence)"Skipping - all grammars up to date");
        } else {
            if (!this.getTimestampDirectory().exists()) {
                this.getTimestampDirectory().mkdirs();
            }
            for (int i = 0; i < grammarInfos.length; ++i) {
                this.processGrammar(grammarInfos[i]);
            }
            this.getLog().info((CharSequence)("Processed " + grammarInfos.length + " grammar" + (grammarInfos.length != 1 ? "s" : "")));
        }
        this.addCompileSourceRoot();
    }

    protected abstract void processGrammar(GrammarInfo var1) throws MojoExecutionException, MojoFailureException;

    private GrammarInfo[] scanForGrammars() throws MojoExecutionException {
        GrammarInfo[] grammarInfos;
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + this.getSourceDirectory()));
        try {
            LegacyGrammarDirectoryScanner scanner = new LegacyGrammarDirectoryScanner();
            scanner.setSourceDirectory(this.getSourceDirectory());
            scanner.setIncludes(this.getIncludes());
            scanner.setExcludes(this.getExcludes());
            scanner.setOutputDirectory(this.getTimestampDirectory());
            scanner.setStaleMillis(this.getStaleMillis());
            scanner.scan();
            grammarInfos = scanner.getIncludedGrammars();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to scan for grammars: " + this.getSourceDirectory(), e);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfos)));
        return grammarInfos;
    }

    protected void createTimestamp(GrammarInfo grammarInfo) {
        File jjFile = grammarInfo.getGrammarFile();
        File timestampFile = new File(this.getTimestampDirectory(), grammarInfo.getRelativeGrammarFile());
        try {
            FileUtils.copyFile((File)jjFile, (File)timestampFile);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to create copy for timestamp check: " + jjFile), (Throwable)e);
        }
    }

    protected void addCompileSourceRoot() {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + this.getOutputDirectory()));
            this.project.addCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
        }
    }
}

