/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JavaCC;
import org.codehaus.plexus.util.FileUtils;

public class JavaCCMojo
extends AbstractJavaCCMojo {
    private String packageName;
    private File sourceDirectory;
    private File outputDirectory;
    private int staleMillis;
    private String[] includes;
    private String[] excludes;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    protected String getParserPackage() {
        return this.packageName;
    }

    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjFile = grammarInfo.getGrammarFile();
        File parserDirectory = new File(this.getOutputDirectory(), grammarInfo.getParserDirectory());
        try {
            FileUtils.copyDirectory((File)jjFile.getParentFile(), (File)parserDirectory, (String)"*.java", (String)"*.jj,*.JJ");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy custom source files to output directory:" + jjFile.getParent() + " -> " + parserDirectory, (Exception)e);
        }
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jjFile);
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
    }
}

