/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.GrammarDirectoryScanner;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JavaCC;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJavaCCMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private Collection nonGeneratedSourceRoots;
    @Parameter(property="javacc.jdkVersion")
    private String jdkVersion;
    @Parameter(property="javacc.lookAhead")
    private Integer lookAhead;
    @Parameter(property="javacc.choiceAmbiguityCheck")
    private Integer choiceAmbiguityCheck;
    @Parameter(property="javacc.otherAmbiguityCheck")
    private Integer otherAmbiguityCheck;
    @Parameter(property="javacc.isStatic")
    private Boolean isStatic;
    @Parameter(property="javacc.debugParser")
    private Boolean debugParser;
    @Parameter(property="javacc.debugLookAhead")
    private Boolean debugLookAhead;
    @Parameter(property="javacc.debugTokenManager")
    private Boolean debugTokenManager;
    @Parameter(property="javacc.errorReporting")
    private Boolean errorReporting;
    @Parameter(property="javacc.javaUnicodeEscape")
    private Boolean javaUnicodeEscape;
    @Parameter(property="javacc.unicodeInput")
    private Boolean unicodeInput;
    @Parameter(property="javacc.ignoreCase")
    private Boolean ignoreCase;
    @Parameter(property="javacc.commonTokenAction")
    private Boolean commonTokenAction;
    @Parameter(property="javacc.userTokenManager")
    private Boolean userTokenManager;
    @Parameter(property="javacc.userCharStream")
    private Boolean userCharStream;
    @Parameter(property="javacc.buildParser")
    private Boolean buildParser;
    @Parameter(property="javacc.buildTokenManager")
    private Boolean buildTokenManager;
    @Parameter(property="javacc.tokenManagerUsesParser")
    private Boolean tokenManagerUsesParser;
    @Parameter(property="javacc.tokenExtends")
    private String tokenExtends;
    @Parameter(property="javacc.tokenFactory")
    private String tokenFactory;
    @Parameter(property="javacc.sanityCheck")
    private Boolean sanityCheck;
    @Parameter(property="javacc.forceLaCheck")
    private Boolean forceLaCheck;
    @Parameter(property="javacc.cacheTokens")
    private Boolean cacheTokens;
    @Parameter(property="javacc.keepLineColumn")
    private Boolean keepLineColumn;
    @Parameter(property="javacc.supportClassVisibilityPublic")
    private Boolean supportClassVisibilityPublic;
    @Parameter(property="javacc.grammarEncoding", defaultValue="${project.build.sourceEncoding}")
    private String grammarEncoding;

    protected String getGrammarEncoding() {
        return this.grammarEncoding;
    }

    protected String getJdkVersion() {
        return this.jdkVersion;
    }

    protected Boolean getIsStatic() {
        return this.isStatic;
    }

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected abstract String[] getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract int getStaleMillis();

    protected abstract File[] getCompileSourceRoots();

    protected String getParserPackage() {
        return null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        GrammarInfo[] grammarInfos = this.scanForGrammars();
        if (grammarInfos == null) {
            this.getLog().info((CharSequence)("Skipping non-existing source directory: " + this.getSourceDirectory()));
            return;
        }
        if (grammarInfos.length <= 0) {
            this.getLog().info((CharSequence)"Skipping - all parsers are up to date");
        } else {
            this.determineNonGeneratedSourceRoots();
            if (StringUtils.isEmpty((String)this.grammarEncoding)) {
                this.getLog().warn((CharSequence)"File encoding for grammars has not been configured, using platform default encoding, i.e. build is platform dependent!");
            }
            for (int i = 0; i < grammarInfos.length; ++i) {
                this.processGrammar(grammarInfos[i]);
            }
            this.getLog().info((CharSequence)("Processed " + grammarInfos.length + " grammar" + (grammarInfos.length != 1 ? "s" : "")));
        }
        LinkedHashSet<File> compileSourceRoots = new LinkedHashSet<File>(Arrays.asList(this.getCompileSourceRoots()));
        Iterator it = compileSourceRoots.iterator();
        while (it.hasNext()) {
            this.addSourceRoot((File)it.next());
        }
    }

    protected abstract void processGrammar(GrammarInfo var1) throws MojoExecutionException, MojoFailureException;

    private GrammarInfo[] scanForGrammars() throws MojoExecutionException {
        GrammarInfo[] grammarInfos;
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + this.getSourceDirectory()));
        try {
            GrammarDirectoryScanner scanner = new GrammarDirectoryScanner();
            scanner.setSourceDirectory(this.getSourceDirectory());
            scanner.setIncludes(this.getIncludes());
            scanner.setExcludes(this.getExcludes());
            scanner.setOutputDirectory(this.getOutputDirectory());
            scanner.setParserPackage(this.getParserPackage());
            scanner.setStaleMillis(this.getStaleMillis());
            scanner.scan();
            grammarInfos = scanner.getIncludedGrammars();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to scan for grammars: " + this.getSourceDirectory(), e);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfos)));
        return grammarInfos;
    }

    protected File getTempDirectory() {
        return new File(this.project.getBuild().getDirectory(), "javacc-" + System.currentTimeMillis());
    }

    protected void deleteTempDirectory(File tempDirectory) {
        try {
            FileUtils.deleteDirectory((File)tempDirectory);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to delete temporary directory: " + tempDirectory), (Throwable)e);
        }
    }

    protected void copyGrammarOutput(File sourceRoot, String packageName, File tempDirectory, String updatePattern) throws MojoExecutionException {
        try {
            List tempFiles = FileUtils.getFiles((File)tempDirectory, (String)"*.java", null);
            for (File tempFile : tempFiles) {
                String outputPath = "";
                if (packageName.length() > 0) {
                    outputPath = packageName.replace('.', '/') + '/';
                }
                outputPath = outputPath + tempFile.getName();
                File outputFile = new File(sourceRoot, outputPath);
                File sourceFile = this.findSourceFile(outputPath);
                boolean alwaysUpdate = false;
                if (updatePattern != null && sourceFile != null) {
                    alwaysUpdate = updatePattern.startsWith("!") ? !SelectorUtils.match((String)updatePattern.substring(1), (String)tempFile.getName()) : SelectorUtils.match((String)updatePattern, (String)tempFile.getName());
                }
                if (sourceFile == null || alwaysUpdate && sourceFile.equals(outputFile)) {
                    this.getLog().debug((CharSequence)("Copying generated file: " + outputPath));
                    try {
                        FileUtils.copyFile((File)tempFile, (File)outputFile);
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to copy generated source file to output directory:" + tempFile + " -> " + outputFile, (Exception)e);
                    }
                }
                this.getLog().debug((CharSequence)("Skipping customized file: " + outputPath));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy generated source files", (Exception)e);
        }
    }

    private void determineNonGeneratedSourceRoots() throws MojoExecutionException {
        this.nonGeneratedSourceRoots = new LinkedHashSet();
        try {
            String targetPrefix = new File(this.project.getBuild().getDirectory()).getCanonicalPath() + File.separator;
            List sourceRoots = this.project.getCompileSourceRoots();
            Iterator it = sourceRoots.iterator();
            while (it.hasNext()) {
                String sourcePath;
                File sourceRoot = new File(it.next().toString());
                if (!sourceRoot.isAbsolute()) {
                    sourceRoot = new File(this.project.getBasedir(), sourceRoot.getPath());
                }
                if (!(sourcePath = sourceRoot.getCanonicalPath()).startsWith(targetPrefix)) {
                    this.nonGeneratedSourceRoots.add(sourceRoot);
                    this.getLog().debug((CharSequence)("Non-generated compile source root: " + sourceRoot));
                    continue;
                }
                this.getLog().debug((CharSequence)("Generated compile source root: " + sourceRoot));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to determine non-generated source roots", (Exception)e);
        }
    }

    private File findSourceFile(String filename) {
        Collection sourceRoots = this.nonGeneratedSourceRoots;
        for (File sourceRoot : sourceRoots) {
            File sourceFile = new File(sourceRoot, filename);
            if (!sourceFile.exists()) continue;
            return sourceFile;
        }
        return null;
    }

    protected boolean isSourceRoot(File directory) {
        return this.nonGeneratedSourceRoots.contains(directory);
    }

    private void addSourceRoot(File directory) {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + directory));
            this.project.addCompileSourceRoot(directory.getAbsolutePath());
        }
    }

    protected JavaCC newJavaCC() {
        JavaCC javacc = new JavaCC();
        javacc.setLog(this.getLog());
        javacc.setGrammarEncoding(this.grammarEncoding);
        javacc.setJdkVersion(this.jdkVersion);
        javacc.setStatic(this.isStatic);
        javacc.setBuildParser(this.buildParser);
        javacc.setBuildTokenManager(this.buildTokenManager);
        javacc.setCacheTokens(this.cacheTokens);
        javacc.setChoiceAmbiguityCheck(this.choiceAmbiguityCheck);
        javacc.setCommonTokenAction(this.commonTokenAction);
        javacc.setDebugLookAhead(this.debugLookAhead);
        javacc.setDebugParser(this.debugParser);
        javacc.setDebugTokenManager(this.debugTokenManager);
        javacc.setErrorReporting(this.errorReporting);
        javacc.setForceLaCheck(this.forceLaCheck);
        javacc.setIgnoreCase(this.ignoreCase);
        javacc.setJavaUnicodeEscape(this.javaUnicodeEscape);
        javacc.setKeepLineColumn(this.keepLineColumn);
        javacc.setLookAhead(this.lookAhead);
        javacc.setOtherAmbiguityCheck(this.otherAmbiguityCheck);
        javacc.setSanityCheck(this.sanityCheck);
        javacc.setTokenManagerUsesParser(this.tokenManagerUsesParser);
        javacc.setTokenExtends(this.tokenExtends);
        javacc.setTokenFactory(this.tokenFactory);
        javacc.setUnicodeInput(this.unicodeInput);
        javacc.setUserCharStream(this.userCharStream);
        javacc.setUserTokenManager(this.userTokenManager);
        javacc.setSupportClassVisibilityPublic(this.supportClassVisibilityPublic);
        return javacc;
    }
}

