/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.javancss.AbstractNcssReportGenerator;
import org.codehaus.mojo.javancss.NumericNodeComparator;
import org.dom4j.Document;
import org.dom4j.Node;

public class NcssReportGenerator
extends AbstractNcssReportGenerator {
    private String xrefLocation;
    private int lineThreshold;

    public NcssReportGenerator(Sink sink, ResourceBundle bundle, Log log, String xrefLocation) {
        super(sink, bundle, log);
        this.xrefLocation = xrefLocation;
    }

    public void doReport(Document document, int lineThreshold) {
        this.lineThreshold = lineThreshold;
        this.getSink().head();
        this.getSink().title();
        this.getSink().text(this.getString("report.javancss.title"));
        this.getSink().title_();
        this.getSink().head_();
        this.getSink().body();
        this.doIntro(true);
        this.startSection("report.javancss.package.link", "report.javancss.package.title");
        this.doMainPackageAnalysis(document);
        this.doTotalPackageAnalysis(document);
        this.endSection();
        this.startSection("report.javancss.object.link", "report.javancss.object.title");
        this.doTopObjectNcss(document);
        this.doTopObjectFunctions(document);
        this.doObjectAverage(document);
        this.endSection();
        this.startSection("report.javancss.function.link", "report.javancss.function.title");
        this.doFunctionAnalysis(document);
        this.doFunctionAverage(document);
        this.endSection();
        this.startSection("report.javancss.explanation.link", "report.javancss.explanation.title");
        this.doExplanation();
        this.endSection();
        this.getSink().body_();
    }

    private void doMainPackageAnalysis(Document document) {
        this.subtitleHelper(this.getString("report.javancss.package.text"));
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.package"));
        this.headerCellHelper(this.getString("report.javancss.header.classe"));
        this.headerCellHelper(this.getString("report.javancss.header.function"));
        this.headerCellHelper(this.getString("report.javancss.header.ncss"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc_line"));
        this.headerCellHelper(this.getString("report.javancss.header.single_comment"));
        this.headerCellHelper(this.getString("report.javancss.header.multi_comment"));
        this.getSink().tableRow_();
        List list = document.selectNodes("//javancss/packages/package");
        Collections.sort(list, new NumericNodeComparator("ncss"));
        Iterator nodeIterator = list.iterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            this.getSink().tableRow();
            this.tableCellHelper(node.valueOf("name"));
            this.tableCellHelper(node.valueOf("classes"));
            this.tableCellHelper(node.valueOf("functions"));
            this.tableCellHelper(node.valueOf("ncss"));
            this.tableCellHelper(node.valueOf("javadocs"));
            this.tableCellHelper(node.valueOf("javadoc_lines"));
            this.tableCellHelper(node.valueOf("single_comment_lines"));
            this.tableCellHelper(node.valueOf("multi_comment_lines"));
            this.getSink().tableRow_();
        }
        this.getSink().table_();
    }

    private void doTotalPackageAnalysis(Document document) {
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.classetotal"));
        this.headerCellHelper(this.getString("report.javancss.header.functiontotal"));
        this.headerCellHelper(this.getString("report.javancss.header.ncsstotal"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc_line"));
        this.headerCellHelper(this.getString("report.javancss.header.single_comment"));
        this.headerCellHelper(this.getString("report.javancss.header.multi_comment"));
        this.getSink().tableRow_();
        Node node = document.selectSingleNode("//javancss/packages/total");
        this.getSink().tableRow();
        this.tableCellHelper(node.valueOf("classes"));
        this.tableCellHelper(node.valueOf("functions"));
        this.tableCellHelper(node.valueOf("ncss"));
        this.tableCellHelper(node.valueOf("javadocs"));
        this.tableCellHelper(node.valueOf("javadoc_lines"));
        this.tableCellHelper(node.valueOf("single_comment_lines"));
        this.tableCellHelper(node.valueOf("multi_comment_lines"));
        this.getSink().tableRow_();
        this.getSink().table_();
    }

    private void doTopObjectNcss(Document document) {
        this.subtitleHelper(this.getString("report.javancss.top") + " " + this.lineThreshold + " " + this.getString("report.javancss.object.byncss"));
        List nodeList = document.selectNodes("//javancss/objects/object");
        Collections.sort(nodeList, new NumericNodeComparator("ncss"));
        this.doTopObjectGeneric(nodeList);
    }

    private void doTopObjectFunctions(Document document) {
        this.subtitleHelper(this.getString("report.javancss.top") + " " + this.lineThreshold + " " + this.getString("report.javancss.object.byfunction"));
        List nodeList = document.selectNodes("//javancss/objects/object");
        Collections.sort(nodeList, new NumericNodeComparator("functions"));
        this.doTopObjectGeneric(nodeList);
    }

    private void doTopObjectGeneric(List nodeList) {
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.object"));
        this.headerCellHelper(this.getString("report.javancss.header.ncss"));
        this.headerCellHelper(this.getString("report.javancss.header.function"));
        this.headerCellHelper(this.getString("report.javancss.header.classe"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc"));
        this.getSink().tableRow_();
        Iterator nodeIterator = nodeList.iterator();
        int i = 0;
        while (nodeIterator.hasNext() && i++ < this.lineThreshold) {
            Node node = (Node)nodeIterator.next();
            this.getSink().tableRow();
            this.getSink().tableCell();
            this.jxrLink(node.valueOf("name"));
            this.getSink().tableCell_();
            this.tableCellHelper(node.valueOf("ncss"));
            this.tableCellHelper(node.valueOf("functions"));
            this.tableCellHelper(node.valueOf("classes"));
            this.tableCellHelper(node.valueOf("javadocs"));
            this.getSink().tableRow_();
        }
        this.getSink().table_();
    }

    private void doObjectAverage(Document document) {
        this.subtitleHelper(this.getString("report.javancss.averages"));
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.ncssaverage"));
        this.headerCellHelper(this.getString("report.javancss.header.programncss"));
        this.headerCellHelper(this.getString("report.javancss.header.classeaverage"));
        this.headerCellHelper(this.getString("report.javancss.header.functionaverage"));
        this.headerCellHelper(this.getString("report.javancss.header.javadocaverage"));
        this.getSink().tableRow_();
        Node node = document.selectSingleNode("//javancss/objects/averages");
        String totalNcss = document.selectSingleNode("//javancss/objects/ncss").getText();
        this.getSink().tableRow();
        this.tableCellHelper(node.valueOf("ncss"));
        this.tableCellHelper(totalNcss);
        this.tableCellHelper(node.valueOf("classes"));
        this.tableCellHelper(node.valueOf("functions"));
        this.tableCellHelper(node.valueOf("javadocs"));
        this.getSink().tableRow_();
        this.getSink().table_();
    }

    private void doFunctionAnalysis(Document document) {
        this.subtitleHelper(this.getString("report.javancss.top") + " " + this.lineThreshold + " " + this.getString("report.javancss.function.byncss"));
        this.getSink().paragraph();
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.function"));
        this.headerCellHelper(this.getString("report.javancss.header.ncss"));
        this.headerCellHelper(this.getString("report.javancss.header.ccn"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc"));
        this.getSink().tableRow_();
        List list = document.selectNodes("//javancss/functions/function");
        Collections.sort(list, new NumericNodeComparator("ncss"));
        Iterator nodeIterator = list.iterator();
        int i = 0;
        while (nodeIterator.hasNext() && i++ < this.lineThreshold) {
            Node node = (Node)nodeIterator.next();
            this.getSink().tableRow();
            this.getSink().tableCell();
            this.jxrFunctionLink(node.valueOf("name"));
            this.getSink().tableCell_();
            this.tableCellHelper(node.valueOf("ncss"));
            this.tableCellHelper(node.valueOf("ccn"));
            this.tableCellHelper(node.valueOf("javadocs"));
            this.getSink().tableRow_();
        }
        this.getSink().table_();
        this.getSink().paragraph_();
    }

    private void doFunctionAverage(Document document) {
        this.subtitleHelper(this.getString("report.javancss.averages"));
        this.getSink().paragraph();
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.programncss"));
        this.headerCellHelper(this.getString("report.javancss.header.ncssaverage"));
        this.headerCellHelper(this.getString("report.javancss.header.ccnaverage"));
        this.headerCellHelper(this.getString("report.javancss.header.javadocaverage"));
        this.getSink().tableRow_();
        Node node = document.selectSingleNode("//javancss/functions/function_averages");
        String totalNcss = document.selectSingleNode("//javancss/functions/ncss").getText();
        this.getSink().tableRow();
        this.tableCellHelper(totalNcss);
        this.tableCellHelper(node.valueOf("ncss"));
        this.tableCellHelper(node.valueOf("ccn"));
        this.tableCellHelper(node.valueOf("javadocs"));
        this.getSink().tableRow_();
        this.getSink().table_();
        this.getSink().paragraph_();
    }

    private void doExplanation() {
        this.subtitleHelper(this.getString("report.javancss.explanation.ncss.title"));
        this.paragraphHelper(this.getString("report.javancss.explanation.ncss.paragraph1"));
        this.paragraphHelper(this.getString("report.javancss.explanation.ncss.paragraph2"));
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper("");
        this.headerCellHelper(this.getString("report.javancss.explanation.ncss.table.examples"));
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.package"));
        this.codeCellHelper("package java.lang;");
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.import"));
        this.codeCellHelper("import java.awt.*;");
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.class"));
        this.getSink().tableCell();
        this.getSink().list();
        this.codeItemListHelper("public class Foo {");
        this.codeItemListHelper("public class Foo extends Bla {");
        this.getSink().list_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.interface"));
        this.codeCellHelper("public interface Able ; {");
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.field"));
        this.getSink().tableCell();
        this.getSink().list();
        this.codeItemListHelper("int a; ");
        this.codeItemListHelper("int a, b, c = 5, d = 6;");
        this.getSink().list_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.method"));
        this.getSink().tableCell();
        this.getSink().list();
        this.codeItemListHelper("public void cry();");
        this.codeItemListHelper("public void gib() throws DeadException {");
        this.getSink().list_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.constructorD"));
        this.codeCellHelper("public Foo() {");
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.constructorI"));
        this.getSink().tableCell();
        this.getSink().list();
        this.codeItemListHelper("this();");
        this.codeItemListHelper("super();");
        this.getSink().list_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.statement"));
        this.getSink().tableCell();
        this.getSink().list();
        this.codeItemListHelper("i = 0;");
        this.codeItemListHelper("if (ok)");
        this.codeItemListHelper("if (exit) {");
        this.codeItemListHelper("if (3 == 4);");
        this.codeItemListHelper("if (4 == 4) { ;");
        this.codeItemListHelper("} else {");
        this.getSink().list_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.explanation.ncss.table.label"));
        this.codeCellHelper("fine :");
        this.getSink().tableRow_();
        this.getSink().table_();
        this.paragraphHelper(this.getString("report.javancss.explanation.ncss.paragraph3"));
        this.subtitleHelper(this.getString("report.javancss.explanation.ccn.title"));
        this.paragraphHelper(this.getString("report.javancss.explanation.ccn.paragraph1"));
        this.paragraphHelper(this.getString("report.javancss.explanation.ccn.paragraph2"));
        this.getSink().list();
        this.codeItemListHelper("if");
        this.codeItemListHelper("for");
        this.codeItemListHelper("while");
        this.codeItemListHelper("case");
        this.codeItemListHelper("catch");
        this.getSink().list_();
        this.paragraphHelper(this.getString("report.javancss.explanation.ccn.paragraph3"));
        this.getSink().list();
        this.codeItemListHelper("if");
        this.codeItemListHelper("for");
        this.getSink().list_();
        this.paragraphHelper(this.getString("report.javancss.explanation.ccn.paragraph4"));
        this.paragraphHelper(this.getString("report.javancss.explanation.ccn.paragraph5"));
    }

    protected void startSection(String link, String title) {
        super.startSection(link, title);
        this.navigationBar();
    }

    protected void jxrLink(String clazz) {
        if (this.xrefLocation != null) {
            this.getSink().link(this.xrefLocation + "/" + clazz.replace('.', '/') + ".html");
        }
        this.getSink().text(clazz);
        if (this.xrefLocation != null) {
            this.getSink().link_();
        }
    }

    protected void jxrFunctionLink(String clazz) {
        int indexDot = -1;
        if (this.xrefLocation != null && (indexDot = clazz.lastIndexOf(46)) != -1) {
            this.getSink().link(this.xrefLocation + "/" + clazz.substring(0, indexDot).replace('.', '/') + ".html");
        }
        this.getSink().text(clazz);
        if (this.xrefLocation != null && indexDot != -1) {
            this.getSink().link_();
        }
    }
}

