/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2;

import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.XJCListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XjcMojo
extends AbstractMojo {
    private MavenProject project;
    protected File outputDirectory;
    protected File generatedResourcesDirectory;
    protected String packageName;
    protected File catalog;
    protected String httpproxy;
    protected File schemaDirectory;
    protected File bindingDirectory;
    protected String bindingFiles;
    protected String schemaFiles;
    protected String schemaListFileName;
    protected boolean dtd;
    protected boolean npa;
    protected boolean nv;
    protected boolean relaxng;
    protected boolean relaxngCompact;
    protected boolean quiet;
    protected boolean readOnly;
    protected boolean verbose;
    protected boolean wsdl;
    protected boolean xmlschema;
    protected boolean extension;
    protected boolean explicitAnnotation;
    protected String arguments;
    protected File staleFile;
    protected String includeSchemasOutputPath;
    protected boolean clearOutputDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            if (this.isOutputStale()) {
                this.getLog().info((CharSequence)"Generating source...");
                this.prepareDirectory(this.outputDirectory);
                if (this.generatedResourcesDirectory != null) {
                    this.prepareDirectory(this.generatedResourcesDirectory);
                }
                ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
                List classpathFiles = this.project.getCompileClasspathElements();
                URL[] urls = new URL[classpathFiles.size() + 1];
                StringBuffer classPath = new StringBuffer();
                for (int i = 0; i < classpathFiles.size(); ++i) {
                    this.getLog().debug((CharSequence)((String)classpathFiles.get(i)));
                    urls[i] = new File((String)classpathFiles.get(i)).toURL();
                    classPath.append((String)classpathFiles.get(i));
                    classPath.append(File.pathSeparatorChar);
                }
                urls[classpathFiles.size()] = new File(this.project.getBuild().getOutputDirectory()).toURL();
                URLClassLoader cl = new URLClassLoader(urls, parent);
                Thread.currentThread().setContextClassLoader(cl);
                try {
                    ArrayList<String> args = this.getXJCArgs(classPath.toString());
                    if (0 != Driver.run((String[])args.toArray(new String[args.size()]), (XJCListener)new MojoXjcListener())) {
                        String msg = "Could not process schema";
                        if (null != this.schemaFiles) {
                            File[] xsds = this.getXSDFiles();
                            msg = msg + (xsds.length > 1 ? "s:" : ":");
                            for (int i = 0; i < xsds.length; ++i) {
                                msg = msg + "\n  " + xsds[i].getName();
                            }
                        } else {
                            msg = msg + " files in directory " + this.schemaDirectory;
                        }
                        throw new MojoExecutionException(msg);
                    }
                    this.touchStaleFile();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(parent);
                }
            } else {
                this.getLog().info((CharSequence)"No changes detected in schema or binding files, skipping source generation.");
            }
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
            if (this.generatedResourcesDirectory != null) {
                Resource resource = new Resource();
                resource.setDirectory(this.generatedResourcesDirectory.getAbsolutePath());
                this.project.addResource(resource);
            }
            if (this.includeSchemasOutputPath != null) {
                FileUtils.forceMkdir((File)new File(this.project.getBuild().getOutputDirectory(), this.includeSchemasOutputPath));
                this.copyXSDs();
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void copyXSDs() throws MojoExecutionException {
        File[] srcFiles = this.getXSDFiles();
        File baseDir = new File(this.project.getBuild().getOutputDirectory(), this.includeSchemasOutputPath);
        for (int j = 0; j < srcFiles.length; ++j) {
            File from = srcFiles[j];
            File to = new File(baseDir, from.getName());
            File parent = to.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.copyFile(from, to);
        }
    }

    private void copyFile(File from, File to) {
        try {
            FileChannel srcChannel = new FileInputStream(from).getChannel();
            FileChannel dstChannel = new FileOutputStream(to).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void prepareDirectory(File dir) throws MojoExecutionException {
        if (this.clearOutputDir && dir.exists()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error cleaning directory " + dir.getAbsolutePath(), (Exception)e);
            }
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + dir.getAbsolutePath());
        }
    }

    private ArrayList<String> getXJCArgs(String classPath) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.npa) {
            args.add("-npa");
        }
        if (this.nv) {
            args.add("-nv");
        }
        if (this.dtd) {
            args.add("-dtd");
        }
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.quiet) {
            args.add("-quiet");
        }
        if (this.readOnly) {
            args.add("-readOnly");
        }
        if (this.relaxng) {
            args.add("-relaxng");
        }
        if (this.relaxngCompact) {
            args.add("-relaxng-compact");
        }
        if (this.wsdl) {
            args.add("-wsdl");
        }
        if (this.xmlschema) {
            args.add("-xmlschema");
        }
        if (this.explicitAnnotation) {
            args.add("-XexplicitAnnotation");
        }
        if (this.httpproxy != null) {
            args.add("-httpproxy");
            args.add(this.httpproxy);
        }
        if (this.packageName != null) {
            args.add("-p");
            args.add(this.packageName);
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.arguments != null && this.arguments.trim().length() > 0) {
            for (String arg : this.arguments.trim().split(" ")) {
                args.add(arg);
            }
        }
        args.add("-d");
        args.add(this.outputDirectory.getAbsolutePath());
        args.add("-classpath");
        args.add(classPath);
        File[] bindings = this.getBindingFiles();
        for (int i = 0; i < bindings.length; ++i) {
            args.add("-b");
            args.add(bindings[i].getAbsolutePath());
        }
        if (this.schemaFiles != null || this.schemaListFileName != null) {
            File[] xsds = this.getXSDFiles();
            for (int i = 0; i < xsds.length; ++i) {
                args.add(xsds[i].getAbsolutePath());
            }
        } else {
            args.add(this.schemaDirectory.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)("JAXB 2.0 args: " + args));
        return args;
    }

    protected void getSchemasFromFileListing(List<File> files) throws MojoExecutionException {
        File schemaListFile = new File(this.schemaListFileName);
        Scanner scanner = null;
        try {
            scanner = new Scanner(schemaListFile).useDelimiter(",");
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("schemaListFileName: " + this.schemaListFileName + " could not be found - error:" + e.getMessage(), (Exception)e);
        }
        String nextToken = null;
        File nextFile = null;
        while (scanner.hasNext()) {
            nextToken = scanner.next();
            nextFile = new File(this.schemaDirectory, nextToken.trim());
            files.add(nextFile);
        }
    }

    public final File[] getBindingFiles() {
        ArrayList<File> bindings;
        block3: {
            block2: {
                bindings = new ArrayList<File>();
                if (this.bindingFiles == null) break block2;
                StringTokenizer st = new StringTokenizer(this.bindingFiles, ",");
                while (st.hasMoreTokens()) {
                    String schemaName = st.nextToken();
                    bindings.add(new File(this.bindingDirectory, schemaName));
                }
                break block3;
            }
            this.getLog().debug((CharSequence)("The binding Directory is " + this.bindingDirectory));
            File[] files = this.bindingDirectory.listFiles(new XJBFile());
            if (files == null) break block3;
            for (int i = 0; i < files.length; ++i) {
                bindings.add(files[i]);
            }
        }
        return bindings.toArray(new File[0]);
    }

    public final File[] getXSDFiles() throws MojoExecutionException {
        ArrayList<File> xsdFiles;
        block4: {
            block5: {
                block3: {
                    if (this.schemaFiles != null && this.schemaListFileName != null) {
                        throw new MojoExecutionException("schemaFiles and schemaListFileName options were provided, these options may not be used together - schemaFiles: " + this.schemaFiles + " schemaListFileName: " + this.schemaListFileName);
                    }
                    xsdFiles = new ArrayList<File>();
                    if (this.schemaFiles == null) break block3;
                    StringTokenizer st = new StringTokenizer(this.schemaFiles, ",");
                    while (st.hasMoreTokens()) {
                        String schemaName = st.nextToken();
                        xsdFiles.add(new File(this.schemaDirectory, schemaName));
                    }
                    break block4;
                }
                if (this.schemaListFileName == null) break block5;
                this.getSchemasFromFileListing(xsdFiles);
                break block4;
            }
            this.getLog().debug((CharSequence)("The schema Directory is " + this.schemaDirectory));
            File[] files = this.schemaDirectory.listFiles(new XSDFile());
            if (files == null) break block4;
            for (int i = 0; i < files.length; ++i) {
                xsdFiles.add(files[i]);
            }
        }
        return xsdFiles.toArray(new File[0]);
    }

    private boolean isOutputStale() throws MojoExecutionException {
        boolean stale;
        File[] sourceXsds = this.getXSDFiles();
        File[] sourceXjbs = this.getBindingFiles();
        boolean bl = stale = !this.staleFile.exists();
        if (!stale) {
            int i;
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to xsds and xjbs.");
            long staleMod = this.staleFile.lastModified();
            for (i = 0; i < sourceXsds.length; ++i) {
                if (sourceXsds[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceXsds[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
            for (i = 0; i < sourceXjbs.length; ++i) {
                if (sourceXjbs[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceXjbs[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    private void touchStaleFile() throws IOException {
        if (!this.staleFile.exists()) {
            this.staleFile.getParentFile().mkdirs();
            this.staleFile.createNewFile();
            this.getLog().debug((CharSequence)"Stale flag file created.");
        } else {
            this.staleFile.setLastModified(System.currentTimeMillis());
        }
    }

    class MojoXjcListener
    extends XJCListener {
        MojoXjcListener() {
        }

        private String location(SAXParseException e) {
            return e.getPublicId() + "[" + e.getLineNumber() + "," + e.getColumnNumber() + "]";
        }

        public void error(SAXParseException arg0) {
            XjcMojo.this.getLog().error((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void fatalError(SAXParseException arg0) {
            XjcMojo.this.getLog().error((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void warning(SAXParseException arg0) {
            XjcMojo.this.getLog().warn((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void info(SAXParseException arg0) {
            XjcMojo.this.getLog().warn((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void message(String arg0) {
            XjcMojo.this.getLog().info((CharSequence)arg0);
        }

        public void generatedFile(String arg0) {
            XjcMojo.this.getLog().info((CharSequence)arg0);
        }
    }

    private final class XSDFile
    implements FileFilter {
        private XSDFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".xsd");
        }
    }

    private final class XJBFile
    implements FileFilter {
        private XJBFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".xjb");
        }
    }
}

