package org.codehaus.mojo.jaxb2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jaxb2-maven-plugin.<br/> Call <pre>  mvn jaxb2:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Aug 26 21:30:18 CEST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:jaxb2-maven-plugin:1.5", 0 );
        append( sb, "", 0 );

        append( sb, "JAXB-2 Maven Plugin", 0 );
        append( sb, "Mojo\'s JAXB-2 Maven plugin is used to create an object graph from XSDs based on the JAXB 2.1 implementation and to generate XSDs from JAXB-annotated Java classes.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 5 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jaxb2:help", 0 );
            append( sb, "Display help information on jaxb2-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jaxb2:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "schemagen".equals( goal ) )
        {
            append( sb, "jaxb2:schemagen", 0 );
            append( sb, "Creates XML Schema file(s) for sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of exclusion filters for the generator.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of inclusion filters for the generator. At least one file has to be specified.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-resources/schemagen)", 2 );
                append( sb, "The directory where the generated XML Schema file(s) will be placed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "Expression: ${lastModGranularityMs}", 3 );
                append( sb, "", 0 );

                append( sb, "transformSchemas", 2 );
                append( sb, "A List holding desired schema mappings, each of which binds a schema namespace URI to its desired prefix [optional] and the name of the resulting schema file [optional]. All given elements (uri, prefix, file) must be unique within the configuration; no two elements may have the same values.\nThe example schema configuration below maps two namespace uris to prefixes and generated file names. This implies that http://some/namespace will be represented by the prefix some within the generated XML Schema files; creating namespace definitions on the form xmlns:some=\'http://some/namespace\', and corresponding uses on the form <xs:element minOccurs=\'0\' ref=\'some:anOptionalElementInSomeNamespace\'/>. Moreover, the file element defines that the http://some/namespace definitions will be written to the file some_schema.xsd, and that all import references will be on the form <xs:import namespace=\'http://some/namespace\' schemaLocation=\'some_schema.xsd\'/>\n\nThe example configuration below also performs identical operations for the namespace uri http://another/namespace with the prefix another and the file another_schema.xsd.\n\n<schemas>\n\u00a0\u00a0<schema>\n\u00a0\u00a0\u00a0\u00a0<uri>http://some/namespace</uri>\n\u00a0\u00a0\u00a0\u00a0<toPrefix>some</toPrefix>\n\u00a0\u00a0\u00a0\u00a0<toFile>some_schema.xsd</toFile>\n\u00a0\u00a0<schema>\n\u00a0\u00a0\u00a0\u00a0<uri>http://another/namespace</uri>\n\u00a0\u00a0\u00a0\u00a0<toPrefix>another</toPrefix>\n\u00a0\u00a0\u00a0\u00a0<toFile>another_schema.xsd</toFile>\n\u00a0\u00a0</schema>\n</schemas>\n", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/jaxb2/work)", 2 );
                append( sb, "The name of the directory where copies of the original/generated schema files are stored. Thus, original generated XSD files are preserved for reference.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "testSchemagen".equals( goal ) )
        {
            append( sb, "jaxb2:testSchemagen", 0 );
            append( sb, "Creates XML Schema file(s) for test sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of exclusion filters for the generator.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of inclusion filters for the generator. At least one file has to be specified.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-test-resources/schemagen)", 2 );
                append( sb, "The directory where the generated XML Schema file(s) will be placed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "Expression: ${lastModGranularityMs}", 3 );
                append( sb, "", 0 );

                append( sb, "testWorkDirectory (Default: ${project.build.directory}/jaxb2/test-work)", 2 );
                append( sb, "The name of the directory where copies of the original/generated schema files are stored. Thus, original generated XSD files are preserved for reference.", 3 );
                append( sb, "", 0 );

                append( sb, "transformSchemas", 2 );
                append( sb, "A List holding desired schema mappings, each of which binds a schema namespace URI to its desired prefix [optional] and the name of the resulting schema file [optional]. All given elements (uri, prefix, file) must be unique within the configuration; no two elements may have the same values.\nThe example schema configuration below maps two namespace uris to prefixes and generated file names. This implies that http://some/namespace will be represented by the prefix some within the generated XML Schema files; creating namespace definitions on the form xmlns:some=\'http://some/namespace\', and corresponding uses on the form <xs:element minOccurs=\'0\' ref=\'some:anOptionalElementInSomeNamespace\'/>. Moreover, the file element defines that the http://some/namespace definitions will be written to the file some_schema.xsd, and that all import references will be on the form <xs:import namespace=\'http://some/namespace\' schemaLocation=\'some_schema.xsd\'/>\n\nThe example configuration below also performs identical operations for the namespace uri http://another/namespace with the prefix another and the file another_schema.xsd.\n\n<schemas>\n\u00a0\u00a0<schema>\n\u00a0\u00a0\u00a0\u00a0<uri>http://some/namespace</uri>\n\u00a0\u00a0\u00a0\u00a0<toPrefix>some</toPrefix>\n\u00a0\u00a0\u00a0\u00a0<toFile>some_schema.xsd</toFile>\n\u00a0\u00a0<schema>\n\u00a0\u00a0\u00a0\u00a0<uri>http://another/namespace</uri>\n\u00a0\u00a0\u00a0\u00a0<toPrefix>another</toPrefix>\n\u00a0\u00a0\u00a0\u00a0<toFile>another_schema.xsd</toFile>\n\u00a0\u00a0</schema>\n</schemas>\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "testXjc".equals( goal ) )
        {
            append( sb, "jaxb2:testXjc", 0 );
            append( sb, "Generates Java test sources from XML Schema(s) and binding file(s) using the JAXB Binding Compiler (XJC).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Space separated string of extra arguments, for instance -Xfluent-api -episode somefile; These will be passed on to XJC as \'-Xfluent-api\' \'-episode\' \'somefile\' options.", 3 );
                append( sb, "Expression: ${xjc.arguments}", 3 );
                append( sb, "", 0 );

                append( sb, "bindingDirectory (Default: ${project.basedir}/src/test/xjb)", 2 );
                append( sb, "The directory for JAXB binding files.", 3 );
                append( sb, "", 0 );

                append( sb, "bindingFiles", 2 );
                append( sb, "List of files to use for bindings, comma delimited. If none, then all xjb files are used in the bindingDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "catalog", 2 );
                append( sb, "Catalog file to resolve external entity references. Supports TR9401, XCatalog, and OASIS XML Catalog format.", 3 );
                append( sb, "", 0 );

                append( sb, "clearOutputDir (Default: true)", 2 );
                append( sb, "Clears the output directory on each run. Defaults to \'true\' but if false, will not clear the directory.", 3 );
                append( sb, "", 0 );

                append( sb, "dtd (Default: false)", 2 );
                append( sb, "Treat input schemas as XML DTD (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "enableIntrospection (Default: false)", 2 );
                append( sb, "Enable correct generation of Boolean getters/setters to enable Bean Introspection apis.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The character encoding for the generated Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "explicitAnnotation (Default: false)", 2 );
                append( sb, "Allow generation of explicit annotations that are needed for JAXB2 to work on RetroTranslator.", 3 );
                append( sb, "", 0 );

                append( sb, "extension (Default: false)", 2 );
                append( sb, "Allow to use the JAXB Vendor Extensions.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnNoSchemas (Default: true)", 2 );
                append( sb, "Fails the mojo if no schemas are found.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedResourcesDirectory", 2 );
                append( sb, "The optional directory where generated resources can be placed, generated by addons/plugins.", 3 );
                append( sb, "", 0 );

                append( sb, "httpproxy", 2 );
                append( sb, "Set HTTP/HTTPS proxy. Format is [user[:password]@]proxyHost[:proxyPort]", 3 );
                append( sb, "", 0 );

                append( sb, "includeSchemasOutputPath", 2 );
                append( sb, "The output path to include in your jar/war/etc if you wish to include your schemas in your artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "npa (Default: false)", 2 );
                append( sb, "Suppress generation of package level annotations (package-info.java).", 3 );
                append( sb, "", 0 );

                append( sb, "nv (Default: false)", 2 );
                append( sb, "Do not perform strict validation of the input schema(s).", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-test-sources/jaxb)", 2 );
                append( sb, "The working directory where the generated Java test source files are created.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "packageName", 2 );
                append( sb, "The package under which the source files will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Suppress compiler output.", 3 );
                append( sb, "", 0 );

                append( sb, "readOnly (Default: false)", 2 );
                append( sb, "Deprecated. Not suitable for a Maven build.", 3 );
                append( sb, "", 0 );
                append( sb, "Generated files will be in read-only mode.", 3 );
                append( sb, "", 0 );

                append( sb, "relaxng (Default: false)", 2 );
                append( sb, "Treat input schemas as RELAX NG (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "relaxngCompact (Default: false)", 2 );
                append( sb, "Treat input as RELAX NG compact syntax (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "schemaDirectory (Default: ${project.basedir}/src/test/xsd)", 2 );
                append( sb, "The directory for XML Schema files (XSDs).", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "schemaFiles", 2 );
                append( sb, "List of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory. This parameter also accepts Ant-style file patterns.\nNote: you can only use either the \'schemaFiles\' or the \'schemaListFileName\' option (you may not use both at once!).", 3 );
                append( sb, "", 0 );

                append( sb, "schemaListFileName", 2 );
                append( sb, "A filename containing the list of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory.\nNote: you can only use either the \'schemaFiles\' or the \'schemaListFileName\' option (you may not use both at once!).", 3 );
                append( sb, "", 0 );

                append( sb, "staleFile (Default: ${project.build.directory}/jaxb2/.testXjcStaleFlag)", 2 );
                append( sb, "The location of the flag file used to determine if the output is stale.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "target", 2 );
                append( sb, "Specifies the runtime environment in which the generated code is supposed to run, if older than the JAXB version used by the plugin (for example \'2.0\'). This will create generated code that doesn\'t use any newer JAXB features. Thus, allowing the generated code to run with an earlier JAXB 2.x runtime.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Be extra verbose.", 3 );
                append( sb, "Expression: ${xjc.verbose}", 3 );
                append( sb, "", 0 );

                append( sb, "wsdl (Default: false)", 2 );
                append( sb, "Treat input as WSDL and compile schemas inside it (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "xmlschema (Default: true)", 2 );
                append( sb, "Treat input as W3C XML Schema (default).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xjc".equals( goal ) )
        {
            append( sb, "jaxb2:xjc", 0 );
            append( sb, "Generates Java sources from XML Schema(s) and binding file(s) using the JAXB Binding Compiler (XJC).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Space separated string of extra arguments, for instance -Xfluent-api -episode somefile; These will be passed on to XJC as \'-Xfluent-api\' \'-episode\' \'somefile\' options.", 3 );
                append( sb, "Expression: ${xjc.arguments}", 3 );
                append( sb, "", 0 );

                append( sb, "bindingDirectory (Default: ${project.basedir}/src/main/xjb)", 2 );
                append( sb, "The directory for JAXB binding files.", 3 );
                append( sb, "", 0 );

                append( sb, "bindingFiles", 2 );
                append( sb, "List of files to use for bindings, comma delimited. If none, then all xjb files are used in the bindingDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "catalog", 2 );
                append( sb, "Catalog file to resolve external entity references. Supports TR9401, XCatalog, and OASIS XML Catalog format.", 3 );
                append( sb, "", 0 );

                append( sb, "clearOutputDir (Default: true)", 2 );
                append( sb, "Clears the output directory on each run. Defaults to \'true\' but if false, will not clear the directory.", 3 );
                append( sb, "", 0 );

                append( sb, "dtd (Default: false)", 2 );
                append( sb, "Treat input schemas as XML DTD (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "enableIntrospection (Default: false)", 2 );
                append( sb, "Enable correct generation of Boolean getters/setters to enable Bean Introspection apis.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The character encoding for the generated Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "explicitAnnotation (Default: false)", 2 );
                append( sb, "Allow generation of explicit annotations that are needed for JAXB2 to work on RetroTranslator.", 3 );
                append( sb, "", 0 );

                append( sb, "extension (Default: false)", 2 );
                append( sb, "Allow to use the JAXB Vendor Extensions.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnNoSchemas (Default: true)", 2 );
                append( sb, "Fails the mojo if no schemas are found.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedResourcesDirectory", 2 );
                append( sb, "The optional directory where generated resources can be placed, generated by addons/plugins.", 3 );
                append( sb, "", 0 );

                append( sb, "httpproxy", 2 );
                append( sb, "Set HTTP/HTTPS proxy. Format is [user[:password]@]proxyHost[:proxyPort]", 3 );
                append( sb, "", 0 );

                append( sb, "includeSchemasOutputPath", 2 );
                append( sb, "The output path to include in your jar/war/etc if you wish to include your schemas in your artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "npa (Default: false)", 2 );
                append( sb, "Suppress generation of package level annotations (package-info.java).", 3 );
                append( sb, "", 0 );

                append( sb, "nv (Default: false)", 2 );
                append( sb, "Do not perform strict validation of the input schema(s).", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/jaxb)", 2 );
                append( sb, "The working directory where the generated Java source files are created.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "packageName", 2 );
                append( sb, "The package under which the source files will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Suppress compiler output.", 3 );
                append( sb, "", 0 );

                append( sb, "readOnly (Default: false)", 2 );
                append( sb, "Deprecated. Not suitable for a Maven build.", 3 );
                append( sb, "", 0 );
                append( sb, "Generated files will be in read-only mode.", 3 );
                append( sb, "", 0 );

                append( sb, "relaxng (Default: false)", 2 );
                append( sb, "Treat input schemas as RELAX NG (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "relaxngCompact (Default: false)", 2 );
                append( sb, "Treat input as RELAX NG compact syntax (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "schemaDirectory (Default: ${project.basedir}/src/main/xsd)", 2 );
                append( sb, "The directory for XML Schema files (XSDs).", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "schemaFiles", 2 );
                append( sb, "List of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory. This parameter also accepts Ant-style file patterns.\nNote: you can only use either the \'schemaFiles\' or the \'schemaListFileName\' option (you may not use both at once!).", 3 );
                append( sb, "", 0 );

                append( sb, "schemaListFileName", 2 );
                append( sb, "A filename containing the list of files to use for schemas, comma delimited. If none, then all xsd files are used in the schemaDirectory.\nNote: you can only use either the \'schemaFiles\' or the \'schemaListFileName\' option (you may not use both at once!).", 3 );
                append( sb, "", 0 );

                append( sb, "staleFile (Default: ${project.build.directory}/jaxb2/.xjcStaleFlag)", 2 );
                append( sb, "The location of the flag file used to determine if the output is stale.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "target", 2 );
                append( sb, "Specifies the runtime environment in which the generated code is supposed to run, if older than the JAXB version used by the plugin (for example \'2.0\'). This will create generated code that doesn\'t use any newer JAXB features. Thus, allowing the generated code to run with an earlier JAXB 2.x runtime.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Be extra verbose.", 3 );
                append( sb, "Expression: ${xjc.verbose}", 3 );
                append( sb, "", 0 );

                append( sb, "wsdl (Default: false)", 2 );
                append( sb, "Treat input as WSDL and compile schemas inside it (experimental, unsupported).", 3 );
                append( sb, "", 0 );

                append( sb, "xmlschema (Default: true)", 2 );
                append( sb, "Treat input as W3C XML Schema (default).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
