/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment.classloading;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.classloading.ThreadContextClassLoaderHolder;

public class ThreadContextClassLoaderBuilder {
    private ClassLoader originalClassLoader;
    private List<URL> urlList;
    private Log log;

    private ThreadContextClassLoaderBuilder(ClassLoader classLoader, Log aLog) {
        this.log = aLog;
        this.originalClassLoader = classLoader;
        this.urlList = new ArrayList<URL>();
    }

    public ThreadContextClassLoaderBuilder addURL(URL anURL) {
        Validate.notNull(anURL, "anURL");
        for (URL current : this.urlList) {
            if (!current.toString().equalsIgnoreCase(anURL.toString())) continue;
            if (this.log.isWarnEnabled()) {
                this.log.warn((CharSequence)("Not adding URL [" + anURL.toString() + "]\u00a0twice. Check your plugin configuration."));
            }
            return this;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Adding URL [" + anURL.toString() + "]"));
        }
        this.urlList.add(this.addSlashToDirectoryUrlIfRequired(anURL));
        return this;
    }

    public ThreadContextClassLoaderBuilder addPath(String path) {
        URL anUrl;
        Validate.notEmpty(path, "path");
        try {
            anUrl = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not convert path [" + path + "]\u00a0to an URL.", e);
        }
        return this.addURL(anUrl);
    }

    public ThreadContextClassLoaderBuilder addPaths(List<String> paths) {
        Validate.notNull(paths, "paths");
        for (String path : paths) {
            this.addPath(path);
        }
        return this;
    }

    public ThreadContextClassLoaderHolder buildAndSet() {
        URL[] allURLs = new URL[this.urlList.size()];
        this.urlList.toArray(allURLs);
        URLClassLoader classLoader = new URLClassLoader(allURLs, this.originalClassLoader);
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(classLoader);
        StringBuilder builder = new StringBuilder();
        try {
            for (URL current : Collections.list(classLoader.getResources(""))) {
                String toAppend = ThreadContextClassLoaderBuilder.getClassPathElement(current);
                if (toAppend == null) continue;
                builder.append(toAppend).append(File.pathSeparator);
            }
        }
        catch (IOException e) {
            currentThread.setContextClassLoader(this.originalClassLoader);
            throw new IllegalStateException("Could not synthesize classPath from original ClassLoader.", e);
        }
        String classPathString = builder.length() > 0 ? builder.toString().substring(0, builder.length() - File.pathSeparator.length()) : "";
        return new DefaultHolder(currentThread, this.originalClassLoader, classPathString);
    }

    public static ThreadContextClassLoaderBuilder createFor(ClassLoader classLoader, Log log) {
        Validate.notNull(classLoader, "classLoader");
        Validate.notNull(log, "log");
        return new ThreadContextClassLoaderBuilder(classLoader, log);
    }

    public static List<URL> getRootResources(ClassLoader classLoader) throws IllegalStateException {
        Validate.notNull(classLoader, "classLoader");
        ArrayList<URL> toReturn = new ArrayList<URL>();
        try {
            toReturn.addAll(Collections.list(classLoader.getResources("")));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not synthesize classPath from original ClassLoader.", e);
        }
        return toReturn;
    }

    public static ThreadContextClassLoaderBuilder createFor(Class<?> aClass, Log log) {
        Validate.notNull(aClass, "aClass");
        return ThreadContextClassLoaderBuilder.createFor(aClass.getClassLoader(), log);
    }

    public static String getClassPathElement(URL anURL) throws IllegalArgumentException {
        Validate.notNull(anURL, "anURL");
        String protocol = anURL.getProtocol();
        String toReturn = null;
        if ("file".equalsIgnoreCase(protocol)) {
            toReturn = anURL.getPath();
        } else if ("jar".equalsIgnoreCase(protocol)) {
            toReturn = anURL.getPath();
        } else if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
            toReturn = anURL.toString();
        } else {
            throw new IllegalArgumentException("Unknown protocol [" + protocol + "]; could not handle URL [" + anURL + "]");
        }
        return toReturn;
    }

    private URL addSlashToDirectoryUrlIfRequired(URL anURL) {
        File theFile;
        Validate.notNull(anURL, "anURL");
        URL toReturn = anURL;
        if ("file".equalsIgnoreCase(anURL.getProtocol()) && (theFile = new File(anURL.getPath())).isDirectory()) {
            try {
                toReturn = theFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Could not convert a File to an URL", e);
            }
        }
        return toReturn;
    }

    class DefaultHolder
    implements ThreadContextClassLoaderHolder {
        private Thread affectedThread;
        private ClassLoader originalClassLoader;
        private String classPathArgument;

        public DefaultHolder(Thread affectedThread, ClassLoader originalClassLoader, String classPathArgument) {
            Validate.notNull(affectedThread, "affectedThread");
            Validate.notNull(originalClassLoader, "originalClassLoader");
            Validate.notNull(classPathArgument, "classPathArgument");
            this.affectedThread = affectedThread;
            this.originalClassLoader = originalClassLoader;
            this.classPathArgument = classPathArgument;
        }

        @Override
        public void restoreClassLoaderAndReleaseThread() {
            if (this.affectedThread != null) {
                this.affectedThread.setContextClassLoader(this.originalClassLoader);
                this.affectedThread = null;
                this.originalClassLoader = null;
                this.classPathArgument = null;
            }
        }

        @Override
        public String getClassPathAsArgument() {
            return this.classPathArgument;
        }

        protected void finalize() throws Throwable {
            try {
                this.restoreClassLoaderAndReleaseThread();
            }
            finally {
                super.finalize();
            }
        }
    }
}

