/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.Filters;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

public final class FileSystemUtilities {
    public static final FileFilter EXISTING_FILE = new FileFilter(){

        @Override
        public boolean accept(File candidate) {
            return candidate != null && candidate.exists() && candidate.isFile();
        }
    };
    public static final FileFilter EXISTING_DIRECTORY = new FileFilter(){

        @Override
        public boolean accept(File candidate) {
            return candidate != null && candidate.exists() && candidate.isDirectory();
        }
    };
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    private FileSystemUtilities() {
    }

    public static String getCanonicalPath(File file) {
        return FileSystemUtilities.getCanonicalFile(file).getPath();
    }

    public static File getCanonicalFile(File file) {
        Validate.notNull(file, "file");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not acquire the canonical file for [" + file.getAbsolutePath() + "]", e);
        }
    }

    public static File getExistingFile(String path, File baseDir) {
        Validate.notEmpty(path, "path");
        File theFile = new File(path);
        File toReturn = null;
        if (theFile.isAbsolute() && (EXISTING_FILE.accept(theFile) || EXISTING_DIRECTORY.accept(theFile))) {
            toReturn = FileSystemUtilities.getCanonicalFile(theFile);
        }
        if (!theFile.isAbsolute()) {
            Validate.notNull(baseDir, "baseDir");
            File relativeFile = new File(baseDir, path);
            if (EXISTING_FILE.accept(relativeFile) || EXISTING_DIRECTORY.accept(relativeFile)) {
                toReturn = FileSystemUtilities.getCanonicalFile(relativeFile);
            }
        }
        return toReturn;
    }

    public static URL getUrlFor(File aFile) throws IllegalArgumentException {
        Validate.notNull(aFile, "aFile");
        try {
            return aFile.toURI().normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not retrieve the URL from file [" + FileSystemUtilities.getCanonicalPath(aFile) + "]", e);
        }
    }

    public static File getFileFor(URL anURL, String encoding) {
        Validate.notNull(anURL, "anURL");
        Validate.notNull(encoding, "encoding");
        String protocol = anURL.getProtocol();
        File toReturn = null;
        if ("file".equalsIgnoreCase(protocol)) {
            try {
                String decodedPath = URLDecoder.decode(anURL.getPath(), encoding);
                toReturn = new File(decodedPath);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not get the File for [" + anURL + "]", e);
            }
        }
        if ("jar".equalsIgnoreCase(protocol)) {
            try {
                String tmp = URLDecoder.decode(anURL.getFile(), encoding);
                URL innerURL = new URL(tmp);
                if ("file".equalsIgnoreCase(innerURL.getProtocol())) {
                    String innerUrlPath = innerURL.getPath();
                    String filePath = innerUrlPath.contains("!") ? innerUrlPath.substring(0, innerUrlPath.indexOf("!")) : innerUrlPath;
                    toReturn = new File(URLDecoder.decode(filePath, encoding));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not get the File for [" + anURL + "]", e);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - void declaration
     */
    public static List<URL> filterFiles(File baseDir, List<String> sources, List<String> standardDirectories, Log log, String fileTypeDescription, List<Filter<File>> excludePatterns) {
        TreeMap<String, File> pathToResolvedSourceMap = new TreeMap<String, File>();
        for (String string : standardDirectories) {
            for (File currentResolvedSource : FileSystemUtilities.filterFiles(baseDir, sources, FileSystemUtilities.relativize(string, baseDir), log, fileTypeDescription, excludePatterns)) {
                pathToResolvedSourceMap.put(FileSystemUtilities.getCanonicalPath(currentResolvedSource), currentResolvedSource);
            }
        }
        ArrayList<URL> toReturn = new ArrayList<URL>();
        for (Map.Entry entry : pathToResolvedSourceMap.entrySet()) {
            toReturn.add(FileSystemUtilities.getUrlFor((File)entry.getValue()));
        }
        if (log.isDebugEnabled()) {
            void var9_19;
            void var9_17;
            void var9_15;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n+=================== [Filtered " + fileTypeDescription + "]\n");
            stringBuilder.append("|\n");
            stringBuilder.append("| " + excludePatterns.size() + " Exclude patterns:\n");
            boolean bl = false;
            while (var9_15 < excludePatterns.size()) {
                stringBuilder.append("| [" + (int)(var9_15 + true) + "/" + excludePatterns.size() + "]: " + excludePatterns.get((int)var9_15) + "\n");
                ++var9_15;
            }
            stringBuilder.append("|\n");
            stringBuilder.append("| " + standardDirectories.size() + " Standard Directories:\n");
            boolean bl2 = false;
            while (var9_17 < standardDirectories.size()) {
                stringBuilder.append("| [" + (int)(var9_17 + true) + "/" + standardDirectories.size() + "]: " + standardDirectories.get((int)var9_17) + "\n");
                ++var9_17;
            }
            stringBuilder.append("|\n");
            stringBuilder.append("| " + toReturn.size() + " Results:\n");
            boolean bl3 = false;
            while (var9_19 < toReturn.size()) {
                stringBuilder.append("| [" + (int)(var9_19 + true) + "/" + toReturn.size() + "]: " + toReturn.get((int)var9_19) + "\n");
                ++var9_19;
            }
            stringBuilder.append("|\n");
            stringBuilder.append("+=================== [End Filtered " + fileTypeDescription + "]\n\n");
            log.debug((CharSequence)stringBuilder.toString().replace("\n", AbstractJaxbMojo.NEWLINE));
        }
        return toReturn;
    }

    public static List<File> filterFiles(File baseDir, List<String> sources, String standardDirectory, Log log, String fileTypeDescription, List<Filter<File>> excludeFilters) {
        Validate.notNull(baseDir, "baseDir");
        Validate.notNull(log, "log");
        Validate.notEmpty(standardDirectory, "standardDirectory");
        Validate.notEmpty(fileTypeDescription, "fileTypeDescription");
        List<String> effectiveSources = sources;
        if (sources == null || sources.isEmpty()) {
            effectiveSources = new ArrayList<String>();
            File tmp = new File(standardDirectory);
            File rootDirectory = tmp.isAbsolute() ? tmp : new File(baseDir, standardDirectory);
            effectiveSources.add(FileSystemUtilities.getCanonicalPath(rootDirectory));
        }
        ArrayList<File> existingSources = new ArrayList<File>();
        for (String current : effectiveSources) {
            File existingFile = FileSystemUtilities.getExistingFile(current, baseDir);
            if (existingFile != null) {
                existingSources.add(existingFile);
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)("Accepted configured " + fileTypeDescription + " [" + FileSystemUtilities.getCanonicalFile(existingFile) + "]"));
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info((CharSequence)("Ignored given or default " + fileTypeDescription + " [" + current + "], since it is not an existent file or directory."));
        }
        if (log.isDebugEnabled() && existingSources.size() > 0) {
            int size = existingSources.size();
            log.debug((CharSequence)(" [" + size + " existing " + fileTypeDescription + "] ..."));
            for (int i = 0; i < size; ++i) {
                log.debug((CharSequence)("   " + (i + 1) + "/" + size + ": " + existingSources.get(i)));
            }
            log.debug((CharSequence)(" ... End [" + size + " existing " + fileTypeDescription + "]"));
        }
        return FileSystemUtilities.resolveRecursively(existingSources, excludeFilters, log);
    }

    public static List<File> filterFiles(List<File> files, Filter<File> acceptFilter, Log log) {
        Validate.notNull(files, "files");
        ArrayList<File> toReturn = new ArrayList<File>();
        if (files.size() > 0) {
            for (File current : files) {
                boolean isAcceptedDirectory;
                boolean isAcceptedFile = EXISTING_FILE.accept(current) && acceptFilter.accept(current);
                boolean bl = isAcceptedDirectory = EXISTING_DIRECTORY.accept(current) && acceptFilter.accept(current);
                if (isAcceptedFile) {
                    toReturn.add(current);
                    continue;
                }
                if (!isAcceptedDirectory) continue;
                FileSystemUtilities.recurseAndPopulate(toReturn, Collections.singletonList(acceptFilter), current, false, log);
            }
        }
        return toReturn;
    }

    public static List<File> resolveRecursively(List<File> files, List<Filter<File>> exclusionFilters, Log log) {
        Validate.notNull(files, "files");
        ArrayList<Filter<File>> effectiveExclusions = exclusionFilters == null ? new ArrayList<Filter<File>>() : exclusionFilters;
        ArrayList<File> toReturn = new ArrayList<File>();
        if (files.size() > 0) {
            for (File current : files) {
                boolean isAcceptedDirectory;
                boolean isAcceptedFile = EXISTING_FILE.accept(current) && Filters.noFilterMatches(current, effectiveExclusions);
                boolean bl = isAcceptedDirectory = EXISTING_DIRECTORY.accept(current) && Filters.noFilterMatches(current, effectiveExclusions);
                if (isAcceptedFile) {
                    toReturn.add(current);
                    continue;
                }
                if (!isAcceptedDirectory) continue;
                FileSystemUtilities.recurseAndPopulate(toReturn, effectiveExclusions, current, true, log);
            }
        }
        return toReturn;
    }

    public static void createDirectory(File aDirectory, boolean cleanBeforeCreate) throws MojoExecutionException {
        boolean existsAsFile;
        Validate.notNull(aDirectory, "aDirectory");
        FileSystemUtilities.validateFileOrDirectoryName(aDirectory);
        if (cleanBeforeCreate) {
            try {
                FileUtils.deleteDirectory((File)aDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean directory [" + FileSystemUtilities.getCanonicalPath(aDirectory) + "]", (Exception)e);
            }
        }
        boolean bl = existsAsFile = aDirectory.exists() && aDirectory.isFile();
        if (existsAsFile) {
            throw new MojoExecutionException("[" + FileSystemUtilities.getCanonicalPath(aDirectory) + "] exists and is a file. Cannot make directory");
        }
        if (!aDirectory.exists() && !aDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory [" + FileSystemUtilities.getCanonicalPath(aDirectory) + "]");
        }
    }

    public static String relativize(String path, File parentDir) {
        Validate.notNull(path, "path");
        Validate.notNull(parentDir, "parentDir");
        String basedirPath = FileSystemUtilities.getCanonicalPath(parentDir);
        String toReturn = path;
        if (path.toLowerCase().startsWith(basedirPath.toLowerCase())) {
            toReturn = path.substring(basedirPath.length() + 1);
        }
        return toReturn;
    }

    public static List<File> listFiles(File fileOrDir, List<Filter<File>> fileFilters, Log log) {
        return FileSystemUtilities.listFiles(fileOrDir, fileFilters, false, log);
    }

    public static List<File> listFiles(File fileOrDir, List<Filter<File>> fileFilters, boolean excludeFilterOperation, Log log) {
        File[] listedFiles;
        Validate.notNull(log, "log");
        Validate.notNull(fileFilters, "fileFilters");
        ArrayList<File> toReturn = new ArrayList<File>();
        if (EXISTING_FILE.accept(fileOrDir)) {
            FileSystemUtilities.checkAndAdd(toReturn, fileOrDir, fileFilters, excludeFilterOperation, log);
        } else if (EXISTING_DIRECTORY.accept(fileOrDir) && (listedFiles = fileOrDir.listFiles()) != null) {
            for (File current : listedFiles) {
                FileSystemUtilities.checkAndAdd(toReturn, current, fileFilters, excludeFilterOperation, log);
            }
        }
        return toReturn;
    }

    private static void checkAndAdd(List<File> toPopulate, File current, List<Filter<File>> fileFilters, boolean excludeFilterOperation, Log log) {
        boolean noFilters;
        boolean bl = noFilters = fileFilters == null || fileFilters.isEmpty();
        boolean addFile = excludeFilterOperation ? noFilters || Filters.rejectAtLeastOnce(current, fileFilters) : noFilters || Filters.matchAtLeastOnce(current, fileFilters);
        String logPrefix = (addFile ? "Accepted " : "Rejected ") + (current.isDirectory() ? "directory" : "file") + " [";
        if (addFile) {
            toPopulate.add(current);
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)(logPrefix + FileSystemUtilities.getCanonicalPath(current) + "]"));
        }
    }

    private static void validateFileOrDirectoryName(File fileOrDir) {
        if (Os.isFamily((String)"windows") && !FileUtils.isValidWindowsFileName((File)fileOrDir)) {
            throw new IllegalArgumentException("The file (" + fileOrDir + ") cannot contain any of the following characters: \n" + StringUtils.join((Object[])INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, (String)" "));
        }
    }

    private static void recurseAndPopulate(List<File> toPopulate, List<Filter<File>> fileFilters, File aDirectory, boolean excludeOperation, Log log) {
        List<File> files = FileSystemUtilities.listFiles(aDirectory, fileFilters, excludeOperation, log);
        for (File current : files) {
            if (EXISTING_FILE.accept(current)) {
                toPopulate.add(current);
            }
            if (!EXISTING_DIRECTORY.accept(current)) continue;
            FileSystemUtilities.recurseAndPopulate(toPopulate, fileFilters, current, excludeOperation, log);
        }
    }
}

