/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WsImportMojo
extends AbstractJaxwsMojo {
    private String packageName;
    private File catalog;
    private String httpproxy;
    private File wsdlDirectory;
    protected List wsdlFiles;
    private List wsdlUrls;
    protected File bindingDirectory;
    protected List bindingFiles;
    private String wsdlLocation;
    private String target;
    protected File sourceDestDir;
    private List xjcArgs;
    private File staleFile;

    WsImportMojo() {
    }

    public void execute() throws MojoExecutionException {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        String originalSystemClasspath = this.initClassLoader(parent);
        try {
            this.sourceDestDir.mkdirs();
            this.getDestDir().mkdirs();
            this.processWsdlViaUrls();
            this.processLocalWsdlFiles();
            this.project.addCompileSourceRoot(this.sourceDestDir.getAbsolutePath());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            System.setProperty("java.class.path", originalSystemClasspath);
        }
    }

    private void processLocalWsdlFiles() throws MojoExecutionException, IOException {
        if (this.isOutputStale()) {
            File[] wsdls = this.getWSDLFiles();
            for (int i = 0; i < wsdls.length; ++i) {
                this.getLog().info((CharSequence)("Processing: " + wsdls[i].getAbsolutePath()));
                ArrayList<String> args = this.getWsImportArgs();
                args.add(wsdls[i].getAbsolutePath());
                this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
                this.wsImport(args);
            }
            this.touchStaleFile();
        }
    }

    private void processWsdlViaUrls() throws MojoExecutionException {
        for (int i = 0; this.wsdlUrls != null && i < this.wsdlUrls.size(); ++i) {
            String wsdlUrl = this.wsdlUrls.get(i).toString();
            this.getLog().info((CharSequence)("Processing: " + wsdlUrl));
            ArrayList<String> args = this.getWsImportArgs();
            args.add(wsdlUrl);
            this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
            this.wsImport(args);
        }
    }

    private void wsImport(ArrayList<String> args) throws MojoExecutionException {
        WsimportTool compTool = new WsimportTool((OutputStream)System.out);
        if (!compTool.run(args.toArray(new String[args.size()]))) {
            throw new MojoExecutionException("Error executing: wsimport " + args);
        }
    }

    private ArrayList<String> getWsImportArgs() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-s");
        args.add(this.sourceDestDir.getAbsolutePath());
        args.add("-d");
        args.add(this.getDestDir().getAbsolutePath());
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.httpproxy != null) {
            args.add("-httpproxy");
            args.add(this.httpproxy);
        }
        if (this.packageName != null) {
            args.add("-p");
            args.add(this.packageName);
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdllocation");
            args.add(this.wsdlLocation);
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.xjcArgs != null) {
            for (String xjcArg : this.xjcArgs) {
                args.add("-B" + xjcArg);
            }
        }
        File[] bindings = this.getBindingFiles();
        for (int i = 0; i < bindings.length; ++i) {
            args.add("-b");
            args.add(bindings[i].getAbsolutePath());
        }
        this.getLog().debug((CharSequence)("jaxws:wsimport args: " + args));
        return args;
    }

    public final File[] getBindingFiles() {
        File[] bindings;
        if (this.bindingFiles != null) {
            bindings = new File[this.bindingFiles.size()];
            for (int i = 0; i < this.bindingFiles.size(); ++i) {
                String schemaName = (String)this.bindingFiles.get(i);
                File file = new File(schemaName);
                if (!file.isAbsolute()) {
                    file = new File(this.bindingDirectory, schemaName);
                }
                bindings[i] = file;
            }
        } else {
            this.getLog().debug((CharSequence)("The binding Directory is " + this.bindingDirectory));
            bindings = this.bindingDirectory.listFiles(new XMLFile());
            if (bindings == null) {
                bindings = new File[]{};
            }
        }
        return bindings;
    }

    public final File[] getWSDLFiles() {
        File[] files;
        if (this.wsdlFiles != null) {
            files = new File[this.wsdlFiles.size()];
            for (int i = 0; i < this.wsdlFiles.size(); ++i) {
                String schemaName = (String)this.wsdlFiles.get(i);
                files[i] = new File(this.wsdlDirectory, schemaName);
            }
        } else {
            this.getLog().debug((CharSequence)("The wsdl Directory is " + this.wsdlDirectory));
            files = this.wsdlDirectory.listFiles(new WSDLFile());
            if (files == null) {
                files = new File[]{};
            }
        }
        return files;
    }

    private boolean isOutputStale() {
        boolean stale;
        File[] sourceWsdls = this.getWSDLFiles();
        File[] sourceBindings = this.getBindingFiles();
        boolean bl = stale = !this.staleFile.exists();
        if (!stale) {
            int i;
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to wsdls and bindings.");
            long staleMod = this.staleFile.lastModified();
            for (i = 0; i < sourceWsdls.length; ++i) {
                if (sourceWsdls[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceWsdls[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
            for (i = 0; i < sourceBindings.length; ++i) {
                if (sourceBindings[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceBindings[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    private void touchStaleFile() throws IOException {
        if (!this.staleFile.exists()) {
            this.staleFile.getParentFile().mkdirs();
            this.staleFile.createNewFile();
            this.getLog().debug((CharSequence)"Stale flag file created.");
        } else {
            this.staleFile.setLastModified(System.currentTimeMillis());
        }
    }

    private final class WSDLFile
    implements FileFilter {
        private WSDLFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".wsdl");
        }
    }

    private final class XMLFile
    implements FileFilter {
        private XMLFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".xml");
        }
    }
}

