/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.jaxws.Invoker;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractJaxwsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="true")
    protected boolean keep;
    @Parameter(defaultValue="false")
    private boolean extension;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    private List<String> args;
    @Parameter
    private List<String> vmArgs;
    @Parameter
    private File executable;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor pluginDescriptor;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="false")
    protected boolean useJdkToolchainExecutable;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    private static final Logger logger = Logger.getLogger(AbstractJaxwsMojo.class.getName());
    private static final List<String> METRO_22 = new ArrayList<String>();
    private static final List<String> METRO_221 = new ArrayList<String>();
    private static final List<String> METRO_23 = new ArrayList<String>();

    AbstractJaxwsMojo() {
    }

    protected abstract String getMain();

    protected abstract String getToolName();

    protected abstract File getDestDir();

    protected abstract File getSourceDestDir();

    protected void addSourceRoot(String sourceDir) {
        if (!this.project.getCompileSourceRoots().contains(sourceDir)) {
            this.getLog().debug((CharSequence)("adding src root: " + sourceDir));
            this.project.addCompileSourceRoot(sourceDir);
        } else {
            this.getLog().debug((CharSequence)("existing src root: " + sourceDir));
        }
    }

    protected abstract File getDefaultSrcOut();

    protected abstract boolean isXnocompile();

    protected String getExtraClasspath() {
        return null;
    }

    protected boolean isExtensionOn() {
        return this.extension;
    }

    protected List<String> getCommonArgs() throws MojoExecutionException {
        File destDir;
        ArrayList<String> commonArgs = new ArrayList<String>();
        if (!this.isDefaultSrc(this.getSourceDestDir()) || this.keep) {
            commonArgs.add("-keep");
            commonArgs.add("-s");
            commonArgs.add("'" + this.getSourceDestDir().getAbsolutePath() + "'");
            if (!this.getSourceDestDir().mkdirs() && !this.getSourceDestDir().exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + this.getSourceDestDir().getAbsolutePath()));
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
        if (!(destDir = this.getDestDir()).mkdirs() && !destDir.exists()) {
            this.getLog().warn((CharSequence)("Cannot create directory: " + destDir.getAbsolutePath()));
        }
        commonArgs.add("-d");
        commonArgs.add("'" + destDir.getAbsolutePath() + "'");
        if (this.verbose) {
            commonArgs.add("-verbose");
        }
        if (this.isArgSupported("-encoding")) {
            if (this.encoding != null) {
                this.maybeUnsupportedOption("-encoding", this.encoding, commonArgs);
            } else {
                this.getLog().warn((CharSequence)("Using platform encoding (" + System.getProperty("file.encoding") + "), build is platform dependent!"));
            }
        }
        if (this.isExtensionOn()) {
            commonArgs.add("-extension");
        }
        if (this.isXnocompile()) {
            commonArgs.add("-Xnocompile");
        }
        if (this.args != null) {
            for (String arg : this.args) {
                commonArgs.add(arg);
            }
        }
        return commonArgs;
    }

    protected boolean isArgSupported(String arg) throws MojoExecutionException {
        ArtifactVersion av;
        List<String> supportedArgs = METRO_23;
        Artifact a = (Artifact)this.pluginDescriptor.getArtifactMap().get("org.glassfish.metro:webservices-tools");
        String v = null;
        if (a != null) {
            av = AbstractJaxwsMojo.getSelectedVersion(a);
            v = av.toString();
            if (av.getMajorVersion() == 2 && av.getMinorVersion() == 2) {
                supportedArgs = av.getIncrementalVersion() == 0 ? METRO_22 : METRO_221;
            }
        } else {
            a = (Artifact)this.pluginDescriptor.getArtifactMap().get("com.sun.xml.ws:jaxws-tools");
            av = AbstractJaxwsMojo.getSelectedVersion(a);
            v = av.toString();
            if (av.getMajorVersion() == 2 && av.getMinorVersion() == 2) {
                if (av.getIncrementalVersion() == 6) {
                    supportedArgs = METRO_22;
                } else if (av.getIncrementalVersion() == 7) {
                    supportedArgs = METRO_221;
                }
            }
        }
        boolean isSupported = supportedArgs.contains(arg);
        if (!isSupported) {
            this.getLog().warn((CharSequence)("'" + arg + "' is not supported by " + a.getArtifactId() + ":" + v));
        }
        return isSupported;
    }

    private static ArtifactVersion getSelectedVersion(Artifact artifact) throws MojoExecutionException {
        try {
            return artifact.getSelectedVersion();
        }
        catch (OverConstrainedVersionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private boolean isDefaultSrc(File srcout) {
        return srcout.equals(this.getDefaultSrcOut());
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.executable == null && this.getJdkToolchain() != null) {
            this.executable = new File(this.getJdkToolchain().findTool(this.getToolName()));
        }
        this.executeJaxws();
    }

    public abstract void executeJaxws() throws MojoExecutionException, MojoFailureException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exec(List<String> args) throws MojoExecutionException {
        String launched = "";
        Commandline cmd = new Commandline();
        if (this.executable != null) {
            launched = this.executable.getName();
            if (!this.executable.isFile() || !this.executable.canExecute()) throw new MojoExecutionException("Cannot execute: " + this.executable.getAbsolutePath());
            cmd.setExecutable(this.executable.getAbsolutePath());
            if (this.getExtraClasspath() != null) {
                cmd.createArg().setLine("-cp");
                cmd.createArg().setValue(this.getExtraClasspath());
            }
        } else {
            launched = this.getMain();
            if (this.getJdkToolchain() == null) {
                cmd.setExecutable(new File(new File(System.getProperty("java.home"), "bin"), this.getJavaExec()).getAbsolutePath());
            } else {
                cmd.setExecutable(this.getJdkToolchain().findTool("java"));
            }
            if (this.vmArgs != null) {
                for (String arg : this.vmArgs) {
                    cmd.createArg().setLine(arg);
                }
            }
            InvokerCP classpath = this.getInvokerCP();
            cmd.createArg().setValue("-Xbootclasspath/p:" + classpath.ecp);
            cmd.createArg().setValue("-cp");
            cmd.createArg().setValue(classpath.invokerPath);
            cmd.createArg().setLine(Invoker.class.getCanonicalName());
            cmd.createArg().setLine(this.getMain());
            String extraCp = this.getExtraClasspath();
            String cp = (extraCp != null ? extraCp + File.pathSeparator : "") + classpath.cp;
            try {
                File pathFile = this.createPathFile(cp);
                cmd.createArg().setLine("-pathfile " + pathFile.getAbsolutePath());
            }
            catch (IOException ioe) {
                cmd.createArg().setValue("-cp");
                cmd.createArg().setValue(cp);
            }
        }
        cmd.setWorkingDirectory(this.project.getBasedir());
        for (String arg : args) {
            cmd.createArg().setLine(arg);
        }
        try {
            String fullCommand = cmd.toString();
            if (this.isWindows() && 8191 <= fullCommand.length()) {
                this.getLog().warn((CharSequence)("Length of Windows command line is limited to 8191 characters, but current command has " + fullCommand.length() + " characters:"));
                this.getLog().warn((CharSequence)fullCommand);
            } else {
                this.getLog().debug((CharSequence)fullCommand);
            }
            DefaultConsumer sc = new DefaultConsumer();
            if (CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)sc, (StreamConsumer)sc) == 0) return;
            throw new MojoExecutionException("Invocation of " + launched + " failed - check output");
        }
        catch (CommandLineException t) {
            throw new MojoExecutionException(t.getMessage(), (Exception)((Object)t));
        }
    }

    protected void maybeUnsupportedOption(String option, String value, List<String> args) {
        if (this.executable == null) {
            args.add(option);
            if (value != null) {
                args.add(value);
            }
        } else {
            this.getLog().warn((CharSequence)(option + " may not supported on older JDKs.\n" + "Use <args> to bypass this warning if you really want to use it."));
        }
    }

    private InvokerCP getInvokerCP() {
        HashSet<Artifact> endorsedArtifacts = new HashSet<Artifact>();
        HashMap<String, Artifact> artifactsMap = new HashMap<String, Artifact>();
        for (Artifact a : this.pluginDescriptor.getArtifacts()) {
            this.addArtifactToCp(a, artifactsMap, endorsedArtifacts);
        }
        StringBuilder cp = this.getCPasString(artifactsMap.values());
        StringBuilder ecp = this.getCPasString(endorsedArtifacts);
        String invokerPath = null;
        try {
            invokerPath = Invoker.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
            invokerPath = new URI(invokerPath.substring(5)).getPath();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        cp.append(File.pathSeparator);
        cp.append(invokerPath);
        String javaHome = this.getJavaHome();
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHome, "lib/tools.jar");
        }
        cp.append(File.pathSeparator);
        cp.append(toolsJar.getAbsolutePath());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("getInvokerCP():\n    endorsed: " + this.toString(endorsedArtifacts) + "\n" + "    classpath: " + this.toString(artifactsMap.values()) + "\n" + "    ecp: " + ecp + "\n" + "    cp: " + cp + "\n" + "    invokerPath: " + invokerPath));
        }
        return new InvokerCP(ecp.toString(), cp.toString(), invokerPath);
    }

    private String getJavaExec() {
        return this.isWindows() ? "java.exe" : "java";
    }

    private String getJavaHome() {
        String javaHome = System.getProperty("java.home");
        if (this.getJdkToolchain() != null) {
            File javaExecutable = new File(this.getJdkToolchain().findTool("java"));
            javaHome = javaExecutable.getParentFile().getParent();
        }
        return javaHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPathFile(String cp) throws IOException {
        File f = File.createTempFile("jax-ws-mvn-plugin-cp", ".txt");
        if (f.exists() && f.isFile() && !f.delete()) {
            this.getLog().warn((CharSequence)("cannot remove obsolete classpath setting file: " + f.getAbsolutePath()));
        }
        Properties p = new Properties();
        p.put("cp", cp.replace(File.separatorChar, '/'));
        this.getLog().debug((CharSequence)("stored classpath: " + cp.replace(File.separatorChar, '/')));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            p.store(fos, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            this.closeQuietly(fos);
        }
        return f;
    }

    private boolean isWindows() {
        return Os.isFamily((String)"windows");
    }

    private boolean containsTools(Set<String> cp) {
        return cp.contains("com.sun.xml.ws:jaxws-tools") || cp.contains("org.glassfish.metro:webservices-tools") || cp.contains("com.oracle.weblogic:weblogic-server-pom");
    }

    private StringBuilder getCPasString(Collection<Artifact> artifacts) {
        StringBuilder sb = new StringBuilder();
        for (Artifact a : artifacts) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(a.getFile().getAbsolutePath());
        }
        return sb;
    }

    private String toString(Collection<Artifact> artifacts) {
        StringBuilder sb = new StringBuilder();
        for (Artifact a : artifacts) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(a.getGroupId());
            sb.append(':');
            sb.append(a.getArtifactId());
            sb.append(':');
            sb.append(a.getVersion());
        }
        return sb.toString();
    }

    private void addArtifactToCp(Artifact a, Map<String, Artifact> artifactsMap, Set<Artifact> endorsedArtifacts) {
        if (this.isEndorsedArtifact(a)) {
            endorsedArtifacts.add(a);
        } else if ("compile".equals(a.getScope()) || "runtime".equals(a.getScope())) {
            artifactsMap.put(a.getGroupId() + ":" + a.getArtifactId(), a);
        }
    }

    private boolean isEndorsedArtifact(Artifact a) {
        return "jaxws-api".equals(a.getArtifactId()) || "jaxb-api".equals(a.getArtifactId()) || "saaj-api".equals(a.getArtifactId()) || "jsr181-api".equals(a.getArtifactId()) || "javax.annotation".equals(a.getArtifactId()) || "javax.annotation-api".equals(a.getArtifactId()) || "webservices-api".equals(a.getArtifactId()) || a.getArtifactId().startsWith("javax.xml.ws") || a.getArtifactId().startsWith("javax.xml.bind");
    }

    private Toolchain getJdkToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    protected void closeQuietly(Object o) {
        if (o != null && o instanceof Closeable) {
            try {
                ((Closeable)o).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        METRO_22.add("-encoding");
        METRO_22.add("-clientjar");
        METRO_22.add("-generateJWS");
        METRO_22.add("-implDestDir");
        METRO_22.add("-implServiceName");
        METRO_22.add("-implPortName");
        METRO_221.addAll(METRO_22);
        METRO_221.add("-XdisableAuthenticator");
        METRO_23.addAll(METRO_221);
        METRO_23.add("-x");
    }

    private static class InvokerCP {
        public final String ecp;
        public final String cp;
        public final String invokerPath;

        public InvokerCP(String ecp, String cp, String invokerPath) {
            this.ecp = ecp;
            this.cp = cp;
            this.invokerPath = invokerPath;
        }
    }
}

