/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;
import org.codehaus.plexus.util.FileUtils;

abstract class AbstractWsGenMojo
extends AbstractJaxwsMojo {
    @Parameter(defaultValue="false")
    protected boolean genWsdl;
    @Parameter
    private String sei;
    @Parameter
    private String protocol;
    @Parameter
    private String servicename;
    @Parameter
    private String portname;
    @Parameter(defaultValue="false")
    private boolean inlineSchemas;
    @Parameter(defaultValue="false")
    private boolean xnocompile;
    @Parameter(defaultValue="false")
    private boolean xdonotoverwrite;
    @Parameter
    private File metadata;

    AbstractWsGenMojo() {
    }

    protected abstract File getResourceDestDir();

    protected abstract File getClassesDir();

    @Override
    public void executeJaxws() throws MojoExecutionException, MojoFailureException {
        HashSet<String> seis = new HashSet<String>();
        if (this.sei != null) {
            seis.add(this.sei);
        } else {
            seis.addAll(this.getSEIs(this.getClassesDir()));
        }
        if (seis.isEmpty()) {
            throw new MojoFailureException("No @javax.jws.WebService found.");
        }
        for (String aSei : seis) {
            this.processSei(aSei);
        }
    }

    protected void processSei(String aSei) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Processing: " + aSei));
        ArrayList<String> args = this.getWsGenArgs(aSei);
        this.getLog().info((CharSequence)("jaxws:wsgen args: " + args));
        this.exec(args);
        if (this.metadata != null) {
            try {
                FileUtils.copyFileToDirectory((File)this.metadata, (File)this.getClassesDir());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
    }

    @Override
    protected String getMain() {
        return "com.sun.tools.ws.wscompile.WsgenTool";
    }

    @Override
    protected String getToolName() {
        return "wsgen";
    }

    @Override
    protected String getExtraClasspath() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClassesDir().getAbsolutePath());
        for (Artifact a : this.project.getArtifacts()) {
            buf.append(File.pathSeparatorChar);
            buf.append(a.getFile().getAbsolutePath());
        }
        return buf.toString();
    }

    @Override
    protected boolean isXnocompile() {
        return this.xnocompile;
    }

    private ArrayList<String> getWsGenArgs(String aSei) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCommonArgs());
        if (this.genWsdl) {
            File resourceDir;
            if (this.protocol != null) {
                args.add("-wsdl:" + this.protocol);
            } else {
                args.add("-wsdl");
            }
            if (this.inlineSchemas) {
                this.maybeUnsupportedOption("-inlineSchemas", null, args);
            }
            if (this.servicename != null) {
                args.add("-servicename");
                args.add(this.servicename);
            }
            if (this.portname != null) {
                args.add("-portname");
                args.add(this.portname);
            }
            if (!(resourceDir = this.getResourceDestDir()).mkdirs() && !resourceDir.exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + resourceDir.getAbsolutePath()));
            }
            args.add("-r");
            args.add("'" + resourceDir.getAbsolutePath() + "'");
            if (!"war".equals(this.project.getPackaging())) {
                Resource r = new Resource();
                r.setDirectory(this.getRelativePath(this.project.getBasedir(), this.getResourceDestDir()));
                this.project.addResource(r);
            }
        }
        if (this.xdonotoverwrite) {
            args.add("-Xdonotoverwrite");
        }
        if (this.metadata != null && this.isArgSupported("-x")) {
            this.maybeUnsupportedOption("-x", "'" + this.metadata.getAbsolutePath() + "'", args);
        }
        args.add(aSei);
        return args;
    }

    private String getRelativePath(File root, File f) {
        return root.toURI().relativize(f.toURI()).getPath();
    }

    /*
     * Exception decompiling
     */
    private Set<String> getSEIs(File directory) throws MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

