package org.codehaus.mojo.jboss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jboss-maven-plugin.<br/> Call <pre>  mvn jboss:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Jul 07 10:31:42 CDT 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:jboss-maven-plugin:1.4.1", 0 );
        append( sb, "", 0 );

        append( sb, "JBoss Maven Plugin", 0 );
        append( sb, "This plugin manages the ability start/stop JBoss and deploy/undeploy applications via JMX.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 13 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "configure".equals( goal ) )
        {
            append( sb, "jboss:configure", 0 );
            append( sb, "Allows you to configure JBoss installation by overlaying a conf, lib and deploy directory.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "confDir (Default: ${basedir}/jboss/conf)", 2 );
                append( sb, "The directory for overrides to the conf directory.", 3 );
                append( sb, "", 0 );

                append( sb, "deployDir (Default: ${basedir}/jboss/deploy)", 2 );
                append( sb, "The directory for overrides to the deploy directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javaOpts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: ${basedir}/jboss/lib)", 2 );
                append( sb, "The directory for overrides to the lib directory.", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/jboss)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "deploy".equals( goal ) )
        {
            append( sb, "jboss:deploy", 0 );
            append( sb, "Deploys a directory or file to JBoss via JMX.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "deployUrlPath", 2 );
                append( sb, "The deployment URL path relative to the base URL path.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNameEncoding (Default: UTF-8)", 2 );
                append( sb, "The character encoding for the fileName.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The name of the file or directory to deploy or undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "hostName (Default: localhost)", 2 );
                append( sb, "The host JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hard-deploy".equals( goal ) )
        {
            append( sb, "jboss:hard-deploy", 0 );
            append( sb, "Hard deploys the file by copying it to the $JBOSS_HOME/server/[serverName]/deploy directory.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "deploySubDir", 2 );
                append( sb, "An optional name of a subdirectory on the deploy directory to be used", 3 );
                append( sb, "", 0 );

                append( sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2 );
                append( sb, "The name of the file or directory to deploy or undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The names of the files or directories to deploy. If this is set, the fileName parameter will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );

                append( sb, "unpack (Default: false)", 2 );
                append( sb, "A boolean indicating if the artifact should be unpacked when deployed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hard-undeploy".equals( goal ) )
        {
            append( sb, "jboss:hard-undeploy", 0 );
            append( sb, "Delete file form $JBOSS_HOME/server/[serverName]/deploy directory.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2 );
                append( sb, "The name of the file or directory to undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The names of the files or directories to undeploy. If this is set, the fileName parameter will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "harddeploy".equals( goal ) )
        {
            append( sb, "jboss:harddeploy", 0 );
            append( sb, "Deprecated. As of version 1.4, use the hard-deploy goal instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Place holder to allow deprecated goal name to call hard-deploy.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "deploySubDir", 2 );
                append( sb, "An optional name of a subdirectory on the deploy directory to be used", 3 );
                append( sb, "", 0 );

                append( sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2 );
                append( sb, "The name of the file or directory to deploy or undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The names of the files or directories to deploy. If this is set, the fileName parameter will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );

                append( sb, "unpack (Default: false)", 2 );
                append( sb, "A boolean indicating if the artifact should be unpacked when deployed", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "hardundeploy".equals( goal ) )
        {
            append( sb, "jboss:hardundeploy", 0 );
            append( sb, "Deprecated. As of version 1.4, use the hard-undeploy goal instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Place holder to allow deprecated goal name to call hard-undeploy.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2 );
                append( sb, "The name of the file or directory to undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The names of the files or directories to undeploy. If this is set, the fileName parameter will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jboss:help", 0 );
            append( sb, "Display help information on jboss-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jboss:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "redeploy".equals( goal ) )
        {
            append( sb, "jboss:redeploy", 0 );
            append( sb, "ReDeploys a directory or file to JBoss via JMX.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The name of the file or directory to deploy or undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "hostName (Default: localhost)", 2 );
                append( sb, "The host JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "redeployUrlPath", 2 );
                append( sb, "The redeployment URL.", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "start".equals( goal ) )
        {
            append( sb, "jboss:start", 0 );
            append( sb, "Starts JBoss.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "start-and-wait".equals( goal ) )
        {
            append( sb, "jboss:start-and-wait", 0 );
            append( sb, "Starts JBoss and waits until the server is started.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "hostName (Default: localhost)", 2 );
                append( sb, "The host JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "namingPort (Default: 1099)", 2 );
                append( sb, "The port for the naming service.", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "retry (Default: 4)", 2 );
                append( sb, "Maximum number of retries to get JBoss JMX MBean connection.", 3 );
                append( sb, "", 0 );

                append( sb, "retryWait (Default: 5000)", 2 );
                append( sb, "Wait in ms before each retry of the JBoss JMX MBean connection.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );

                append( sb, "timeout (Default: 20000)", 2 );
                append( sb, "Time in ms to start the application server (once JMX MBean connection has been reached).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "startAndWait".equals( goal ) )
        {
            append( sb, "jboss:startAndWait", 0 );
            append( sb, "Deprecated. As of version 1.4, use the start-and-wait goal instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Place holder to allow deprecated goal name to call start-and-wait.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "hostName (Default: localhost)", 2 );
                append( sb, "The host JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "namingPort (Default: 1099)", 2 );
                append( sb, "The port for the naming service.", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'run\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "retry (Default: 4)", 2 );
                append( sb, "Maximum number of retries to get JBoss JMX MBean connection.", 3 );
                append( sb, "", 0 );

                append( sb, "retryWait (Default: 5000)", 2 );
                append( sb, "Wait in ms before each retry of the JBoss JMX MBean connection.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );

                append( sb, "timeout (Default: 20000)", 2 );
                append( sb, "Time in ms to start the application server (once JMX MBean connection has been reached).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stop".equals( goal ) )
        {
            append( sb, "jboss:stop", 0 );
            append( sb, "Stops JBoss. By default the plugin will return immediately after calling \'shutdown\' command. The @see #stopWait parameter can be used to force the plugin to wait for a specified time before returning control.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "jbossHome", 2 );
                append( sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3 );
                append( sb, "", 0 );

                append( sb, "options", 2 );
                append( sb, "The set of options to pass to the JBoss \'shutdown\' command.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "serverName (Default: default)", 2 );
                append( sb, "The name of the configuration profile to use when starting the server. This might be something like \'all\', \'default\', or \'minimal\'.", 3 );
                append( sb, "", 0 );

                append( sb, "stopWait", 2 );
                append( sb, "Wait in ms for server to shutdown before the plugin returns.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "undeploy".equals( goal ) )
        {
            append( sb, "jboss:undeploy", 0 );
            append( sb, "Undeploys a directory or file from JBoss via JMX.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fileNames", 2 );
                append( sb, "The name of the file or directory to deploy or undeploy.", 3 );
                append( sb, "", 0 );

                append( sb, "hostName (Default: localhost)", 2 );
                append( sb, "The host JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port JBoss is running on.", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "undeployUrlPath", 2 );
                append( sb, "The undeployment path relative to the base server URL.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
