// $ANTLR 3.1.3 Mar 17, 2009 19:23:44 org/codehaus/mojo/jsimport/ECMAScriptLexer.g 2012-05-15 12:30:48

	package org.codehaus.mojo.jsimport;
	
	import java.io.File;

	import java.net.URI;
	import java.net.URISyntaxException;
	import java.util.ArrayList;
	import java.util.List;

	import org.apache.commons.io.FilenameUtils;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
public class ECMAScriptLexer extends Lexer {
    public static final int MODULE_ID=13;
    public static final int GLOBAL_OBJECT=32;
    public static final int EXTERNAL_VAR_DECL=5;
    public static final int IMPORTDOC=9;
    public static final int VAR_DECL=29;
    public static final int LITERAL=22;
    public static final int RELURL=17;
    public static final int GAVID=10;
    public static final int WINDOW_VAR_BRACKET=28;
    public static final int ENTER_SCOPE=24;
    public static final int ID=7;
    public static final int EOF=-1;
    public static final int StringLiteral=21;
    public static final int QUOTE=27;
    public static final int IMPORT=8;
    public static final int WS=4;
    public static final int EscapeQuoteSequence=23;
    public static final int REQUIRE_DECL=16;
    public static final int CharLiteral=20;
    public static final int OBJECT_DECL=31;
    public static final int WINDOW_VAR_DOT=26;
    public static final int MODULE_DEPENDENCIES=14;
    public static final int SL_COMMENT=12;
    public static final int MODULE_DEPENDENCY=18;
    public static final int RegexLiteral=19;
    public static final int EXTERNAL_VAR=6;
    public static final int COMMENT=11;
    public static final int EXIT_SCOPE=25;
    public static final int GLOBAL_VAR=30;
    public static final int MODULE_DECL=15;

    	private int varScopeLevel = 0;
    	
    	private List<String> assignedGlobalVars = new ArrayList<String>();
    	private List<String> unassignedGlobalVars = new ArrayList<String>();
    	
    	private URI sourceBaseDirUri;
    	private String sourceFilename;
    	
    	boolean moduleNameProvided;
    	String moduleName;
    	List<String> moduleDependencies = new ArrayList<String>();
    	
    	public class GAV {
    		public String groupId;
    		public String artifactId;
    		
    		public String toString() {
    			return groupId + ":" + artifactId;
    		}
    	}
    	
    	private List<GAV> importGavs = new ArrayList<GAV>();
    	
    	public List<String> getAssignedGlobalVars() {
    		return assignedGlobalVars;
    	}
    	
    	public List<GAV> getImportGavs() {
    		return importGavs;
    	}
    	
    	public List<String> getUnassignedGlobalVars() {
    		return unassignedGlobalVars;
    	}
    	
    	public void setSourceFile(URI sourceBaseDirUri, String sourceFilename) {
    		this.sourceBaseDirUri = sourceBaseDirUri;
    		this.sourceFilename = sourceFilename;
    	}
    	
    	private String makeRelPath(String filePath) {
    		try {
    			URI relUri = sourceBaseDirUri.resolve(new URI(filePath));
    			return relUri.getPath();
    		} catch (URISyntaxException e) {
    			return filePath;
    		}
    	}
    	
    	private String normaliseModuleId(String moduleId) {
    		if (moduleId.startsWith("./") || moduleId.startsWith("../")) {
    			return makeRelPath(moduleId);
    		} else {
    			return moduleId;
    		}
    	}


    // delegates
    // delegators

    public ECMAScriptLexer() {;} 
    public ECMAScriptLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public ECMAScriptLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "org/codehaus/mojo/jsimport/ECMAScriptLexer.g"; }

    public Token nextToken() {
        while (true) {
            if ( input.LA(1)==CharStream.EOF ) {
                return Token.EOF_TOKEN;
            }
            state.token = null;
    	state.channel = Token.DEFAULT_CHANNEL;
            state.tokenStartCharIndex = input.index();
            state.tokenStartCharPositionInLine = input.getCharPositionInLine();
            state.tokenStartLine = input.getLine();
    	state.text = null;
            try {
                int m = input.mark();
                state.backtracking=1; 
                state.failed=false;
                mTokens();
                state.backtracking=0;

                if ( state.failed ) {
                    input.rewind(m);
                    input.consume(); 
                }
                else {
                    emit();
                    return state.token;
                }
            }
            catch (RecognitionException re) {
                // shouldn't happen in backtracking mode, but...
                reportError(re);
                recover(re);
            }
        }
    }

    public void memoize(IntStream input,
    		int ruleIndex,
    		int ruleStartIndex)
    {
    if ( state.backtracking>1 ) super.memoize(input, ruleIndex, ruleStartIndex);
    }

    public boolean alreadyParsedRule(IntStream input, int ruleIndex) {
    if ( state.backtracking>1 ) return super.alreadyParsedRule(input, ruleIndex);
    return false;
    }// $ANTLR start "EXTERNAL_VAR"
    public final void mEXTERNAL_VAR() throws RecognitionException {
        try {
            int _type = EXTERNAL_VAR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:94:5: ( '/*global' WS EXTERNAL_VAR_DECL ( ',' ( WS )? EXTERNAL_VAR_DECL )* '*/' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:94:9: '/*global' WS EXTERNAL_VAR_DECL ( ',' ( WS )? EXTERNAL_VAR_DECL )* '*/'
            {
            match("/*global"); if (state.failed) return ;

            mWS(); if (state.failed) return ;
            mEXTERNAL_VAR_DECL(); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:94:41: ( ',' ( WS )? EXTERNAL_VAR_DECL )*
            loop2:
            do {
                int alt2=2;
                int LA2_0 = input.LA(1);

                if ( (LA2_0==',') ) {
                    alt2=1;
                }


                switch (alt2) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:94:42: ',' ( WS )? EXTERNAL_VAR_DECL
            	    {
            	    match(','); if (state.failed) return ;
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:94:46: ( WS )?
            	    int alt1=2;
            	    int LA1_0 = input.LA(1);

            	    if ( ((LA1_0>='\t' && LA1_0<='\n')||LA1_0=='\r'||LA1_0==' ') ) {
            	        alt1=1;
            	    }
            	    switch (alt1) {
            	        case 1 :
            	            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:94:46: WS
            	            {
            	            mWS(); if (state.failed) return ;

            	            }
            	            break;

            	    }

            	    mEXTERNAL_VAR_DECL(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            match("*/"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "EXTERNAL_VAR"

    // $ANTLR start "EXTERNAL_VAR_DECL"
    public final void mEXTERNAL_VAR_DECL() throws RecognitionException {
        try {
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:5: (name= ID ( WS )? ( ':' ( WS )? ( 'true' | 'false' ) ( WS )? )? )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:9: name= ID ( WS )? ( ':' ( WS )? ( 'true' | 'false' ) ( WS )? )?
            {
            int nameStart83 = getCharIndex();
            mID(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart83, getCharIndex()-1);
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:17: ( WS )?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( ((LA3_0>='\t' && LA3_0<='\n')||LA3_0=='\r'||LA3_0==' ') ) {
                alt3=1;
            }
            switch (alt3) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:17: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:21: ( ':' ( WS )? ( 'true' | 'false' ) ( WS )? )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==':') ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:22: ':' ( WS )? ( 'true' | 'false' ) ( WS )?
                    {
                    match(':'); if (state.failed) return ;
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:26: ( WS )?
                    int alt4=2;
                    int LA4_0 = input.LA(1);

                    if ( ((LA4_0>='\t' && LA4_0<='\n')||LA4_0=='\r'||LA4_0==' ') ) {
                        alt4=1;
                    }
                    switch (alt4) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:26: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }

                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:30: ( 'true' | 'false' )
                    int alt5=2;
                    int LA5_0 = input.LA(1);

                    if ( (LA5_0=='t') ) {
                        alt5=1;
                    }
                    else if ( (LA5_0=='f') ) {
                        alt5=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 5, 0, input);

                        throw nvae;
                    }
                    switch (alt5) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:31: 'true'
                            {
                            match("true"); if (state.failed) return ;


                            }
                            break;
                        case 2 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:38: 'false'
                            {
                            match("false"); if (state.failed) return ;


                            }
                            break;

                    }

                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:47: ( WS )?
                    int alt6=2;
                    int LA6_0 = input.LA(1);

                    if ( ((LA6_0>='\t' && LA6_0<='\n')||LA6_0=='\r'||LA6_0==' ') ) {
                        alt6=1;
                    }
                    switch (alt6) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:98:47: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }


                    }
                    break;

            }

            if ( state.backtracking==1 ) {

                 			unassignedGlobalVars.add((name!=null?name.getText():null));
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "EXTERNAL_VAR_DECL"

    // $ANTLR start "IMPORTDOC"
    public final void mIMPORTDOC() throws RecognitionException {
        try {
            int _type = IMPORTDOC;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:2: ( '/**' ( . )* IMPORT ( . )* ( IMPORT ( . )* )* '*/' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:4: '/**' ( . )* IMPORT ( . )* ( IMPORT ( . )* )* '*/'
            {
            match("/**"); if (state.failed) return ;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:10: ( . )*
            loop8:
            do {
                int alt8=2;
                alt8 = dfa8.predict(input);
                switch (alt8) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:10: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop8;
                }
            } while (true);

            mIMPORT(); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:20: ( . )*
            loop9:
            do {
                int alt9=2;
                alt9 = dfa9.predict(input);
                switch (alt9) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:20: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop9;
                }
            } while (true);

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:23: ( IMPORT ( . )* )*
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( (LA11_0=='@') ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:24: IMPORT ( . )*
            	    {
            	    mIMPORT(); if (state.failed) return ;
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:31: ( . )*
            	    loop10:
            	    do {
            	        int alt10=2;
            	        alt10 = dfa10.predict(input);
            	        switch (alt10) {
            	    	case 1 :
            	    	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:104:31: .
            	    	    {
            	    	    matchAny(); if (state.failed) return ;

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop10;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop11;
                }
            } while (true);

            match("*/"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "IMPORTDOC"

    // $ANTLR start "IMPORT"
    public final void mIMPORT() throws RecognitionException {
        try {
            Token groupId=null;
            Token artifactId=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:109:2: ( '@import' WS groupId= GAVID ':' artifactId= GAVID )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:109:4: '@import' WS groupId= GAVID ':' artifactId= GAVID
            {
            match("@import"); if (state.failed) return ;

            mWS(); if (state.failed) return ;
            int groupIdStart159 = getCharIndex();
            mGAVID(); if (state.failed) return ;
            groupId = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, groupIdStart159, getCharIndex()-1);
            match(':'); if (state.failed) return ;
            int artifactIdStart165 = getCharIndex();
            mGAVID(); if (state.failed) return ;
            artifactId = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, artifactIdStart165, getCharIndex()-1);
            if ( state.backtracking==1 ) {

              			// Note the import GAV params.
              			GAV importGav = new GAV();
              			importGav.groupId = (groupId!=null?groupId.getText():null);
              			importGav.artifactId = (artifactId!=null?artifactId.getText():null);
              			importGavs.add(importGav);
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "IMPORT"

    // $ANTLR start "GAVID"
    public final void mGAVID() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:120:2: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' ) ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '-' | '0' .. '9' | '.' )* )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:120:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' ) ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '-' | '0' .. '9' | '.' )*
            {
            if ( (input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:120:30: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '-' | '0' .. '9' | '.' )*
            loop12:
            do {
                int alt12=2;
                int LA12_0 = input.LA(1);

                if ( ((LA12_0>='-' && LA12_0<='.')||(LA12_0>='0' && LA12_0<='9')||(LA12_0>='A' && LA12_0<='Z')||LA12_0=='_'||(LA12_0>='a' && LA12_0<='z')) ) {
                    alt12=1;
                }


                switch (alt12) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:
            	    {
            	    if ( (input.LA(1)>='-' && input.LA(1)<='.')||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop12;
                }
            } while (true);


            }

        }
        finally {
        }
    }
    // $ANTLR end "GAVID"

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:124:2: ( '/*' ( . )* '*/' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:124:4: '/*' ( . )* '*/'
            {
            match("/*"); if (state.failed) return ;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:124:9: ( . )*
            loop13:
            do {
                int alt13=2;
                int LA13_0 = input.LA(1);

                if ( (LA13_0=='*') ) {
                    int LA13_1 = input.LA(2);

                    if ( (LA13_1=='/') ) {
                        alt13=2;
                    }
                    else if ( ((LA13_1>='\u0000' && LA13_1<='.')||(LA13_1>='0' && LA13_1<='\uFFFF')) ) {
                        alt13=1;
                    }


                }
                else if ( ((LA13_0>='\u0000' && LA13_0<=')')||(LA13_0>='+' && LA13_0<='\uFFFF')) ) {
                    alt13=1;
                }


                switch (alt13) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:124:9: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop13;
                }
            } while (true);

            match("*/"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "SL_COMMENT"
    public final void mSL_COMMENT() throws RecognitionException {
        try {
            int _type = SL_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:128:2: ( '//' ( . )* '\\n' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:128:4: '//' ( . )* '\\n'
            {
            match("//"); if (state.failed) return ;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:128:9: ( . )*
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0=='\n') ) {
                    alt14=2;
                }
                else if ( ((LA14_0>='\u0000' && LA14_0<='\t')||(LA14_0>='\u000B' && LA14_0<='\uFFFF')) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:128:9: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop14;
                }
            } while (true);

            match('\n'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "SL_COMMENT"

    // $ANTLR start "MODULE_DECL"
    public final void mMODULE_DECL() throws RecognitionException {
        try {
            int _type = MODULE_DECL;
            int _channel = DEFAULT_TOKEN_CHANNEL;

            	moduleNameProvided = false;
            	moduleDependencies.clear();

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:3: ( 'define' ( WS )? '(' ( ( WS )? MODULE_ID ( WS )? ',' )? ( ( WS )? MODULE_DEPENDENCIES ( WS )? ',' ( WS )? )? 'function' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:5: 'define' ( WS )? '(' ( ( WS )? MODULE_ID ( WS )? ',' )? ( ( WS )? MODULE_DEPENDENCIES ( WS )? ',' ( WS )? )? 'function'
            {
            match("define"); if (state.failed) return ;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:14: ( WS )?
            int alt15=2;
            int LA15_0 = input.LA(1);

            if ( ((LA15_0>='\t' && LA15_0<='\n')||LA15_0=='\r'||LA15_0==' ') ) {
                alt15=1;
            }
            switch (alt15) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:14: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match('('); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:22: ( ( WS )? MODULE_ID ( WS )? ',' )?
            int alt18=2;
            alt18 = dfa18.predict(input);
            switch (alt18) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:23: ( WS )? MODULE_ID ( WS )? ','
                    {
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:23: ( WS )?
                    int alt16=2;
                    int LA16_0 = input.LA(1);

                    if ( ((LA16_0>='\t' && LA16_0<='\n')||LA16_0=='\r'||LA16_0==' ') ) {
                        alt16=1;
                    }
                    switch (alt16) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:23: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }

                    mMODULE_ID(); if (state.failed) return ;
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:37: ( WS )?
                    int alt17=2;
                    int LA17_0 = input.LA(1);

                    if ( ((LA17_0>='\t' && LA17_0<='\n')||LA17_0=='\r'||LA17_0==' ') ) {
                        alt17=1;
                    }
                    switch (alt17) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:37: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }

                    match(','); if (state.failed) return ;

                    }
                    break;

            }

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:47: ( ( WS )? MODULE_DEPENDENCIES ( WS )? ',' ( WS )? )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( ((LA22_0>='\t' && LA22_0<='\n')||LA22_0=='\r'||LA22_0==' '||LA22_0=='[') ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:48: ( WS )? MODULE_DEPENDENCIES ( WS )? ',' ( WS )?
                    {
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:48: ( WS )?
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( ((LA19_0>='\t' && LA19_0<='\n')||LA19_0=='\r'||LA19_0==' ') ) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:48: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }

                    mMODULE_DEPENDENCIES(); if (state.failed) return ;
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:72: ( WS )?
                    int alt20=2;
                    int LA20_0 = input.LA(1);

                    if ( ((LA20_0>='\t' && LA20_0<='\n')||LA20_0=='\r'||LA20_0==' ') ) {
                        alt20=1;
                    }
                    switch (alt20) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:72: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }

                    match(','); if (state.failed) return ;
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:80: ( WS )?
                    int alt21=2;
                    int LA21_0 = input.LA(1);

                    if ( ((LA21_0>='\t' && LA21_0<='\n')||LA21_0=='\r'||LA21_0==' ') ) {
                        alt21=1;
                    }
                    switch (alt21) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:134:80: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }


                    }
                    break;

            }

            match("function"); if (state.failed) return ;

            if ( state.backtracking==1 ) {

              			StringBuilder builder = new StringBuilder();
              			builder.append("define( ");
              			builder.append("\"" + moduleName + "\",");
              			builder.append(" [");
              			boolean appendedOneDependency = false;
              			for (String moduleDependency : moduleDependencies) {
              				if (appendedOneDependency) {
              					builder.append(',');
              				}
              				builder.append(" \"" + moduleDependency + "\"");
              				appendedOneDependency = true;
              			}
              			builder.append(" ], ");
              			builder.append("function");
              			state.text = builder.toString();
              		
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MODULE_DECL"

    // $ANTLR start "REQUIRE_DECL"
    public final void mREQUIRE_DECL() throws RecognitionException {
        try {
            int _type = REQUIRE_DECL;
            int _channel = DEFAULT_TOKEN_CHANNEL;

            	moduleDependencies.clear();

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:3: ( 'require' ( WS )? '(' ( WS )? MODULE_DEPENDENCIES ( WS )? ',' ( WS )? 'function' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:5: 'require' ( WS )? '(' ( WS )? MODULE_DEPENDENCIES ( WS )? ',' ( WS )? 'function'
            {
            match("require"); if (state.failed) return ;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:15: ( WS )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( ((LA23_0>='\t' && LA23_0<='\n')||LA23_0=='\r'||LA23_0==' ') ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:15: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match('('); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:23: ( WS )?
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( ((LA24_0>='\t' && LA24_0<='\n')||LA24_0=='\r'||LA24_0==' ') ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:23: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            mMODULE_DEPENDENCIES(); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:47: ( WS )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( ((LA25_0>='\t' && LA25_0<='\n')||LA25_0=='\r'||LA25_0==' ') ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:47: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match(','); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:55: ( WS )?
            int alt26=2;
            int LA26_0 = input.LA(1);

            if ( ((LA26_0>='\t' && LA26_0<='\n')||LA26_0=='\r'||LA26_0==' ') ) {
                alt26=1;
            }
            switch (alt26) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:155:55: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match("function"); if (state.failed) return ;

            if ( state.backtracking==1 ) {

              			StringBuilder builder = new StringBuilder();
              			builder.append("require( ");
              			builder.append(" [");
              			boolean appendedOneDependency = false;
              			for (String moduleDependency : moduleDependencies) {
              				if (appendedOneDependency) {
              					builder.append(',');
              				}
              				builder.append(" \"" + moduleDependency + "\"");
              				appendedOneDependency = true;
              			}
              			builder.append(" ], ");
              			builder.append("function");
              			state.text = builder.toString();
              		
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "REQUIRE_DECL"

    // $ANTLR start "MODULE_ID"
    public final void mMODULE_ID() throws RecognitionException {
        try {
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:174:2: ( ( '\"' | '\\'' ) name= RELURL ( '\"' | '\\'' ) )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:174:4: ( '\"' | '\\'' ) name= RELURL ( '\"' | '\\'' )
            {
            if ( input.LA(1)=='\"'||input.LA(1)=='\'' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            int nameStart367 = getCharIndex();
            mRELURL(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart367, getCharIndex()-1);
            if ( input.LA(1)=='\"'||input.LA(1)=='\'' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            if ( state.backtracking==1 ) {

              			String relPath = normaliseModuleId((name!=null?name.getText():null));
              			assignedGlobalVars.add(relPath);
              			moduleName = relPath;
              			moduleNameProvided = true;
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "MODULE_ID"

    // $ANTLR start "MODULE_DEPENDENCIES"
    public final void mMODULE_DEPENDENCIES() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:2: ( '[' ( WS )? ( MODULE_DEPENDENCY ( ( WS )? ',' ( WS )? MODULE_DEPENDENCY )* ( WS )? )? ']' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:4: '[' ( WS )? ( MODULE_DEPENDENCY ( ( WS )? ',' ( WS )? MODULE_DEPENDENCY )* ( WS )? )? ']'
            {
            match('['); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:8: ( WS )?
            int alt27=2;
            int LA27_0 = input.LA(1);

            if ( ((LA27_0>='\t' && LA27_0<='\n')||LA27_0=='\r'||LA27_0==' ') ) {
                alt27=1;
            }
            switch (alt27) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:8: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:12: ( MODULE_DEPENDENCY ( ( WS )? ',' ( WS )? MODULE_DEPENDENCY )* ( WS )? )?
            int alt32=2;
            int LA32_0 = input.LA(1);

            if ( (LA32_0=='\"'||LA32_0=='\'') ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:13: MODULE_DEPENDENCY ( ( WS )? ',' ( WS )? MODULE_DEPENDENCY )* ( WS )?
                    {
                    mMODULE_DEPENDENCY(); if (state.failed) return ;
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:31: ( ( WS )? ',' ( WS )? MODULE_DEPENDENCY )*
                    loop30:
                    do {
                        int alt30=2;
                        alt30 = dfa30.predict(input);
                        switch (alt30) {
                    	case 1 :
                    	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:32: ( WS )? ',' ( WS )? MODULE_DEPENDENCY
                    	    {
                    	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:32: ( WS )?
                    	    int alt28=2;
                    	    int LA28_0 = input.LA(1);

                    	    if ( ((LA28_0>='\t' && LA28_0<='\n')||LA28_0=='\r'||LA28_0==' ') ) {
                    	        alt28=1;
                    	    }
                    	    switch (alt28) {
                    	        case 1 :
                    	            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:32: WS
                    	            {
                    	            mWS(); if (state.failed) return ;

                    	            }
                    	            break;

                    	    }

                    	    match(','); if (state.failed) return ;
                    	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:40: ( WS )?
                    	    int alt29=2;
                    	    int LA29_0 = input.LA(1);

                    	    if ( ((LA29_0>='\t' && LA29_0<='\n')||LA29_0=='\r'||LA29_0==' ') ) {
                    	        alt29=1;
                    	    }
                    	    switch (alt29) {
                    	        case 1 :
                    	            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:40: WS
                    	            {
                    	            mWS(); if (state.failed) return ;

                    	            }
                    	            break;

                    	    }

                    	    mMODULE_DEPENDENCY(); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    break loop30;
                        }
                    } while (true);

                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:64: ( WS )?
                    int alt31=2;
                    int LA31_0 = input.LA(1);

                    if ( ((LA31_0>='\t' && LA31_0<='\n')||LA31_0=='\r'||LA31_0==' ') ) {
                        alt31=1;
                    }
                    switch (alt31) {
                        case 1 :
                            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:183:64: WS
                            {
                            mWS(); if (state.failed) return ;

                            }
                            break;

                    }


                    }
                    break;

            }

            match(']'); if (state.failed) return ;
            if ( state.backtracking==1 ) {

              			if (!moduleNameProvided) {
              				String relPath = makeRelPath(FilenameUtils.getBaseName(sourceFilename));
              				assignedGlobalVars.add(relPath);
              				moduleName = relPath;
              			}
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "MODULE_DEPENDENCIES"

    // $ANTLR start "MODULE_DEPENDENCY"
    public final void mMODULE_DEPENDENCY() throws RecognitionException {
        try {
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:193:2: ( ( '\"' | '\\'' ) name= RELURL ( '\"' | '\\'' ) )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:193:4: ( '\"' | '\\'' ) name= RELURL ( '\"' | '\\'' )
            {
            if ( input.LA(1)=='\"'||input.LA(1)=='\'' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            int nameStart443 = getCharIndex();
            mRELURL(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart443, getCharIndex()-1);
            if ( input.LA(1)=='\"'||input.LA(1)=='\'' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            if ( state.backtracking==1 ) {

              			String relPath = normaliseModuleId((name!=null?name.getText():null));
              			unassignedGlobalVars.add(relPath);
              			moduleDependencies.add(relPath);
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "MODULE_DEPENDENCY"

    // $ANTLR start "RELURL"
    public final void mRELURL() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:201:2: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '-' | '0' .. '9' | '.' | '/' | '+' )* )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:201:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '-' | '0' .. '9' | '.' | '/' | '+' )*
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:201:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '-' | '0' .. '9' | '.' | '/' | '+' )*
            loop33:
            do {
                int alt33=2;
                int LA33_0 = input.LA(1);

                if ( (LA33_0=='+'||(LA33_0>='-' && LA33_0<='9')||(LA33_0>='A' && LA33_0<='Z')||LA33_0=='_'||(LA33_0>='a' && LA33_0<='z')) ) {
                    alt33=1;
                }


                switch (alt33) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:
            	    {
            	    if ( input.LA(1)=='+'||(input.LA(1)>='-' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop33;
                }
            } while (true);


            }

        }
        finally {
        }
    }
    // $ANTLR end "RELURL"

    // $ANTLR start "LITERAL"
    public final void mLITERAL() throws RecognitionException {
        try {
            int _type = LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:205:2: ( ( '/' RegexLiteral | '\\'' CharLiteral | '\"' StringLiteral ) )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:205:4: ( '/' RegexLiteral | '\\'' CharLiteral | '\"' StringLiteral )
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:205:4: ( '/' RegexLiteral | '\\'' CharLiteral | '\"' StringLiteral )
            int alt34=3;
            switch ( input.LA(1) ) {
            case '/':
                {
                alt34=1;
                }
                break;
            case '\'':
                {
                alt34=2;
                }
                break;
            case '\"':
                {
                alt34=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;
            }

            switch (alt34) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:205:6: '/' RegexLiteral
                    {
                    match('/'); if (state.failed) return ;
                    mRegexLiteral(); if (state.failed) return ;

                    }
                    break;
                case 2 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:206:5: '\\'' CharLiteral
                    {
                    match('\''); if (state.failed) return ;
                    mCharLiteral(); if (state.failed) return ;

                    }
                    break;
                case 3 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:207:5: '\"' StringLiteral
                    {
                    match('\"'); if (state.failed) return ;
                    mStringLiteral(); if (state.failed) return ;

                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LITERAL"

    // $ANTLR start "RegexLiteral"
    public final void mRegexLiteral() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:213:5: ( ( EscapeQuoteSequence | ~ ( '\\\\' | '/' | '\\n' ) )* '/' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:213:9: ( EscapeQuoteSequence | ~ ( '\\\\' | '/' | '\\n' ) )* '/'
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:213:9: ( EscapeQuoteSequence | ~ ( '\\\\' | '/' | '\\n' ) )*
            loop35:
            do {
                int alt35=3;
                int LA35_0 = input.LA(1);

                if ( (LA35_0=='\\') ) {
                    alt35=1;
                }
                else if ( ((LA35_0>='\u0000' && LA35_0<='\t')||(LA35_0>='\u000B' && LA35_0<='.')||(LA35_0>='0' && LA35_0<='[')||(LA35_0>=']' && LA35_0<='\uFFFF')) ) {
                    alt35=2;
                }


                switch (alt35) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:213:13: EscapeQuoteSequence
            	    {
            	    mEscapeQuoteSequence(); if (state.failed) return ;

            	    }
            	    break;
            	case 2 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:214:13: ~ ( '\\\\' | '/' | '\\n' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='.')||(input.LA(1)>='0' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop35;
                }
            } while (true);

            match('/'); if (state.failed) return ;

            }

        }
        finally {
        }
    }
    // $ANTLR end "RegexLiteral"

    // $ANTLR start "CharLiteral"
    public final void mCharLiteral() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:221:5: ( ( EscapeQuoteSequence | ~ ( '\\\\' | '\\'' | '\\n' ) )* '\\'' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:221:9: ( EscapeQuoteSequence | ~ ( '\\\\' | '\\'' | '\\n' ) )* '\\''
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:221:9: ( EscapeQuoteSequence | ~ ( '\\\\' | '\\'' | '\\n' ) )*
            loop36:
            do {
                int alt36=3;
                int LA36_0 = input.LA(1);

                if ( (LA36_0=='\\') ) {
                    alt36=1;
                }
                else if ( ((LA36_0>='\u0000' && LA36_0<='\t')||(LA36_0>='\u000B' && LA36_0<='&')||(LA36_0>='(' && LA36_0<='[')||(LA36_0>=']' && LA36_0<='\uFFFF')) ) {
                    alt36=2;
                }


                switch (alt36) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:221:13: EscapeQuoteSequence
            	    {
            	    mEscapeQuoteSequence(); if (state.failed) return ;

            	    }
            	    break;
            	case 2 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:222:13: ~ ( '\\\\' | '\\'' | '\\n' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='&')||(input.LA(1)>='(' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop36;
                }
            } while (true);

            match('\''); if (state.failed) return ;

            }

        }
        finally {
        }
    }
    // $ANTLR end "CharLiteral"

    // $ANTLR start "StringLiteral"
    public final void mStringLiteral() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:229:5: ( ( EscapeQuoteSequence | ~ ( '\\\\' | '\"' | '\\n' ) )* '\"' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:229:9: ( EscapeQuoteSequence | ~ ( '\\\\' | '\"' | '\\n' ) )* '\"'
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:229:9: ( EscapeQuoteSequence | ~ ( '\\\\' | '\"' | '\\n' ) )*
            loop37:
            do {
                int alt37=3;
                int LA37_0 = input.LA(1);

                if ( (LA37_0=='\\') ) {
                    alt37=1;
                }
                else if ( ((LA37_0>='\u0000' && LA37_0<='\t')||(LA37_0>='\u000B' && LA37_0<='!')||(LA37_0>='#' && LA37_0<='[')||(LA37_0>=']' && LA37_0<='\uFFFF')) ) {
                    alt37=2;
                }


                switch (alt37) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:229:13: EscapeQuoteSequence
            	    {
            	    mEscapeQuoteSequence(); if (state.failed) return ;

            	    }
            	    break;
            	case 2 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:230:13: ~ ( '\\\\' | '\"' | '\\n' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='!')||(input.LA(1)>='#' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop37;
                }
            } while (true);

            match('\"'); if (state.failed) return ;

            }

        }
        finally {
        }
    }
    // $ANTLR end "StringLiteral"

    // $ANTLR start "EscapeQuoteSequence"
    public final void mEscapeQuoteSequence() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:237:5: ( '\\\\' ( . )? )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:237:9: '\\\\' ( . )?
            {
            match('\\'); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:237:14: ( . )?
            int alt38=2;
            int LA38_0 = input.LA(1);

            if ( ((LA38_0>='\u0000' && LA38_0<='\uFFFF')) ) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:237:14: .
                    {
                    matchAny(); if (state.failed) return ;

                    }
                    break;

            }


            }

        }
        finally {
        }
    }
    // $ANTLR end "EscapeQuoteSequence"

    // $ANTLR start "ENTER_SCOPE"
    public final void mENTER_SCOPE() throws RecognitionException {
        try {
            int _type = ENTER_SCOPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:241:2: ( '{' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:241:4: '{'
            {
            match('{'); if (state.failed) return ;
            if ( state.backtracking==1 ) {
              ++varScopeLevel;
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ENTER_SCOPE"

    // $ANTLR start "EXIT_SCOPE"
    public final void mEXIT_SCOPE() throws RecognitionException {
        try {
            int _type = EXIT_SCOPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:245:2: ( '}' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:245:4: '}'
            {
            match('}'); if (state.failed) return ;
            if ( state.backtracking==1 ) {
              --varScopeLevel;
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "EXIT_SCOPE"

    // $ANTLR start "WINDOW_VAR_DOT"
    public final void mWINDOW_VAR_DOT() throws RecognitionException {
        try {
            int _type = WINDOW_VAR_DOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:249:5: ( 'window.' name= ID ( WS )? '=' ( . )* ';' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:249:9: 'window.' name= ID ( WS )? '=' ( . )* ';'
            {
            match("window."); if (state.failed) return ;

            int nameStart861 = getCharIndex();
            mID(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart861, getCharIndex()-1);
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:249:27: ( WS )?
            int alt39=2;
            int LA39_0 = input.LA(1);

            if ( ((LA39_0>='\t' && LA39_0<='\n')||LA39_0=='\r'||LA39_0==' ') ) {
                alt39=1;
            }
            switch (alt39) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:249:27: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match('='); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:249:35: ( . )*
            loop40:
            do {
                int alt40=2;
                int LA40_0 = input.LA(1);

                if ( (LA40_0==';') ) {
                    alt40=2;
                }
                else if ( ((LA40_0>='\u0000' && LA40_0<=':')||(LA40_0>='<' && LA40_0<='\uFFFF')) ) {
                    alt40=1;
                }


                switch (alt40) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:249:35: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop40;
                }
            } while (true);

            match(';'); if (state.failed) return ;
            if ( state.backtracking==1 ) {

              			assignedGlobalVars.add((name!=null?name.getText():null));
              		
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "WINDOW_VAR_DOT"

    // $ANTLR start "WINDOW_VAR_BRACKET"
    public final void mWINDOW_VAR_BRACKET() throws RecognitionException {
        try {
            int _type = WINDOW_VAR_BRACKET;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:5: ( 'window[' ( WS )? QUOTE name= ID QUOTE ( WS )? ']' ( WS )? '=' ( . )* ';' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:9: 'window[' ( WS )? QUOTE name= ID QUOTE ( WS )? ']' ( WS )? '=' ( . )* ';'
            {
            match("window["); if (state.failed) return ;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:19: ( WS )?
            int alt41=2;
            int LA41_0 = input.LA(1);

            if ( ((LA41_0>='\t' && LA41_0<='\n')||LA41_0=='\r'||LA41_0==' ') ) {
                alt41=1;
            }
            switch (alt41) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:19: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            mQUOTE(); if (state.failed) return ;
            int nameStart901 = getCharIndex();
            mID(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart901, getCharIndex()-1);
            mQUOTE(); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:43: ( WS )?
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( ((LA42_0>='\t' && LA42_0<='\n')||LA42_0=='\r'||LA42_0==' ') ) {
                alt42=1;
            }
            switch (alt42) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:43: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match(']'); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:51: ( WS )?
            int alt43=2;
            int LA43_0 = input.LA(1);

            if ( ((LA43_0>='\t' && LA43_0<='\n')||LA43_0=='\r'||LA43_0==' ') ) {
                alt43=1;
            }
            switch (alt43) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:51: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match('='); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:59: ( . )*
            loop44:
            do {
                int alt44=2;
                int LA44_0 = input.LA(1);

                if ( (LA44_0==';') ) {
                    alt44=2;
                }
                else if ( ((LA44_0>='\u0000' && LA44_0<=':')||(LA44_0>='<' && LA44_0<='\uFFFF')) ) {
                    alt44=1;
                }


                switch (alt44) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:255:59: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop44;
                }
            } while (true);

            match(';'); if (state.failed) return ;
            if ( state.backtracking==1 ) {

              			assignedGlobalVars.add((name!=null?name.getText():null));
              		
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "WINDOW_VAR_BRACKET"

    // $ANTLR start "GLOBAL_VAR"
    public final void mGLOBAL_VAR() throws RecognitionException {
        try {
            int _type = GLOBAL_VAR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:5: ( 'var' WS VAR_DECL ( ( WS )? ',' ( WS )? VAR_DECL )* ';' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:9: 'var' WS VAR_DECL ( ( WS )? ',' ( WS )? VAR_DECL )* ';'
            {
            match("var"); if (state.failed) return ;

            mWS(); if (state.failed) return ;
            mVAR_DECL(); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:27: ( ( WS )? ',' ( WS )? VAR_DECL )*
            loop47:
            do {
                int alt47=2;
                int LA47_0 = input.LA(1);

                if ( ((LA47_0>='\t' && LA47_0<='\n')||LA47_0=='\r'||LA47_0==' '||LA47_0==',') ) {
                    alt47=1;
                }


                switch (alt47) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:28: ( WS )? ',' ( WS )? VAR_DECL
            	    {
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:28: ( WS )?
            	    int alt45=2;
            	    int LA45_0 = input.LA(1);

            	    if ( ((LA45_0>='\t' && LA45_0<='\n')||LA45_0=='\r'||LA45_0==' ') ) {
            	        alt45=1;
            	    }
            	    switch (alt45) {
            	        case 1 :
            	            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:28: WS
            	            {
            	            mWS(); if (state.failed) return ;

            	            }
            	            break;

            	    }

            	    match(','); if (state.failed) return ;
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:36: ( WS )?
            	    int alt46=2;
            	    int LA46_0 = input.LA(1);

            	    if ( ((LA46_0>='\t' && LA46_0<='\n')||LA46_0=='\r'||LA46_0==' ') ) {
            	        alt46=1;
            	    }
            	    switch (alt46) {
            	        case 1 :
            	            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:261:36: WS
            	            {
            	            mWS(); if (state.failed) return ;

            	            }
            	            break;

            	    }

            	    mVAR_DECL(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop47;
                }
            } while (true);

            match(';'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GLOBAL_VAR"

    // $ANTLR start "VAR_DECL"
    public final void mVAR_DECL() throws RecognitionException {
        try {
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:265:5: (name= ID ( WS )? ( '=' )? )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:265:9: name= ID ( WS )? ( '=' )?
            {
            int nameStart982 = getCharIndex();
            mID(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart982, getCharIndex()-1);
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:265:17: ( WS )?
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( ((LA48_0>='\t' && LA48_0<='\n')||LA48_0=='\r'||LA48_0==' ') ) {
                alt48=1;
            }
            switch (alt48) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:265:17: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:265:21: ( '=' )?
            int alt49=2;
            int LA49_0 = input.LA(1);

            if ( (LA49_0=='=') ) {
                alt49=1;
            }
            switch (alt49) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:265:21: '='
                    {
                    match('='); if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==1 ) {

                      	if (varScopeLevel == 0) {
                  			assignedGlobalVars.add((name!=null?name.getText():null));
              		    }
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "VAR_DECL"

    // $ANTLR start "GLOBAL_OBJECT"
    public final void mGLOBAL_OBJECT() throws RecognitionException {
        try {
            int _type = GLOBAL_OBJECT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:273:5: ( 'function' WS OBJECT_DECL )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:273:9: 'function' WS OBJECT_DECL
            {
            match("function"); if (state.failed) return ;

            mWS(); if (state.failed) return ;
            mOBJECT_DECL(); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GLOBAL_OBJECT"

    // $ANTLR start "OBJECT_DECL"
    public final void mOBJECT_DECL() throws RecognitionException {
        try {
            Token name=null;

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:277:5: (name= ID ( WS )? '(' ( . )* ')' )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:277:9: name= ID ( WS )? '(' ( . )* ')'
            {
            int nameStart1036 = getCharIndex();
            mID(); if (state.failed) return ;
            name = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, nameStart1036, getCharIndex()-1);
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:277:17: ( WS )?
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( ((LA50_0>='\t' && LA50_0<='\n')||LA50_0=='\r'||LA50_0==' ') ) {
                alt50=1;
            }
            switch (alt50) {
                case 1 :
                    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:277:17: WS
                    {
                    mWS(); if (state.failed) return ;

                    }
                    break;

            }

            match('('); if (state.failed) return ;
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:277:25: ( . )*
            loop51:
            do {
                int alt51=2;
                int LA51_0 = input.LA(1);

                if ( (LA51_0==')') ) {
                    alt51=2;
                }
                else if ( ((LA51_0>='\u0000' && LA51_0<='(')||(LA51_0>='*' && LA51_0<='\uFFFF')) ) {
                    alt51=1;
                }


                switch (alt51) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:277:25: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop51;
                }
            } while (true);

            match(')'); if (state.failed) return ;
            if ( state.backtracking==1 ) {

                      	if (varScopeLevel == 0) {
                  			assignedGlobalVars.add((name!=null?name.getText():null));
              		    }
              		
            }

            }

        }
        finally {
        }
    }
    // $ANTLR end "OBJECT_DECL"

    // $ANTLR start "ID"
    public final void mID() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:285:5: ( ( 'a' .. 'z' | 'A' .. 'Z' | '$' | '_' ) ( 'a' .. 'z' | 'A' .. 'Z' | '$' | '_' | '0' .. '9' )* )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:285:9: ( 'a' .. 'z' | 'A' .. 'Z' | '$' | '_' ) ( 'a' .. 'z' | 'A' .. 'Z' | '$' | '_' | '0' .. '9' )*
            {
            if ( input.LA(1)=='$'||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:285:37: ( 'a' .. 'z' | 'A' .. 'Z' | '$' | '_' | '0' .. '9' )*
            loop52:
            do {
                int alt52=2;
                int LA52_0 = input.LA(1);

                if ( (LA52_0=='$'||(LA52_0>='0' && LA52_0<='9')||(LA52_0>='A' && LA52_0<='Z')||LA52_0=='_'||(LA52_0>='a' && LA52_0<='z')) ) {
                    alt52=1;
                }


                switch (alt52) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:
            	    {
            	    if ( input.LA(1)=='$'||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop52;
                }
            } while (true);


            }

        }
        finally {
        }
    }
    // $ANTLR end "ID"

    // $ANTLR start "WS"
    public final void mWS() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:289:5: ( ( ' ' | '\\t' | '\\r' | '\\n' )+ )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:289:9: ( ' ' | '\\t' | '\\r' | '\\n' )+
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:289:9: ( ' ' | '\\t' | '\\r' | '\\n' )+
            int cnt53=0;
            loop53:
            do {
                int alt53=2;
                int LA53_0 = input.LA(1);

                if ( ((LA53_0>='\t' && LA53_0<='\n')||LA53_0=='\r'||LA53_0==' ') ) {
                    alt53=1;
                }


                switch (alt53) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:
            	    {
            	    if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt53 >= 1 ) break loop53;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(53, input);
                        throw eee;
                }
                cnt53++;
            } while (true);


            }

        }
        finally {
        }
    }
    // $ANTLR end "WS"

    // $ANTLR start "QUOTE"
    public final void mQUOTE() throws RecognitionException {
        try {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:293:7: ( ( '\\'' | '\"' )+ )
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:293:9: ( '\\'' | '\"' )+
            {
            // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:293:9: ( '\\'' | '\"' )+
            int cnt54=0;
            loop54:
            do {
                int alt54=2;
                int LA54_0 = input.LA(1);

                if ( (LA54_0=='\"'||LA54_0=='\'') ) {
                    alt54=1;
                }


                switch (alt54) {
            	case 1 :
            	    // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:
            	    {
            	    if ( input.LA(1)=='\"'||input.LA(1)=='\'' ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt54 >= 1 ) break loop54;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(54, input);
                        throw eee;
                }
                cnt54++;
            } while (true);


            }

        }
        finally {
        }
    }
    // $ANTLR end "QUOTE"

    public void mTokens() throws RecognitionException {
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:39: ( EXTERNAL_VAR | IMPORTDOC | COMMENT | SL_COMMENT | MODULE_DECL | REQUIRE_DECL | LITERAL | ENTER_SCOPE | EXIT_SCOPE | WINDOW_VAR_DOT | WINDOW_VAR_BRACKET | GLOBAL_VAR | GLOBAL_OBJECT )
        int alt55=13;
        alt55 = dfa55.predict(input);
        switch (alt55) {
            case 1 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:41: EXTERNAL_VAR
                {
                mEXTERNAL_VAR(); if (state.failed) return ;

                }
                break;
            case 2 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:54: IMPORTDOC
                {
                mIMPORTDOC(); if (state.failed) return ;

                }
                break;
            case 3 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:64: COMMENT
                {
                mCOMMENT(); if (state.failed) return ;

                }
                break;
            case 4 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:72: SL_COMMENT
                {
                mSL_COMMENT(); if (state.failed) return ;

                }
                break;
            case 5 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:83: MODULE_DECL
                {
                mMODULE_DECL(); if (state.failed) return ;

                }
                break;
            case 6 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:95: REQUIRE_DECL
                {
                mREQUIRE_DECL(); if (state.failed) return ;

                }
                break;
            case 7 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:108: LITERAL
                {
                mLITERAL(); if (state.failed) return ;

                }
                break;
            case 8 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:116: ENTER_SCOPE
                {
                mENTER_SCOPE(); if (state.failed) return ;

                }
                break;
            case 9 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:128: EXIT_SCOPE
                {
                mEXIT_SCOPE(); if (state.failed) return ;

                }
                break;
            case 10 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:139: WINDOW_VAR_DOT
                {
                mWINDOW_VAR_DOT(); if (state.failed) return ;

                }
                break;
            case 11 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:154: WINDOW_VAR_BRACKET
                {
                mWINDOW_VAR_BRACKET(); if (state.failed) return ;

                }
                break;
            case 12 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:173: GLOBAL_VAR
                {
                mGLOBAL_VAR(); if (state.failed) return ;

                }
                break;
            case 13 :
                // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:184: GLOBAL_OBJECT
                {
                mGLOBAL_OBJECT(); if (state.failed) return ;

                }
                break;

        }

    }

    // $ANTLR start synpred1_ECMAScriptLexer
    public final void synpred1_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:41: ( EXTERNAL_VAR )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:41: EXTERNAL_VAR
        {
        mEXTERNAL_VAR(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred1_ECMAScriptLexer

    // $ANTLR start synpred2_ECMAScriptLexer
    public final void synpred2_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:54: ( IMPORTDOC )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:54: IMPORTDOC
        {
        mIMPORTDOC(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred2_ECMAScriptLexer

    // $ANTLR start synpred3_ECMAScriptLexer
    public final void synpred3_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:64: ( COMMENT )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:64: COMMENT
        {
        mCOMMENT(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred3_ECMAScriptLexer

    // $ANTLR start synpred4_ECMAScriptLexer
    public final void synpred4_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:72: ( SL_COMMENT )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:72: SL_COMMENT
        {
        mSL_COMMENT(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred4_ECMAScriptLexer

    // $ANTLR start synpred7_ECMAScriptLexer
    public final void synpred7_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:108: ( LITERAL )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:108: LITERAL
        {
        mLITERAL(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred7_ECMAScriptLexer

    // $ANTLR start synpred10_ECMAScriptLexer
    public final void synpred10_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:139: ( WINDOW_VAR_DOT )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:139: WINDOW_VAR_DOT
        {
        mWINDOW_VAR_DOT(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred10_ECMAScriptLexer

    // $ANTLR start synpred11_ECMAScriptLexer
    public final void synpred11_ECMAScriptLexer_fragment() throws RecognitionException {   
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:154: ( WINDOW_VAR_BRACKET )
        // org/codehaus/mojo/jsimport/ECMAScriptLexer.g:1:154: WINDOW_VAR_BRACKET
        {
        mWINDOW_VAR_BRACKET(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred11_ECMAScriptLexer

    public final boolean synpred1_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred10_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred10_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred4_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred4_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred3_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred3_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred7_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred7_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred11_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred11_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred2_ECMAScriptLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred2_ECMAScriptLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA8 dfa8 = new DFA8(this);
    protected DFA9 dfa9 = new DFA9(this);
    protected DFA10 dfa10 = new DFA10(this);
    protected DFA18 dfa18 = new DFA18(this);
    protected DFA30 dfa30 = new DFA30(this);
    protected DFA55 dfa55 = new DFA55(this);
    static final String DFA8_eotS =
        "\12\uffff";
    static final String DFA8_eofS =
        "\12\uffff";
    static final String DFA8_minS =
        "\2\0\1\uffff\6\0\1\uffff";
    static final String DFA8_maxS =
        "\2\uffff\1\uffff\6\uffff\1\uffff";
    static final String DFA8_acceptS =
        "\2\uffff\1\1\6\uffff\1\2";
    static final String DFA8_specialS =
        "\1\1\1\5\1\uffff\1\6\1\0\1\2\1\3\1\4\1\7\1\uffff}>";
    static final String[] DFA8_transitionS = {
            "\100\2\1\1\uffbf\2",
            "\151\2\1\3\uff96\2",
            "",
            "\155\2\1\4\uff92\2",
            "\160\2\1\5\uff8f\2",
            "\157\2\1\6\uff90\2",
            "\162\2\1\7\uff8d\2",
            "\164\2\1\10\uff8b\2",
            "\11\2\2\11\2\2\1\11\22\2\1\11\uffdf\2",
            ""
    };

    static final short[] DFA8_eot = DFA.unpackEncodedString(DFA8_eotS);
    static final short[] DFA8_eof = DFA.unpackEncodedString(DFA8_eofS);
    static final char[] DFA8_min = DFA.unpackEncodedStringToUnsignedChars(DFA8_minS);
    static final char[] DFA8_max = DFA.unpackEncodedStringToUnsignedChars(DFA8_maxS);
    static final short[] DFA8_accept = DFA.unpackEncodedString(DFA8_acceptS);
    static final short[] DFA8_special = DFA.unpackEncodedString(DFA8_specialS);
    static final short[][] DFA8_transition;

    static {
        int numStates = DFA8_transitionS.length;
        DFA8_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA8_transition[i] = DFA.unpackEncodedString(DFA8_transitionS[i]);
        }
    }

    class DFA8 extends DFA {

        public DFA8(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 8;
            this.eot = DFA8_eot;
            this.eof = DFA8_eof;
            this.min = DFA8_min;
            this.max = DFA8_max;
            this.accept = DFA8_accept;
            this.special = DFA8_special;
            this.transition = DFA8_transition;
        }
        public String getDescription() {
            return "()* loopback of 104:10: ( . )*";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA8_4 = input.LA(1);

                        s = -1;
                        if ( (LA8_4=='p') ) {s = 5;}

                        else if ( ((LA8_4>='\u0000' && LA8_4<='o')||(LA8_4>='q' && LA8_4<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA8_0 = input.LA(1);

                        s = -1;
                        if ( (LA8_0=='@') ) {s = 1;}

                        else if ( ((LA8_0>='\u0000' && LA8_0<='?')||(LA8_0>='A' && LA8_0<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA8_5 = input.LA(1);

                        s = -1;
                        if ( (LA8_5=='o') ) {s = 6;}

                        else if ( ((LA8_5>='\u0000' && LA8_5<='n')||(LA8_5>='p' && LA8_5<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA8_6 = input.LA(1);

                        s = -1;
                        if ( (LA8_6=='r') ) {s = 7;}

                        else if ( ((LA8_6>='\u0000' && LA8_6<='q')||(LA8_6>='s' && LA8_6<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA8_7 = input.LA(1);

                        s = -1;
                        if ( (LA8_7=='t') ) {s = 8;}

                        else if ( ((LA8_7>='\u0000' && LA8_7<='s')||(LA8_7>='u' && LA8_7<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA8_1 = input.LA(1);

                        s = -1;
                        if ( (LA8_1=='i') ) {s = 3;}

                        else if ( ((LA8_1>='\u0000' && LA8_1<='h')||(LA8_1>='j' && LA8_1<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA8_3 = input.LA(1);

                        s = -1;
                        if ( (LA8_3=='m') ) {s = 4;}

                        else if ( ((LA8_3>='\u0000' && LA8_3<='l')||(LA8_3>='n' && LA8_3<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA8_8 = input.LA(1);

                        s = -1;
                        if ( ((LA8_8>='\t' && LA8_8<='\n')||LA8_8=='\r'||LA8_8==' ') ) {s = 9;}

                        else if ( ((LA8_8>='\u0000' && LA8_8<='\b')||(LA8_8>='\u000B' && LA8_8<='\f')||(LA8_8>='\u000E' && LA8_8<='\u001F')||(LA8_8>='!' && LA8_8<='\uFFFF')) ) {s = 2;}

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 8, _s, input);
            error(nvae);
            throw nvae;
        }
    }
    static final String DFA9_eotS =
        "\14\uffff";
    static final String DFA9_eofS =
        "\14\uffff";
    static final String DFA9_minS =
        "\3\0\1\uffff\1\0\1\uffff\5\0\1\uffff";
    static final String DFA9_maxS =
        "\3\uffff\1\uffff\1\uffff\1\uffff\5\uffff\1\uffff";
    static final String DFA9_acceptS =
        "\3\uffff\1\1\1\uffff\1\2\5\uffff\1\2";
    static final String DFA9_specialS =
        "\1\4\1\3\1\5\1\uffff\1\2\1\uffff\1\1\1\0\1\7\1\6\1\10\1\uffff}>";
    static final String[] DFA9_transitionS = {
            "\52\3\1\2\25\3\1\1\uffbf\3",
            "\151\3\1\4\uff96\3",
            "\57\3\1\5\uffd0\3",
            "",
            "\155\3\1\6\uff92\3",
            "",
            "\160\3\1\7\uff8f\3",
            "\157\3\1\10\uff90\3",
            "\162\3\1\11\uff8d\3",
            "\164\3\1\12\uff8b\3",
            "\11\3\2\13\2\3\1\13\22\3\1\13\uffdf\3",
            ""
    };

    static final short[] DFA9_eot = DFA.unpackEncodedString(DFA9_eotS);
    static final short[] DFA9_eof = DFA.unpackEncodedString(DFA9_eofS);
    static final char[] DFA9_min = DFA.unpackEncodedStringToUnsignedChars(DFA9_minS);
    static final char[] DFA9_max = DFA.unpackEncodedStringToUnsignedChars(DFA9_maxS);
    static final short[] DFA9_accept = DFA.unpackEncodedString(DFA9_acceptS);
    static final short[] DFA9_special = DFA.unpackEncodedString(DFA9_specialS);
    static final short[][] DFA9_transition;

    static {
        int numStates = DFA9_transitionS.length;
        DFA9_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA9_transition[i] = DFA.unpackEncodedString(DFA9_transitionS[i]);
        }
    }

    class DFA9 extends DFA {

        public DFA9(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 9;
            this.eot = DFA9_eot;
            this.eof = DFA9_eof;
            this.min = DFA9_min;
            this.max = DFA9_max;
            this.accept = DFA9_accept;
            this.special = DFA9_special;
            this.transition = DFA9_transition;
        }
        public String getDescription() {
            return "()* loopback of 104:20: ( . )*";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA9_7 = input.LA(1);

                        s = -1;
                        if ( (LA9_7=='o') ) {s = 8;}

                        else if ( ((LA9_7>='\u0000' && LA9_7<='n')||(LA9_7>='p' && LA9_7<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA9_6 = input.LA(1);

                        s = -1;
                        if ( (LA9_6=='p') ) {s = 7;}

                        else if ( ((LA9_6>='\u0000' && LA9_6<='o')||(LA9_6>='q' && LA9_6<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA9_4 = input.LA(1);

                        s = -1;
                        if ( (LA9_4=='m') ) {s = 6;}

                        else if ( ((LA9_4>='\u0000' && LA9_4<='l')||(LA9_4>='n' && LA9_4<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA9_1 = input.LA(1);

                        s = -1;
                        if ( (LA9_1=='i') ) {s = 4;}

                        else if ( ((LA9_1>='\u0000' && LA9_1<='h')||(LA9_1>='j' && LA9_1<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA9_0 = input.LA(1);

                        s = -1;
                        if ( (LA9_0=='@') ) {s = 1;}

                        else if ( (LA9_0=='*') ) {s = 2;}

                        else if ( ((LA9_0>='\u0000' && LA9_0<=')')||(LA9_0>='+' && LA9_0<='?')||(LA9_0>='A' && LA9_0<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA9_2 = input.LA(1);

                        s = -1;
                        if ( (LA9_2=='/') ) {s = 5;}

                        else if ( ((LA9_2>='\u0000' && LA9_2<='.')||(LA9_2>='0' && LA9_2<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA9_9 = input.LA(1);

                        s = -1;
                        if ( (LA9_9=='t') ) {s = 10;}

                        else if ( ((LA9_9>='\u0000' && LA9_9<='s')||(LA9_9>='u' && LA9_9<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA9_8 = input.LA(1);

                        s = -1;
                        if ( (LA9_8=='r') ) {s = 9;}

                        else if ( ((LA9_8>='\u0000' && LA9_8<='q')||(LA9_8>='s' && LA9_8<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA9_10 = input.LA(1);

                        s = -1;
                        if ( ((LA9_10>='\t' && LA9_10<='\n')||LA9_10=='\r'||LA9_10==' ') ) {s = 11;}

                        else if ( ((LA9_10>='\u0000' && LA9_10<='\b')||(LA9_10>='\u000B' && LA9_10<='\f')||(LA9_10>='\u000E' && LA9_10<='\u001F')||(LA9_10>='!' && LA9_10<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 9, _s, input);
            error(nvae);
            throw nvae;
        }
    }
    static final String DFA10_eotS =
        "\14\uffff";
    static final String DFA10_eofS =
        "\14\uffff";
    static final String DFA10_minS =
        "\3\0\2\uffff\6\0\1\uffff";
    static final String DFA10_maxS =
        "\3\uffff\2\uffff\6\uffff\1\uffff";
    static final String DFA10_acceptS =
        "\3\uffff\1\1\1\2\6\uffff\1\2";
    static final String DFA10_specialS =
        "\1\7\1\10\1\0\2\uffff\1\3\1\1\1\5\1\4\1\6\1\2\1\uffff}>";
    static final String[] DFA10_transitionS = {
            "\52\3\1\1\25\3\1\2\uffbf\3",
            "\57\3\1\4\uffd0\3",
            "\151\3\1\5\uff96\3",
            "",
            "",
            "\155\3\1\6\uff92\3",
            "\160\3\1\7\uff8f\3",
            "\157\3\1\10\uff90\3",
            "\162\3\1\11\uff8d\3",
            "\164\3\1\12\uff8b\3",
            "\11\3\2\13\2\3\1\13\22\3\1\13\uffdf\3",
            ""
    };

    static final short[] DFA10_eot = DFA.unpackEncodedString(DFA10_eotS);
    static final short[] DFA10_eof = DFA.unpackEncodedString(DFA10_eofS);
    static final char[] DFA10_min = DFA.unpackEncodedStringToUnsignedChars(DFA10_minS);
    static final char[] DFA10_max = DFA.unpackEncodedStringToUnsignedChars(DFA10_maxS);
    static final short[] DFA10_accept = DFA.unpackEncodedString(DFA10_acceptS);
    static final short[] DFA10_special = DFA.unpackEncodedString(DFA10_specialS);
    static final short[][] DFA10_transition;

    static {
        int numStates = DFA10_transitionS.length;
        DFA10_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA10_transition[i] = DFA.unpackEncodedString(DFA10_transitionS[i]);
        }
    }

    class DFA10 extends DFA {

        public DFA10(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 10;
            this.eot = DFA10_eot;
            this.eof = DFA10_eof;
            this.min = DFA10_min;
            this.max = DFA10_max;
            this.accept = DFA10_accept;
            this.special = DFA10_special;
            this.transition = DFA10_transition;
        }
        public String getDescription() {
            return "()* loopback of 104:31: ( . )*";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA10_2 = input.LA(1);

                        s = -1;
                        if ( (LA10_2=='i') ) {s = 5;}

                        else if ( ((LA10_2>='\u0000' && LA10_2<='h')||(LA10_2>='j' && LA10_2<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA10_6 = input.LA(1);

                        s = -1;
                        if ( (LA10_6=='p') ) {s = 7;}

                        else if ( ((LA10_6>='\u0000' && LA10_6<='o')||(LA10_6>='q' && LA10_6<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA10_10 = input.LA(1);

                        s = -1;
                        if ( ((LA10_10>='\u0000' && LA10_10<='\b')||(LA10_10>='\u000B' && LA10_10<='\f')||(LA10_10>='\u000E' && LA10_10<='\u001F')||(LA10_10>='!' && LA10_10<='\uFFFF')) ) {s = 3;}

                        else if ( ((LA10_10>='\t' && LA10_10<='\n')||LA10_10=='\r'||LA10_10==' ') ) {s = 11;}

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA10_5 = input.LA(1);

                        s = -1;
                        if ( (LA10_5=='m') ) {s = 6;}

                        else if ( ((LA10_5>='\u0000' && LA10_5<='l')||(LA10_5>='n' && LA10_5<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA10_8 = input.LA(1);

                        s = -1;
                        if ( (LA10_8=='r') ) {s = 9;}

                        else if ( ((LA10_8>='\u0000' && LA10_8<='q')||(LA10_8>='s' && LA10_8<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA10_7 = input.LA(1);

                        s = -1;
                        if ( (LA10_7=='o') ) {s = 8;}

                        else if ( ((LA10_7>='\u0000' && LA10_7<='n')||(LA10_7>='p' && LA10_7<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA10_9 = input.LA(1);

                        s = -1;
                        if ( (LA10_9=='t') ) {s = 10;}

                        else if ( ((LA10_9>='\u0000' && LA10_9<='s')||(LA10_9>='u' && LA10_9<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA10_0 = input.LA(1);

                        s = -1;
                        if ( (LA10_0=='*') ) {s = 1;}

                        else if ( (LA10_0=='@') ) {s = 2;}

                        else if ( ((LA10_0>='\u0000' && LA10_0<=')')||(LA10_0>='+' && LA10_0<='?')||(LA10_0>='A' && LA10_0<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA10_1 = input.LA(1);

                        s = -1;
                        if ( (LA10_1=='/') ) {s = 4;}

                        else if ( ((LA10_1>='\u0000' && LA10_1<='.')||(LA10_1>='0' && LA10_1<='\uFFFF')) ) {s = 3;}

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 10, _s, input);
            error(nvae);
            throw nvae;
        }
    }
    static final String DFA18_eotS =
        "\4\uffff";
    static final String DFA18_eofS =
        "\4\uffff";
    static final String DFA18_minS =
        "\2\11\2\uffff";
    static final String DFA18_maxS =
        "\1\146\1\133\2\uffff";
    static final String DFA18_acceptS =
        "\2\uffff\1\1\1\2";
    static final String DFA18_specialS =
        "\4\uffff}>";
    static final String[] DFA18_transitionS = {
            "\2\1\2\uffff\1\1\22\uffff\1\1\1\uffff\1\2\4\uffff\1\2\63\uffff"+
            "\1\3\12\uffff\1\3",
            "\2\1\2\uffff\1\1\22\uffff\1\1\1\uffff\1\2\4\uffff\1\2\63\uffff"+
            "\1\3",
            "",
            ""
    };

    static final short[] DFA18_eot = DFA.unpackEncodedString(DFA18_eotS);
    static final short[] DFA18_eof = DFA.unpackEncodedString(DFA18_eofS);
    static final char[] DFA18_min = DFA.unpackEncodedStringToUnsignedChars(DFA18_minS);
    static final char[] DFA18_max = DFA.unpackEncodedStringToUnsignedChars(DFA18_maxS);
    static final short[] DFA18_accept = DFA.unpackEncodedString(DFA18_acceptS);
    static final short[] DFA18_special = DFA.unpackEncodedString(DFA18_specialS);
    static final short[][] DFA18_transition;

    static {
        int numStates = DFA18_transitionS.length;
        DFA18_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA18_transition[i] = DFA.unpackEncodedString(DFA18_transitionS[i]);
        }
    }

    class DFA18 extends DFA {

        public DFA18(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 18;
            this.eot = DFA18_eot;
            this.eof = DFA18_eof;
            this.min = DFA18_min;
            this.max = DFA18_max;
            this.accept = DFA18_accept;
            this.special = DFA18_special;
            this.transition = DFA18_transition;
        }
        public String getDescription() {
            return "134:22: ( ( WS )? MODULE_ID ( WS )? ',' )?";
        }
    }
    static final String DFA30_eotS =
        "\4\uffff";
    static final String DFA30_eofS =
        "\4\uffff";
    static final String DFA30_minS =
        "\2\11\2\uffff";
    static final String DFA30_maxS =
        "\2\135\2\uffff";
    static final String DFA30_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA30_specialS =
        "\4\uffff}>";
    static final String[] DFA30_transitionS = {
            "\2\1\2\uffff\1\1\22\uffff\1\1\13\uffff\1\3\60\uffff\1\2",
            "\2\1\2\uffff\1\1\22\uffff\1\1\13\uffff\1\3\60\uffff\1\2",
            "",
            ""
    };

    static final short[] DFA30_eot = DFA.unpackEncodedString(DFA30_eotS);
    static final short[] DFA30_eof = DFA.unpackEncodedString(DFA30_eofS);
    static final char[] DFA30_min = DFA.unpackEncodedStringToUnsignedChars(DFA30_minS);
    static final char[] DFA30_max = DFA.unpackEncodedStringToUnsignedChars(DFA30_maxS);
    static final short[] DFA30_accept = DFA.unpackEncodedString(DFA30_acceptS);
    static final short[] DFA30_special = DFA.unpackEncodedString(DFA30_specialS);
    static final short[][] DFA30_transition;

    static {
        int numStates = DFA30_transitionS.length;
        DFA30_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA30_transition[i] = DFA.unpackEncodedString(DFA30_transitionS[i]);
        }
    }

    class DFA30 extends DFA {

        public DFA30(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 30;
            this.eot = DFA30_eot;
            this.eof = DFA30_eof;
            this.min = DFA30_min;
            this.max = DFA30_max;
            this.accept = DFA30_accept;
            this.special = DFA30_special;
            this.transition = DFA30_transition;
        }
        public String getDescription() {
            return "()* loopback of 183:31: ( ( WS )? ',' ( WS )? MODULE_DEPENDENCY )*";
        }
    }
    static final String DFA55_eotS =
        "\21\uffff";
    static final String DFA55_eofS =
        "\21\uffff";
    static final String DFA55_minS =
        "\1\42\1\0\7\uffff\1\0\7\uffff";
    static final String DFA55_maxS =
        "\1\175\1\0\7\uffff\1\0\7\uffff";
    static final String DFA55_acceptS =
        "\2\uffff\1\1\1\2\1\3\1\4\1\7\1\11\1\6\1\uffff\1\12\1\13\1\7\1\14"+
        "\1\15\1\5\1\10";
    static final String DFA55_specialS =
        "\1\uffff\1\0\7\uffff\1\1\7\uffff}>";
    static final String[] DFA55_transitionS = {
            "\1\14\4\uffff\1\14\7\uffff\1\1\64\uffff\1\17\1\uffff\1\16\13"+
            "\uffff\1\10\3\uffff\1\15\1\11\3\uffff\1\20\1\uffff\1\7",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA55_eot = DFA.unpackEncodedString(DFA55_eotS);
    static final short[] DFA55_eof = DFA.unpackEncodedString(DFA55_eofS);
    static final char[] DFA55_min = DFA.unpackEncodedStringToUnsignedChars(DFA55_minS);
    static final char[] DFA55_max = DFA.unpackEncodedStringToUnsignedChars(DFA55_maxS);
    static final short[] DFA55_accept = DFA.unpackEncodedString(DFA55_acceptS);
    static final short[] DFA55_special = DFA.unpackEncodedString(DFA55_specialS);
    static final short[][] DFA55_transition;

    static {
        int numStates = DFA55_transitionS.length;
        DFA55_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA55_transition[i] = DFA.unpackEncodedString(DFA55_transitionS[i]);
        }
    }

    class DFA55 extends DFA {

        public DFA55(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 55;
            this.eot = DFA55_eot;
            this.eof = DFA55_eof;
            this.min = DFA55_min;
            this.max = DFA55_max;
            this.accept = DFA55_accept;
            this.special = DFA55_special;
            this.transition = DFA55_transition;
        }
        public String getDescription() {
            return "1:1: Tokens options {k=1; backtrack=true; } : ( EXTERNAL_VAR | IMPORTDOC | COMMENT | SL_COMMENT | MODULE_DECL | REQUIRE_DECL | LITERAL | ENTER_SCOPE | EXIT_SCOPE | WINDOW_VAR_DOT | WINDOW_VAR_BRACKET | GLOBAL_VAR | GLOBAL_OBJECT );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA55_1 = input.LA(1);

                         
                        int index55_1 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (synpred1_ECMAScriptLexer()) ) {s = 2;}

                        else if ( (synpred2_ECMAScriptLexer()) ) {s = 3;}

                        else if ( (synpred3_ECMAScriptLexer()) ) {s = 4;}

                        else if ( (synpred4_ECMAScriptLexer()) ) {s = 5;}

                        else if ( (synpred7_ECMAScriptLexer()) ) {s = 6;}

                         
                        input.seek(index55_1);
                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA55_9 = input.LA(1);

                         
                        int index55_9 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (synpred10_ECMAScriptLexer()) ) {s = 10;}

                        else if ( (synpred11_ECMAScriptLexer()) ) {s = 11;}

                         
                        input.seek(index55_9);
                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 55, _s, input);
            error(nvae);
            throw nvae;
        }
    }
 

}