package org.codehaus.mojo.jsimport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on js-import-maven-plugin.<br/> Call <pre>  mvn js-import:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue May 15 12:30:47 EST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:js-import-maven-plugin:1.0.1", 0 );
        append( sb, "", 0 );

        append( sb, "JavaScript Import Maven Plugin", 0 );
        append( sb, "Provides tooling for managing JavaScript dependencies.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 5 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "generate-html".equals( goal ) )
        {
            append( sb, "js-import:generate-html", 0 );
            append( sb, "Main goal implementation of the generate html mojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The character encoding scheme to be applied when filtering resources.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Files to exclude. Nothing is excluded by default.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Files to include. Defaults to \'**\\/*.html,**\\/*.htm\'.", 3 );
                append( sb, "", 0 );

                append( sb, "resourceHtmlFolder (Default: ${basedir}/src/main/resources)", 2 );
                append( sb, "The HTML resource folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "sourceJsFolder (Default: ${basedir}/src/main/js)", 2 );
                append( sb, "The JavaScript source folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "targetFolder (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The project target folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "targetJsPath (Default: js)", 2 );
                append( sb, "The target path for js files.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workFolder (Default: ${project.build.directory}/ImportMojo/main)", 2 );
                append( sb, "The folder where test files are created that assist with multiple invocations e.g. caches.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "js-import:help", 0 );
            append( sb, "Display help information on js-import-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0js-import:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "import-js".equals( goal ) )
        {
            append( sb, "js-import:import-js", 0 );
            append( sb, "Main goal implementation of the import mojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assumeABrowser (Default: true)", 2 );
                append( sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser TODO: Provide the other JSLint \'assume\' options.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Files to exclude. Nothing is excluded by default.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Files to include. Defaults to \'**\\/*.js\'.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceJsFolder (Default: ${basedir}/src/main/js)", 2 );
                append( sb, "Source JavaScript folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "targetFolder (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The project target folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workFolder (Default: ${project.build.directory}/ImportMojo/main)", 2 );
                append( sb, "The folder where files are created that assist with multiple invocations e.g. caches.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-generate-html".equals( goal ) )
        {
            append( sb, "js-import:test-generate-html", 0 );
            append( sb, "Test goal implementation of the generate html mojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The character encoding scheme to be applied when filtering resources.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Files to exclude. Nothing is excluded by default.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Files to include. Defaults to \'**\\/*.html,**\\/*.htm\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mainSourceJsFolder (Default: ${basedir}/src/main/js)", 2 );
                append( sb, "The JavaScript main source folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "mainTargetFolder (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The main project target folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "resourceHtmlFolder (Default: ${basedir}/src/test/resources)", 2 );
                append( sb, "The HTML test resource folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "sourceJsFolder (Default: ${basedir}/src/test/js)", 2 );
                append( sb, "The JavaScript test source folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "targetFolder (Default: ${project.build.testOutputDirectory})", 2 );
                append( sb, "The project target folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "targetJsPath (Default: js)", 2 );
                append( sb, "The target path for js files.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workFolder (Default: ${project.build.directory}/ImportMojo/test)", 2 );
                append( sb, "The folder where test files are created that assist with multiple invocations e.g. caches.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-import-js".equals( goal ) )
        {
            append( sb, "js-import:test-import-js", 0 );
            append( sb, "Test goal implementation of the import mojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assumeABrowser (Default: true)", 2 );
                append( sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser TODO: Provide the other JSLint \'assume\' options.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Files to exclude. Nothing is excluded by default.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Files to include. Defaults to \'**\\/*.js\'.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceJsFolder (Default: ${basedir}/src/test/js)", 2 );
                append( sb, "The test source folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "targetFolder (Default: ${project.build.testOutputDirectory})", 2 );
                append( sb, "The project target folder.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workFolder (Default: ${project.build.directory}/ImportMojo/test)", 2 );
                append( sb, "The folder where test files are created that assist with multiple invocations e.g. caches.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
