/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;

public class LocalRepositoryCollector {
    private final List<String> localRepositoryPaths = new ArrayList<String>();

    public LocalRepositoryCollector(MavenProject project, ArtifactRepository localRepository, File[] additionalFolderBases) {
        List modules;
        this.localRepositoryPaths.add(localRepository.getBasedir());
        String projectArtifactId = project.getArtifactId();
        for (MavenProject parentProject = project.getParent(); parentProject != null && (modules = parentProject.getModules()).contains(projectArtifactId); parentProject = parentProject.getParent()) {
            projectArtifactId = parentProject.getArtifactId();
            String parentProjectPath = parentProject.getBasedir().getAbsolutePath();
            this.localRepositoryPaths.add(parentProjectPath);
        }
        for (File additionalFolderBase : additionalFolderBases) {
            File[] additionalFolders = additionalFolderBase.listFiles();
            if (additionalFolders == null) continue;
            for (File additionalFolder : additionalFolders) {
                if (!additionalFolder.isDirectory()) continue;
                this.localRepositoryPaths.add(additionalFolder.getAbsolutePath());
            }
        }
    }

    public String findLocalRepository(String filePath) {
        String localRepositoryPathFound = null;
        for (String localRepositoryPath : this.localRepositoryPaths) {
            if (!filePath.startsWith(localRepositoryPath)) continue;
            localRepositoryPathFound = localRepositoryPath;
            break;
        }
        return localRepositoryPathFound;
    }

    public void addLocalRepositoryPath(String path) {
        this.localRepositoryPaths.add(path);
    }
}

