package org.codehaus.mojo.jspc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on 'org.codehaus.mojo.jspc:jspc-maven-plugin' plugin. Call 'mvn jspc:help -Ddetail=true' to display all details.
 *
 * @version generated on Fri Sep 19 08:29:16 MDT 2008
 * @goal help
 */
public class HelpMojo
    extends AbstractMojo
{
    /** 80-character display buffer */
    private static final int DEFAULT_WIDTH = 80;

    /** 4 indent spaces */
    private static final String DEFAULT_INDENT = repeat( " ", 2 );

    /**
     * If true, display all settable properies for each goal.
     *
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        sb.append( "The 'org.codehaus.mojo.jspc:jspc-maven-plugin' plugin has 4 goals:" ).append( "\n" );
        sb.append( "\n" );

        sb.append( "jspc:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.codehaus.mojo.jspc:jspc-maven-plugin' plugin. Call 'mvn jspc:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "detail (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "If true, display all settable properies for each goal.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "jspc:testCompile" ).append( "\n" );
        for ( Iterator it = toLines( "Compile test JSPs." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "compile (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Sets if you want to compile the JSP classes.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "filtering (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Provides filtering of the generated web.xml text.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "includeInProject (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Set this to false if you don't want to include the compiled JSPs in your web.xml nor add the generated sources to your project's source roots.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "injectString (Default: '</web-app>')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The string to look for in the web.xml to replace with the web fragment contents If not defined, fragment will be appended before the </webapp> tag which is fine for servlet 2.4 and greater. If using this parameter its recommanded to use Strings such as <!-- [INSERT FRAGMENT HERE] --> Be aware the < and > are for your pom verbatim.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "inputWebXml", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The path and location of the original web.xml file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "javaEncoding", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Character encoding.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "listErrors (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "List Errors option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputWebXml", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The final path and file name of the web.xml.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "packageName (Default: 'jsp')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The package in which the jsp files will be contained.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "showSuccess (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Show Success option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "smapDumped (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Set Smap Dumped option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "smapSupressed (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Set Smap Supressed option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "source", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Provide source compatibility with specified release.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "sources", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The sources of the webapp. Default is ${basedir}/src/main/webapp.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "target", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Generate class files for specific VM version.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "trimSpaces (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Removes the spaces from the generated JSP files.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "validateXml (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Validate XML option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "verbose (Default: '0')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Verbose level option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "webFragmentFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The path and location to the web fragment file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "workingDirectory", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The working directory to create the generated java source files.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "jspc:compile" ).append( "\n" );
        for ( Iterator it = toLines( "Compile JSPs." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "compile (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Sets if you want to compile the JSP classes.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "filtering (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Provides filtering of the generated web.xml text.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "includeInProject (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Set this to false if you don't want to include the compiled JSPs in your web.xml nor add the generated sources to your project's source roots.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "injectString (Default: '</web-app>')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The string to look for in the web.xml to replace with the web fragment contents If not defined, fragment will be appended before the </webapp> tag which is fine for servlet 2.4 and greater. If using this parameter its recommanded to use Strings such as <!-- [INSERT FRAGMENT HERE] --> Be aware the < and > are for your pom verbatim.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "inputWebXml", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The path and location of the original web.xml file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "javaEncoding", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Character encoding.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "listErrors (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "List Errors option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "outputWebXml", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The final path and file name of the web.xml.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "packageName (Default: 'jsp')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The package in which the jsp files will be contained.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "showSuccess (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Show Success option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "smapDumped (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Set Smap Dumped option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "smapSupressed (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Set Smap Supressed option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "source", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Provide source compatibility with specified release.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "sources", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The sources of the webapp. Default is ${basedir}/src/main/webapp.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "target", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Generate class files for specific VM version.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "trimSpaces (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Removes the spaces from the generated JSP files.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "validateXml (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Validate XML option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "verbose (Default: '0')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Verbose level option for JcpC.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "webFragmentFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The path and location to the web fragment file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "workingDirectory", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The working directory to create the generated java source files.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "jspc:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.codehaus.mojo.jspc:jspc-maven-plugin' plugin. Call 'mvn jspc:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by 4 spaces
     * and has a maximum of <code>80</code> characters.</p>
     *
     * @param str String to split in lines
     * @return List of lines
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str )
    {
        return toLines( str, DEFAULT_INDENT, DEFAULT_WIDTH );
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by <code>indent</code>
     * and has a maximum of <code>size</code> characters.</p>
     *
     * @param str String to split in lines
     * @param indent the string to precede each line
     * @param size the size of the character display buffer
     * @return List of lines
     * @throws IllegalArgumentException if <code>size < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str, String indent, int size )
    {
        List sentences = new ArrayList();

        if ( indent == null )
        {
            indent = "";
        }

        if ( size < 0 )
        {
            throw new IllegalArgumentException( "size should be positive" );
        }

        StringBuffer tmp = new StringBuffer( indent );
        StringTokenizer tokenizer = new StringTokenizer( str, " " );
        while ( tokenizer.hasMoreTokens() )
        {
            String word = tokenizer.nextToken();

            if ( tmp.length() + word.length() + 1 < size )
            {
                tmp.append( word ).append( " " );
            }
            else
            {
                sentences.add( tmp.toString() );
                tmp = new StringBuffer( indent );
                tmp.append( word ).append( " " );
            }
        }

        if ( tmp.toString().length() > 0 )
        {
            sentences.add( tmp.toString() );
        }

        return sentences;
    }
}
