/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.l10n;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class PseudoLocalizeMojo
extends AbstractMojo {
    private File outputDirectory;
    private File inputDirectory;
    private List includes;
    private List excludes;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.properties"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String pseudoLocPattern;
    private String pseudoLocale;

    public void execute() throws MojoExecutionException {
        if (this.pseudoLocPattern.indexOf("{0}") == -1) {
            throw new MojoExecutionException("The pseudoLocPattern parameter with value '" + this.pseudoLocPattern + "' is misconfigured.");
        }
        this.generatePseudoLoc();
    }

    protected void generatePseudoLoc() throws MojoExecutionException {
        if (!this.inputDirectory.exists()) {
            this.getLog().info((CharSequence)("Resource input directory does not exist: " + this.inputDirectory));
            return;
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Cannot create resource output directory: " + this.outputDirectory);
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.inputDirectory);
        if (this.includes != null && !this.includes.isEmpty()) {
            scanner.setIncludes(this.includes.toArray(EMPTY_STRING_ARRAY));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            scanner.setExcludes(this.excludes.toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        Iterator<String> j = includedFiles.iterator();
        while (j.hasNext()) {
            String name = j.next();
            File source = new File(this.inputDirectory, name);
            File dest = new File(this.outputDirectory, name);
            String fileName = "";
            String[] split = StringUtils.split((String)source.getName(), (String)".");
            for (int i = 0; i < split.length - 1; ++i) {
                fileName = i == split.length - 2 ? fileName + split[i] + "_" + this.pseudoLocale + "." : fileName + split[i] + ".";
            }
            fileName = fileName + split[split.length - 1];
            File destinationFile = new File(dest.getParentFile(), fileName);
            this.getLog().info((CharSequence)("Pseudo-localizing " + name + " bundle file."));
            try {
                this.copyFile(source, destinationFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying resource " + source, (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File from, File to) throws IOException {
        Properties props = new Properties();
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        to.getParentFile().mkdirs();
        try {
            in = new BufferedInputStream(new FileInputStream(from));
            props.load(in);
            Iterator it = ((Hashtable)props).keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = props.getProperty(key);
                String newVal = MessageFormat.format(this.pseudoLocPattern, val);
                props.setProperty(key, newVal);
            }
            out = new BufferedOutputStream(new FileOutputStream(to));
            props.store(out, "Pseudo Localized bundle file for I18N testing autogenerated by the l10n-maven-plugin.");
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
    }
}

