package org.codehaus.mojo.l10n;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on l10n-maven-plugin. Call <pre>  mvn l10n:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Jan 02 17:16:12 CET 2009
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:l10n-maven-plugin:1.0-alpha-2", 0 );
        append( sb, "", 0 );

        append( sb, "Localization Tools Maven Plugin 1.0-alpha-2", 0 );
        append( sb, "Allows you to do an automated pseudo-localization to test the completeness of your project\'s internationalization effort. This technique simulates the process of localizing products by prefixing and suffixing all your internationalized messages. For more information on pseudo-localization, see http://developers.sun.com/solaris/articles/i18n/I18N_Testing.html. For more general information on localization, see http://java.sun.com/developer/technicalArticles/Intl/ResourceBundles/.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "l10n:help", 0 );
            append( sb, "Display help information on l10n-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0l10n:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "pseudo".equals( goal ) )
        {
            append( sb, "l10n:pseudo", 0 );
            append( sb, "Allows you to do an automated pseudo-localization to test the completeness of your project\'s internationalization effort. This technique simulates the process of localizing products by prefixing and suffixing all your internationalized messages.\n>For more information on pseudo-localization, see I18N Testing Guidelines and Techniques.\n\n>For more general information on localization, see Java Internationalization: Localization with ResourceBundles.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "The list of resources we don\'t want to pseudo-localize. By default, no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "The list of resources we want to pseudo-localize. If not specified, the default pattern is **/*.properties.", 3 );
                append( sb, "", 0 );

                append( sb, "inputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The input directory from which we copy the resources. The plugin scans the build output directory by default, in order to have the complete set of resources that end up in the product.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The output directory into which to copy the resources.", 3 );
                append( sb, "", 0 );

                append( sb, "pseudoLocPattern (Default: XXX \u00e5\u00a4\u0161\u00e5\u00b0\u2018 {0} YYY)", 2 );
                append( sb, "Pattern for replacement of localized string values. The plugin iterates over all properties in the property files and replaces the values using MessageFormat with this value as a formatting pattern. The pattern is expected to contain this sequence {0} exactly once with a prefix and/or suffix.", 3 );
                append( sb, "", 0 );

                append( sb, "pseudoLocale (Default: xx)", 2 );
                append( sb, "Locale name that is used for pseudo-localization. The resulting property files will have the following name: <filename>_<pseudoLocale>.properties.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "l10n:report", 0 );
            append( sb, "A simple report for keeping track of l10n status. It lists all bundle properties files and the number of properties in them. For a configurable list of locales it also tracks the progress of localization.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of exclude patterns to use. By default no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of include patterns to use. By default all *.properties files are included.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A list of locale strings that are to be watched for l10n status.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2 );
                append( sb, "Report output directory.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
