/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.LicenseDownloader;
import org.codehaus.mojo.license.LicenseSummaryReader;
import org.codehaus.mojo.license.LicenseSummaryWriter;
import org.codehaus.mojo.license.model.ProjectLicenseInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadLicensesMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectBuilder projectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File licensesSummaryConfigFile;
    private File licensesOutputDirectory;
    private File licensesSummaryOutputFile;
    private boolean quiet;
    private boolean includeTransitiveDependencies;
    private HashSet<String> downloadedLicenseURLs = new HashSet();

    public void execute() throws MojoExecutionException {
        if (!this.licensesOutputDirectory.exists()) {
            this.licensesOutputDirectory.mkdirs();
        }
        if (!this.licensesSummaryOutputFile.getParentFile().exists()) {
            this.licensesSummaryOutputFile.getParentFile().mkdirs();
        }
        HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap = new HashMap<String, ProjectLicenseInfo>();
        this.loadLicenseInfo(configuredDepLicensesMap, this.licensesSummaryOutputFile, true);
        this.loadLicenseInfo(configuredDepLicensesMap, this.licensesSummaryConfigFile, false);
        Set depArtifacts = null;
        depArtifacts = this.includeTransitiveDependencies ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
        ArrayList<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
        for (Artifact artifact : depArtifacts) {
            this.getLog().debug((CharSequence)("Checking licenses for project " + artifact));
            String artifactProjectId = this.getArtifactProjectId(artifact);
            ProjectLicenseInfo depProject = null;
            if (configuredDepLicensesMap.containsKey(artifactProjectId)) {
                depProject = configuredDepLicensesMap.get(artifactProjectId);
                depProject.setVersion(artifact.getVersion());
            } else {
                try {
                    depProject = this.createDependencyProject(artifact);
                }
                catch (ProjectBuildingException e) {
                    this.getLog().warn((CharSequence)("Unable to build project: " + artifact));
                    this.getLog().warn((Throwable)e);
                }
            }
            this.downloadLicenses(depProject);
            depProjectLicenses.add(depProject);
        }
        try {
            LicenseSummaryWriter.writeLicenseSummary(depProjectLicenses, this.licensesSummaryOutputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file.", e);
        }
    }

    private void loadLicenseInfo(HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap, File licenseConfigFile, boolean previouslyDownloaded) throws MojoExecutionException {
        if (licenseConfigFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(licenseConfigFile);
                List<ProjectLicenseInfo> licensesList = LicenseSummaryReader.parseLicenseSummary(fis);
                for (ProjectLicenseInfo dep : licensesList) {
                    configuredDepLicensesMap.put(dep.getId(), dep);
                    if (!previouslyDownloaded) continue;
                    for (License license : dep.getLicenses()) {
                        this.downloadedLicenseURLs.add(license.getUrl());
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new MojoExecutionException("Unable to parse license summary output file.", e);
                }
                catch (Throwable throwable) {
                    FileUtil.tryClose(fis);
                    throw throwable;
                }
            }
            FileUtil.tryClose(fis);
        }
    }

    public String getArtifactProjectId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public ProjectLicenseInfo createDependencyProject(Artifact artifact) throws ProjectBuildingException {
        MavenProject depMavenProject = null;
        depMavenProject = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (License license : licenses) {
            dependencyProject.addLicense(license);
        }
        return dependencyProject;
    }

    private String getLicenseFileName(License license) throws MalformedURLException {
        URL licenseUrl = new URL(license.getUrl());
        File licenseUrlFile = new File(licenseUrl.getPath());
        String licenseFileName = licenseUrlFile.getName();
        if (license.getName() != null) {
            licenseFileName = license.getName() + " - " + licenseUrlFile.getName();
        }
        String DEFAULT_EXTENSION = ".txt";
        int extensionIndex = licenseFileName.lastIndexOf(".");
        if (extensionIndex == -1 || extensionIndex > licenseFileName.length() - 3) {
            licenseFileName = licenseFileName + ".txt";
        }
        licenseFileName = licenseFileName.toLowerCase();
        return licenseFileName;
    }

    private void downloadLicenses(ProjectLicenseInfo depProject) {
        this.getLog().debug((CharSequence)("Downloading license(s) for project " + depProject));
        List<License> licenses = depProject.getLicenses();
        if (depProject.getLicenses() == null || depProject.getLicenses().isEmpty()) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)("No license information available for: " + depProject));
            }
            return;
        }
        for (License license : licenses) {
            try {
                String licenseFileName = this.getLicenseFileName(license);
                File licenseOutputFile = new File(this.licensesOutputDirectory, licenseFileName);
                if (licenseOutputFile.exists() || this.downloadedLicenseURLs.contains(license.getUrl())) continue;
                LicenseDownloader.downloadLicense(license.getUrl(), licenseOutputFile);
                this.downloadedLicenseURLs.add(license.getUrl());
            }
            catch (MalformedURLException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has an invalid license URL: " + license.getUrl()));
            }
            catch (FileNotFoundException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has a license URL that returns file not found: " + license.getUrl()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to retrieve license for dependency: " + depProject.toString()));
                this.getLog().warn((CharSequence)license.getUrl());
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }
}

