/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.LicenseDownloader;
import org.codehaus.mojo.license.LicenseSummaryReader;
import org.codehaus.mojo.license.LicenseSummaryWriter;
import org.codehaus.mojo.license.model.DependencyProject;

public class DownloadLicensesMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectBuilder projectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File licensesSummaryFile;
    private File licensesOutputDirectory;
    private File licensesSummaryOutputFile;
    private boolean quiet;
    private boolean includeTransitiveDependencies;

    public void execute() throws MojoExecutionException {
        HashMap<String, DependencyProject> configuredDepLicensesMap;
        block20: {
            FileInputStream fis;
            block21: {
                if (!this.licensesOutputDirectory.exists()) {
                    this.licensesOutputDirectory.mkdirs();
                }
                if (!this.licensesSummaryOutputFile.getParentFile().exists()) {
                    this.licensesSummaryOutputFile.getParentFile().mkdirs();
                }
                configuredDepLicensesMap = new HashMap<String, DependencyProject>();
                if (!this.licensesSummaryOutputFile.exists()) break block21;
                fis = null;
                try {
                    fis = new FileInputStream(this.licensesSummaryOutputFile);
                    List<DependencyProject> licensesList = LicenseSummaryReader.parseLicenseSummary(fis);
                    for (DependencyProject dep : licensesList) {
                        configuredDepLicensesMap.put(dep.getId(), dep);
                    }
                }
                catch (Exception e) {
                    try {
                        throw new MojoExecutionException("Unable to parse license summary file.", e);
                    }
                    catch (Throwable throwable) {
                        FileUtil.tryClose(fis);
                        throw throwable;
                    }
                }
                FileUtil.tryClose(fis);
                break block20;
            }
            if (this.licensesSummaryFile.exists()) {
                fis = null;
                try {
                    fis = new FileInputStream(this.licensesSummaryFile);
                    List<DependencyProject> depLicensesList = LicenseSummaryReader.parseLicenseSummary(fis);
                    this.getLog().debug((CharSequence)("Loaded " + depLicensesList.size() + " licenses"));
                    for (DependencyProject depProject : depLicensesList) {
                        this.getLog().debug((CharSequence)("Downloading licenses for project " + depProject.getId()));
                        this.downloadLicenses(depProject);
                        configuredDepLicensesMap.put(depProject.getId(), depProject);
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to parse license summary file.", e);
                }
                finally {
                    FileUtil.tryClose(fis);
                }
            }
        }
        Set depArtifacts = null;
        depArtifacts = this.includeTransitiveDependencies ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
        ArrayList<DependencyProject> depProjectLicenses = new ArrayList<DependencyProject>();
        for (Artifact artifact : depArtifacts) {
            DependencyProject depProject;
            this.getLog().debug((CharSequence)("Checking licenses for project " + artifact));
            String artifactProjectId = this.getArtifactProjectId(artifact);
            if (configuredDepLicensesMap.containsKey(artifactProjectId)) {
                depProject = (DependencyProject)configuredDepLicensesMap.get(artifactProjectId);
                depProject.setVersion(artifact.getVersion());
                depProjectLicenses.add(depProject);
                continue;
            }
            depProject = null;
            try {
                depProject = this.createDependencyProject(artifact);
                this.getLog().debug((CharSequence)("Downloading licenses for project " + depProject));
                this.downloadLicenses(depProject);
                depProjectLicenses.add(depProject);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to build project: " + artifact));
                this.getLog().warn((Throwable)e);
            }
        }
        try {
            LicenseSummaryWriter.writeLicenseSummary(depProjectLicenses, this.licensesSummaryOutputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file.", e);
        }
    }

    public String getArtifactProjectId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public DependencyProject createDependencyProject(Artifact artifact) throws ProjectBuildingException {
        MavenProject depMavenProject = null;
        depMavenProject = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        DependencyProject dependencyProject = new DependencyProject(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (License license : licenses) {
            dependencyProject.addLicense(license);
        }
        return dependencyProject;
    }

    private String getLicenseFileName(License license) throws MalformedURLException {
        URL licenseUrl = new URL(license.getUrl());
        File licenseUrlFile = new File(licenseUrl.getPath());
        String licenseFileName = licenseUrlFile.getName();
        if (license.getName() != null) {
            licenseFileName = license.getName() + " - " + licenseUrlFile.getName();
        }
        String DEFAULT_EXTENSION = ".txt";
        int extensionIndex = licenseFileName.lastIndexOf(".");
        if (extensionIndex == -1 || extensionIndex > licenseFileName.length() - 3) {
            licenseFileName = licenseFileName + ".txt";
        }
        return licenseFileName;
    }

    private void downloadLicenses(DependencyProject depProject) {
        List<License> licenses = depProject.getLicenses();
        if (depProject.getLicenses() == null || depProject.getLicenses().isEmpty()) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)("No license information available for: " + depProject));
            }
            return;
        }
        for (License license : licenses) {
            try {
                String licenseFileName = this.getLicenseFileName(license);
                File licenseOutputFile = new File(this.licensesOutputDirectory, licenseFileName);
                if (licenseOutputFile.exists()) continue;
                LicenseDownloader.downloadLicense(license.getUrl(), licenseOutputFile);
            }
            catch (MalformedURLException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has an invalid license URL: " + license.getUrl()));
            }
            catch (FileNotFoundException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has a license URL that returns file not found: " + license.getUrl()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to retrieve license for dependency: " + depProject.toString()));
                this.getLog().warn((CharSequence)license.getUrl());
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }
}

