/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.mojo.license.Eol;
import org.codehaus.mojo.license.LicenseUrlReplacement;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.model.ProjectLicense;
import org.codehaus.mojo.license.model.ProjectLicenseInfo;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.LicenseDownloader;
import org.codehaus.mojo.license.utils.LicenseSummaryReader;
import org.codehaus.mojo.license.utils.LicenseSummaryWriter;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.Base64;

public abstract class AbstractDownloadLicensesMojo
extends AbstractMojo
implements MavenProjectDependenciesConfigurator {
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List remoteRepositories;
    @Parameter(property="licensesConfigFile", defaultValue="${project.basedir}/src/license/licenses.xml")
    private File licensesConfigFile;
    @Parameter(property="licensesOutputDirectory", defaultValue="${project.build.directory}/generated-resources/licenses")
    private File licensesOutputDirectory;
    @Parameter(property="licensesOutputFile", defaultValue="${project.build.directory}/generated-resources/licenses.xml")
    private File licensesOutputFile;
    @Parameter(property="licensesOutputFileEol", defaultValue="AUTODETECT")
    private Eol licensesOutputFileEol;
    @Parameter(property="licensesOutputFileEncoding", defaultValue="${project.build.sourceEncoding}")
    private String licensesOutputFileEncoding;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes")
    private String includedScopes;
    @Parameter(property="license.excludedTypes")
    private String excludedTypes;
    @Parameter(property="license.includedTypes")
    private String includedTypes;
    @Parameter(defaultValue="${settings.offline}")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    private boolean excludeTransitiveDependencies;
    @Parameter(defaultValue="${settings.proxies}", readonly=true)
    private List<Proxy> proxies;
    @Parameter(property="license.organizeLicensesByDependencies", defaultValue="false")
    protected boolean organizeLicensesByDependencies;
    @Parameter(property="license.sortByGroupIdAndArtifactId", defaultValue="false")
    private boolean sortByGroupIdAndArtifactId;
    @Parameter(property="license.excludedGroups")
    private String excludedGroups;
    @Parameter(property="license.includedGroups")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    private String includedArtifacts;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private List<LicenseUrlReplacement> licenseUrlReplacements;
    @Component
    private DependenciesTool dependenciesTool;
    private Map<String, File> downloadedLicenseURLs = new HashMap<String, File>();
    private String proxyLoginPasswordEncoded;
    protected Properties systemProperties;

    protected abstract boolean isSkip();

    protected MavenProject getProject() {
        return this.project;
    }

    protected abstract Set<MavenProject> getDependencies();

    protected SortedMap<String, MavenProject> getDependencies(MavenProject project) {
        return this.dependenciesTool.loadProjectDependencies(new ResolvedProjectDependencies(project.getArtifacts(), project.getDependencyArtifacts()), this, this.localRepository, this.remoteRepositories, null);
    }

    protected void storeProperties() {
        this.systemProperties = (Properties)System.getProperties().clone();
    }

    protected void restoreProperties() {
        if (this.systemProperties != null) {
            System.setProperties(this.systemProperties);
            this.systemProperties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return;
        }
        this.initDirectories();
        try {
            this.initProxy();
            HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap = new HashMap<String, ProjectLicenseInfo>();
            if (this.licensesOutputFile.exists()) {
                this.loadLicenseInfo(configuredDepLicensesMap, this.licensesOutputFile, true);
            }
            if (this.licensesConfigFile.exists()) {
                this.loadLicenseInfo(configuredDepLicensesMap, this.licensesConfigFile, false);
            }
            Set<MavenProject> dependencies = this.getDependencies();
            List<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
            for (MavenProject project : dependencies) {
                ProjectLicenseInfo depProject;
                Artifact artifact = project.getArtifact();
                this.getLog().debug((CharSequence)("Checking licenses for project " + artifact));
                String artifactProjectId = this.getArtifactProjectId(artifact);
                if (configuredDepLicensesMap.containsKey(artifactProjectId)) {
                    depProject = (ProjectLicenseInfo)configuredDepLicensesMap.get(artifactProjectId);
                    depProject.setVersion(artifact.getVersion());
                } else {
                    depProject = this.createDependencyProject(project);
                }
                if (!this.offline) {
                    this.downloadLicenses(depProject);
                }
                depProjectLicenses.add(depProject);
            }
            try {
                if (this.sortByGroupIdAndArtifactId) {
                    depProjectLicenses = this.sortByGroupIdAndArtifactId(depProjectLicenses);
                }
                if (this.licensesOutputFileEncoding == null) {
                    this.licensesOutputFileEncoding = System.getProperty("file.encoding");
                    this.getLog().warn((CharSequence)"Using the default system encoding for reading or writing licenses.xml file. This makes your build platform dependent. You should set either project.build.sourceEncoding or licensesOutputFileEncoding");
                }
                Charset charset = Charset.forName(this.licensesOutputFileEncoding);
                if (this.licensesOutputFileEol == Eol.AUTODETECT) {
                    Path autodetectFromFile = this.licensesConfigFile.exists() ? this.licensesConfigFile.toPath() : this.project.getBasedir().toPath().resolve("pom.xml");
                    this.licensesOutputFileEol = Eol.autodetect(autodetectFromFile, charset);
                }
                LicenseSummaryWriter.writeLicenseSummary(depProjectLicenses, this.licensesOutputFile, charset, this.licensesOutputFileEol);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
            }
        }
        finally {
            this.restoreProperties();
        }
    }

    private List<ProjectLicenseInfo> sortByGroupIdAndArtifactId(List<ProjectLicenseInfo> depProjectLicenses) {
        ArrayList<ProjectLicenseInfo> sorted = new ArrayList<ProjectLicenseInfo>(depProjectLicenses);
        Comparator<ProjectLicenseInfo> comparator = new Comparator<ProjectLicenseInfo>(){

            @Override
            public int compare(ProjectLicenseInfo info1, ProjectLicenseInfo info2) {
                return (info1.getGroupId() + "+" + info1.getArtifactId()).compareTo(info2.getGroupId() + "+" + info2.getArtifactId());
            }
        };
        Collections.sort(sorted, comparator);
        return sorted;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    public void setExcludedScopes(String excludedScopes) {
        this.excludedScopes = excludedScopes;
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public List<String> getExcludedTypes() {
        return MojoHelper.getParams(this.excludedTypes);
    }

    @Override
    public List<String> getIncludedTypes() {
        return MojoHelper.getParams(this.includedTypes);
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public boolean isVerbose() {
        return this.getLog().isDebugEnabled();
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            FileUtil.createDirectoryIfNecessary(this.licensesOutputDirectory);
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    private void initProxy() throws MojoExecutionException {
        Proxy proxyToUse = null;
        for (Proxy proxy : this.proxies) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            proxyToUse = proxy;
            break;
        }
        if (proxyToUse != null) {
            this.storeProperties();
            System.getProperties().put("proxySet", "true");
            System.setProperty("proxyHost", proxyToUse.getHost());
            System.setProperty("proxyPort", String.valueOf(proxyToUse.getPort()));
            if (proxyToUse.getNonProxyHosts() != null) {
                System.setProperty("nonProxyHosts", proxyToUse.getNonProxyHosts());
            }
            if (proxyToUse.getUsername() != null) {
                String loginPassword = proxyToUse.getUsername() + ":" + proxyToUse.getPassword();
                this.proxyLoginPasswordEncoded = new String(Base64.encodeBase64((byte[])loginPassword.getBytes()));
            }
        }
    }

    private void loadLicenseInfo(Map<String, ProjectLicenseInfo> configuredDepLicensesMap, File licenseConfigFile, boolean previouslyDownloaded) throws MojoExecutionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(licenseConfigFile);
            List<ProjectLicenseInfo> licensesList = LicenseSummaryReader.parseLicenseSummary(fis);
            for (ProjectLicenseInfo dep : licensesList) {
                configuredDepLicensesMap.put(dep.getId(), dep);
                if (!previouslyDownloaded) continue;
                for (ProjectLicense license : dep.getLicenses()) {
                    File licenseFile;
                    String fileName = license.getFile();
                    if (fileName == null || !(licenseFile = new File(this.licensesOutputDirectory, fileName)).exists()) continue;
                    this.downloadedLicenseURLs.put(license.getUrl(), licenseFile);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Unable to parse license summary output file: " + licenseConfigFile, e);
            }
            catch (Throwable throwable) {
                FileUtil.tryClose(fis);
                throw throwable;
            }
        }
        FileUtil.tryClose(fis);
    }

    private String getArtifactProjectId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (Object license : licenses) {
            dependencyProject.addLicense(new ProjectLicense((License)license));
        }
        return dependencyProject;
    }

    private String getLicenseFileName(ProjectLicenseInfo depProject, URL licenseUrl, String licenseName) {
        String licenseFileName;
        String defaultExtension = ".txt";
        File licenseUrlFile = new File(licenseUrl.getPath());
        if (this.organizeLicensesByDependencies) {
            licenseFileName = String.format("%s.%s%s", depProject.getGroupId(), depProject.getArtifactId(), licenseName != null ? "_" + licenseName : "").replaceAll("\\s+", "_");
        } else {
            int extensionIndex;
            licenseFileName = licenseUrlFile.getName();
            if (licenseName != null) {
                licenseFileName = licenseName + " - " + licenseUrlFile.getName();
            }
            if ((extensionIndex = licenseFileName.lastIndexOf(".")) == -1 || extensionIndex > licenseFileName.length() - 3) {
                licenseFileName = licenseFileName + defaultExtension;
            }
        }
        licenseFileName = licenseFileName.toLowerCase(Locale.US).replaceAll("[\\\\/]+", "_");
        return licenseFileName;
    }

    private void downloadLicenses(ProjectLicenseInfo depProject) {
        this.getLog().debug((CharSequence)("Downloading license(s) for project " + depProject));
        List<ProjectLicense> licenses = depProject.getLicenses();
        if (depProject.getLicenses() == null || depProject.getLicenses().isEmpty()) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)("No license information available for: " + depProject));
            }
            return;
        }
        for (ProjectLicense license : licenses) {
            String licenseUrl = this.rewriteLicenseUrlIfNecessary(license.getUrl());
            try {
                File licenseOutputFile = this.downloadedLicenseURLs.get(licenseUrl);
                if (licenseOutputFile == null) {
                    String licenseFileName = license.getFile() != null ? new File(license.getFile()).getName() : this.getLicenseFileName(depProject, new URL(license.getUrl()), license.getName());
                    licenseOutputFile = new File(this.licensesOutputDirectory, licenseFileName);
                }
                if (!(licenseOutputFile.exists() || this.downloadedLicenseURLs.containsKey(licenseUrl) && !this.organizeLicensesByDependencies)) {
                    licenseOutputFile = LicenseDownloader.downloadLicense(licenseUrl, this.proxyLoginPasswordEncoded, licenseOutputFile, this.getLog());
                    this.downloadedLicenseURLs.put(licenseUrl, licenseOutputFile);
                }
                if (licenseOutputFile == null) continue;
                license.setFile(licenseOutputFile.getName());
            }
            catch (MalformedURLException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has an invalid license URL: " + licenseUrl));
            }
            catch (FileNotFoundException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has a license URL that returns file not found: " + licenseUrl));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to retrieve license for dependency: " + depProject.toString()));
                this.getLog().warn((CharSequence)licenseUrl);
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }

    private String rewriteLicenseUrlIfNecessary(String originalLicenseUrl) {
        String resultUrl = originalLicenseUrl;
        if (this.licenseUrlReplacements != null) {
            for (LicenseUrlReplacement urlReplacement : this.licenseUrlReplacements) {
                String replacement;
                Pattern regexp = urlReplacement.getRegexp();
                String string = replacement = urlReplacement.getReplacement() == null ? "" : urlReplacement.getReplacement();
                if (regexp == null) continue;
                resultUrl = regexp.matcher(resultUrl).replaceAll(replacement);
            }
            if (!resultUrl.equals(originalLicenseUrl)) {
                this.getLog().debug((CharSequence)String.format("Rewrote URL %s => %s", originalLicenseUrl, resultUrl));
            }
        }
        return resultUrl;
    }
}

