/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=DependenciesTool.class, hint="default")
public class DefaultDependenciesTool
extends AbstractLogEnabled
implements DependenciesTool {
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Requirement
    private MavenProjectBuilder mavenProjectBuilder;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactMetadataSource artifactMetadataSource;

    @Override
    public SortedMap<String, MavenProject> loadProjectDependencies(ResolvedProjectDependencies artifacts, MavenProjectDependenciesConfigurator configuration, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, SortedMap<String, MavenProject> cache) {
        boolean haveNoIncludedGroups = StringUtils.isEmpty((CharSequence)configuration.getIncludedGroups());
        boolean haveNoIncludedArtifacts = StringUtils.isEmpty((CharSequence)configuration.getIncludedArtifacts());
        boolean excludeTransitiveDependencies = configuration.isExcludeTransitiveDependencies();
        boolean haveExcludedGroups = StringUtils.isNotEmpty((CharSequence)configuration.getExcludedGroups());
        boolean haveExcludedArtifacts = StringUtils.isNotEmpty((CharSequence)configuration.getExcludedArtifacts());
        boolean haveExclusions = haveExcludedGroups || haveExcludedArtifacts;
        Pattern includedGroupPattern = null;
        Pattern includedArtifactPattern = null;
        Pattern excludedGroupPattern = null;
        Pattern excludedArtifactPattern = null;
        if (!haveNoIncludedGroups) {
            includedGroupPattern = Pattern.compile(configuration.getIncludedGroups());
        }
        if (!haveNoIncludedArtifacts) {
            includedArtifactPattern = Pattern.compile(configuration.getIncludedArtifacts());
        }
        if (haveExcludedGroups) {
            excludedGroupPattern = Pattern.compile(configuration.getExcludedGroups());
        }
        if (haveExcludedArtifacts) {
            excludedArtifactPattern = Pattern.compile(configuration.getExcludedArtifacts());
        }
        Set<Artifact> depArtifacts = configuration.isIncludeTransitiveDependencies() ? artifacts.getAllDependencies() : artifacts.getDirectDependencies();
        List<String> includedScopes = configuration.getIncludedScopes();
        List<String> excludeScopes = configuration.getExcludedScopes();
        List<String> includedTypes = configuration.getIncludedTypes();
        List<String> excludeTypes = configuration.getExcludedTypes();
        boolean verbose = configuration.isVerbose();
        TreeMap<String, MavenProject> result = new TreeMap<String, MavenProject>();
        HashMap<String, Artifact> excludeArtifacts = new HashMap<String, Artifact>();
        HashMap<String, Artifact> includeArtifacts = new HashMap<String, Artifact>();
        TreeMap<String, MavenProject> localCache = new TreeMap<String, MavenProject>();
        if (cache != null) {
            localCache.putAll(cache);
        }
        Iterator<Object> iterator = depArtifacts.iterator();
        while (iterator.hasNext()) {
            boolean isToExclude;
            Artifact artifact;
            Artifact artifact2 = artifact = iterator.next();
            excludeArtifacts.put(artifact2.getId(), artifact2);
            if ("license.properties".equals(artifact2.getType())) continue;
            String scope = artifact2.getScope();
            if (CollectionUtils.isNotEmpty(includedScopes) && !includedScopes.contains(scope) || excludeScopes.contains(scope)) continue;
            String type = artifact2.getType();
            if (CollectionUtils.isNotEmpty(includedTypes) && !includedTypes.contains(type) || excludeTypes.contains(type)) continue;
            Logger log = this.getLogger();
            String id = MojoHelper.getArtifactId(artifact2);
            if (verbose) {
                log.info("detected artifact " + id);
            }
            boolean isToInclude = haveNoIncludedArtifacts && haveNoIncludedGroups || this.isIncludable(artifact2, includedGroupPattern, includedArtifactPattern);
            boolean bl = isToExclude = isToInclude && haveExclusions && this.isExcludable(artifact2, excludedGroupPattern, excludedArtifactPattern);
            if (!isToInclude || isToExclude) {
                if (!verbose) continue;
                log.info("skip artifact " + id);
                continue;
            }
            MavenProject depMavenProject = (MavenProject)localCache.get(id);
            if (depMavenProject != null) {
                if (verbose) {
                    log.info("add dependency [" + id + "] (from cache)");
                }
            } else {
                block20: {
                    try {
                        depMavenProject = this.mavenProjectBuilder.buildFromRepository(artifact2, remoteRepositories, localRepository, true);
                        depMavenProject.getArtifact().setScope(artifact2.getScope());
                        if (!depMavenProject.getGroupId().equals(artifact2.getGroupId())) {
                            depMavenProject.setGroupId(artifact2.getGroupId());
                            depMavenProject.getArtifact().setGroupId(artifact2.getGroupId());
                        }
                        if (!depMavenProject.getArtifactId().equals(artifact2.getArtifactId())) {
                            depMavenProject.setArtifactId(artifact2.getArtifactId());
                            depMavenProject.getArtifact().setArtifactId(artifact2.getArtifactId());
                        }
                        if (depMavenProject.getVersion().equals(artifact2.getVersion())) break block20;
                        depMavenProject.setVersion(artifact2.getVersion());
                        depMavenProject.getArtifact().setVersion(artifact2.getVersion());
                    }
                    catch (ProjectBuildingException e) {
                        log.warn("Unable to obtain POM for artifact : " + artifact2, (Throwable)e);
                        continue;
                    }
                }
                if (verbose) {
                    log.info("add dependency [" + id + "]");
                }
                localCache.put(id, depMavenProject);
            }
            result.put(id, depMavenProject);
            excludeArtifacts.remove(artifact2.getId());
            includeArtifacts.put(artifact2.getId(), artifact2);
        }
        if (excludeTransitiveDependencies) {
            for (Map.Entry entry : includeArtifacts.entrySet()) {
                List dependencyTrail = ((Artifact)entry.getValue()).getDependencyTrail();
                boolean remove = false;
                for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
                    if (!excludeArtifacts.containsKey(dependencyTrail.get(i))) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                result.remove(MojoHelper.getArtifactId((Artifact)entry.getValue()));
            }
        }
        if (cache != null) {
            cache.putAll(result);
        }
        return result;
    }

    @Override
    public ResolvedProjectDependencies loadProjectArtifacts(ArtifactRepository localRepository, List remoteRepositories, MavenProject project, List<MavenProject> reactorProjects) throws DependenciesToolException {
        HashMap<String, MavenProject> idToReactorProject = new HashMap<String, MavenProject>();
        if (reactorProjects != null) {
            for (MavenProject reactorProject : reactorProjects) {
                idToReactorProject.put(String.format("%s:%s", reactorProject.getGroupId(), reactorProject.getArtifactId()), reactorProject);
            }
        }
        ArrayList<Dependency> directDependencies = new ArrayList<Dependency>(project.getDependencies());
        HashMap<Object, ArrayList<Dependency>> reactorProjectToTransitiveDependencies = new HashMap<Object, ArrayList<Dependency>>();
        ArrayDeque<Pair> dependenciesToCheck = new ArrayDeque<Pair>();
        for (Dependency dependency : directDependencies) {
            dependenciesToCheck.add(Pair.of((Object)project, (Object)dependency));
        }
        if (reactorProjects != null) {
            while (!dependenciesToCheck.isEmpty()) {
                Dependency dependency;
                Pair pair = (Pair)dependenciesToCheck.remove();
                dependency = (Dependency)pair.getRight();
                String id = String.format("%s:%s", dependency.getGroupId(), dependency.getArtifactId());
                MavenProject dependencyReactorProject = (MavenProject)idToReactorProject.get(id);
                if (dependencyReactorProject != null) {
                    for (Dependency dependency2 : dependencyReactorProject.getDependencies()) {
                        dependenciesToCheck.add(Pair.of((Object)dependencyReactorProject, (Object)dependency2));
                    }
                }
                if (directDependencies.contains(dependency)) continue;
                List<Object> transitiveForSameProject = (List)reactorProjectToTransitiveDependencies.get(pair.getLeft());
                if (transitiveForSameProject == null) {
                    transitiveForSameProject = new ArrayList<Dependency>();
                    reactorProjectToTransitiveDependencies.put(pair.getLeft(), (ArrayList<Dependency>)transitiveForSameProject);
                }
                transitiveForSameProject.add(dependency);
            }
        }
        Set<Artifact> directDependencyArtifacts = this.createDependencyArtifacts(project, directDependencies);
        HashMap reactorProjectToDependencyArtifacts = new HashMap();
        for (Map.Entry entry : reactorProjectToTransitiveDependencies.entrySet()) {
            reactorProjectToDependencyArtifacts.put(entry.getKey(), this.createDependencyArtifacts((MavenProject)entry.getKey(), (List)entry.getValue()));
        }
        HashSet<Artifact> reactorArtifacts = new HashSet<Artifact>();
        HashSet<Artifact> directArtifactsToResolve = new HashSet<Artifact>();
        if (reactorProjects == null) {
            directArtifactsToResolve.addAll(directDependencyArtifacts);
        } else {
            this.partitionByIsReactorProject(directDependencyArtifacts, reactorArtifacts, directArtifactsToResolve, idToReactorProject.keySet());
            for (Map.Entry entry : reactorProjectToDependencyArtifacts.entrySet()) {
                HashSet<Artifact> nonReactorArtifacts = new HashSet<Artifact>();
                this.partitionByIsReactorProject((Set)entry.getValue(), reactorArtifacts, nonReactorArtifacts, idToReactorProject.keySet());
                entry.setValue(nonReactorArtifacts);
            }
        }
        HashSet<Artifact> allDependencies = new HashSet<Artifact>(reactorArtifacts);
        allDependencies.addAll(this.resolve(directArtifactsToResolve, project.getArtifact(), localRepository, remoteRepositories).getArtifacts());
        for (Map.Entry entry : reactorProjectToDependencyArtifacts.entrySet()) {
            MavenProject reactorProject = (MavenProject)entry.getKey();
            Set toResolve = (Set)entry.getValue();
            Artifact reactorProjectArtifact = reactorProject.getArtifact();
            List reactorRemoteRepositories = reactorProject.getRemoteArtifactRepositories();
            allDependencies.addAll(this.resolve(toResolve, reactorProjectArtifact, localRepository, reactorRemoteRepositories).getArtifacts());
        }
        return new ResolvedProjectDependencies(allDependencies, directDependencyArtifacts);
    }

    private Set<Artifact> createDependencyArtifacts(MavenProject project, List<Dependency> dependencies) throws DependenciesToolException {
        try {
            return MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, dependencies, null, null, (MavenProject)project);
        }
        catch (InvalidDependencyVersionException e) {
            throw new DependenciesToolException(e);
        }
    }

    private void partitionByIsReactorProject(Set<Artifact> artifacts, Set<Artifact> reactorArtifacts, Set<Artifact> nonReactorArtifacts, Set<String> reactorProjectIds) {
        for (Artifact dependencyArtifact : artifacts) {
            String artifactKey = String.format("%s:%s", dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId());
            if (reactorProjectIds.contains(artifactKey)) {
                reactorArtifacts.add(dependencyArtifact);
                continue;
            }
            nonReactorArtifacts.add(dependencyArtifact);
        }
    }

    private ArtifactResolutionResult resolve(Set<Artifact> artifacts, Artifact projectArtifact, ArtifactRepository localRepository, List remoteRepositories) throws DependenciesToolException {
        try {
            return this.artifactResolver.resolveTransitively(artifacts, projectArtifact, remoteRepositories, localRepository, this.artifactMetadataSource);
        }
        catch (ArtifactResolutionException e) {
            throw new DependenciesToolException(e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DependenciesToolException(e);
        }
    }

    protected boolean isIncludable(Artifact project, Pattern includedGroupPattern, Pattern includedArtifactPattern) {
        Matcher matchGroupId;
        Logger log = this.getLogger();
        if (includedGroupPattern != null) {
            try {
                matchGroupId = includedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Include " + project.getGroupId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, includedGroupPattern.pattern()));
            }
        }
        if (includedArtifactPattern != null) {
            try {
                matchGroupId = includedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Include " + project.getArtifactId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, includedArtifactPattern.pattern()));
            }
        }
        return false;
    }

    protected boolean isExcludable(Artifact project, Pattern excludedGroupPattern, Pattern excludedArtifactPattern) {
        Matcher matchGroupId;
        Logger log = this.getLogger();
        if (excludedGroupPattern != null) {
            try {
                matchGroupId = excludedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exclude " + project.getGroupId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, excludedGroupPattern.pattern()));
            }
        }
        if (excludedArtifactPattern != null) {
            try {
                matchGroupId = excludedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exclude " + project.getArtifactId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, excludedArtifactPattern.pattern()));
            }
        }
        return false;
    }
}

