/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.spdx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpdxLicenseInfo {
    private final String reference;
    private final boolean isDeprecatedLicenseId;
    private final String detailsUrl;
    private final int referenceNumber;
    private final String name;
    private final String licenseId;
    private final List<String> seeAlso;
    private final boolean isOsiApproved;
    private final boolean isFsfLibre;
    private final Attachments attachments;

    public static Builder builder() {
        return new Builder();
    }

    public SpdxLicenseInfo(String reference, boolean isDeprecatedLicenseId, boolean isFsfLibre, String detailsUrl, int referenceNumber, String name, String licenseId, List<String> seeAlso, boolean isOsiApproved, Attachments attachments) {
        this.reference = reference;
        this.isDeprecatedLicenseId = isDeprecatedLicenseId;
        this.isFsfLibre = isFsfLibre;
        this.detailsUrl = detailsUrl;
        this.referenceNumber = referenceNumber;
        this.name = name;
        this.licenseId = licenseId;
        this.seeAlso = seeAlso;
        this.isOsiApproved = isOsiApproved;
        this.attachments = attachments;
    }

    public boolean isFsfLibre() {
        return this.isFsfLibre;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean isDeprecatedLicenseId() {
        return this.isDeprecatedLicenseId;
    }

    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    public int getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public List<String> getSeeAlso() {
        return this.seeAlso;
    }

    public boolean isOsiApproved() {
        return this.isOsiApproved;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public static class Builder {
        private Boolean isDeprecatedLicenseId;
        private boolean isFsfLibre;
        private String detailsUrl;
        private Integer referenceNumber;
        private String name;
        private String reference;
        private String licenseId;
        private List<String> seeAlso = new ArrayList<String>();
        private Boolean isOsiApproved;
        private Map<String, Attachments.UrlInfo> urlInfos = new LinkedHashMap<String, Attachments.UrlInfo>();

        public Builder isDeprecatedLicenseId(boolean isDeprecatedLicenseId) {
            this.isDeprecatedLicenseId = isDeprecatedLicenseId;
            return this;
        }

        public Builder isFsfLibre(boolean isFsfLibre) {
            this.isFsfLibre = isFsfLibre;
            return this;
        }

        public Builder detailsUrl(String detailsUrl) {
            this.detailsUrl = detailsUrl;
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder referenceNumber(int referenceNumber) {
            this.referenceNumber = referenceNumber;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder licenseId(String licenseId) {
            this.licenseId = licenseId;
            return this;
        }

        public Builder seeAlso(String seeAlso) {
            this.seeAlso.add(seeAlso);
            return this;
        }

        public Builder urlInfo(String url, String sha1, String mimeType, boolean stable) {
            this.urlInfos.put(url, new Attachments.UrlInfo(sha1, mimeType, stable));
            return this;
        }

        public Builder isOsiApproved(boolean isOsiApproved) {
            this.isOsiApproved = isOsiApproved;
            return this;
        }

        public SpdxLicenseInfo build() {
            Objects.requireNonNull(this.isDeprecatedLicenseId, "isDeprecatedLicenseId");
            Objects.requireNonNull(this.detailsUrl, "detailsUrl");
            Objects.requireNonNull(this.reference, "reference");
            Objects.requireNonNull(this.referenceNumber, "referenceNumber");
            Objects.requireNonNull(this.name, "name");
            Objects.requireNonNull(this.licenseId, "licenseId");
            Objects.requireNonNull(this.isOsiApproved, "isOsiApproved");
            if (this.seeAlso.isEmpty()) {
                throw new IllegalStateException("seeAlso cannot be empty");
            }
            List<String> sa = Collections.unmodifiableList(this.seeAlso);
            this.seeAlso = null;
            Map<String, Attachments.UrlInfo> uis = Collections.unmodifiableMap(this.urlInfos);
            this.urlInfos = null;
            return new SpdxLicenseInfo(this.reference, this.isDeprecatedLicenseId, this.isFsfLibre, this.detailsUrl, this.referenceNumber, this.name, this.licenseId, sa, this.isOsiApproved, new Attachments(uis));
        }
    }

    public static class Attachments {
        private final Map<String, UrlInfo> urlInfos;

        Attachments(Map<String, UrlInfo> urlInfos) {
            this.urlInfos = urlInfos;
        }

        public Map<String, UrlInfo> getUrlInfos() {
            return this.urlInfos;
        }

        public static class UrlInfo {
            private final String sha1;
            private final String mimeType;
            private final boolean stable;

            public UrlInfo(String sha1, String mimeType, boolean stable) {
                this.sha1 = sha1;
                this.mimeType = mimeType;
                this.stable = stable;
            }

            public boolean isStable() {
                return this.stable;
            }

            public String getSha1() {
                return this.sha1;
            }

            public String getMimeType() {
                return this.mimeType;
            }
        }
    }
}

