/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.Eol;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.download.LicenseSummaryWriter;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;

public abstract class AbstractLicensesXmlMojo
extends AbstractMojo {
    @Parameter(property="licensesOutputFile", defaultValue="${project.build.directory}/generated-resources/licenses.xml")
    protected File licensesOutputFile;
    @Parameter(property="licensesOutputFileEol", defaultValue="AUTODETECT")
    protected Eol licensesOutputFileEol;
    @Parameter(property="licensesOutputFileEncoding", defaultValue="${project.build.sourceEncoding}")
    private String licensesOutputFileEncoding;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    protected DependenciesTool dependenciesTool;
    private Charset charset;

    public String getEncoding() {
        this.initEncoding();
        return this.licensesOutputFileEncoding;
    }

    private void initEncoding() {
        if (this.charset == null) {
            if (this.licensesOutputFileEncoding == null) {
                this.licensesOutputFileEncoding = System.getProperty("file.encoding");
                this.getLog().warn((CharSequence)"Using the default system encoding for reading or writing licenses.xml file. This makes your build platform dependent. You should set either project.build.sourceEncoding or licensesOutputFileEncoding");
            }
            this.charset = Charset.forName(this.licensesOutputFileEncoding);
            if (this.licensesOutputFileEol == Eol.AUTODETECT) {
                Path[] paths = this.getAutodetectEolFiles();
                Path autodetectFromFile = null;
                for (Path path : paths) {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    autodetectFromFile = path;
                    break;
                }
                if (autodetectFromFile != null) {
                    try {
                        this.licensesOutputFileEol = Eol.autodetect(autodetectFromFile, this.charset);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot autodetect end of line from file \"" + autodetectFromFile + "\"", e);
                    }
                }
            }
        }
    }

    protected Path[] getAutodetectEolFiles() {
        return new Path[]{this.licensesOutputFile.toPath()};
    }

    protected void writeLicenseSummary(List<ProjectLicenseInfo> deps, File licensesOutputFile, boolean writeVersions) throws ParserConfigurationException, TransformerException, IOException {
        this.initEncoding();
        LicenseSummaryWriter.writeLicenseSummary(deps, licensesOutputFile, this.charset, this.licensesOutputFileEol, writeVersions);
    }
}

