/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="add-third-party", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class AddThirdPartyMojo
extends AbstractAddThirdPartyMojo
implements MavenProjectDependenciesConfigurator {
    @Parameter(property="license.deployMissingFile", defaultValue="true")
    private boolean deployMissingFile;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    private boolean useRepositoryMissingFiles;
    @Parameter(property="license.acceptPomPackaging", defaultValue="false")
    private boolean acceptPomPackaging;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes", defaultValue="")
    private String includedScopes;
    @Parameter(property="license.excludedGroups", defaultValue="")
    private String excludedGroups;
    @Parameter(property="license.includedGroups", defaultValue="")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts", defaultValue="")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts", defaultValue="")
    private String includedArtifacts;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    private boolean doGenerateMissing;

    @Override
    protected boolean checkPackaging() {
        if (this.acceptPomPackaging) {
            return true;
        }
        return this.rejectPackaging("pom");
    }

    @Override
    protected boolean checkSkip() {
        if (!(this.isDoGenerate() || this.isDoGenerateBundle() || this.doGenerateMissing)) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        boolean unsafe = this.checkUnsafeDependencies();
        boolean safeLicense = this.checkForbiddenLicenses();
        if (!safeLicense && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some forbidden licenses used, please check your dependencies.");
        }
        this.writeThirdPartyFile();
        if (this.doGenerateMissing) {
            this.writeMissingFile();
        }
        if (unsafe && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some dependencies with no license, please fill the file " + this.getMissingFile());
        }
        if (!unsafe && this.isUseMissingFile() && MapUtils.isEmpty((Map)this.getUnsafeMappings()) && this.getMissingFile().exists()) {
            this.getLog().info((CharSequence)("There is no dependency to put in missing file, delete it at " + this.getMissingFile()));
            FileUtil.deleteFile(this.getMissingFile());
        }
        if (!unsafe && this.deployMissingFile && MapUtils.isNotEmpty((Map)this.getUnsafeMappings())) {
            File file = this.getMissingFile();
            this.getLog().info((CharSequence)("Will deploy third party file from " + file));
            this.getHelper().attachThirdPartyDescriptor(file);
        }
        this.addResourceDir(this.getOutputDirectory(), "**/*.txt");
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() {
        return this.getHelper().loadDependencies(this);
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException {
        SortedSet<MavenProject> unsafeDependencies = this.getUnsafeDependencies();
        SortedProperties unsafeMappings = this.getHelper().createUnsafeMapping(this.getLicenseMap(), this.getMissingFile(), this.useRepositoryMissingFiles, unsafeDependencies, this.getProjectDependencies().values());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("found " + unsafeMappings.size() + " unsafe mappings"));
        }
        this.doGenerateMissing = this.computeDoGenerateMissingFile(unsafeMappings, unsafeDependencies);
        if (this.doGenerateMissing && this.isVerbose()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Will use from missing file ");
            sb.append(unsafeMappings.size());
            sb.append(" dependencies :");
            for (Map.Entry<Object, Object> entry : unsafeMappings.entrySet()) {
                String id = (String)entry.getKey();
                String license = (String)entry.getValue();
                sb.append("\n - ").append(id).append(" - ").append(license);
            }
            this.getLog().info((CharSequence)sb.toString());
        } else if (this.isUseMissingFile() && !unsafeMappings.isEmpty()) {
            this.getLog().info((CharSequence)("Missing file " + this.getMissingFile() + " is up-to-date."));
        }
        return unsafeMappings;
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    private boolean computeDoGenerateMissingFile(SortedProperties unsafeMappings, SortedSet<MavenProject> unsafeDependencies) throws IOException {
        if (!this.isUseMissingFile()) {
            return false;
        }
        if (this.isForce()) {
            return !CollectionUtils.isEmpty(unsafeMappings.keySet());
        }
        if (!CollectionUtils.isEmpty(unsafeDependencies)) {
            return true;
        }
        File missingFile = this.getMissingFile();
        if (!missingFile.exists()) {
            return true;
        }
        SortedProperties oldUnsafeMappings = new SortedProperties(this.getEncoding());
        oldUnsafeMappings.load(missingFile);
        return !unsafeMappings.equals(oldUnsafeMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMissingFile() throws IOException {
        Log log = this.getLog();
        LicenseMap licenseMap = this.getLicenseMap();
        File file = this.getMissingFile();
        FileUtil.createDirectoryIfNecessary(file.getParentFile());
        log.info((CharSequence)("Regenerate missing license file " + file));
        FileOutputStream writer = new FileOutputStream(file);
        try {
            StringBuilder sb = new StringBuilder(" Generated by " + this.getClass().getName());
            ArrayList licenses = new ArrayList(licenseMap.keySet());
            licenses.remove("Unknown license");
            if (!licenses.isEmpty()) {
                sb.append("\n-------------------------------------------------------------------------------");
                sb.append("\n Already used licenses in project :");
                for (String license : licenses) {
                    sb.append("\n - ").append(license);
                }
            }
            sb.append("\n-------------------------------------------------------------------------------");
            sb.append("\n Please fill the missing licenses for dependencies :\n\n");
            this.getUnsafeMappings().store(writer, sb.toString());
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }
}

