/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.model.ProjectLicenseInfo;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.LicenseDownloader;
import org.codehaus.mojo.license.utils.LicenseSummaryReader;
import org.codehaus.mojo.license.utils.LicenseSummaryWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="download-licenses", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public class DownloadLicensesMojo
extends AbstractMojo
implements MavenProjectDependenciesConfigurator {
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List remoteRepositories;
    @Parameter(property="licensesConfigFile", defaultValue="${project.basedir}/src/license/licenses.xml")
    private File licensesConfigFile;
    @Parameter(property="licensesOutputDirectory", defaultValue="${project.build.directory}/generated-resources/licenses")
    private File licensesOutputDirectory;
    @Parameter(property="licensesOutputFile", defaultValue="${project.build.directory}/generated-resources/licenses.xml")
    private File licensesOutputFile;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes", defaultValue="")
    private String includedScopes;
    @Parameter(defaultValue="${settings.offline}")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Component
    private MavenProject project;
    @Component
    private DependenciesTool dependenciesTool;
    private Set<String> downloadedLicenseURLs = new HashSet<String>();

    public void execute() throws MojoExecutionException {
        if (this.offline) {
            this.getLog().warn((CharSequence)"Offline flag is on, download-licenses goal is skip.");
            return;
        }
        this.initDirectories();
        HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap = new HashMap<String, ProjectLicenseInfo>();
        if (this.licensesOutputFile.exists()) {
            this.loadLicenseInfo(configuredDepLicensesMap, this.licensesOutputFile, true);
        }
        if (this.licensesConfigFile.exists()) {
            this.loadLicenseInfo(configuredDepLicensesMap, this.licensesConfigFile, false);
        }
        SortedMap<String, MavenProject> dependencies = this.dependenciesTool.loadProjectDependencies(this.project, this, this.localRepository, this.remoteRepositories, null);
        ArrayList<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
        for (MavenProject project : dependencies.values()) {
            ProjectLicenseInfo depProject;
            Artifact artifact = project.getArtifact();
            this.getLog().debug((CharSequence)("Checking licenses for project " + artifact));
            String artifactProjectId = this.getArtifactProjectId(artifact);
            if (configuredDepLicensesMap.containsKey(artifactProjectId)) {
                depProject = (ProjectLicenseInfo)configuredDepLicensesMap.get(artifactProjectId);
                depProject.setVersion(artifact.getVersion());
            } else {
                depProject = this.createDependencyProject(project);
            }
            this.downloadLicenses(depProject);
            depProjectLicenses.add(depProject);
        }
        try {
            LicenseSummaryWriter.writeLicenseSummary(depProjectLicenses, this.licensesOutputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
        }
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public List<String> getExcludedScopes() {
        String[] split = this.excludedScopes == null ? new String[]{} : this.excludedScopes.split(",");
        return Arrays.asList(split);
    }

    public void setExcludedScopes(String excludedScopes) {
        this.excludedScopes = excludedScopes;
    }

    @Override
    public List<String> getIncludedScopes() {
        String[] split = this.includedScopes == null ? new String[]{} : this.includedScopes.split(",");
        return Arrays.asList(split);
    }

    @Override
    public String getIncludedArtifacts() {
        return null;
    }

    @Override
    public String getIncludedGroups() {
        return null;
    }

    @Override
    public String getExcludedGroups() {
        return null;
    }

    @Override
    public String getExcludedArtifacts() {
        return null;
    }

    @Override
    public boolean isVerbose() {
        return this.getLog().isDebugEnabled();
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            FileUtil.createDirectoryIfNecessary(this.licensesOutputDirectory);
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    private void loadLicenseInfo(Map<String, ProjectLicenseInfo> configuredDepLicensesMap, File licenseConfigFile, boolean previouslyDownloaded) throws MojoExecutionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(licenseConfigFile);
            List<ProjectLicenseInfo> licensesList = LicenseSummaryReader.parseLicenseSummary(fis);
            for (ProjectLicenseInfo dep : licensesList) {
                configuredDepLicensesMap.put(dep.getId(), dep);
                if (!previouslyDownloaded) continue;
                for (License license : dep.getLicenses()) {
                    this.downloadedLicenseURLs.add(license.getUrl());
                }
            }
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Unable to parse license summary output file: " + licenseConfigFile, e);
            }
            catch (Throwable throwable) {
                FileUtil.tryClose(fis);
                throw throwable;
            }
        }
        FileUtil.tryClose(fis);
    }

    private String getArtifactProjectId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (Object license : licenses) {
            dependencyProject.addLicense((License)license);
        }
        return dependencyProject;
    }

    private String getLicenseFileName(License license) throws MalformedURLException {
        URL licenseUrl = new URL(license.getUrl());
        File licenseUrlFile = new File(licenseUrl.getPath());
        String licenseFileName = licenseUrlFile.getName();
        if (license.getName() != null) {
            licenseFileName = license.getName() + " - " + licenseUrlFile.getName();
        }
        String defaultExtension = ".txt";
        int extensionIndex = licenseFileName.lastIndexOf(".");
        if (extensionIndex == -1 || extensionIndex > licenseFileName.length() - 3) {
            licenseFileName = licenseFileName + ".txt";
        }
        licenseFileName = licenseFileName.toLowerCase();
        return licenseFileName;
    }

    private void downloadLicenses(ProjectLicenseInfo depProject) {
        this.getLog().debug((CharSequence)("Downloading license(s) for project " + depProject));
        List<License> licenses = depProject.getLicenses();
        if (depProject.getLicenses() == null || depProject.getLicenses().isEmpty()) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)("No license information available for: " + depProject));
            }
            return;
        }
        for (License license : licenses) {
            try {
                String licenseFileName = this.getLicenseFileName(license);
                File licenseOutputFile = new File(this.licensesOutputDirectory, licenseFileName);
                if (licenseOutputFile.exists() || this.downloadedLicenseURLs.contains(license.getUrl())) continue;
                LicenseDownloader.downloadLicense(license.getUrl(), licenseOutputFile);
                this.downloadedLicenseURLs.add(license.getUrl());
            }
            catch (MalformedURLException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has an invalid license URL: " + license.getUrl()));
            }
            catch (FileNotFoundException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has a license URL that returns file not found: " + license.getUrl()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to retrieve license for dependency: " + depProject.toString()));
                this.getLog().warn((CharSequence)license.getUrl());
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }
}

