package org.codehaus.mojo.license.spdx;

/*
 * #%L
 * License Maven Plugin
 * %%
 * Copyright (C) 2019 Codehaus
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * A class generated by GenerateSpdxLicenseList.groovy from
 * <a href="https://raw.githubusercontent.com/spdx/license-list-data/master/json/licenses.json">
 * https://raw.githubusercontent.com/spdx/license-list-data/master/json/licenses.json</a>
 */
class SpdxLicenseListData
{

    static SpdxLicenseList createList()
    {
        final SpdxLicenseList.Builder builder = SpdxLicenseList.builder();
        builder.licenseListVersion( "v3.4-13-g6f12e70" );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./0BSD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/0BSD.json" )
            .name( "BSD Zero Clause License" )
            .licenseId( "0BSD" )
            .seeAlso( "http://landley.net/toybox/license.html" )

            .urlInfo( "http://landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .urlInfo( "http://www.landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .urlInfo( "https://landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .urlInfo( "https://www.landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AAL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AAL.json" )
            .name( "Attribution Assurance License" )
            .licenseId( "AAL" )
            .seeAlso( "https://opensource.org/licenses/attribution" )

            .urlInfo( "http://opensource.org/licenses/attribution", "167a1512b3489de35caabde436b1fb1fa880768e", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/attribution", "167a1512b3489de35caabde436b1fb1fa880768e", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/attribution", "167a1512b3489de35caabde436b1fb1fa880768e", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/attribution", "167a1512b3489de35caabde436b1fb1fa880768e", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ADSL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ADSL.json" )
            .name( "Amazon Digital Services License" )
            .licenseId( "ADSL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-1.1.json" )
            .name( "Academic Free License v1.1" )
            .licenseId( "AFL-1.1" )
            .seeAlso( "http://opensource.linux-mirror.org/licenses/afl-1.1.txt" )
            .seeAlso( "http://wayback.archive.org/web/20021004124254/http://www.opensource.org/licenses/academic.php" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-1.2.json" )
            .name( "Academic Free License v1.2" )
            .licenseId( "AFL-1.2" )
            .seeAlso( "http://opensource.linux-mirror.org/licenses/afl-1.2.txt" )
            .seeAlso( "http://wayback.archive.org/web/20021204204652/http://www.opensource.org/licenses/academic.php" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-2.0.json" )
            .name( "Academic Free License v2.0" )
            .licenseId( "AFL-2.0" )
            .seeAlso( "http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-2.1.json" )
            .name( "Academic Free License v2.1" )
            .licenseId( "AFL-2.1" )
            .seeAlso( "http://opensource.linux-mirror.org/licenses/afl-2.1.txt" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-3.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-3.0.json" )
            .name( "Academic Free License v3.0" )
            .licenseId( "AFL-3.0" )
            .seeAlso( "http://www.rosenlaw.com/AFL3.0.htm" )
            .seeAlso( "https://opensource.org/licenses/afl-3.0" )

            .urlInfo( "http://opensource.org/licenses/afl-3.0", "3f28e70cbfc51f40160d9b8bf5bdbe639cdb8c34", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/afl-3.0", "3f28e70cbfc51f40160d9b8bf5bdbe639cdb8c34", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/afl-3.0", "3f28e70cbfc51f40160d9b8bf5bdbe639cdb8c34", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/afl-3.0", "3f28e70cbfc51f40160d9b8bf5bdbe639cdb8c34", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-1.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-1.0.json" )
            .name( "Affero General Public License v1.0" )
            .licenseId( "AGPL-1.0" )
            .seeAlso( "http://www.affero.org/oagpl.html" )

            .urlInfo( "http://affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .urlInfo( "http://www.affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-1.0-only.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AGPL-1.0-only.json" )
            .name( "Affero General Public License v1.0 only" )
            .licenseId( "AGPL-1.0-only" )
            .seeAlso( "http://www.affero.org/oagpl.html" )

            .urlInfo( "http://affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .urlInfo( "http://www.affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-1.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AGPL-1.0-or-later.json" )
            .name( "Affero General Public License v1.0 or later" )
            .licenseId( "AGPL-1.0-or-later" )
            .seeAlso( "http://www.affero.org/oagpl.html" )

            .urlInfo( "http://affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .urlInfo( "http://www.affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-3.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-3.0.json" )
            .name( "GNU Affero General Public License v3.0" )
            .licenseId( "AGPL-3.0" )
            .seeAlso( "https://www.gnu.org/licenses/agpl.txt" )
            .seeAlso( "https://opensource.org/licenses/AGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-3.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-3.0-only.json" )
            .name( "GNU Affero General Public License v3.0 only" )
            .licenseId( "AGPL-3.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/agpl.txt" )
            .seeAlso( "https://opensource.org/licenses/AGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-3.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-3.0-or-later.json" )
            .name( "GNU Affero General Public License v3.0 or later" )
            .licenseId( "AGPL-3.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/agpl.txt" )
            .seeAlso( "https://opensource.org/licenses/AGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/AGPL-3.0", "f1141a83b31049d9aaf668b09d29f650568a8864", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AMDPLPA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AMDPLPA.json" )
            .name( "AMD's plpa_map.c License" )
            .licenseId( "AMDPLPA" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "2c6a826c264baa26b61799066041b64f44e8f00a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "2c6a826c264baa26b61799066041b64f44e8f00a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "2c6a826c264baa26b61799066041b64f44e8f00a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "2c6a826c264baa26b61799066041b64f44e8f00a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AML.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AML.json" )
            .name( "Apple MIT License" )
            .licenseId( "AML" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Apple_MIT_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Apple_MIT_License", "4a0ab46e3cb366eae3795537fa490b94e8c4a474", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Apple_MIT_License", "4a0ab46e3cb366eae3795537fa490b94e8c4a474", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Apple_MIT_License", "4a0ab46e3cb366eae3795537fa490b94e8c4a474", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Apple_MIT_License", "4a0ab46e3cb366eae3795537fa490b94e8c4a474", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AMPAS.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AMPAS.json" )
            .name( "Academy of Motion Picture Arts and Sciences BSD" )
            .licenseId( "AMPAS" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ANTLR-PD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ANTLR-PD.json" )
            .name( "ANTLR Software Rights Notice" )
            .licenseId( "ANTLR-PD" )
            .seeAlso( "http://www.antlr2.org/license.html" )

            .urlInfo( "http://antlr2.org/license.html", "ff217bee0b3bec01a758737818bacb25dfbd6afe", "text/html", true, false )
            .urlInfo( "http://www.antlr2.org/license.html", "ff217bee0b3bec01a758737818bacb25dfbd6afe", "text/html", true, false )
            .urlInfo( "https://www.antlr2.org/license.html", "ff217bee0b3bec01a758737818bacb25dfbd6afe", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APAFML.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APAFML.json" )
            .name( "Adobe Postscript AFM License" )
            .licenseId( "APAFML" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "59b86d966161c6f391668e5c22d2ad51c240e43a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "59b86d966161c6f391668e5c22d2ad51c240e43a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "59b86d966161c6f391668e5c22d2ad51c240e43a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "59b86d966161c6f391668e5c22d2ad51c240e43a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APL-1.0.json" )
            .name( "Adaptive Public License 1.0" )
            .licenseId( "APL-1.0" )
            .seeAlso( "https://opensource.org/licenses/APL-1.0" )

            .urlInfo( "http://opensource.org/licenses/APL-1.0", "e9ca68f274ad4a1836a9d35576e37dfe6fe90dfd", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/APL-1.0", "e9ca68f274ad4a1836a9d35576e37dfe6fe90dfd", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/APL-1.0", "e9ca68f274ad4a1836a9d35576e37dfe6fe90dfd", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/APL-1.0", "e9ca68f274ad4a1836a9d35576e37dfe6fe90dfd", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APSL-1.0.json" )
            .name( "Apple Public Source License 1.0" )
            .licenseId( "APSL-1.0" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "8db2d5c7fffb8a7d86504a79c3c81e2b138a53c2", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "8db2d5c7fffb8a7d86504a79c3c81e2b138a53c2", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "8db2d5c7fffb8a7d86504a79c3c81e2b138a53c2", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "8db2d5c7fffb8a7d86504a79c3c81e2b138a53c2", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APSL-1.1.json" )
            .name( "Apple Public Source License 1.1" )
            .licenseId( "APSL-1.1" )
            .seeAlso( "http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE" )

            .urlInfo( "http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE", "ee2b2438e398cfe8568a1826ff18fff4aff2b3a7", "text/plain", true, false )
            .urlInfo( "https://opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE", "ee2b2438e398cfe8568a1826ff18fff4aff2b3a7", "text/plain", true, false )
            .urlInfo( "https://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE", "ee2b2438e398cfe8568a1826ff18fff4aff2b3a7", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APSL-1.2.json" )
            .name( "Apple Public Source License 1.2" )
            .licenseId( "APSL-1.2" )
            .seeAlso( "http://www.samurajdata.se/opensource/mirror/licenses/apsl.php" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/APSL-2.0.json" )
            .name( "Apple Public Source License 2.0" )
            .licenseId( "APSL-2.0" )
            .seeAlso( "http://www.opensource.apple.com/license/apsl/" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Abstyles.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Abstyles.json" )
            .name( "Abstyles License" )
            .licenseId( "Abstyles" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Abstyles" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Abstyles", "696e92cbcfb4082dfb9a0bac290a63437a0a37bf", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Abstyles", "696e92cbcfb4082dfb9a0bac290a63437a0a37bf", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Abstyles", "696e92cbcfb4082dfb9a0bac290a63437a0a37bf", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Abstyles", "696e92cbcfb4082dfb9a0bac290a63437a0a37bf", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Adobe-2006.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Adobe-2006.json" )
            .name( "Adobe Systems Incorporated Source Code License Agreement" )
            .licenseId( "Adobe-2006" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AdobeLicense" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AdobeLicense", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Adobe-Glyph.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Adobe-Glyph.json" )
            .name( "Adobe Glyph List License" )
            .licenseId( "Adobe-Glyph" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Afmparse.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Afmparse.json" )
            .name( "Afmparse License" )
            .licenseId( "Afmparse" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Afmparse" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Afmparse", "a509c3eb761b8c62c11b492dc48a1788394ceb83", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Afmparse", "a509c3eb761b8c62c11b492dc48a1788394ceb83", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Afmparse", "a509c3eb761b8c62c11b492dc48a1788394ceb83", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Afmparse", "a509c3eb761b8c62c11b492dc48a1788394ceb83", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Aladdin.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Aladdin.json" )
            .name( "Aladdin Free Public License" )
            .licenseId( "Aladdin" )
            .seeAlso( "http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm" )

            .urlInfo( "http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm", "c38fdbb75a01231de6a9d8315fbdd2a4f897b0ee", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Apache-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Apache-1.0.json" )
            .name( "Apache License 1.0" )
            .licenseId( "Apache-1.0" )
            .seeAlso( "http://www.apache.org/licenses/LICENSE-1.0" )

            .urlInfo( "http://apache.org/licenses/LICENSE-1.0", "ee3ed3c77889131fcce593511cb4d8d416ca94ac", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-1.0", "ee3ed3c77889131fcce593511cb4d8d416ca94ac", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-1.0", "ee3ed3c77889131fcce593511cb4d8d416ca94ac", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-1.0", "ee3ed3c77889131fcce593511cb4d8d416ca94ac", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Apache-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Apache-1.1.json" )
            .name( "Apache License 1.1" )
            .licenseId( "Apache-1.1" )
            .seeAlso( "http://apache.org/licenses/LICENSE-1.1" )
            .seeAlso( "https://opensource.org/licenses/Apache-1.1" )

            .urlInfo( "http://apache.org/licenses/LICENSE-1.1", "2d4dc7c4a231cff49934c3830787769a7afa5549", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-1.1", "2d4dc7c4a231cff49934c3830787769a7afa5549", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-1.1", "2d4dc7c4a231cff49934c3830787769a7afa5549", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-1.1", "2d4dc7c4a231cff49934c3830787769a7afa5549", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/Apache-1.1", "8a6e39453268a2e79a6b94f3e7d1e15100c6c627", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Apache-1.1", "8a6e39453268a2e79a6b94f3e7d1e15100c6c627", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Apache-1.1", "8a6e39453268a2e79a6b94f3e7d1e15100c6c627", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Apache-1.1", "8a6e39453268a2e79a6b94f3e7d1e15100c6c627", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Apache-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Apache-2.0.json" )
            .name( "Apache License 2.0" )
            .licenseId( "Apache-2.0" )
            .seeAlso( "http://www.apache.org/licenses/LICENSE-2.0" )
            .seeAlso( "https://opensource.org/licenses/Apache-2.0" )

            .urlInfo( "http://apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/Apache-2.0", "709c684f56ad4b7c9bee6a690868687df1d6cc07", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Apache-2.0", "709c684f56ad4b7c9bee6a690868687df1d6cc07", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Apache-2.0", "709c684f56ad4b7c9bee6a690868687df1d6cc07", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Apache-2.0", "709c684f56ad4b7c9bee6a690868687df1d6cc07", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Artistic-1.0.json" )
            .name( "Artistic License 1.0" )
            .licenseId( "Artistic-1.0" )
            .seeAlso( "https://opensource.org/licenses/Artistic-1.0" )

            .urlInfo( "http://opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-1.0-Perl.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Artistic-1.0-Perl.json" )
            .name( "Artistic License 1.0 (Perl)" )
            .licenseId( "Artistic-1.0-Perl" )
            .seeAlso( "http://dev.perl.org/licenses/artistic.html" )

            .urlInfo( "http://dev.perl.org/licenses/artistic.html", "10aab5372b3fde865b62d3c0047f824f17c49a8d", "text/html", true, false )
            .urlInfo( "https://dev.perl.org/licenses/artistic.html", "10aab5372b3fde865b62d3c0047f824f17c49a8d", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-1.0-cl8.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Artistic-1.0-cl8.json" )
            .name( "Artistic License 1.0 w/clause 8" )
            .licenseId( "Artistic-1.0-cl8" )
            .seeAlso( "https://opensource.org/licenses/Artistic-1.0" )

            .urlInfo( "http://opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Artistic-1.0", "b821de05448a16af3ed3d1ca2045825c17cd5f40", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Artistic-2.0.json" )
            .name( "Artistic License 2.0" )
            .licenseId( "Artistic-2.0" )
            .seeAlso( "http://www.perlfoundation.org/artistic_license_2_0" )
            .seeAlso( "https://opensource.org/licenses/artistic-license-2.0" )

            .urlInfo( "http://perlfoundation.org/artistic_license_2_0", "79a5a5d832b801579bf6f9b29ec87614f79e6513", "text/html", true, false )
            .urlInfo( "http://www.perlfoundation.org/artistic_license_2_0", "79a5a5d832b801579bf6f9b29ec87614f79e6513", "text/html", true, false )
            .urlInfo( "https://perlfoundation.org/artistic_license_2_0", "79a5a5d832b801579bf6f9b29ec87614f79e6513", "text/html", true, false )
            .urlInfo( "https://www.perlfoundation.org/artistic_license_2_0", "79a5a5d832b801579bf6f9b29ec87614f79e6513", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/artistic-license-2.0", "b2517818a4c1216ffd0e5cb81d5fab75b20a9836", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/artistic-license-2.0", "b2517818a4c1216ffd0e5cb81d5fab75b20a9836", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/artistic-license-2.0", "b2517818a4c1216ffd0e5cb81d5fab75b20a9836", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/artistic-license-2.0", "b2517818a4c1216ffd0e5cb81d5fab75b20a9836", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-1-Clause.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-1-Clause.json" )
            .name( "BSD 1-Clause License" )
            .licenseId( "BSD-1-Clause" )
            .seeAlso( "https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823" )

            .urlInfo( "http://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823", "0c025021376b31ef1c4920f5ae3428d3eeb1fa50", "text/plain", true, false )
            .urlInfo( "https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823", "0c025021376b31ef1c4920f5ae3428d3eeb1fa50", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause.json" )
            .name( "BSD 2-Clause \"Simplified\" License" )
            .licenseId( "BSD-2-Clause" )
            .seeAlso( "https://opensource.org/licenses/BSD-2-Clause" )

            .urlInfo( "http://opensource.org/licenses/BSD-2-Clause", "76fdee75b52e9a2f0fef6378ffa16def650fbc71", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/BSD-2-Clause", "76fdee75b52e9a2f0fef6378ffa16def650fbc71", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/BSD-2-Clause", "76fdee75b52e9a2f0fef6378ffa16def650fbc71", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/BSD-2-Clause", "76fdee75b52e9a2f0fef6378ffa16def650fbc71", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause-FreeBSD.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause-FreeBSD.json" )
            .name( "BSD 2-Clause FreeBSD License" )
            .licenseId( "BSD-2-Clause-FreeBSD" )
            .seeAlso( "http://www.freebsd.org/copyright/freebsd-license.html" )

            .urlInfo( "http://freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .urlInfo( "http://www.freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .urlInfo( "https://freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .urlInfo( "https://www.freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause-NetBSD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause-NetBSD.json" )
            .name( "BSD 2-Clause NetBSD License" )
            .licenseId( "BSD-2-Clause-NetBSD" )
            .seeAlso( "http://www.netbsd.org/about/redistribution.html#default" )

            .urlInfo( "http://netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .urlInfo( "http://www.netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .urlInfo( "https://netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .urlInfo( "https://www.netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause-Patent.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause-Patent.json" )
            .name( "BSD-2-Clause Plus Patent License" )
            .licenseId( "BSD-2-Clause-Patent" )
            .seeAlso( "https://opensource.org/licenses/BSDplusPatent" )

            .urlInfo( "http://opensource.org/licenses/BSDplusPatent", "6ef965b512c89e0683598329e20d4412af5e9374", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/BSDplusPatent", "6ef965b512c89e0683598329e20d4412af5e9374", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/BSDplusPatent", "6ef965b512c89e0683598329e20d4412af5e9374", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/BSDplusPatent", "6ef965b512c89e0683598329e20d4412af5e9374", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause.json" )
            .name( "BSD 3-Clause \"New\" or \"Revised\" License" )
            .licenseId( "BSD-3-Clause" )
            .seeAlso( "https://opensource.org/licenses/BSD-3-Clause" )

            .urlInfo( "http://opensource.org/licenses/BSD-3-Clause", "47eb016bca74a25c1c43b0923710ef7f1845474e", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/BSD-3-Clause", "47eb016bca74a25c1c43b0923710ef7f1845474e", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/BSD-3-Clause", "47eb016bca74a25c1c43b0923710ef7f1845474e", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/BSD-3-Clause", "47eb016bca74a25c1c43b0923710ef7f1845474e", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-Attribution.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-Attribution.json" )
            .name( "BSD with attribution" )
            .licenseId( "BSD-3-Clause-Attribution" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/BSD_with_Attribution", "80b0acc26d7eb5a2d48068d8c2480530b9948823", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/BSD_with_Attribution", "80b0acc26d7eb5a2d48068d8c2480530b9948823", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution", "80b0acc26d7eb5a2d48068d8c2480530b9948823", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/BSD_with_Attribution", "80b0acc26d7eb5a2d48068d8c2480530b9948823", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-Clear.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-Clear.json" )
            .name( "BSD 3-Clause Clear License" )
            .licenseId( "BSD-3-Clause-Clear" )
            .seeAlso( "http://labs.metacarta.com/license-explanation.html#license" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-LBNL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-LBNL.json" )
            .name( "Lawrence Berkeley National Labs BSD variant license" )
            .licenseId( "BSD-3-Clause-LBNL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/LBNLBSD" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/LBNLBSD", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-No-Nuclear-License.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.json" )
            .name( "BSD 3-Clause No Nuclear License" )
            .licenseId( "BSD-3-Clause-No-Nuclear-License" )
            .seeAlso( "http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-No-Nuclear-License-2014.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.json" )
            .name( "BSD 3-Clause No Nuclear License 2014" )
            .licenseId( "BSD-3-Clause-No-Nuclear-License-2014" )
            .seeAlso( "https://java.net/projects/javaeetutorial/pages/BerkeleyLicense" )

            .urlInfo( "http://java.net/projects/javaeetutorial/pages/BerkeleyLicense", "75c018e5b34ba1adce64325cc1250a7689814c27", "text/html", true, false )
            .urlInfo( "https://java.net/projects/javaeetutorial/pages/BerkeleyLicense", "75c018e5b34ba1adce64325cc1250a7689814c27", "text/html", true, false )
            .urlInfo( "https://www.java.net/projects/javaeetutorial/pages/BerkeleyLicense", "75c018e5b34ba1adce64325cc1250a7689814c27", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-No-Nuclear-Warranty.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.json" )
            .name( "BSD 3-Clause No Nuclear Warranty" )
            .licenseId( "BSD-3-Clause-No-Nuclear-Warranty" )
            .seeAlso( "https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt" )

            .urlInfo( "http://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .urlInfo( "http://www.jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .urlInfo( "https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .urlInfo( "https://www.jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-4-Clause.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-4-Clause.json" )
            .name( "BSD 4-Clause \"Original\" or \"Old\" License" )
            .licenseId( "BSD-4-Clause" )
            .seeAlso( "http://directory.fsf.org/wiki/License:BSD_4Clause" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-4-Clause-UC.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-4-Clause-UC.json" )
            .name( "BSD-4-Clause (University of California-Specific)" )
            .licenseId( "BSD-4-Clause-UC" )
            .seeAlso( "http://www.freebsd.org/copyright/license.html" )

            .urlInfo( "http://freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .urlInfo( "http://www.freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .urlInfo( "https://freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .urlInfo( "https://www.freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-Protection.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-Protection.json" )
            .name( "BSD Protection License" )
            .licenseId( "BSD-Protection" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/BSD_Protection_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/BSD_Protection_License", "721bfd7f2049ad3ad95f5014055f5d1a8ef3d41d", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/BSD_Protection_License", "721bfd7f2049ad3ad95f5014055f5d1a8ef3d41d", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/BSD_Protection_License", "721bfd7f2049ad3ad95f5014055f5d1a8ef3d41d", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/BSD_Protection_License", "721bfd7f2049ad3ad95f5014055f5d1a8ef3d41d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-Source-Code.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-Source-Code.json" )
            .name( "BSD Source Code Attribution" )
            .licenseId( "BSD-Source-Code" )
            .seeAlso( "https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSL-1.0.json" )
            .name( "Boost Software License 1.0" )
            .licenseId( "BSL-1.0" )
            .seeAlso( "http://www.boost.org/LICENSE_1_0.txt" )
            .seeAlso( "https://opensource.org/licenses/BSL-1.0" )

            .urlInfo( "http://boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "http://www.boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "https://boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "https://www.boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/BSL-1.0", "b968a951ea14721dd9c613e3055efc31a72e6eec", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/BSL-1.0", "b968a951ea14721dd9c613e3055efc31a72e6eec", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/BSL-1.0", "b968a951ea14721dd9c613e3055efc31a72e6eec", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/BSL-1.0", "b968a951ea14721dd9c613e3055efc31a72e6eec", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Bahyph.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Bahyph.json" )
            .name( "Bahyph License" )
            .licenseId( "Bahyph" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Bahyph" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Bahyph", "ed1b8b5ce959deced0145fc3098904ec2ba6ad51", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Bahyph", "ed1b8b5ce959deced0145fc3098904ec2ba6ad51", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Bahyph", "ed1b8b5ce959deced0145fc3098904ec2ba6ad51", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Bahyph", "ed1b8b5ce959deced0145fc3098904ec2ba6ad51", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Barr.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Barr.json" )
            .name( "Barr License" )
            .licenseId( "Barr" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Barr" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Barr", "0f04b7576e071368ff0f4a100f4e10ecb10240ca", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Barr", "0f04b7576e071368ff0f4a100f4e10ecb10240ca", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Barr", "0f04b7576e071368ff0f4a100f4e10ecb10240ca", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Barr", "0f04b7576e071368ff0f4a100f4e10ecb10240ca", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Beerware.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Beerware.json" )
            .name( "Beerware License" )
            .licenseId( "Beerware" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Beerware" )
            .seeAlso( "https://people.freebsd.org/~phk/" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Beerware", "960424cfb2e4527065c5678b0a2cce4893154dfa", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Beerware", "960424cfb2e4527065c5678b0a2cce4893154dfa", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Beerware", "960424cfb2e4527065c5678b0a2cce4893154dfa", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Beerware", "960424cfb2e4527065c5678b0a2cce4893154dfa", "text/html", true, true )
            .urlInfo( "http://people.freebsd.org/~phk/", "8941cb77388e1fc73ec5a714ae571103c101b4fd", "text/html", true, false )
            .urlInfo( "https://people.freebsd.org/~phk/", "8941cb77388e1fc73ec5a714ae571103c101b4fd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BitTorrent-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BitTorrent-1.0.json" )
            .name( "BitTorrent Open Source License v1.0" )
            .licenseId( "BitTorrent-1.0" )
            .seeAlso( "http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s" )

            .urlInfo( "http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s", "9612e12cd880c1e835561e8a7557c2d1016a99bd", "text/html", true, false )
            .urlInfo( "https://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s", "9612e12cd880c1e835561e8a7557c2d1016a99bd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BitTorrent-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BitTorrent-1.1.json" )
            .name( "BitTorrent Open Source License v1.1" )
            .licenseId( "BitTorrent-1.1" )
            .seeAlso( "http://directory.fsf.org/wiki/License:BitTorrentOSL1.1" )

            .urlInfo( "http://directory.fsf.org/wiki/License:BitTorrentOSL1.1", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Borceux.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Borceux.json" )
            .name( "Borceux license" )
            .licenseId( "Borceux" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Borceux" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Borceux", "faeaa0717846317b62bbabaefa5c1703c935edec", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Borceux", "faeaa0717846317b62bbabaefa5c1703c935edec", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Borceux", "faeaa0717846317b62bbabaefa5c1703c935edec", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Borceux", "faeaa0717846317b62bbabaefa5c1703c935edec", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CATOSL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CATOSL-1.1.json" )
            .name( "Computer Associates Trusted Open Source License 1.1" )
            .licenseId( "CATOSL-1.1" )
            .seeAlso( "https://opensource.org/licenses/CATOSL-1.1" )

            .urlInfo( "http://opensource.org/licenses/CATOSL-1.1", "f9c4491be51f3a8113a0f3df07e8c1cda84e3203", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/CATOSL-1.1", "f9c4491be51f3a8113a0f3df07e8c1cda84e3203", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/CATOSL-1.1", "f9c4491be51f3a8113a0f3df07e8c1cda84e3203", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/CATOSL-1.1", "f9c4491be51f3a8113a0f3df07e8c1cda84e3203", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-1.0.json" )
            .name( "Creative Commons Attribution 1.0 Generic" )
            .licenseId( "CC-BY-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-2.0.json" )
            .name( "Creative Commons Attribution 2.0 Generic" )
            .licenseId( "CC-BY-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-2.5.json" )
            .name( "Creative Commons Attribution 2.5 Generic" )
            .licenseId( "CC-BY-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-3.0.json" )
            .name( "Creative Commons Attribution 3.0 Unported" )
            .licenseId( "CC-BY-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/3.0/legalcode", "7af76a69c93b33793f19f9ea648c6ba727cd8e9c", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by/3.0/legalcode", "7af76a69c93b33793f19f9ea648c6ba727cd8e9c", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by/3.0/legalcode", "7af76a69c93b33793f19f9ea648c6ba727cd8e9c", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by/3.0/legalcode", "7af76a69c93b33793f19f9ea648c6ba727cd8e9c", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-4.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-4.0.json" )
            .name( "Creative Commons Attribution 4.0 International" )
            .licenseId( "CC-BY-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/4.0/legalcode", "3de8294f0eee052f7b51155f4c9bfa53d474dae6", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by/4.0/legalcode", "3de8294f0eee052f7b51155f4c9bfa53d474dae6", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by/4.0/legalcode", "3de8294f0eee052f7b51155f4c9bfa53d474dae6", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by/4.0/legalcode", "3de8294f0eee052f7b51155f4c9bfa53d474dae6", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-1.0.json" )
            .name( "Creative Commons Attribution Non Commercial 1.0 Generic" )
            .licenseId( "CC-BY-NC-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-2.0.json" )
            .name( "Creative Commons Attribution Non Commercial 2.0 Generic" )
            .licenseId( "CC-BY-NC-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/2.0/legalcode", "2b790767c82ad1f57588c34bc75ce9d562c010d6", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/2.0/legalcode", "2b790767c82ad1f57588c34bc75ce9d562c010d6", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/2.0/legalcode", "2b790767c82ad1f57588c34bc75ce9d562c010d6", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/2.0/legalcode", "2b790767c82ad1f57588c34bc75ce9d562c010d6", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-2.5.json" )
            .name( "Creative Commons Attribution Non Commercial 2.5 Generic" )
            .licenseId( "CC-BY-NC-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/2.5/legalcode", "8380833276a77b9046c1d9359dca6aacc7115464", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/2.5/legalcode", "8380833276a77b9046c1d9359dca6aacc7115464", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/2.5/legalcode", "8380833276a77b9046c1d9359dca6aacc7115464", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/2.5/legalcode", "8380833276a77b9046c1d9359dca6aacc7115464", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-3.0.json" )
            .name( "Creative Commons Attribution Non Commercial 3.0 Unported" )
            .licenseId( "CC-BY-NC-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/3.0/legalcode", "4b9db592867e6c9e3df0a9f9da59c5059920dda5", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/3.0/legalcode", "4b9db592867e6c9e3df0a9f9da59c5059920dda5", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/3.0/legalcode", "4b9db592867e6c9e3df0a9f9da59c5059920dda5", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/3.0/legalcode", "4b9db592867e6c9e3df0a9f9da59c5059920dda5", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-4.0.json" )
            .name( "Creative Commons Attribution Non Commercial 4.0 International" )
            .licenseId( "CC-BY-NC-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/4.0/legalcode", "e79552a1a2bdf470cebb117d888c400b828c6f8d", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/4.0/legalcode", "e79552a1a2bdf470cebb117d888c400b828c6f8d", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/4.0/legalcode", "e79552a1a2bdf470cebb117d888c400b828c6f8d", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/4.0/legalcode", "e79552a1a2bdf470cebb117d888c400b828c6f8d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-1.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic" )
            .licenseId( "CC-BY-NC-ND-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-2.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic" )
            .licenseId( "CC-BY-NC-ND-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "600bcd7c266ae06a0ff9afda1079a81473852869", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "600bcd7c266ae06a0ff9afda1079a81473852869", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "600bcd7c266ae06a0ff9afda1079a81473852869", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "600bcd7c266ae06a0ff9afda1079a81473852869", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-2.5.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic" )
            .licenseId( "CC-BY-NC-ND-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "ea051b1ef90360c0bfac2310645310a16f1f4967", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "ea051b1ef90360c0bfac2310645310a16f1f4967", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "ea051b1ef90360c0bfac2310645310a16f1f4967", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "ea051b1ef90360c0bfac2310645310a16f1f4967", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-3.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported" )
            .licenseId( "CC-BY-NC-ND-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "8e436a3cf57e16d0a1ad1db2218ae8b9a4c16221", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "8e436a3cf57e16d0a1ad1db2218ae8b9a4c16221", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "8e436a3cf57e16d0a1ad1db2218ae8b9a4c16221", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "8e436a3cf57e16d0a1ad1db2218ae8b9a4c16221", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-4.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 4.0 International" )
            .licenseId( "CC-BY-NC-ND-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "b95e13e31497f071151d9c0b641d6d3d6a44c187", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "b95e13e31497f071151d9c0b641d6d3d6a44c187", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "b95e13e31497f071151d9c0b641d6d3d6a44c187", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "b95e13e31497f071151d9c0b641d6d3d6a44c187", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-1.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic" )
            .licenseId( "CC-BY-NC-SA-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-2.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic" )
            .licenseId( "CC-BY-NC-SA-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "0b49d0b35f1f4edd28a6899c29d4ca20ff06906d", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "0b49d0b35f1f4edd28a6899c29d4ca20ff06906d", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "0b49d0b35f1f4edd28a6899c29d4ca20ff06906d", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "0b49d0b35f1f4edd28a6899c29d4ca20ff06906d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-2.5.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic" )
            .licenseId( "CC-BY-NC-SA-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "f3cc9c702bc0b6b5701c6d36cfc7f992f6b284f0", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "f3cc9c702bc0b6b5701c6d36cfc7f992f6b284f0", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "f3cc9c702bc0b6b5701c6d36cfc7f992f6b284f0", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "f3cc9c702bc0b6b5701c6d36cfc7f992f6b284f0", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-3.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported" )
            .licenseId( "CC-BY-NC-SA-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "ef67115b7cd9c400b30cd6918fac5e786adeb461", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "ef67115b7cd9c400b30cd6918fac5e786adeb461", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "ef67115b7cd9c400b30cd6918fac5e786adeb461", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "ef67115b7cd9c400b30cd6918fac5e786adeb461", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-4.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 4.0 International" )
            .licenseId( "CC-BY-NC-SA-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "9ad6ed6dae48020e52d046a6c0ecfa6f5398d540", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "9ad6ed6dae48020e52d046a6c0ecfa6f5398d540", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "9ad6ed6dae48020e52d046a6c0ecfa6f5398d540", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "9ad6ed6dae48020e52d046a6c0ecfa6f5398d540", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-1.0.json" )
            .name( "Creative Commons Attribution No Derivatives 1.0 Generic" )
            .licenseId( "CC-BY-ND-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-2.0.json" )
            .name( "Creative Commons Attribution No Derivatives 2.0 Generic" )
            .licenseId( "CC-BY-ND-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/2.0/legalcode", "7b72808675433ab5a153f3c71396b71296f68a72", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/2.0/legalcode", "7b72808675433ab5a153f3c71396b71296f68a72", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/2.0/legalcode", "7b72808675433ab5a153f3c71396b71296f68a72", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/2.0/legalcode", "7b72808675433ab5a153f3c71396b71296f68a72", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-2.5.json" )
            .name( "Creative Commons Attribution No Derivatives 2.5 Generic" )
            .licenseId( "CC-BY-ND-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/2.5/legalcode", "7b7790e21639a5219a706dd7924370018f8c6473", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/2.5/legalcode", "7b7790e21639a5219a706dd7924370018f8c6473", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/2.5/legalcode", "7b7790e21639a5219a706dd7924370018f8c6473", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/2.5/legalcode", "7b7790e21639a5219a706dd7924370018f8c6473", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-3.0.json" )
            .name( "Creative Commons Attribution No Derivatives 3.0 Unported" )
            .licenseId( "CC-BY-ND-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/3.0/legalcode" )

            .urlInfo( "https://creativecommons.org/licenses/by-nd/3.0/legalcode", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-4.0.json" )
            .name( "Creative Commons Attribution No Derivatives 4.0 International" )
            .licenseId( "CC-BY-ND-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/4.0/legalcode", "d551d08b9ce091b2e9a68603c8bd84836cca1aa0", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/4.0/legalcode", "d551d08b9ce091b2e9a68603c8bd84836cca1aa0", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/4.0/legalcode", "d551d08b9ce091b2e9a68603c8bd84836cca1aa0", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/4.0/legalcode", "d551d08b9ce091b2e9a68603c8bd84836cca1aa0", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-1.0.json" )
            .name( "Creative Commons Attribution Share Alike 1.0 Generic" )
            .licenseId( "CC-BY-SA-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-2.0.json" )
            .name( "Creative Commons Attribution Share Alike 2.0 Generic" )
            .licenseId( "CC-BY-SA-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-2.5.json" )
            .name( "Creative Commons Attribution Share Alike 2.5 Generic" )
            .licenseId( "CC-BY-SA-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-3.0.json" )
            .name( "Creative Commons Attribution Share Alike 3.0 Unported" )
            .licenseId( "CC-BY-SA-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/3.0/legalcode" )

            .urlInfo( "https://creativecommons.org/licenses/by-sa/3.0/legalcode", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-4.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-4.0.json" )
            .name( "Creative Commons Attribution Share Alike 4.0 International" )
            .licenseId( "CC-BY-SA-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/4.0/legalcode", "70390703b82ae4020739c0bad1d71111e1d7fba3", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/4.0/legalcode", "70390703b82ae4020739c0bad1d71111e1d7fba3", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/4.0/legalcode", "70390703b82ae4020739c0bad1d71111e1d7fba3", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/4.0/legalcode", "70390703b82ae4020739c0bad1d71111e1d7fba3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC0-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CC0-1.0.json" )
            .name( "Creative Commons Zero v1.0 Universal" )
            .licenseId( "CC0-1.0" )
            .seeAlso( "https://creativecommons.org/publicdomain/zero/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/publicdomain/zero/1.0/legalcode", "6f960e0d06f29f18ec5055cb680addb848caec93", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/publicdomain/zero/1.0/legalcode", "6f960e0d06f29f18ec5055cb680addb848caec93", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/publicdomain/zero/1.0/legalcode", "6f960e0d06f29f18ec5055cb680addb848caec93", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/publicdomain/zero/1.0/legalcode", "6f960e0d06f29f18ec5055cb680addb848caec93", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDDL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CDDL-1.0.json" )
            .name( "Common Development and Distribution License 1.0" )
            .licenseId( "CDDL-1.0" )
            .seeAlso( "https://opensource.org/licenses/cddl1" )

            .urlInfo( "http://opensource.org/licenses/cddl1", "0db087e6948031277a972dbf490cfa260aaaf883", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/cddl1", "0db087e6948031277a972dbf490cfa260aaaf883", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/cddl1", "0db087e6948031277a972dbf490cfa260aaaf883", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/cddl1", "0db087e6948031277a972dbf490cfa260aaaf883", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDDL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CDDL-1.1.json" )
            .name( "Common Development and Distribution License 1.1" )
            .licenseId( "CDDL-1.1" )
            .seeAlso( "http://glassfish.java.net/public/CDDL+GPL_1_1.html" )
            .seeAlso( "https://javaee.github.io/glassfish/LICENSE" )

            .urlInfo( "http://glassfish.java.net/public/CDDL+GPL_1_1.html", "047abb20f37c1629c82db23d99783e41207c2564", "text/html", true, false )
            .urlInfo( "https://glassfish.java.net/public/CDDL+GPL_1_1.html", "047abb20f37c1629c82db23d99783e41207c2564", "text/html", true, false )
            .urlInfo( "http://javaee.github.io/glassfish/LICENSE", "09e401981fad6a8cbeea3173b9ea9c4a2c95610a", "text/html", true, false )
            .urlInfo( "https://javaee.github.io/glassfish/LICENSE", "09e401981fad6a8cbeea3173b9ea9c4a2c95610a", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDLA-Permissive-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CDLA-Permissive-1.0.json" )
            .name( "Community Data License Agreement Permissive 1.0" )
            .licenseId( "CDLA-Permissive-1.0" )
            .seeAlso( "https://cdla.io/permissive-1-0" )

            .urlInfo( "http://cdla.io/permissive-1-0", "11f90a27f255e0aa9a30836fc6fc41119b328aa8", "text/html", true, false )
            .urlInfo( "http://www.cdla.io/permissive-1-0", "11f90a27f255e0aa9a30836fc6fc41119b328aa8", "text/html", true, false )
            .urlInfo( "https://cdla.io/permissive-1-0", "11f90a27f255e0aa9a30836fc6fc41119b328aa8", "text/html", true, false )
            .urlInfo( "https://www.cdla.io/permissive-1-0", "11f90a27f255e0aa9a30836fc6fc41119b328aa8", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDLA-Sharing-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CDLA-Sharing-1.0.json" )
            .name( "Community Data License Agreement Sharing 1.0" )
            .licenseId( "CDLA-Sharing-1.0" )
            .seeAlso( "https://cdla.io/sharing-1-0" )

            .urlInfo( "http://cdla.io/sharing-1-0", "0dfdb4f8536f2af263e39475dcfdb48e4c58c072", "text/html", true, false )
            .urlInfo( "http://www.cdla.io/sharing-1-0", "0dfdb4f8536f2af263e39475dcfdb48e4c58c072", "text/html", true, false )
            .urlInfo( "https://cdla.io/sharing-1-0", "0dfdb4f8536f2af263e39475dcfdb48e4c58c072", "text/html", true, false )
            .urlInfo( "https://www.cdla.io/sharing-1-0", "0dfdb4f8536f2af263e39475dcfdb48e4c58c072", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CECILL-1.0.json" )
            .name( "CeCILL Free Software License Agreement v1.0" )
            .licenseId( "CECILL-1.0" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V1-fr.html", "f17da26e34780330205e0fccdda4f2804f58de0f", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html", "f17da26e34780330205e0fccdda4f2804f58de0f", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V1-fr.html", "f17da26e34780330205e0fccdda4f2804f58de0f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CECILL-1.1.json" )
            .name( "CeCILL Free Software License Agreement v1.1" )
            .licenseId( "CECILL-1.1" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V1.1-US.html", "aa6f3f6ec2ddea7c007f2a03c7388ce5b828e0d0", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html", "aa6f3f6ec2ddea7c007f2a03c7388ce5b828e0d0", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V1.1-US.html", "aa6f3f6ec2ddea7c007f2a03c7388ce5b828e0d0", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CECILL-2.0.json" )
            .name( "CeCILL Free Software License Agreement v2.0" )
            .licenseId( "CECILL-2.0" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V2-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V2-en.html", "93a69271faa4f031dc2ccde64140cb7743ab9e3e", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V2-en.html", "93a69271faa4f031dc2ccde64140cb7743ab9e3e", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V2-en.html", "93a69271faa4f031dc2ccde64140cb7743ab9e3e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CECILL-2.1.json" )
            .name( "CeCILL Free Software License Agreement v2.1" )
            .licenseId( "CECILL-2.1" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V2.1-en.html", "929cdbfd392146302d80a5d50b320c7912edd4e9", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html", "929cdbfd392146302d80a5d50b320c7912edd4e9", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V2.1-en.html", "929cdbfd392146302d80a5d50b320c7912edd4e9", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-B.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CECILL-B.json" )
            .name( "CeCILL-B Free Software License Agreement" )
            .licenseId( "CECILL-B" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL-B_V1-en.html", "886d89c8a46947091e395d6adeed081df0f04846", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html", "886d89c8a46947091e395d6adeed081df0f04846", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL-B_V1-en.html", "886d89c8a46947091e395d6adeed081df0f04846", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-C.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CECILL-C.json" )
            .name( "CeCILL-C Free Software License Agreement" )
            .licenseId( "CECILL-C" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL-C_V1-en.html", "273cc1c96fa23a8211f27876ed4b7f7b8e4285fd", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html", "273cc1c96fa23a8211f27876ed4b7f7b8e4285fd", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL-C_V1-en.html", "273cc1c96fa23a8211f27876ed4b7f7b8e4285fd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CNRI-Jython.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CNRI-Jython.json" )
            .name( "CNRI Jython License" )
            .licenseId( "CNRI-Jython" )
            .seeAlso( "http://www.jython.org/license.html" )

            .urlInfo( "http://jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .urlInfo( "http://www.jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .urlInfo( "https://jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .urlInfo( "https://www.jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CNRI-Python.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CNRI-Python.json" )
            .name( "CNRI Python License" )
            .licenseId( "CNRI-Python" )
            .seeAlso( "https://opensource.org/licenses/CNRI-Python" )

            .urlInfo( "http://opensource.org/licenses/CNRI-Python", "830c376b1086e94356642705fb2b6ff9cd45ebd2", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/CNRI-Python", "830c376b1086e94356642705fb2b6ff9cd45ebd2", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/CNRI-Python", "830c376b1086e94356642705fb2b6ff9cd45ebd2", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/CNRI-Python", "830c376b1086e94356642705fb2b6ff9cd45ebd2", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CNRI-Python-GPL-Compatible.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CNRI-Python-GPL-Compatible.json" )
            .name( "CNRI Python Open Source GPL Compatible License Agreement" )
            .licenseId( "CNRI-Python-GPL-Compatible" )
            .seeAlso( "http://www.python.org/download/releases/1.6.1/download_win/" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CPAL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CPAL-1.0.json" )
            .name( "Common Public Attribution License 1.0" )
            .licenseId( "CPAL-1.0" )
            .seeAlso( "https://opensource.org/licenses/CPAL-1.0" )

            .urlInfo( "http://opensource.org/licenses/CPAL-1.0", "e4f786bad66f01eb636d78985e132aa9064796c7", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/CPAL-1.0", "e4f786bad66f01eb636d78985e132aa9064796c7", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/CPAL-1.0", "e4f786bad66f01eb636d78985e132aa9064796c7", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/CPAL-1.0", "e4f786bad66f01eb636d78985e132aa9064796c7", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CPL-1.0.json" )
            .name( "Common Public License 1.0" )
            .licenseId( "CPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/CPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/CPL-1.0", "c147fe0cdc6b4cb495ab5e83c674361dff4caf6f", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/CPL-1.0", "c147fe0cdc6b4cb495ab5e83c674361dff4caf6f", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/CPL-1.0", "c147fe0cdc6b4cb495ab5e83c674361dff4caf6f", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/CPL-1.0", "c147fe0cdc6b4cb495ab5e83c674361dff4caf6f", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CPOL-1.02.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CPOL-1.02.json" )
            .name( "Code Project Open License 1.02" )
            .licenseId( "CPOL-1.02" )
            .seeAlso( "http://www.codeproject.com/info/cpol10.aspx" )

            .urlInfo( "http://www.codeproject.com/info/cpol10.aspx", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CUA-OPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CUA-OPL-1.0.json" )
            .name( "CUA Office Public License v1.0" )
            .licenseId( "CUA-OPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/CUA-OPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/CUA-OPL-1.0", "7977f16a637ed5e9babcaf12c8ac435eea01dba1", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/CUA-OPL-1.0", "7977f16a637ed5e9babcaf12c8ac435eea01dba1", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/CUA-OPL-1.0", "7977f16a637ed5e9babcaf12c8ac435eea01dba1", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/CUA-OPL-1.0", "7977f16a637ed5e9babcaf12c8ac435eea01dba1", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Caldera.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Caldera.json" )
            .name( "Caldera License" )
            .licenseId( "Caldera" )
            .seeAlso( "http://www.lemis.com/grog/UNIX/ancient-source-all.pdf" )

            .urlInfo( "http://lemis.com/grog/UNIX/ancient-source-all.pdf", "81d30f492d00e2f5b2be3750bd99e2feb4f0ca33", "application/pdf", true, false )
            .urlInfo( "http://www.lemis.com/grog/UNIX/ancient-source-all.pdf", "81d30f492d00e2f5b2be3750bd99e2feb4f0ca33", "application/pdf", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ClArtistic.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ClArtistic.json" )
            .name( "Clarified Artistic License" )
            .licenseId( "ClArtistic" )
            .seeAlso( "http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/" )
            .seeAlso( "http://www.ncftp.com/ncftp/doc/LICENSE.txt" )

            .urlInfo( "http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/", null, null, false, true )
            .urlInfo( "http://ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .urlInfo( "http://www.ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .urlInfo( "https://ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .urlInfo( "https://www.ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Condor-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Condor-1.1.json" )
            .name( "Condor Public License v1.1" )
            .licenseId( "Condor-1.1" )
            .seeAlso( "http://research.cs.wisc.edu/condor/license.html#condor" )
            .seeAlso( "http://web.archive.org/web/20111123062036/http://research.cs.wisc.edu/condor/license.html#condor" )

            .urlInfo( "http://research.cs.wisc.edu/condor/license.html#condor", "a4ed29ffd7cc6114ebff053853c3ae196a4c0366", "text/html", true, false )
            .urlInfo( "https://research.cs.wisc.edu/condor/license.html#condor", "a4ed29ffd7cc6114ebff053853c3ae196a4c0366", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Crossword.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Crossword.json" )
            .name( "Crossword License" )
            .licenseId( "Crossword" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Crossword" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Crossword", "dc59482efae3ef61e7f792f06de3857c27ae62df", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Crossword", "dc59482efae3ef61e7f792f06de3857c27ae62df", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Crossword", "dc59482efae3ef61e7f792f06de3857c27ae62df", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Crossword", "dc59482efae3ef61e7f792f06de3857c27ae62df", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CrystalStacker.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CrystalStacker.json" )
            .name( "CrystalStacker License" )
            .licenseId( "CrystalStacker" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Cube.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Cube.json" )
            .name( "Cube License" )
            .licenseId( "Cube" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Cube" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Cube", "70240442576850126bed57fb6809dd9bccf8da7b", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Cube", "70240442576850126bed57fb6809dd9bccf8da7b", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Cube", "70240442576850126bed57fb6809dd9bccf8da7b", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Cube", "70240442576850126bed57fb6809dd9bccf8da7b", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./D-FSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/D-FSL-1.0.json" )
            .name( "Deutsche Freie Software Lizenz" )
            .licenseId( "D-FSL-1.0" )
            .seeAlso( "http://www.dipp.nrw.de/d-fsl/lizenzen/" )
            .seeAlso( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/de/D-FSL-1_0_de.txt" )
            .seeAlso( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/en/D-FSL-1_0_en.txt" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file" )

            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/de/D-FSL-1_0_de.txt", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/en/D-FSL-1_0_en.txt", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.dipp.nrw.de/d-fsl/lizenzen/", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz", "728fc7525ea38a81b9a50ddd3d929dc514b642c8", "text/html", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz", "728fc7525ea38a81b9a50ddd3d929dc514b642c8", "text/html", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz", "728fc7525ea38a81b9a50ddd3d929dc514b642c8", "text/html", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license", "96713f02fd64b9a8899c8608afd2803d3632f16f", "text/html", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license", "96713f02fd64b9a8899c8608afd2803d3632f16f", "text/html", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license", "96713f02fd64b9a8899c8608afd2803d3632f16f", "text/html", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file", "030d427e3f2b5cae1bdc081839495e2226898a95", "text/plain", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file", "030d427e3f2b5cae1bdc081839495e2226898a95", "text/plain", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file", "030d427e3f2b5cae1bdc081839495e2226898a95", "text/plain", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file", "e234377676a736aec560548b260c3d645f1adc40", "text/plain", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file", "e234377676a736aec560548b260c3d645f1adc40", "text/plain", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file", "e234377676a736aec560548b260c3d645f1adc40", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./DOC.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/DOC.json" )
            .name( "DOC License" )
            .licenseId( "DOC" )
            .seeAlso( "http://www.cs.wustl.edu/~schmidt/ACE-copying.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./DSDP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/DSDP.json" )
            .name( "DSDP License" )
            .licenseId( "DSDP" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/DSDP" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/DSDP", "223224dd5de195ba9857063515c42a4275bec847", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/DSDP", "223224dd5de195ba9857063515c42a4275bec847", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/DSDP", "223224dd5de195ba9857063515c42a4275bec847", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/DSDP", "223224dd5de195ba9857063515c42a4275bec847", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Dotseqn.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Dotseqn.json" )
            .name( "Dotseqn License" )
            .licenseId( "Dotseqn" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Dotseqn" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Dotseqn", "c4ccbecb94aa8df8b98f141548474f6be84b9815", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Dotseqn", "c4ccbecb94aa8df8b98f141548474f6be84b9815", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Dotseqn", "c4ccbecb94aa8df8b98f141548474f6be84b9815", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Dotseqn", "c4ccbecb94aa8df8b98f141548474f6be84b9815", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ECL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ECL-1.0.json" )
            .name( "Educational Community License v1.0" )
            .licenseId( "ECL-1.0" )
            .seeAlso( "https://opensource.org/licenses/ECL-1.0" )

            .urlInfo( "http://opensource.org/licenses/ECL-1.0", "6148ea974877d4322ee9edae2131615333aa0530", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/ECL-1.0", "6148ea974877d4322ee9edae2131615333aa0530", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/ECL-1.0", "6148ea974877d4322ee9edae2131615333aa0530", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/ECL-1.0", "6148ea974877d4322ee9edae2131615333aa0530", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ECL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ECL-2.0.json" )
            .name( "Educational Community License v2.0" )
            .licenseId( "ECL-2.0" )
            .seeAlso( "https://opensource.org/licenses/ECL-2.0" )

            .urlInfo( "http://opensource.org/licenses/ECL-2.0", "40e63550f1d779e500c50a39b5825a0537f56914", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/ECL-2.0", "40e63550f1d779e500c50a39b5825a0537f56914", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/ECL-2.0", "40e63550f1d779e500c50a39b5825a0537f56914", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/ECL-2.0", "40e63550f1d779e500c50a39b5825a0537f56914", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EFL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/EFL-1.0.json" )
            .name( "Eiffel Forum License v1.0" )
            .licenseId( "EFL-1.0" )
            .seeAlso( "http://www.eiffel-nice.org/license/forum.txt" )
            .seeAlso( "https://opensource.org/licenses/EFL-1.0" )

            .urlInfo( "http://eiffel-nice.org/license/forum.txt", "0187bf4669b68a88a606fcc56026d42f6130a3b5", "text/plain", true, false )
            .urlInfo( "http://www.eiffel-nice.org/license/forum.txt", "0187bf4669b68a88a606fcc56026d42f6130a3b5", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/EFL-1.0", "a4ae96d53f591e1dec33d93bb9ff483a6285bfec", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EFL-1.0", "a4ae96d53f591e1dec33d93bb9ff483a6285bfec", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EFL-1.0", "a4ae96d53f591e1dec33d93bb9ff483a6285bfec", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EFL-1.0", "a4ae96d53f591e1dec33d93bb9ff483a6285bfec", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EFL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EFL-2.0.json" )
            .name( "Eiffel Forum License v2.0" )
            .licenseId( "EFL-2.0" )
            .seeAlso( "http://www.eiffel-nice.org/license/eiffel-forum-license-2.html" )
            .seeAlso( "https://opensource.org/licenses/EFL-2.0" )

            .urlInfo( "http://eiffel-nice.org/license/eiffel-forum-license-2.html", "11a3b6c48679ec916eee3ffbd2378355738cfc46", "text/html", true, false )
            .urlInfo( "http://www.eiffel-nice.org/license/eiffel-forum-license-2.html", "11a3b6c48679ec916eee3ffbd2378355738cfc46", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EFL-2.0", "277cf137b876b8f36be0c69443a735bdfdf1934f", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EFL-2.0", "277cf137b876b8f36be0c69443a735bdfdf1934f", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EFL-2.0", "277cf137b876b8f36be0c69443a735bdfdf1934f", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EFL-2.0", "277cf137b876b8f36be0c69443a735bdfdf1934f", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EPL-1.0.json" )
            .name( "Eclipse Public License 1.0" )
            .licenseId( "EPL-1.0" )
            .seeAlso( "http://www.eclipse.org/legal/epl-v10.html" )
            .seeAlso( "https://opensource.org/licenses/EPL-1.0" )

            .urlInfo( "http://eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "http://www.eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "https://eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "https://www.eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EPL-1.0", "02e14182e62c3c8401c925fdc8031a1ff60744dc", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EPL-1.0", "02e14182e62c3c8401c925fdc8031a1ff60744dc", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EPL-1.0", "02e14182e62c3c8401c925fdc8031a1ff60744dc", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EPL-1.0", "02e14182e62c3c8401c925fdc8031a1ff60744dc", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EPL-2.0.json" )
            .name( "Eclipse Public License 2.0" )
            .licenseId( "EPL-2.0" )
            .seeAlso( "https://www.eclipse.org/legal/epl-2.0" )
            .seeAlso( "https://www.opensource.org/licenses/EPL-2.0" )

            .urlInfo( "https://eclipse.org/legal/epl-2.0", "efb60bb2810e8e8a15d0d721e7dc06cf6aab195b", "text/html", true, false )
            .urlInfo( "https://www.eclipse.org/legal/epl-2.0", "efb60bb2810e8e8a15d0d721e7dc06cf6aab195b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EPL-2.0", "4dbcd9610d04e2b3d4ecee55e8c558ef463639a0", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EPL-2.0", "4dbcd9610d04e2b3d4ecee55e8c558ef463639a0", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EPL-2.0", "4dbcd9610d04e2b3d4ecee55e8c558ef463639a0", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EPL-2.0", "4dbcd9610d04e2b3d4ecee55e8c558ef463639a0", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUDatagrid.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EUDatagrid.json" )
            .name( "EU DataGrid Software License" )
            .licenseId( "EUDatagrid" )
            .seeAlso( "http://eu-datagrid.web.cern.ch/eu-datagrid/license.html" )
            .seeAlso( "https://opensource.org/licenses/EUDatagrid" )

            .urlInfo( "http://eu-datagrid.web.cern.ch/eu-datagrid/license.html", null, null, false, true )
            .urlInfo( "http://opensource.org/licenses/EUDatagrid", "97807431010e47b2bf903a3f73788a8caccab80c", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EUDatagrid", "97807431010e47b2bf903a3f73788a8caccab80c", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EUDatagrid", "97807431010e47b2bf903a3f73788a8caccab80c", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EUDatagrid", "97807431010e47b2bf903a3f73788a8caccab80c", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/EUPL-1.0.json" )
            .name( "European Union Public License 1.0" )
            .licenseId( "EUPL-1.0" )
            .seeAlso( "http://ec.europa.eu/idabc/en/document/7330.html" )
            .seeAlso( "http://ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096" )

            .urlInfo( "http://ec.europa.eu/idabc/en/document/7330.html", "0d18bb9db4a45ad4cffefcc150ae07ce0bef9bd1", "text/html", true, false )
            .urlInfo( "http://www.ec.europa.eu/idabc/en/document/7330.html", "0d18bb9db4a45ad4cffefcc150ae07ce0bef9bd1", "text/html", true, false )
            .urlInfo( "http://ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096", "b5ce3f58aeb32c9d3f4d1d59d4c8a5579d1f345a", "application/pdf", true, false )
            .urlInfo( "http://www.ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096", "b5ce3f58aeb32c9d3f4d1d59d4c8a5579d1f345a", "application/pdf", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EUPL-1.1.json" )
            .name( "European Union Public License 1.1" )
            .licenseId( "EUPL-1.1" )
            .seeAlso( "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl" )
            .seeAlso( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf" )
            .seeAlso( "https://opensource.org/licenses/EUPL-1.1" )

            .urlInfo( "http://joinup.ec.europa.eu/page/eupl-text-11-12", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/page/eupl-text-11-12", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf", "b91481f1edd91d5fca56ccf4065b63c3269ac6fb", "application/pdf", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf", "b91481f1edd91d5fca56ccf4065b63c3269ac6fb", "application/pdf", true, false )
            .urlInfo( "http://opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUPL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EUPL-1.2.json" )
            .name( "European Union Public License 1.2" )
            .licenseId( "EUPL-1.2" )
            .seeAlso( "https://joinup.ec.europa.eu/page/eupl-text-11-12" )
            .seeAlso( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf" )
            .seeAlso( "https://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt" )
            .seeAlso( "http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863" )
            .seeAlso( "https://opensource.org/licenses/EUPL-1.1" )

            .urlInfo( "http://joinup.ec.europa.eu/page/eupl-text-11-12", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/page/eupl-text-11-12", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "8cdb0df63c1839b085d10d3a155e1eb4920af79f", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf", "e512a96949c79498ad1a59d6553ddf694ef44666", "application/pdf", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf", "e512a96949c79498ad1a59d6553ddf694ef44666", "application/pdf", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt", "0ecda5d95dd354eaad18d0e72f6560e70fc78f74", "text/plain", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt", "0ecda5d95dd354eaad18d0e72f6560e70fc78f74", "text/plain", true, false )
            .urlInfo( "http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863", "56d6faabaf70c78c28c825bf74fb82aaa82972ba", "text/html", true, false )
            .urlInfo( "http://www.eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863", "56d6faabaf70c78c28c825bf74fb82aaa82972ba", "text/html", true, false )
            .urlInfo( "https://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863", "56d6faabaf70c78c28c825bf74fb82aaa82972ba", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/EUPL-1.1", "e711c0fee9d5371dc184b19cd032572d86b607d8", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Entessa.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Entessa.json" )
            .name( "Entessa Public License v1.0" )
            .licenseId( "Entessa" )
            .seeAlso( "https://opensource.org/licenses/Entessa" )

            .urlInfo( "http://opensource.org/licenses/Entessa", "71523301fdc944d030298a7f16b84dbb44d9ed40", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Entessa", "71523301fdc944d030298a7f16b84dbb44d9ed40", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Entessa", "71523301fdc944d030298a7f16b84dbb44d9ed40", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Entessa", "71523301fdc944d030298a7f16b84dbb44d9ed40", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ErlPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ErlPL-1.1.json" )
            .name( "Erlang Public License v1.1" )
            .licenseId( "ErlPL-1.1" )
            .seeAlso( "http://www.erlang.org/EPLICENSE" )

            .urlInfo( "http://erlang.org/EPLICENSE", "4f3186bd48be9b2cd3bc12bc7a4c9cba6d1ecf59", "text/plain", true, false )
            .urlInfo( "http://www.erlang.org/EPLICENSE", "4f3186bd48be9b2cd3bc12bc7a4c9cba6d1ecf59", "text/plain", true, false )
            .urlInfo( "https://www.erlang.org/EPLICENSE", "4f3186bd48be9b2cd3bc12bc7a4c9cba6d1ecf59", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Eurosym.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Eurosym.json" )
            .name( "Eurosym License" )
            .licenseId( "Eurosym" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Eurosym" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Eurosym", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FSFAP.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/FSFAP.json" )
            .name( "FSF All Permissive License" )
            .licenseId( "FSFAP" )
            .seeAlso( "https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html" )

            .urlInfo( "http://gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .urlInfo( "https://gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FSFUL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/FSFUL.json" )
            .name( "FSF Unlimited License" )
            .licenseId( "FSFUL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FSFULLR.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/FSFULLR.json" )
            .name( "FSF Unlimited License (with License Retention)" )
            .licenseId( "FSFULLR" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "6d055bc50f88547e184af423a7a9998bc77a8b9f", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FTL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/FTL.json" )
            .name( "Freetype Project License" )
            .licenseId( "FTL" )
            .seeAlso( "http://freetype.fis.uniroma2.it/FTL.TXT" )
            .seeAlso( "http://git.savannah.gnu.org/cgit/freetype/freetype2.git/tree/docs/FTL.TXT" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Fair.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Fair.json" )
            .name( "Fair License" )
            .licenseId( "Fair" )
            .seeAlso( "http://fairlicense.org/" )
            .seeAlso( "https://opensource.org/licenses/Fair" )

            .urlInfo( "http://opensource.org/licenses/Fair", "eb770c68f5f2dbc7c8b5f0a09e8188e103746cae", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Fair", "eb770c68f5f2dbc7c8b5f0a09e8188e103746cae", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Fair", "eb770c68f5f2dbc7c8b5f0a09e8188e103746cae", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Fair", "eb770c68f5f2dbc7c8b5f0a09e8188e103746cae", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Frameworx-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Frameworx-1.0.json" )
            .name( "Frameworx Open License 1.0" )
            .licenseId( "Frameworx-1.0" )
            .seeAlso( "https://opensource.org/licenses/Frameworx-1.0" )

            .urlInfo( "http://opensource.org/licenses/Frameworx-1.0", "6da34725b61fdd466f4286430a2ea091cae0639a", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Frameworx-1.0", "6da34725b61fdd466f4286430a2ea091cae0639a", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Frameworx-1.0", "6da34725b61fdd466f4286430a2ea091cae0639a", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Frameworx-1.0", "6da34725b61fdd466f4286430a2ea091cae0639a", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FreeImage.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/FreeImage.json" )
            .name( "FreeImage Public License v1.0" )
            .licenseId( "FreeImage" )
            .seeAlso( "http://freeimage.sourceforge.net/freeimage-license.txt" )

            .urlInfo( "http://freeimage.sourceforge.net/freeimage-license.txt", "0ca251a586f81fb996e02f5391eff7c20f914fa6", "text/plain", true, false )
            .urlInfo( "http://www.freeimage.sourceforge.net/freeimage-license.txt", "0ca251a586f81fb996e02f5391eff7c20f914fa6", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.1.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.1.json" )
            .name( "GNU Free Documentation License v1.1" )
            .licenseId( "GFDL-1.1" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.1-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.1-only.json" )
            .name( "GNU Free Documentation License v1.1 only" )
            .licenseId( "GFDL-1.1-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.1-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.1-or-later.json" )
            .name( "GNU Free Documentation License v1.1 or later" )
            .licenseId( "GFDL-1.1-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.2.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.2.json" )
            .name( "GNU Free Documentation License v1.2" )
            .licenseId( "GFDL-1.2" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.2-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.2-only.json" )
            .name( "GNU Free Documentation License v1.2 only" )
            .licenseId( "GFDL-1.2-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.2-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.2-or-later.json" )
            .name( "GNU Free Documentation License v1.2 or later" )
            .licenseId( "GFDL-1.2-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.3.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.3.json" )
            .name( "GNU Free Documentation License v1.3" )
            .licenseId( "GFDL-1.3" )
            .seeAlso( "https://www.gnu.org/licenses/fdl-1.3.txt" )

            .urlInfo( "http://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.3-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.3-only.json" )
            .name( "GNU Free Documentation License v1.3 only" )
            .licenseId( "GFDL-1.3-only" )
            .seeAlso( "https://www.gnu.org/licenses/fdl-1.3.txt" )

            .urlInfo( "http://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.3-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.3-or-later.json" )
            .name( "GNU Free Documentation License v1.3 or later" )
            .licenseId( "GFDL-1.3-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/fdl-1.3.txt" )

            .urlInfo( "http://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GL2PS.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/GL2PS.json" )
            .name( "GL2PS License" )
            .licenseId( "GL2PS" )
            .seeAlso( "http://www.geuz.org/gl2ps/COPYING.GL2PS" )

            .urlInfo( "http://geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .urlInfo( "http://www.geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .urlInfo( "https://geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .urlInfo( "https://www.geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0.json" )
            .name( "GNU General Public License v1.0 only" )
            .licenseId( "GPL-1.0" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0+.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0+.json" )
            .name( "GNU General Public License v1.0 or later" )
            .licenseId( "GPL-1.0+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0-only.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0-only.json" )
            .name( "GNU General Public License v1.0 only" )
            .licenseId( "GPL-1.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0-or-later.json" )
            .name( "GNU General Public License v1.0 or later" )
            .licenseId( "GPL-1.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0.json" )
            .name( "GNU General Public License v2.0 only" )
            .licenseId( "GPL-2.0" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0+.json" )
            .name( "GNU General Public License v2.0 or later" )
            .licenseId( "GPL-2.0+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-only.json" )
            .name( "GNU General Public License v2.0 only" )
            .licenseId( "GPL-2.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-or-later.json" )
            .name( "GNU General Public License v2.0 or later" )
            .licenseId( "GPL-2.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "48b6db71b12c842a2016ddf4dc15470375e9bfe7", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-GCC-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-GCC-exception.json" )
            .name( "GNU General Public License v2.0 w/GCC Runtime Library exception" )
            .licenseId( "GPL-2.0-with-GCC-exception" )
            .seeAlso( "https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10" )

            .urlInfo( "http://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10", "a2cc775a5ba3b070baa11e1fa3be80026ec52f38", "text/html", true, false )
            .urlInfo( "https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10", "a2cc775a5ba3b070baa11e1fa3be80026ec52f38", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-autoconf-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-autoconf-exception.json" )
            .name( "GNU General Public License v2.0 w/Autoconf exception" )
            .licenseId( "GPL-2.0-with-autoconf-exception" )
            .seeAlso( "http://ac-archive.sourceforge.net/doc/copyright.html" )

            .urlInfo( "http://ac-archive.sourceforge.net/doc/copyright.html", "a84ee700564981a2fd26a0a3820d975b470cad3d", "text/html", true, false )
            .urlInfo( "http://www.ac-archive.sourceforge.net/doc/copyright.html", "a84ee700564981a2fd26a0a3820d975b470cad3d", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-bison-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-bison-exception.json" )
            .name( "GNU General Public License v2.0 w/Bison exception" )
            .licenseId( "GPL-2.0-with-bison-exception" )
            .seeAlso( "http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-classpath-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-classpath-exception.json" )
            .name( "GNU General Public License v2.0 w/Classpath exception" )
            .licenseId( "GPL-2.0-with-classpath-exception" )
            .seeAlso( "https://www.gnu.org/software/classpath/license.html" )

            .urlInfo( "http://gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .urlInfo( "https://gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-font-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-font-exception.json" )
            .name( "GNU General Public License v2.0 w/Font exception" )
            .licenseId( "GPL-2.0-with-font-exception" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-faq.html#FontException" )

            .urlInfo( "http://gnu.org/licenses/gpl-faq.html#FontException", "4d8be584567cb67fa37ce921e1d20964a28e25bd", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-faq.html#FontException", "4d8be584567cb67fa37ce921e1d20964a28e25bd", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-faq.html#FontException", "4d8be584567cb67fa37ce921e1d20964a28e25bd", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-faq.html#FontException", "4d8be584567cb67fa37ce921e1d20964a28e25bd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0.json" )
            .name( "GNU General Public License v3.0 only" )
            .licenseId( "GPL-3.0" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0+.json" )
            .name( "GNU General Public License v3.0 or later" )
            .licenseId( "GPL-3.0+" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-only.json" )
            .name( "GNU General Public License v3.0 only" )
            .licenseId( "GPL-3.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-or-later.json" )
            .name( "GNU General Public License v3.0 or later" )
            .licenseId( "GPL-3.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "66888ed9e008835d5a7cc2c47399705b98902a77", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-with-GCC-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-with-GCC-exception.json" )
            .name( "GNU General Public License v3.0 w/GCC Runtime Library exception" )
            .licenseId( "GPL-3.0-with-GCC-exception" )
            .seeAlso( "https://www.gnu.org/licenses/gcc-exception-3.1.html" )

            .urlInfo( "http://gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-with-autoconf-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-with-autoconf-exception.json" )
            .name( "GNU General Public License v3.0 w/Autoconf exception" )
            .licenseId( "GPL-3.0-with-autoconf-exception" )
            .seeAlso( "https://www.gnu.org/licenses/autoconf-exception-3.0.html" )

            .urlInfo( "http://gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Giftware.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Giftware.json" )
            .name( "Giftware License" )
            .licenseId( "Giftware" )
            .seeAlso( "http://liballeg.org/license.html#allegro-4-the-giftware-license" )

            .urlInfo( "http://liballeg.org/license.html#allegro-4-the-giftware-license", "792d58bca1685e39811d35b63e713337d4d3aeb1", "text/html", true, false )
            .urlInfo( "http://www.liballeg.org/license.html#allegro-4-the-giftware-license", "792d58bca1685e39811d35b63e713337d4d3aeb1", "text/html", true, false )
            .urlInfo( "https://liballeg.org/license.html#allegro-4-the-giftware-license", "792d58bca1685e39811d35b63e713337d4d3aeb1", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Glide.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Glide.json" )
            .name( "3dfx Glide License" )
            .licenseId( "Glide" )
            .seeAlso( "http://www.users.on.net/~triforce/glidexp/COPYING.txt" )

            .urlInfo( "http://www.users.on.net/~triforce/glidexp/COPYING.txt", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Glulxe.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Glulxe.json" )
            .name( "Glulxe License" )
            .licenseId( "Glulxe" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Glulxe" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Glulxe", "eeec1064abebcdc39049f1c56e58976d47b3b920", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Glulxe", "eeec1064abebcdc39049f1c56e58976d47b3b920", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Glulxe", "eeec1064abebcdc39049f1c56e58976d47b3b920", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Glulxe", "eeec1064abebcdc39049f1c56e58976d47b3b920", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./HPND.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/HPND.json" )
            .name( "Historical Permission Notice and Disclaimer" )
            .licenseId( "HPND" )
            .seeAlso( "https://opensource.org/licenses/HPND" )

            .urlInfo( "http://opensource.org/licenses/HPND", "937727034105423dc73080378a7ba72094e32e80", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/HPND", "937727034105423dc73080378a7ba72094e32e80", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/HPND", "937727034105423dc73080378a7ba72094e32e80", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/HPND", "937727034105423dc73080378a7ba72094e32e80", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./HPND-sell-variant.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/HPND-sell-variant.json" )
            .name( "Historical Permission Notice and Disclaimer - sell variant" )
            .licenseId( "HPND-sell-variant" )
            .seeAlso( "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./HaskellReport.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/HaskellReport.json" )
            .name( "Haskell Language Report License" )
            .licenseId( "HaskellReport" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License", "4c399c3095e215945a1237618df134151eedbd8f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License", "4c399c3095e215945a1237618df134151eedbd8f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License", "4c399c3095e215945a1237618df134151eedbd8f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License", "4c399c3095e215945a1237618df134151eedbd8f", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IBM-pibs.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/IBM-pibs.json" )
            .name( "IBM PowerPC Initialization and Boot Software" )
            .licenseId( "IBM-pibs" )
            .seeAlso( "http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ICU.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ICU.json" )
            .name( "ICU License" )
            .licenseId( "ICU" )
            .seeAlso( "http://source.icu-project.org/repos/icu/icu/trunk/license.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IJG.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/IJG.json" )
            .name( "Independent JPEG Group License" )
            .licenseId( "IJG" )
            .seeAlso( "http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2" )

            .urlInfo( "http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2", "d4917567d29c59fe65b1a394d3504c2504ebcc33", "text/html", true, false )
            .urlInfo( "https://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2", "d4917567d29c59fe65b1a394d3504c2504ebcc33", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IPA.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/IPA.json" )
            .name( "IPA Font License" )
            .licenseId( "IPA" )
            .seeAlso( "https://opensource.org/licenses/IPA" )

            .urlInfo( "http://opensource.org/licenses/IPA", "6ed58b7ff312f41b2a06296a2b0bcf3df7a9ffc6", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/IPA", "6ed58b7ff312f41b2a06296a2b0bcf3df7a9ffc6", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/IPA", "6ed58b7ff312f41b2a06296a2b0bcf3df7a9ffc6", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/IPA", "6ed58b7ff312f41b2a06296a2b0bcf3df7a9ffc6", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/IPL-1.0.json" )
            .name( "IBM Public License v1.0" )
            .licenseId( "IPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/IPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/IPL-1.0", "8eb10e919235c04b6d2a20dc16c3294845a75606", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/IPL-1.0", "8eb10e919235c04b6d2a20dc16c3294845a75606", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/IPL-1.0", "8eb10e919235c04b6d2a20dc16c3294845a75606", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/IPL-1.0", "8eb10e919235c04b6d2a20dc16c3294845a75606", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ISC.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ISC.json" )
            .name( "ISC License" )
            .licenseId( "ISC" )
            .seeAlso( "https://www.isc.org/downloads/software-support-policy/isc-license/" )
            .seeAlso( "https://opensource.org/licenses/ISC" )

            .urlInfo( "https://isc.org/downloads/software-support-policy/isc-license/", "90e164c10cfabdd0cdcf03f9a776ce9b695a0c20", "text/html", true, false )
            .urlInfo( "https://www.isc.org/downloads/software-support-policy/isc-license/", "90e164c10cfabdd0cdcf03f9a776ce9b695a0c20", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/ISC", "f16f8ead2c5758c44c9972ff4d63467165a238b9", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/ISC", "f16f8ead2c5758c44c9972ff4d63467165a238b9", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/ISC", "f16f8ead2c5758c44c9972ff4d63467165a238b9", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/ISC", "f16f8ead2c5758c44c9972ff4d63467165a238b9", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ImageMagick.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ImageMagick.json" )
            .name( "ImageMagick License" )
            .licenseId( "ImageMagick" )
            .seeAlso( "http://www.imagemagick.org/script/license.php" )

            .urlInfo( "http://www.imagemagick.org/script/license.php", "8cda9d88a5bc1d40cfc51ddf66b7f162747718d8", "text/html", true, false )
            .urlInfo( "https://www.imagemagick.org/script/license.php", "8cda9d88a5bc1d40cfc51ddf66b7f162747718d8", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Imlib2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Imlib2.json" )
            .name( "Imlib2 License" )
            .licenseId( "Imlib2" )
            .seeAlso( "http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING" )
            .seeAlso( "https://git.enlightenment.org/legacy/imlib2.git/tree/COPYING" )

            .urlInfo( "http://git.enlightenment.org/legacy/imlib2.git/tree/COPYING", "8d76e9f6926b7a97f0d57efe16a9685e36e89995", "text/html", true, false )
            .urlInfo( "https://git.enlightenment.org/legacy/imlib2.git/tree/COPYING", "8d76e9f6926b7a97f0d57efe16a9685e36e89995", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Info-ZIP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Info-ZIP.json" )
            .name( "Info-ZIP License" )
            .licenseId( "Info-ZIP" )
            .seeAlso( "http://www.info-zip.org/license.html" )

            .urlInfo( "http://info-zip.org/license.html", "9596ecc43b8d17228cdf3f5658b9460f653e59ff", "text/html", true, false )
            .urlInfo( "http://www.info-zip.org/license.html", "9596ecc43b8d17228cdf3f5658b9460f653e59ff", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Intel.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Intel.json" )
            .name( "Intel Open Source License" )
            .licenseId( "Intel" )
            .seeAlso( "https://opensource.org/licenses/Intel" )

            .urlInfo( "http://opensource.org/licenses/Intel", "2e6c6b4d87a7171ed998639a21cbcec47dec76ad", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Intel", "2e6c6b4d87a7171ed998639a21cbcec47dec76ad", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Intel", "2e6c6b4d87a7171ed998639a21cbcec47dec76ad", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Intel", "2e6c6b4d87a7171ed998639a21cbcec47dec76ad", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Intel-ACPI.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Intel-ACPI.json" )
            .name( "Intel ACPI Software License Agreement" )
            .licenseId( "Intel-ACPI" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement", "d789f76b8fd4c3b4f778c4566ca0c0971ddb6147", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement", "d789f76b8fd4c3b4f778c4566ca0c0971ddb6147", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement", "d789f76b8fd4c3b4f778c4566ca0c0971ddb6147", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement", "d789f76b8fd4c3b4f778c4566ca0c0971ddb6147", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Interbase-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Interbase-1.0.json" )
            .name( "Interbase Public License v1.0" )
            .licenseId( "Interbase-1.0" )
            .seeAlso( "https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./JSON.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/JSON.json" )
            .name( "JSON License" )
            .licenseId( "JSON" )
            .seeAlso( "http://www.json.org/license.html" )

            .urlInfo( "http://json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .urlInfo( "http://www.json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .urlInfo( "https://json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .urlInfo( "https://www.json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./JasPer-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/JasPer-2.0.json" )
            .name( "JasPer License" )
            .licenseId( "JasPer-2.0" )
            .seeAlso( "http://www.ece.uvic.ca/~mdadams/jasper/LICENSE" )

            .urlInfo( "http://ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .urlInfo( "http://www.ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .urlInfo( "https://ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .urlInfo( "https://www.ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LAL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LAL-1.2.json" )
            .name( "Licence Art Libre 1.2" )
            .licenseId( "LAL-1.2" )
            .seeAlso( "http://artlibre.org/licence/lal/licence-art-libre-12/" )

            .urlInfo( "http://artlibre.org/licence/lal/licence-art-libre-12/", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LAL-1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LAL-1.3.json" )
            .name( "Licence Art Libre 1.3" )
            .licenseId( "LAL-1.3" )
            .seeAlso( "http://artlibre.org/" )

            .urlInfo( "http://artlibre.org/", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0.json" )
            .name( "GNU Library General Public License v2 only" )
            .licenseId( "LGPL-2.0" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0+.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0+.json" )
            .name( "GNU Library General Public License v2 or later" )
            .licenseId( "LGPL-2.0+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0-only.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0-only.json" )
            .name( "GNU Library General Public License v2 only" )
            .licenseId( "LGPL-2.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0-or-later.json" )
            .name( "GNU Library General Public License v2 or later" )
            .licenseId( "LGPL-2.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1.json" )
            .name( "GNU Lesser General Public License v2.1 only" )
            .licenseId( "LGPL-2.1" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1+.json" )
            .name( "GNU Library General Public License v2.1 or later" )
            .licenseId( "LGPL-2.1+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1-only.json" )
            .name( "GNU Lesser General Public License v2.1 only" )
            .licenseId( "LGPL-2.1-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1-or-later.json" )
            .name( "GNU Lesser General Public License v2.1 or later" )
            .licenseId( "LGPL-2.1-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "907b676680213346d9e88f3a44b4c79c7ff45a52", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0.json" )
            .name( "GNU Lesser General Public License v3.0 only" )
            .licenseId( "LGPL-3.0" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0+.json" )
            .name( "GNU Lesser General Public License v3.0 or later" )
            .licenseId( "LGPL-3.0+" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0-only.json" )
            .name( "GNU Lesser General Public License v3.0 only" )
            .licenseId( "LGPL-3.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0-or-later.json" )
            .name( "GNU Lesser General Public License v3.0 or later" )
            .licenseId( "LGPL-3.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "0b7ed4b5bf00542b6097743acc01287855db567b", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPLLR.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LGPLLR.json" )
            .name( "Lesser General Public License For Linguistic Resources" )
            .licenseId( "LGPLLR" )
            .seeAlso( "http://www-igm.univ-mlv.fr/~unitex/lgpllr.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPL-1.0.json" )
            .name( "Lucent Public License Version 1.0" )
            .licenseId( "LPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/LPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/LPL-1.0", "053161719567499c9d39ab8dfcfcc68f90b7e772", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LPL-1.0", "053161719567499c9d39ab8dfcfcc68f90b7e772", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LPL-1.0", "053161719567499c9d39ab8dfcfcc68f90b7e772", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LPL-1.0", "053161719567499c9d39ab8dfcfcc68f90b7e772", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPL-1.02.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LPL-1.02.json" )
            .name( "Lucent Public License v1.02" )
            .licenseId( "LPL-1.02" )
            .seeAlso( "http://plan9.bell-labs.com/plan9/license.html" )
            .seeAlso( "https://opensource.org/licenses/LPL-1.02" )

            .urlInfo( "http://opensource.org/licenses/LPL-1.02", "417007292938413f1c8e3f9b81aa6a837b1b1d2f", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LPL-1.02", "417007292938413f1c8e3f9b81aa6a837b1b1d2f", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LPL-1.02", "417007292938413f1c8e3f9b81aa6a837b1b1d2f", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LPL-1.02", "417007292938413f1c8e3f9b81aa6a837b1b1d2f", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.0.json" )
            .name( "LaTeX Project Public License v1.0" )
            .licenseId( "LPPL-1.0" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-0.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.1.json" )
            .name( "LaTeX Project Public License v1.1" )
            .licenseId( "LPPL-1.1" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-1.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.2.json" )
            .name( "LaTeX Project Public License v1.2" )
            .licenseId( "LPPL-1.2" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-2.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.3a.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.3a.json" )
            .name( "LaTeX Project Public License v1.3a" )
            .licenseId( "LPPL-1.3a" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-3a.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.3c.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.3c.json" )
            .name( "LaTeX Project Public License v1.3c" )
            .licenseId( "LPPL-1.3c" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-3c.txt" )
            .seeAlso( "https://opensource.org/licenses/LPPL-1.3c" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/LPPL-1.3c", "04cfe7522ed28cf62282122c3d5054e9096a91a3", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LPPL-1.3c", "04cfe7522ed28cf62282122c3d5054e9096a91a3", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LPPL-1.3c", "04cfe7522ed28cf62282122c3d5054e9096a91a3", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LPPL-1.3c", "04cfe7522ed28cf62282122c3d5054e9096a91a3", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Latex2e.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Latex2e.json" )
            .name( "Latex2e License" )
            .licenseId( "Latex2e" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Latex2e" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Latex2e", "2ca5b6fdd71131549a180e8feca35bb5f791ef34", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Latex2e", "2ca5b6fdd71131549a180e8feca35bb5f791ef34", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Latex2e", "2ca5b6fdd71131549a180e8feca35bb5f791ef34", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Latex2e", "2ca5b6fdd71131549a180e8feca35bb5f791ef34", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Leptonica.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Leptonica.json" )
            .name( "Leptonica License" )
            .licenseId( "Leptonica" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Leptonica" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Leptonica", "411d9d23cdae63879f8a9607f511dc78f627cb27", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Leptonica", "411d9d23cdae63879f8a9607f511dc78f627cb27", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Leptonica", "411d9d23cdae63879f8a9607f511dc78f627cb27", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Leptonica", "411d9d23cdae63879f8a9607f511dc78f627cb27", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LiLiQ-P-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LiLiQ-P-1.1.json" )
            .name( "Licence Libre du Québec – Permissive version 1.1" )
            .licenseId( "LiLiQ-P-1.1" )
            .seeAlso( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/" )
            .seeAlso( "http://opensource.org/licenses/LiLiQ-P-1.1" )

            .urlInfo( "http://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LiLiQ-P-1.1", "f0c5bc31ae67509bdb25ff6e8b032a3e88ea96b3", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LiLiQ-P-1.1", "f0c5bc31ae67509bdb25ff6e8b032a3e88ea96b3", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LiLiQ-P-1.1", "f0c5bc31ae67509bdb25ff6e8b032a3e88ea96b3", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LiLiQ-P-1.1", "f0c5bc31ae67509bdb25ff6e8b032a3e88ea96b3", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LiLiQ-R-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LiLiQ-R-1.1.json" )
            .name( "Licence Libre du Québec – Réciprocité version 1.1" )
            .licenseId( "LiLiQ-R-1.1" )
            .seeAlso( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/" )
            .seeAlso( "http://opensource.org/licenses/LiLiQ-R-1.1" )

            .urlInfo( "http://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LiLiQ-R-1.1", "87655ae11579cfafdaa6d9c2bafc566b0833d672", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LiLiQ-R-1.1", "87655ae11579cfafdaa6d9c2bafc566b0833d672", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LiLiQ-R-1.1", "87655ae11579cfafdaa6d9c2bafc566b0833d672", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LiLiQ-R-1.1", "87655ae11579cfafdaa6d9c2bafc566b0833d672", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LiLiQ-Rplus-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LiLiQ-Rplus-1.1.json" )
            .name( "Licence Libre du Québec – Réciprocité forte version 1.1" )
            .licenseId( "LiLiQ-Rplus-1.1" )
            .seeAlso( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/" )
            .seeAlso( "http://opensource.org/licenses/LiLiQ-Rplus-1.1" )

            .urlInfo( "http://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LiLiQ-Rplus-1.1", "7f80406b5da4c34a1518e6630ff304d226ed8a34", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/LiLiQ-Rplus-1.1", "7f80406b5da4c34a1518e6630ff304d226ed8a34", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/LiLiQ-Rplus-1.1", "7f80406b5da4c34a1518e6630ff304d226ed8a34", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/LiLiQ-Rplus-1.1", "7f80406b5da4c34a1518e6630ff304d226ed8a34", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Libpng.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Libpng.json" )
            .name( "libpng License" )
            .licenseId( "Libpng" )
            .seeAlso( "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt" )

            .urlInfo( "http://libpng.org/pub/png/src/libpng-LICENSE.txt", "e01ba244558d7a6b6729885beb54e9e561583101", "text/plain", true, false )
            .urlInfo( "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt", "e01ba244558d7a6b6729885beb54e9e561583101", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Linux-OpenIB.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Linux-OpenIB.json" )
            .name( "Linux Kernel Variant of OpenIB.org license" )
            .licenseId( "Linux-OpenIB" )
            .seeAlso( "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MIT.json" )
            .name( "MIT License" )
            .licenseId( "MIT" )
            .seeAlso( "https://opensource.org/licenses/MIT" )

            .urlInfo( "http://opensource.org/licenses/MIT", "0c2c759773dec5c83ca12af00a76934ee1135555", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MIT", "0c2c759773dec5c83ca12af00a76934ee1135555", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MIT", "0c2c759773dec5c83ca12af00a76934ee1135555", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MIT", "0c2c759773dec5c83ca12af00a76934ee1135555", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-0.json" )
            .name( "MIT No Attribution" )
            .licenseId( "MIT-0" )
            .seeAlso( "https://github.com/aws/mit-0" )
            .seeAlso( "https://romanrm.net/mit-zero" )
            .seeAlso( "https://github.com/awsdocs/aws-cloud9-user-guide/blob/master/LICENSE-SAMPLECODE" )

            .urlInfo( "https://romanrm.net/mit-zero", null, null, false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-CMU.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-CMU.json" )
            .name( "CMU License" )
            .licenseId( "MIT-CMU" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-advertising.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-advertising.json" )
            .name( "Enlightenment License (e16)" )
            .licenseId( "MIT-advertising" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "34f3d5d8d2c650ea5e734d775e0397b07179c99d", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "34f3d5d8d2c650ea5e734d775e0397b07179c99d", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "34f3d5d8d2c650ea5e734d775e0397b07179c99d", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "34f3d5d8d2c650ea5e734d775e0397b07179c99d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-enna.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-enna.json" )
            .name( "enna License" )
            .licenseId( "MIT-enna" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT#enna" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#enna", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-feh.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-feh.json" )
            .name( "feh License" )
            .licenseId( "MIT-feh" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT#feh" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#feh", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MITNFA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MITNFA.json" )
            .name( "MIT +no-false-attribs license" )
            .licenseId( "MITNFA" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MITNFA" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MITNFA", "fa242b9b757de68e6c6fb3fc07fe44ef372d5052", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MITNFA", "fa242b9b757de68e6c6fb3fc07fe44ef372d5052", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MITNFA", "fa242b9b757de68e6c6fb3fc07fe44ef372d5052", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MITNFA", "fa242b9b757de68e6c6fb3fc07fe44ef372d5052", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MPL-1.0.json" )
            .name( "Mozilla Public License 1.0" )
            .licenseId( "MPL-1.0" )
            .seeAlso( "http://www.mozilla.org/MPL/MPL-1.0.html" )
            .seeAlso( "https://opensource.org/licenses/MPL-1.0" )

            .urlInfo( "http://mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-1.0", "62e31cba16b94a944ea7b20e95c7904089650707", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-1.0", "62e31cba16b94a944ea7b20e95c7904089650707", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MPL-1.0", "62e31cba16b94a944ea7b20e95c7904089650707", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-1.0", "62e31cba16b94a944ea7b20e95c7904089650707", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MPL-1.1.json" )
            .name( "Mozilla Public License 1.1" )
            .licenseId( "MPL-1.1" )
            .seeAlso( "http://www.mozilla.org/MPL/MPL-1.1.html" )
            .seeAlso( "https://opensource.org/licenses/MPL-1.1" )

            .urlInfo( "http://mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-1.1", "cad130ae63b5f92a982866ef169984d9cd54c680", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-1.1", "cad130ae63b5f92a982866ef169984d9cd54c680", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MPL-1.1", "cad130ae63b5f92a982866ef169984d9cd54c680", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-1.1", "cad130ae63b5f92a982866ef169984d9cd54c680", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MPL-2.0.json" )
            .name( "Mozilla Public License 2.0" )
            .licenseId( "MPL-2.0" )
            .seeAlso( "http://www.mozilla.org/MPL/2.0/" )
            .seeAlso( "https://opensource.org/licenses/MPL-2.0" )

            .urlInfo( "http://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-2.0-no-copyleft-exception.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MPL-2.0-no-copyleft-exception.json" )
            .name( "Mozilla Public License 2.0 (no copyleft exception)" )
            .licenseId( "MPL-2.0-no-copyleft-exception" )
            .seeAlso( "http://www.mozilla.org/MPL/2.0/" )
            .seeAlso( "https://opensource.org/licenses/MPL-2.0" )

            .urlInfo( "http://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-2.0", "80832253aa55be0cfd77da769c635effca43bcbc", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MS-PL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MS-PL.json" )
            .name( "Microsoft Public License" )
            .licenseId( "MS-PL" )
            .seeAlso( "http://www.microsoft.com/opensource/licenses.mspx" )
            .seeAlso( "https://opensource.org/licenses/MS-PL" )

            .urlInfo( "http://opensource.org/licenses/MS-PL", "806025dba33b2a84453f675c4874703189e05433", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MS-PL", "806025dba33b2a84453f675c4874703189e05433", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MS-PL", "806025dba33b2a84453f675c4874703189e05433", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MS-PL", "806025dba33b2a84453f675c4874703189e05433", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MS-RL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MS-RL.json" )
            .name( "Microsoft Reciprocal License" )
            .licenseId( "MS-RL" )
            .seeAlso( "http://www.microsoft.com/opensource/licenses.mspx" )
            .seeAlso( "https://opensource.org/licenses/MS-RL" )

            .urlInfo( "http://opensource.org/licenses/MS-RL", "2696a10c257aab153b90fee0d20faad8fe45ac77", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MS-RL", "2696a10c257aab153b90fee0d20faad8fe45ac77", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MS-RL", "2696a10c257aab153b90fee0d20faad8fe45ac77", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MS-RL", "2696a10c257aab153b90fee0d20faad8fe45ac77", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MTLL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MTLL.json" )
            .name( "Matrix Template Library License" )
            .licenseId( "MTLL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "8fa87194a8039d1d93157f0db8762cf0267b6a27", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "8fa87194a8039d1d93157f0db8762cf0267b6a27", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "8fa87194a8039d1d93157f0db8762cf0267b6a27", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "8fa87194a8039d1d93157f0db8762cf0267b6a27", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MakeIndex.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MakeIndex.json" )
            .name( "MakeIndex License" )
            .licenseId( "MakeIndex" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MakeIndex" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MakeIndex", "e30a2c9e70b3621154773f38ffb1806ac454de9f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MakeIndex", "e30a2c9e70b3621154773f38ffb1806ac454de9f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MakeIndex", "e30a2c9e70b3621154773f38ffb1806ac454de9f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MakeIndex", "e30a2c9e70b3621154773f38ffb1806ac454de9f", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MirOS.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MirOS.json" )
            .name( "MirOS License" )
            .licenseId( "MirOS" )
            .seeAlso( "https://opensource.org/licenses/MirOS" )

            .urlInfo( "http://opensource.org/licenses/MirOS", "0a292aadf7aae1e03ddd17e0d393107bd15cbf40", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/MirOS", "0a292aadf7aae1e03ddd17e0d393107bd15cbf40", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/MirOS", "0a292aadf7aae1e03ddd17e0d393107bd15cbf40", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/MirOS", "0a292aadf7aae1e03ddd17e0d393107bd15cbf40", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Motosoto.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Motosoto.json" )
            .name( "Motosoto License" )
            .licenseId( "Motosoto" )
            .seeAlso( "https://opensource.org/licenses/Motosoto" )

            .urlInfo( "http://opensource.org/licenses/Motosoto", "c38b4f3b6aa19d04d0c0b6308409ae936d161395", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Motosoto", "c38b4f3b6aa19d04d0c0b6308409ae936d161395", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Motosoto", "c38b4f3b6aa19d04d0c0b6308409ae936d161395", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Motosoto", "c38b4f3b6aa19d04d0c0b6308409ae936d161395", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Multics.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Multics.json" )
            .name( "Multics License" )
            .licenseId( "Multics" )
            .seeAlso( "https://opensource.org/licenses/Multics" )

            .urlInfo( "http://opensource.org/licenses/Multics", "c3c2f330b2cc0e92d4a9b2bb77cb7ac639f64117", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Multics", "c3c2f330b2cc0e92d4a9b2bb77cb7ac639f64117", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Multics", "c3c2f330b2cc0e92d4a9b2bb77cb7ac639f64117", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Multics", "c3c2f330b2cc0e92d4a9b2bb77cb7ac639f64117", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Mup.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Mup.json" )
            .name( "Mup License" )
            .licenseId( "Mup" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Mup" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Mup", "fcad72b7af7e6b0710c797e40ef56fe858cc6715", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Mup", "fcad72b7af7e6b0710c797e40ef56fe858cc6715", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Mup", "fcad72b7af7e6b0710c797e40ef56fe858cc6715", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Mup", "fcad72b7af7e6b0710c797e40ef56fe858cc6715", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NASA-1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NASA-1.3.json" )
            .name( "NASA Open Source Agreement 1.3" )
            .licenseId( "NASA-1.3" )
            .seeAlso( "http://ti.arc.nasa.gov/opensource/nosa/" )
            .seeAlso( "https://opensource.org/licenses/NASA-1.3" )

            .urlInfo( "http://ti.arc.nasa.gov/opensource/nosa/", "11e8aeb6176bf4bcc52cbef177c081bf099cccae", "text/html", true, false )
            .urlInfo( "https://ti.arc.nasa.gov/opensource/nosa/", "11e8aeb6176bf4bcc52cbef177c081bf099cccae", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/NASA-1.3", "61efb6be1d9864754cfb643f11870bf20e983716", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/NASA-1.3", "61efb6be1d9864754cfb643f11870bf20e983716", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/NASA-1.3", "61efb6be1d9864754cfb643f11870bf20e983716", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/NASA-1.3", "61efb6be1d9864754cfb643f11870bf20e983716", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NBPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NBPL-1.0.json" )
            .name( "Net Boolean Public License v1" )
            .licenseId( "NBPL-1.0" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894", "59fd5b5f04cbeef07405d2459c0016d9fd334d7d", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894", "59fd5b5f04cbeef07405d2459c0016d9fd334d7d", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894", "59fd5b5f04cbeef07405d2459c0016d9fd334d7d", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NCSA.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NCSA.json" )
            .name( "University of Illinois/NCSA Open Source License" )
            .licenseId( "NCSA" )
            .seeAlso( "http://otm.illinois.edu/uiuc_openSource" )
            .seeAlso( "https://opensource.org/licenses/NCSA" )

            .urlInfo( "http://opensource.org/licenses/NCSA", "12a5b5912a92e76316038d73a2d4717ee4dfb86e", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/NCSA", "12a5b5912a92e76316038d73a2d4717ee4dfb86e", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/NCSA", "12a5b5912a92e76316038d73a2d4717ee4dfb86e", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/NCSA", "12a5b5912a92e76316038d73a2d4717ee4dfb86e", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NGPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NGPL.json" )
            .name( "Nethack General Public License" )
            .licenseId( "NGPL" )
            .seeAlso( "https://opensource.org/licenses/NGPL" )

            .urlInfo( "http://opensource.org/licenses/NGPL", "3411986060908b67db87c8ef963c27c0819206c5", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/NGPL", "3411986060908b67db87c8ef963c27c0819206c5", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/NGPL", "3411986060908b67db87c8ef963c27c0819206c5", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/NGPL", "3411986060908b67db87c8ef963c27c0819206c5", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NLOD-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NLOD-1.0.json" )
            .name( "Norwegian Licence for Open Government Data" )
            .licenseId( "NLOD-1.0" )
            .seeAlso( "http://data.norge.no/nlod/en/1.0" )

            .urlInfo( "http://data.norge.no/nlod/en/1.0", "c947bc5e0871a5a3450c5236f01cff433fc83e30", "text/html", true, true )
            .urlInfo( "http://www.data.norge.no/nlod/en/1.0", "c947bc5e0871a5a3450c5236f01cff433fc83e30", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NLPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NLPL.json" )
            .name( "No Limit Public License" )
            .licenseId( "NLPL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/NLPL" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/NLPL", "7a5f77c09046c1feb00250093de33525a7d4ae20", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/NLPL", "7a5f77c09046c1feb00250093de33525a7d4ae20", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/NLPL", "7a5f77c09046c1feb00250093de33525a7d4ae20", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/NLPL", "7a5f77c09046c1feb00250093de33525a7d4ae20", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NOSL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NOSL.json" )
            .name( "Netizen Open Source License" )
            .licenseId( "NOSL" )
            .seeAlso( "http://bits.netizen.com.au/licenses/NOSL/nosl.txt" )

            .urlInfo( "http://bits.netizen.com.au/licenses/NOSL/nosl.txt", "d553781af37e2cd9dc4d670713b640c7e973154c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NPL-1.0.json" )
            .name( "Netscape Public License v1.0" )
            .licenseId( "NPL-1.0" )
            .seeAlso( "http://www.mozilla.org/MPL/NPL/1.0/" )

            .urlInfo( "http://mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NPL-1.1.json" )
            .name( "Netscape Public License v1.1" )
            .licenseId( "NPL-1.1" )
            .seeAlso( "http://www.mozilla.org/MPL/NPL/1.1/" )

            .urlInfo( "http://mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NPOSL-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NPOSL-3.0.json" )
            .name( "Non-Profit Open Software License 3.0" )
            .licenseId( "NPOSL-3.0" )
            .seeAlso( "https://opensource.org/licenses/NOSL3.0" )

            .urlInfo( "http://opensource.org/licenses/NOSL3.0", "786b95a0baa429286f743ba5ca5e10a9104a410a", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/NOSL3.0", "786b95a0baa429286f743ba5ca5e10a9104a410a", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/NOSL3.0", "786b95a0baa429286f743ba5ca5e10a9104a410a", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/NOSL3.0", "786b95a0baa429286f743ba5ca5e10a9104a410a", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NRL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NRL.json" )
            .name( "NRL License" )
            .licenseId( "NRL" )
            .seeAlso( "http://web.mit.edu/network/isakmp/nrllicense.html" )

            .urlInfo( "http://web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .urlInfo( "http://www.web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .urlInfo( "https://web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .urlInfo( "https://www.web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NTP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NTP.json" )
            .name( "NTP License" )
            .licenseId( "NTP" )
            .seeAlso( "https://opensource.org/licenses/NTP" )

            .urlInfo( "http://opensource.org/licenses/NTP", "c6b1550342cf1325c584621bb02bc5a96dd66f23", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/NTP", "c6b1550342cf1325c584621bb02bc5a96dd66f23", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/NTP", "c6b1550342cf1325c584621bb02bc5a96dd66f23", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/NTP", "c6b1550342cf1325c584621bb02bc5a96dd66f23", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Naumen.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Naumen.json" )
            .name( "Naumen Public License" )
            .licenseId( "Naumen" )
            .seeAlso( "https://opensource.org/licenses/Naumen" )

            .urlInfo( "http://opensource.org/licenses/Naumen", "e53fe416d1f5ce544d42f19b59a360df0c60bf53", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Naumen", "e53fe416d1f5ce544d42f19b59a360df0c60bf53", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Naumen", "e53fe416d1f5ce544d42f19b59a360df0c60bf53", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Naumen", "e53fe416d1f5ce544d42f19b59a360df0c60bf53", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Net-SNMP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Net-SNMP.json" )
            .name( "Net-SNMP License" )
            .licenseId( "Net-SNMP" )
            .seeAlso( "http://net-snmp.sourceforge.net/about/license.html" )

            .urlInfo( "http://net-snmp.sourceforge.net/about/license.html", "25bfbfe536d41d2cbe8666ba72875696e13597ef", "text/html", true, false )
            .urlInfo( "http://www.net-snmp.sourceforge.net/about/license.html", "25bfbfe536d41d2cbe8666ba72875696e13597ef", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NetCDF.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NetCDF.json" )
            .name( "NetCDF license" )
            .licenseId( "NetCDF" )
            .seeAlso( "http://www.unidata.ucar.edu/software/netcdf/copyright.html" )

            .urlInfo( "http://unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .urlInfo( "http://www.unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .urlInfo( "https://unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .urlInfo( "https://www.unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Newsletr.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Newsletr.json" )
            .name( "Newsletr License" )
            .licenseId( "Newsletr" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Newsletr" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Newsletr", "f4583ff111c96c49ea2e91574578a3546cee8b44", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Newsletr", "f4583ff111c96c49ea2e91574578a3546cee8b44", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Newsletr", "f4583ff111c96c49ea2e91574578a3546cee8b44", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Newsletr", "f4583ff111c96c49ea2e91574578a3546cee8b44", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Nokia.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Nokia.json" )
            .name( "Nokia Open Source License" )
            .licenseId( "Nokia" )
            .seeAlso( "https://opensource.org/licenses/nokia" )

            .urlInfo( "http://opensource.org/licenses/nokia", "e49713a3ae380b13bca5a6b3ab655b7505b64510", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/nokia", "e49713a3ae380b13bca5a6b3ab655b7505b64510", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/nokia", "e49713a3ae380b13bca5a6b3ab655b7505b64510", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/nokia", "e49713a3ae380b13bca5a6b3ab655b7505b64510", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Noweb.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Noweb.json" )
            .name( "Noweb License" )
            .licenseId( "Noweb" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Noweb" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Noweb", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Nunit.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Nunit.json" )
            .name( "Nunit License" )
            .licenseId( "Nunit" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Nunit" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Nunit", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OCCT-PL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OCCT-PL.json" )
            .name( "Open CASCADE Technology Public License" )
            .licenseId( "OCCT-PL" )
            .seeAlso( "http://www.opencascade.com/content/occt-public-license" )

            .urlInfo( "http://www.opencascade.com/content/occt-public-license", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OCLC-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OCLC-2.0.json" )
            .name( "OCLC Research Public License 2.0" )
            .licenseId( "OCLC-2.0" )
            .seeAlso( "http://www.oclc.org/research/activities/software/license/v2final.htm" )
            .seeAlso( "https://opensource.org/licenses/OCLC-2.0" )

            .urlInfo( "http://opensource.org/licenses/OCLC-2.0", "3ec3f121954f07cfe0d84d7e6f59877d9825d134", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OCLC-2.0", "3ec3f121954f07cfe0d84d7e6f59877d9825d134", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OCLC-2.0", "3ec3f121954f07cfe0d84d7e6f59877d9825d134", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OCLC-2.0", "3ec3f121954f07cfe0d84d7e6f59877d9825d134", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ODC-By-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ODC-By-1.0.json" )
            .name( "Open Data Commons Attribution License v1.0" )
            .licenseId( "ODC-By-1.0" )
            .seeAlso( "https://opendatacommons.org/licenses/by/1.0/" )

            .urlInfo( "http://opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .urlInfo( "http://www.opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .urlInfo( "https://opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .urlInfo( "https://www.opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ODbL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ODbL-1.0.json" )
            .name( "ODC Open Database License v1.0" )
            .licenseId( "ODbL-1.0" )
            .seeAlso( "http://www.opendatacommons.org/licenses/odbl/1.0/" )

            .urlInfo( "http://opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .urlInfo( "http://www.opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .urlInfo( "https://opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .urlInfo( "https://www.opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OFL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OFL-1.0.json" )
            .name( "SIL Open Font License 1.0" )
            .licenseId( "OFL-1.0" )
            .seeAlso( "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OFL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OFL-1.1.json" )
            .name( "SIL Open Font License 1.1" )
            .licenseId( "OFL-1.1" )
            .seeAlso( "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web" )
            .seeAlso( "https://opensource.org/licenses/OFL-1.1" )

            .urlInfo( "http://opensource.org/licenses/OFL-1.1", "f8ca4c179f3b6058df8601d47a0dc185194e9fa1", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OFL-1.1", "f8ca4c179f3b6058df8601d47a0dc185194e9fa1", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OFL-1.1", "f8ca4c179f3b6058df8601d47a0dc185194e9fa1", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OFL-1.1", "f8ca4c179f3b6058df8601d47a0dc185194e9fa1", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGL-UK-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGL-UK-1.0.json" )
            .name( "Open Government Licence v1.0" )
            .licenseId( "OGL-UK-1.0" )
            .seeAlso( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/" )

            .urlInfo( "http://nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .urlInfo( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .urlInfo( "https://nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .urlInfo( "https://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGL-UK-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGL-UK-2.0.json" )
            .name( "Open Government Licence v2.0" )
            .licenseId( "OGL-UK-2.0" )
            .seeAlso( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/" )

            .urlInfo( "http://nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .urlInfo( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .urlInfo( "https://nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .urlInfo( "https://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGL-UK-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGL-UK-3.0.json" )
            .name( "Open Government Licence v3.0" )
            .licenseId( "OGL-UK-3.0" )
            .seeAlso( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/" )

            .urlInfo( "http://nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .urlInfo( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .urlInfo( "https://nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .urlInfo( "https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGTSL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGTSL.json" )
            .name( "Open Group Test Suite License" )
            .licenseId( "OGTSL" )
            .seeAlso( "http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt" )
            .seeAlso( "https://opensource.org/licenses/OGTSL" )

            .urlInfo( "http://opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "https://opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "https://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/OGTSL", "8a52eb473046c3c674629b04b6323eb185420838", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OGTSL", "8a52eb473046c3c674629b04b6323eb185420838", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OGTSL", "8a52eb473046c3c674629b04b6323eb185420838", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OGTSL", "8a52eb473046c3c674629b04b6323eb185420838", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.1.json" )
            .name( "Open LDAP Public License v1.1" )
            .licenseId( "OLDAP-1.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f", "cc3609bf4dfaeff579d26ad8a4745e46b40d9e39", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f", "cc3609bf4dfaeff579d26ad8a4745e46b40d9e39", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f", "cc3609bf4dfaeff579d26ad8a4745e46b40d9e39", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.2.json" )
            .name( "Open LDAP Public License v1.2" )
            .licenseId( "OLDAP-1.2" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7", "36e686a2fb48ace983206f9b8b1b1d96b84ebf35", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7", "36e686a2fb48ace983206f9b8b1b1d96b84ebf35", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7", "36e686a2fb48ace983206f9b8b1b1d96b84ebf35", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.3.json" )
            .name( "Open LDAP Public License v1.3" )
            .licenseId( "OLDAP-1.3" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1", "dd41669825e0d0a99ab82a10b850f07c28ca163b", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1", "dd41669825e0d0a99ab82a10b850f07c28ca163b", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1", "dd41669825e0d0a99ab82a10b850f07c28ca163b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.4.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.4.json" )
            .name( "Open LDAP Public License v1.4" )
            .licenseId( "OLDAP-1.4" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941", "7f9996c5ccda375682c2888c1443b2d88a095ae2", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941", "7f9996c5ccda375682c2888c1443b2d88a095ae2", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941", "7f9996c5ccda375682c2888c1443b2d88a095ae2", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.0.json" )
            .name( "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)" )
            .licenseId( "OLDAP-2.0" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea", "4143bc62158eddba55ece8e86c696da95431be52", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea", "4143bc62158eddba55ece8e86c696da95431be52", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea", "4143bc62158eddba55ece8e86c696da95431be52", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.0.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.0.1.json" )
            .name( "Open LDAP Public License v2.0.1" )
            .licenseId( "OLDAP-2.0.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e", "0ad6d8ce330110b0a598a1db41e95f07f867ae8f", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e", "0ad6d8ce330110b0a598a1db41e95f07f867ae8f", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e", "0ad6d8ce330110b0a598a1db41e95f07f867ae8f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.1.json" )
            .name( "Open LDAP Public License v2.1" )
            .licenseId( "OLDAP-2.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715", "d1c12b87b84ccb94fbe3ee404bc47363a59ae457", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715", "d1c12b87b84ccb94fbe3ee404bc47363a59ae457", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715", "d1c12b87b84ccb94fbe3ee404bc47363a59ae457", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.2.json" )
            .name( "Open LDAP Public License v2.2" )
            .licenseId( "OLDAP-2.2" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3", "a2d5f10f30009baefde6908b1f1b91c5e056ad0e", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3", "a2d5f10f30009baefde6908b1f1b91c5e056ad0e", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3", "a2d5f10f30009baefde6908b1f1b91c5e056ad0e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.2.1.json" )
            .name( "Open LDAP Public License v2.2.1" )
            .licenseId( "OLDAP-2.2.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e", "47f9ffa3cc4cddb9a0a460c899f5ed78a98693ed", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e", "47f9ffa3cc4cddb9a0a460c899f5ed78a98693ed", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e", "47f9ffa3cc4cddb9a0a460c899f5ed78a98693ed", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.2.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.2.2.json" )
            .name( "Open LDAP Public License 2.2.2" )
            .licenseId( "OLDAP-2.2.2" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188", "91a4bcf746a90ec19b5915cf6f440e137220fc65", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188", "91a4bcf746a90ec19b5915cf6f440e137220fc65", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188", "91a4bcf746a90ec19b5915cf6f440e137220fc65", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.3.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.3.json" )
            .name( "Open LDAP Public License v2.3" )
            .licenseId( "OLDAP-2.3" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3", "e7edc1d7ffb7a8c5687151ebe8db8d8084459fa6", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3", "e7edc1d7ffb7a8c5687151ebe8db8d8084459fa6", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3", "e7edc1d7ffb7a8c5687151ebe8db8d8084459fa6", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.4.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.4.json" )
            .name( "Open LDAP Public License v2.4" )
            .licenseId( "OLDAP-2.4" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386", "859351b167aeb994a2bdb83474c446831891cdeb", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386", "859351b167aeb994a2bdb83474c446831891cdeb", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386", "859351b167aeb994a2bdb83474c446831891cdeb", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.5.json" )
            .name( "Open LDAP Public License v2.5" )
            .licenseId( "OLDAP-2.5" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf", "10bc14c8710f1abd9a9fbe92ef733b9b52727c11", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf", "10bc14c8710f1abd9a9fbe92ef733b9b52727c11", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf", "10bc14c8710f1abd9a9fbe92ef733b9b52727c11", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.6.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.6.json" )
            .name( "Open LDAP Public License v2.6" )
            .licenseId( "OLDAP-2.6" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205", "ad139a7d2daff170319dc950d7a9d6ce72f2cbd5", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205", "ad139a7d2daff170319dc950d7a9d6ce72f2cbd5", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205", "ad139a7d2daff170319dc950d7a9d6ce72f2cbd5", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.7.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.7.json" )
            .name( "Open LDAP Public License v2.7" )
            .licenseId( "OLDAP-2.7" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2", "e2a208598e075a07706faad2af61b85983f95c93", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2", "e2a208598e075a07706faad2af61b85983f95c93", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2", "e2a208598e075a07706faad2af61b85983f95c93", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.8.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.8.json" )
            .name( "Open LDAP Public License v2.8" )
            .licenseId( "OLDAP-2.8" )
            .seeAlso( "http://www.openldap.org/software/release/license.html" )

            .urlInfo( "http://openldap.org/software/release/license.html", "fc5f8da10a6a57b8475f3dff52475367c692de76", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/software/release/license.html", "fc5f8da10a6a57b8475f3dff52475367c692de76", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/software/release/license.html", "fc5f8da10a6a57b8475f3dff52475367c692de76", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OML.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OML.json" )
            .name( "Open Market License" )
            .licenseId( "OML" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Open_Market_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Open_Market_License", "abb4d124816dedecdb31b8135f1db2de5d1ade2b", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Open_Market_License", "abb4d124816dedecdb31b8135f1db2de5d1ade2b", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Open_Market_License", "abb4d124816dedecdb31b8135f1db2de5d1ade2b", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Open_Market_License", "abb4d124816dedecdb31b8135f1db2de5d1ade2b", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OPL-1.0.json" )
            .name( "Open Public License v1.0" )
            .licenseId( "OPL-1.0" )
            .seeAlso( "http://old.koalateam.com/jackaroo/OPL_1_0.TXT" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Open_Public_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Open_Public_License", "2d328a8216ab4f71264dc8bb47f3a3f33e8da266", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Open_Public_License", "2d328a8216ab4f71264dc8bb47f3a3f33e8da266", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Open_Public_License", "2d328a8216ab4f71264dc8bb47f3a3f33e8da266", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Open_Public_License", "2d328a8216ab4f71264dc8bb47f3a3f33e8da266", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSET-PL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OSET-PL-2.1.json" )
            .name( "OSET Public License version 2.1" )
            .licenseId( "OSET-PL-2.1" )
            .seeAlso( "http://www.osetfoundation.org/public-license" )
            .seeAlso( "https://opensource.org/licenses/OPL-2.1" )

            .urlInfo( "http://osetfoundation.org/public-license", "1e691c9f74d3e1cff04d7ed950835f2964835352", "text/html", true, false )
            .urlInfo( "http://www.osetfoundation.org/public-license", "1e691c9f74d3e1cff04d7ed950835f2964835352", "text/html", true, false )
            .urlInfo( "https://www.osetfoundation.org/public-license", "1e691c9f74d3e1cff04d7ed950835f2964835352", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/OPL-2.1", "17913c84a49d477ead2e218716a44690301c32ff", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OPL-2.1", "17913c84a49d477ead2e218716a44690301c32ff", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OPL-2.1", "17913c84a49d477ead2e218716a44690301c32ff", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OPL-2.1", "17913c84a49d477ead2e218716a44690301c32ff", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-1.0.json" )
            .name( "Open Software License 1.0" )
            .licenseId( "OSL-1.0" )
            .seeAlso( "https://opensource.org/licenses/OSL-1.0" )

            .urlInfo( "http://opensource.org/licenses/OSL-1.0", "07e1ae0886993c2b59f8d4292636a52e9734dfb3", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OSL-1.0", "07e1ae0886993c2b59f8d4292636a52e9734dfb3", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OSL-1.0", "07e1ae0886993c2b59f8d4292636a52e9734dfb3", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OSL-1.0", "07e1ae0886993c2b59f8d4292636a52e9734dfb3", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-1.1.json" )
            .name( "Open Software License 1.1" )
            .licenseId( "OSL-1.1" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/OSL1.1" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/OSL1.1", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-2.0.json" )
            .name( "Open Software License 2.0" )
            .licenseId( "OSL-2.0" )
            .seeAlso( "http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-2.1.json" )
            .name( "Open Software License 2.1" )
            .licenseId( "OSL-2.1" )
            .seeAlso( "http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm" )
            .seeAlso( "https://opensource.org/licenses/OSL-2.1" )

            .urlInfo( "http://opensource.org/licenses/OSL-2.1", "5121c310d411133c1449bc08f9c78ded29f6bb39", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OSL-2.1", "5121c310d411133c1449bc08f9c78ded29f6bb39", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OSL-2.1", "5121c310d411133c1449bc08f9c78ded29f6bb39", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OSL-2.1", "5121c310d411133c1449bc08f9c78ded29f6bb39", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-3.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-3.0.json" )
            .name( "Open Software License 3.0" )
            .licenseId( "OSL-3.0" )
            .seeAlso( "https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm" )
            .seeAlso( "https://opensource.org/licenses/OSL-3.0" )

            .urlInfo( "http://opensource.org/licenses/OSL-3.0", "b79ea4d57096ffb9b059ec42e9aff6b2d4e54558", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/OSL-3.0", "b79ea4d57096ffb9b059ec42e9aff6b2d4e54558", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/OSL-3.0", "b79ea4d57096ffb9b059ec42e9aff6b2d4e54558", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/OSL-3.0", "b79ea4d57096ffb9b059ec42e9aff6b2d4e54558", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OpenSSL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OpenSSL.json" )
            .name( "OpenSSL License" )
            .licenseId( "OpenSSL" )
            .seeAlso( "http://www.openssl.org/source/license.html" )

            .urlInfo( "http://openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .urlInfo( "http://www.openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .urlInfo( "https://openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .urlInfo( "https://www.openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PDDL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/PDDL-1.0.json" )
            .name( "ODC Public Domain Dedication & License 1.0" )
            .licenseId( "PDDL-1.0" )
            .seeAlso( "http://opendatacommons.org/licenses/pddl/1.0/" )

            .urlInfo( "http://opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .urlInfo( "http://www.opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .urlInfo( "https://opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .urlInfo( "https://www.opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PHP-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/PHP-3.0.json" )
            .name( "PHP License v3.0" )
            .licenseId( "PHP-3.0" )
            .seeAlso( "http://www.php.net/license/3_0.txt" )
            .seeAlso( "https://opensource.org/licenses/PHP-3.0" )

            .urlInfo( "http://php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "http://www.php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "https://php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "https://www.php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/PHP-3.0", "0341bb4fa80e2609d944193d73271b9081183cc6", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/PHP-3.0", "0341bb4fa80e2609d944193d73271b9081183cc6", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/PHP-3.0", "0341bb4fa80e2609d944193d73271b9081183cc6", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/PHP-3.0", "0341bb4fa80e2609d944193d73271b9081183cc6", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PHP-3.01.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/PHP-3.01.json" )
            .name( "PHP License v3.01" )
            .licenseId( "PHP-3.01" )
            .seeAlso( "http://www.php.net/license/3_01.txt" )

            .urlInfo( "http://php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .urlInfo( "http://www.php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .urlInfo( "https://php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .urlInfo( "https://www.php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Plexus.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Plexus.json" )
            .name( "Plexus Classworlds License" )
            .licenseId( "Plexus" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "35f378214105a76a594e6f0c66d9489d3f296bf9", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "35f378214105a76a594e6f0c66d9489d3f296bf9", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "35f378214105a76a594e6f0c66d9489d3f296bf9", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "35f378214105a76a594e6f0c66d9489d3f296bf9", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PostgreSQL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/PostgreSQL.json" )
            .name( "PostgreSQL License" )
            .licenseId( "PostgreSQL" )
            .seeAlso( "http://www.postgresql.org/about/licence" )
            .seeAlso( "https://opensource.org/licenses/PostgreSQL" )

            .urlInfo( "http://postgresql.org/about/licence", "87dcdb9923b06e8d9d5cfa3c1c157fbcadcef3ac", "text/html", true, false )
            .urlInfo( "http://www.postgresql.org/about/licence", "87dcdb9923b06e8d9d5cfa3c1c157fbcadcef3ac", "text/html", true, false )
            .urlInfo( "https://postgresql.org/about/licence", "87dcdb9923b06e8d9d5cfa3c1c157fbcadcef3ac", "text/html", true, false )
            .urlInfo( "https://www.postgresql.org/about/licence", "87dcdb9923b06e8d9d5cfa3c1c157fbcadcef3ac", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/PostgreSQL", "6f612724f58a7bdcb2ec4a4b0d93e1681d50b7ab", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/PostgreSQL", "6f612724f58a7bdcb2ec4a4b0d93e1681d50b7ab", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/PostgreSQL", "6f612724f58a7bdcb2ec4a4b0d93e1681d50b7ab", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/PostgreSQL", "6f612724f58a7bdcb2ec4a4b0d93e1681d50b7ab", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Python-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Python-2.0.json" )
            .name( "Python License 2.0" )
            .licenseId( "Python-2.0" )
            .seeAlso( "https://opensource.org/licenses/Python-2.0" )

            .urlInfo( "http://opensource.org/licenses/Python-2.0", "45e658b0a40610df5f285b0b2bf73cf33fbc5196", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Python-2.0", "45e658b0a40610df5f285b0b2bf73cf33fbc5196", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Python-2.0", "45e658b0a40610df5f285b0b2bf73cf33fbc5196", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Python-2.0", "45e658b0a40610df5f285b0b2bf73cf33fbc5196", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./QPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/QPL-1.0.json" )
            .name( "Q Public License 1.0" )
            .licenseId( "QPL-1.0" )
            .seeAlso( "http://doc.qt.nokia.com/3.3/license.html" )
            .seeAlso( "https://opensource.org/licenses/QPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/QPL-1.0", "84b0dc463e03b5752052da8a64a44720e75971a3", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/QPL-1.0", "84b0dc463e03b5752052da8a64a44720e75971a3", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/QPL-1.0", "84b0dc463e03b5752052da8a64a44720e75971a3", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/QPL-1.0", "84b0dc463e03b5752052da8a64a44720e75971a3", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Qhull.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Qhull.json" )
            .name( "Qhull License" )
            .licenseId( "Qhull" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Qhull" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Qhull", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RHeCos-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RHeCos-1.1.json" )
            .name( "Red Hat eCos Public License v1.1" )
            .licenseId( "RHeCos-1.1" )
            .seeAlso( "http://ecos.sourceware.org/old-license.html" )

            .urlInfo( "http://ecos.sourceware.org/old-license.html", "7144b1739e30b52df1020dff8866c352babc9460", "text/html", true, false )
            .urlInfo( "http://www.ecos.sourceware.org/old-license.html", "7144b1739e30b52df1020dff8866c352babc9460", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RPL-1.1.json" )
            .name( "Reciprocal Public License 1.1" )
            .licenseId( "RPL-1.1" )
            .seeAlso( "https://opensource.org/licenses/RPL-1.1" )

            .urlInfo( "http://opensource.org/licenses/RPL-1.1", "31c8efde450d7460b2a985922861f065a338767e", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/RPL-1.1", "31c8efde450d7460b2a985922861f065a338767e", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/RPL-1.1", "31c8efde450d7460b2a985922861f065a338767e", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/RPL-1.1", "31c8efde450d7460b2a985922861f065a338767e", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RPL-1.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RPL-1.5.json" )
            .name( "Reciprocal Public License 1.5" )
            .licenseId( "RPL-1.5" )
            .seeAlso( "https://opensource.org/licenses/RPL-1.5" )

            .urlInfo( "http://opensource.org/licenses/RPL-1.5", "21f48d9efd416e98d822345d308e40fccd7dbb17", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/RPL-1.5", "21f48d9efd416e98d822345d308e40fccd7dbb17", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/RPL-1.5", "21f48d9efd416e98d822345d308e40fccd7dbb17", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/RPL-1.5", "21f48d9efd416e98d822345d308e40fccd7dbb17", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RPSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/RPSL-1.0.json" )
            .name( "RealNetworks Public Source License v1.0" )
            .licenseId( "RPSL-1.0" )
            .seeAlso( "https://helixcommunity.org/content/rpsl" )
            .seeAlso( "https://opensource.org/licenses/RPSL-1.0" )

            .urlInfo( "http://opensource.org/licenses/RPSL-1.0", "e922ddc468eeb469104804a989b955deb9e35e22", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/RPSL-1.0", "e922ddc468eeb469104804a989b955deb9e35e22", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/RPSL-1.0", "e922ddc468eeb469104804a989b955deb9e35e22", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/RPSL-1.0", "e922ddc468eeb469104804a989b955deb9e35e22", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RSA-MD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RSA-MD.json" )
            .name( "RSA Message-Digest License" )
            .licenseId( "RSA-MD" )
            .seeAlso( "http://www.faqs.org/rfcs/rfc1321.html" )

            .urlInfo( "http://faqs.org/rfcs/rfc1321.html", "c6576de398f1121635a137c8335d9dd548170311", "text/html", true, false )
            .urlInfo( "http://www.faqs.org/rfcs/rfc1321.html", "c6576de398f1121635a137c8335d9dd548170311", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RSCPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RSCPL.json" )
            .name( "Ricoh Source Code Public License" )
            .licenseId( "RSCPL" )
            .seeAlso( "http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml" )
            .seeAlso( "https://opensource.org/licenses/RSCPL" )

            .urlInfo( "http://opensource.org/licenses/RSCPL", "54e1a40491e6792e1cbd86f8a6e17cbdaf8982c7", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/RSCPL", "54e1a40491e6792e1cbd86f8a6e17cbdaf8982c7", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/RSCPL", "54e1a40491e6792e1cbd86f8a6e17cbdaf8982c7", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/RSCPL", "54e1a40491e6792e1cbd86f8a6e17cbdaf8982c7", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Rdisc.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Rdisc.json" )
            .name( "Rdisc License" )
            .licenseId( "Rdisc" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Rdisc_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Rdisc_License", "85ee6bac6c9d13954f090081211c9348bedd634c", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Rdisc_License", "85ee6bac6c9d13954f090081211c9348bedd634c", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Rdisc_License", "85ee6bac6c9d13954f090081211c9348bedd634c", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Rdisc_License", "85ee6bac6c9d13954f090081211c9348bedd634c", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Ruby.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Ruby.json" )
            .name( "Ruby License" )
            .licenseId( "Ruby" )
            .seeAlso( "http://www.ruby-lang.org/en/LICENSE.txt" )

            .urlInfo( "http://ruby-lang.org/en/LICENSE.txt", "f1d4e2e57f37d52f9d2ec0443c5305ad882b73ce", "text/plain", true, false )
            .urlInfo( "http://www.ruby-lang.org/en/LICENSE.txt", "f1d4e2e57f37d52f9d2ec0443c5305ad882b73ce", "text/plain", true, false )
            .urlInfo( "https://www.ruby-lang.org/en/LICENSE.txt", "f1d4e2e57f37d52f9d2ec0443c5305ad882b73ce", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SAX-PD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SAX-PD.json" )
            .name( "Sax Public Domain Notice" )
            .licenseId( "SAX-PD" )
            .seeAlso( "http://www.saxproject.org/copying.html" )

            .urlInfo( "http://www.saxproject.org/copying.html", "b5045f54ee707e82e7c89ed51a53ba60bb993fd5", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SCEA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SCEA.json" )
            .name( "SCEA Shared Source License" )
            .licenseId( "SCEA" )
            .seeAlso( "http://research.scea.com/scea_shared_source_license.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SGI-B-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SGI-B-1.0.json" )
            .name( "SGI Free Software License B v1.0" )
            .licenseId( "SGI-B-1.0" )
            .seeAlso( "http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SGI-B-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SGI-B-1.1.json" )
            .name( "SGI Free Software License B v1.1" )
            .licenseId( "SGI-B-1.1" )
            .seeAlso( "http://oss.sgi.com/projects/FreeB/" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SGI-B-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SGI-B-2.0.json" )
            .name( "SGI Free Software License B v2.0" )
            .licenseId( "SGI-B-2.0" )
            .seeAlso( "http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SISSL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SISSL.json" )
            .name( "Sun Industry Standards Source License v1.1" )
            .licenseId( "SISSL" )
            .seeAlso( "http://www.openoffice.org/licenses/sissl_license.html" )
            .seeAlso( "https://opensource.org/licenses/SISSL" )

            .urlInfo( "http://openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "http://www.openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "https://openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "https://www.openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/SISSL", "53e6128d0eaeedf9149e1047e194147137eeb1e5", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/SISSL", "53e6128d0eaeedf9149e1047e194147137eeb1e5", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/SISSL", "53e6128d0eaeedf9149e1047e194147137eeb1e5", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/SISSL", "53e6128d0eaeedf9149e1047e194147137eeb1e5", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SISSL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SISSL-1.2.json" )
            .name( "Sun Industry Standards Source License v1.2" )
            .licenseId( "SISSL-1.2" )
            .seeAlso( "http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html" )

            .urlInfo( "http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html", "38ef0c536157be42d18d16002c02893d814e1516", "text/html", true, false )
            .urlInfo( "http://www.gridscheduler.sourceforge.net/Gridengine_SISSL_license.html", "38ef0c536157be42d18d16002c02893d814e1516", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SMLNJ.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SMLNJ.json" )
            .name( "Standard ML of New Jersey License" )
            .licenseId( "SMLNJ" )
            .seeAlso( "https://www.smlnj.org/license.html" )

            .urlInfo( "http://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SMPPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SMPPL.json" )
            .name( "Secure Messaging Protocol Public License" )
            .licenseId( "SMPPL" )
            .seeAlso( "https://github.com/dcblake/SMP/blob/master/Documentation/License.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SNIA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SNIA.json" )
            .name( "SNIA Public License 1.1" )
            .licenseId( "SNIA" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/SNIA_Public_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/SNIA_Public_License", "d1cd19635cc1b9092aa42d404ccd3a82bcb76a4a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/SNIA_Public_License", "d1cd19635cc1b9092aa42d404ccd3a82bcb76a4a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/SNIA_Public_License", "d1cd19635cc1b9092aa42d404ccd3a82bcb76a4a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/SNIA_Public_License", "d1cd19635cc1b9092aa42d404ccd3a82bcb76a4a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SPL-1.0.json" )
            .name( "Sun Public License v1.0" )
            .licenseId( "SPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/SPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/SPL-1.0", "9c7223b48e63c8d2c04176cc52cdc02347fdeda4", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/SPL-1.0", "9c7223b48e63c8d2c04176cc52cdc02347fdeda4", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/SPL-1.0", "9c7223b48e63c8d2c04176cc52cdc02347fdeda4", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/SPL-1.0", "9c7223b48e63c8d2c04176cc52cdc02347fdeda4", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SWL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SWL.json" )
            .name( "Scheme Widget Library (SWL) Software License Agreement" )
            .licenseId( "SWL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/SWL" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/SWL", "20b956202a3f20ca01fd53e6910448a7783f74c3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/SWL", "20b956202a3f20ca01fd53e6910448a7783f74c3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/SWL", "20b956202a3f20ca01fd53e6910448a7783f74c3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/SWL", "20b956202a3f20ca01fd53e6910448a7783f74c3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Saxpath.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Saxpath.json" )
            .name( "Saxpath License" )
            .licenseId( "Saxpath" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Saxpath_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Saxpath_License", "4eb370c421ef9e2bbd81c12f0bca1e0c216d25f2", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Saxpath_License", "4eb370c421ef9e2bbd81c12f0bca1e0c216d25f2", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Saxpath_License", "4eb370c421ef9e2bbd81c12f0bca1e0c216d25f2", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Saxpath_License", "4eb370c421ef9e2bbd81c12f0bca1e0c216d25f2", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Sendmail.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Sendmail.json" )
            .name( "Sendmail License" )
            .licenseId( "Sendmail" )
            .seeAlso( "http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf" )
            .seeAlso( "https://web.archive.org/web/20160322142305/https://www.sendmail.com/pdfs/open_source/sendmail_license.pdf" )

            .urlInfo( "http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Sendmail-8.23.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Sendmail-8.23.json" )
            .name( "Sendmail License 8.23" )
            .licenseId( "Sendmail-8.23" )
            .seeAlso( "https://www.proofpoint.com/sites/default/files/sendmail-license.pdf" )
            .seeAlso( "https://web.archive.org/web/20181003101040/https://www.proofpoint.com/sites/default/files/sendmail-license.pdf" )

            .urlInfo( "http://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "http://web.archive.org/web/20181003101040id_/http://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "http://web.archive.org/web/20181003101040id_/http://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "http://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://web.archive.org/web/20181003101040id_/https://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://web.archive.org/web/20181003101040id_/https://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SimPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SimPL-2.0.json" )
            .name( "Simple Public License 2.0" )
            .licenseId( "SimPL-2.0" )
            .seeAlso( "https://opensource.org/licenses/SimPL-2.0" )

            .urlInfo( "http://opensource.org/licenses/SimPL-2.0", "8bc4fe5d96e98310343479ee20479d7aa377205b", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/SimPL-2.0", "8bc4fe5d96e98310343479ee20479d7aa377205b", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/SimPL-2.0", "8bc4fe5d96e98310343479ee20479d7aa377205b", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/SimPL-2.0", "8bc4fe5d96e98310343479ee20479d7aa377205b", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Sleepycat.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Sleepycat.json" )
            .name( "Sleepycat License" )
            .licenseId( "Sleepycat" )
            .seeAlso( "https://opensource.org/licenses/Sleepycat" )

            .urlInfo( "http://opensource.org/licenses/Sleepycat", "4ca163f21d883377aafa49bad2f4aa98bc1409c1", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Sleepycat", "4ca163f21d883377aafa49bad2f4aa98bc1409c1", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Sleepycat", "4ca163f21d883377aafa49bad2f4aa98bc1409c1", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Sleepycat", "4ca163f21d883377aafa49bad2f4aa98bc1409c1", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Spencer-86.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Spencer-86.json" )
            .name( "Spencer License 86" )
            .licenseId( "Spencer-86" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Spencer-94.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Spencer-94.json" )
            .name( "Spencer License 94" )
            .licenseId( "Spencer-94" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "91027d9bb68b221d1db9728c30fea469f2e776ff", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Spencer-99.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Spencer-99.json" )
            .name( "Spencer License 99" )
            .licenseId( "Spencer-99" )
            .seeAlso( "http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c" )

            .urlInfo( "http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c", "f7c49d5cdf7ca5999cff2ee8f140c3cbfa4b6bbc", "text/x-c", true, false )
            .urlInfo( "https://opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c", "f7c49d5cdf7ca5999cff2ee8f140c3cbfa4b6bbc", "text/x-c", true, false )
            .urlInfo( "https://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c", "f7c49d5cdf7ca5999cff2ee8f140c3cbfa4b6bbc", "text/x-c", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./StandardML-NJ.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/StandardML-NJ.json" )
            .name( "Standard ML of New Jersey License" )
            .licenseId( "StandardML-NJ" )
            .seeAlso( "http://www.smlnj.org//license.html" )

            .urlInfo( "http://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SugarCRM-1.1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SugarCRM-1.1.3.json" )
            .name( "SugarCRM Public License v1.1.3" )
            .licenseId( "SugarCRM-1.1.3" )
            .seeAlso( "http://www.sugarcrm.com/crm/SPL" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TCL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TCL.json" )
            .name( "TCL/TK License" )
            .licenseId( "TCL" )
            .seeAlso( "http://www.tcl.tk/software/tcltk/license.html" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/TCL" )

            .urlInfo( "http://www.tcl.tk/software/tcltk/license.html", null, null, false, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/TCL", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TCP-wrappers.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TCP-wrappers.json" )
            .name( "TCP Wrappers License" )
            .licenseId( "TCP-wrappers" )
            .seeAlso( "http://rc.quest.com/topics/openssh/license.php#tcpwrappers" )

            .urlInfo( "http://rc.quest.com/topics/openssh/license.php#tcpwrappers", "361b2df10b2db8b7f9635890ca8b41ea0f9cba6c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TMate.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TMate.json" )
            .name( "TMate Open Source License" )
            .licenseId( "TMate" )
            .seeAlso( "http://svnkit.com/license.html" )

            .urlInfo( "http://svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .urlInfo( "http://www.svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .urlInfo( "https://svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .urlInfo( "https://www.svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TORQUE-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TORQUE-1.1.json" )
            .name( "TORQUE v2.5+ Software License v1.1" )
            .licenseId( "TORQUE-1.1" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/TORQUEv1.1" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/TORQUEv1.1", "47e7532a312f63da166906c2bba2c5e14baf819c", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/TORQUEv1.1", "47e7532a312f63da166906c2bba2c5e14baf819c", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/TORQUEv1.1", "47e7532a312f63da166906c2bba2c5e14baf819c", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/TORQUEv1.1", "47e7532a312f63da166906c2bba2c5e14baf819c", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TOSL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TOSL.json" )
            .name( "Trusster Open Source License" )
            .licenseId( "TOSL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/TOSL" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/TOSL", "e7986adc7767b91e7a6db327bf835a736c2c222f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/TOSL", "e7986adc7767b91e7a6db327bf835a736c2c222f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/TOSL", "e7986adc7767b91e7a6db327bf835a736c2c222f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/TOSL", "e7986adc7767b91e7a6db327bf835a736c2c222f", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TU-Berlin-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TU-Berlin-1.0.json" )
            .name( "Technische Universitaet Berlin License 1.0" )
            .licenseId( "TU-Berlin-1.0" )
            .seeAlso( "https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TU-Berlin-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TU-Berlin-2.0.json" )
            .name( "Technische Universitaet Berlin License 2.0" )
            .licenseId( "TU-Berlin-2.0" )
            .seeAlso( "https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./UPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/UPL-1.0.json" )
            .name( "Universal Permissive License v1.0" )
            .licenseId( "UPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/UPL" )

            .urlInfo( "http://opensource.org/licenses/UPL", "c28eb75b735673b6ed1c8e0a86ec903cfe51847d", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/UPL", "c28eb75b735673b6ed1c8e0a86ec903cfe51847d", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/UPL", "c28eb75b735673b6ed1c8e0a86ec903cfe51847d", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/UPL", "c28eb75b735673b6ed1c8e0a86ec903cfe51847d", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unicode-DFS-2015.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Unicode-DFS-2015.json" )
            .name( "Unicode License Agreement - Data Files and Software (2015)" )
            .licenseId( "Unicode-DFS-2015" )
            .seeAlso( "https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unicode-DFS-2016.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Unicode-DFS-2016.json" )
            .name( "Unicode License Agreement - Data Files and Software (2016)" )
            .licenseId( "Unicode-DFS-2016" )
            .seeAlso( "http://www.unicode.org/copyright.html" )

            .urlInfo( "http://unicode.org/copyright.html", "14a648b5ae2d7ae366f01f656dd71d33b9ac4ee0", "text/html", true, false )
            .urlInfo( "http://www.unicode.org/copyright.html", "14a648b5ae2d7ae366f01f656dd71d33b9ac4ee0", "text/html", true, false )
            .urlInfo( "https://unicode.org/copyright.html", "14a648b5ae2d7ae366f01f656dd71d33b9ac4ee0", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unicode-TOU.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Unicode-TOU.json" )
            .name( "Unicode Terms of Use" )
            .licenseId( "Unicode-TOU" )
            .seeAlso( "http://www.unicode.org/copyright.html" )

            .urlInfo( "http://unicode.org/copyright.html", "14a648b5ae2d7ae366f01f656dd71d33b9ac4ee0", "text/html", true, false )
            .urlInfo( "http://www.unicode.org/copyright.html", "14a648b5ae2d7ae366f01f656dd71d33b9ac4ee0", "text/html", true, false )
            .urlInfo( "https://unicode.org/copyright.html", "14a648b5ae2d7ae366f01f656dd71d33b9ac4ee0", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unlicense.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Unlicense.json" )
            .name( "The Unlicense" )
            .licenseId( "Unlicense" )
            .seeAlso( "http://unlicense.org/" )

            .urlInfo( "http://unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .urlInfo( "http://www.unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .urlInfo( "https://unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .urlInfo( "https://www.unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./VOSTROM.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/VOSTROM.json" )
            .name( "VOSTROM Public License for Open Source" )
            .licenseId( "VOSTROM" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/VOSTROM" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/VOSTROM", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./VSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/VSL-1.0.json" )
            .name( "Vovida Software License v1.0" )
            .licenseId( "VSL-1.0" )
            .seeAlso( "https://opensource.org/licenses/VSL-1.0" )

            .urlInfo( "http://opensource.org/licenses/VSL-1.0", "8eb986af8a2ff1e26ace80a236e6a72d58f5eb1c", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/VSL-1.0", "8eb986af8a2ff1e26ace80a236e6a72d58f5eb1c", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/VSL-1.0", "8eb986af8a2ff1e26ace80a236e6a72d58f5eb1c", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/VSL-1.0", "8eb986af8a2ff1e26ace80a236e6a72d58f5eb1c", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Vim.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Vim.json" )
            .name( "Vim License" )
            .licenseId( "Vim" )
            .seeAlso( "http://vimdoc.sourceforge.net/htmldoc/uganda.html" )

            .urlInfo( "http://vimdoc.sourceforge.net/htmldoc/uganda.html", "03dc2a471da404470ef443a26d08bfaf12a629aa", "text/html", true, false )
            .urlInfo( "http://www.vimdoc.sourceforge.net/htmldoc/uganda.html", "03dc2a471da404470ef443a26d08bfaf12a629aa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./W3C.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/W3C.json" )
            .name( "W3C Software Notice and License (2002-12-31)" )
            .licenseId( "W3C" )
            .seeAlso( "http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html" )
            .seeAlso( "https://opensource.org/licenses/W3C" )

            .urlInfo( "http://w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "https://w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "https://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/W3C", "b80431e123c8017954c2eb15438d7468b775b71a", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/W3C", "b80431e123c8017954c2eb15438d7468b775b71a", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/W3C", "b80431e123c8017954c2eb15438d7468b775b71a", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/W3C", "b80431e123c8017954c2eb15438d7468b775b71a", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./W3C-19980720.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/W3C-19980720.json" )
            .name( "W3C Software Notice and License (1998-07-20)" )
            .licenseId( "W3C-19980720" )
            .seeAlso( "http://www.w3.org/Consortium/Legal/copyright-software-19980720.html" )

            .urlInfo( "http://w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .urlInfo( "http://www.w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .urlInfo( "https://w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .urlInfo( "https://www.w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./W3C-20150513.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/W3C-20150513.json" )
            .name( "W3C Software Notice and Document License (2015-05-13)" )
            .licenseId( "W3C-20150513" )
            .seeAlso( "https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document" )

            .urlInfo( "http://w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .urlInfo( "http://www.w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .urlInfo( "https://w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .urlInfo( "https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./WTFPL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/WTFPL.json" )
            .name( "Do What The F*ck You Want To Public License" )
            .licenseId( "WTFPL" )
            .seeAlso( "http://sam.zoy.org/wtfpl/COPYING" )

            .urlInfo( "http://sam.zoy.org/wtfpl/COPYING", "337ece375beddfdb7392699fd00eb9b3e823d03f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Watcom-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Watcom-1.0.json" )
            .name( "Sybase Open Watcom Public License 1.0" )
            .licenseId( "Watcom-1.0" )
            .seeAlso( "https://opensource.org/licenses/Watcom-1.0" )

            .urlInfo( "http://opensource.org/licenses/Watcom-1.0", "4f0fb4a3cd8f3fe680f39efe3c7c04808fb95e39", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Watcom-1.0", "4f0fb4a3cd8f3fe680f39efe3c7c04808fb95e39", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Watcom-1.0", "4f0fb4a3cd8f3fe680f39efe3c7c04808fb95e39", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Watcom-1.0", "4f0fb4a3cd8f3fe680f39efe3c7c04808fb95e39", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Wsuipa.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Wsuipa.json" )
            .name( "Wsuipa License" )
            .licenseId( "Wsuipa" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Wsuipa" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Wsuipa", "f0b1f53b5a3e33604d9d06efe31ab82bed60d8aa", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Wsuipa", "f0b1f53b5a3e33604d9d06efe31ab82bed60d8aa", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Wsuipa", "f0b1f53b5a3e33604d9d06efe31ab82bed60d8aa", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Wsuipa", "f0b1f53b5a3e33604d9d06efe31ab82bed60d8aa", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./X11.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/X11.json" )
            .name( "X11 License" )
            .licenseId( "X11" )
            .seeAlso( "http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3" )

            .urlInfo( "http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .urlInfo( "http://xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .urlInfo( "https://www.xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .urlInfo( "https://xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./XFree86-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/XFree86-1.1.json" )
            .name( "XFree86 License 1.1" )
            .licenseId( "XFree86-1.1" )
            .seeAlso( "http://www.xfree86.org/current/LICENSE4.html" )

            .urlInfo( "http://www.xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .urlInfo( "http://xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .urlInfo( "https://www.xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .urlInfo( "https://xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./XSkat.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/XSkat.json" )
            .name( "XSkat License" )
            .licenseId( "XSkat" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/XSkat_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/XSkat_License", "d0716c0abf0b3ff50400ea145f3c58c87fd2c7ea", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/XSkat_License", "d0716c0abf0b3ff50400ea145f3c58c87fd2c7ea", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/XSkat_License", "d0716c0abf0b3ff50400ea145f3c58c87fd2c7ea", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/XSkat_License", "d0716c0abf0b3ff50400ea145f3c58c87fd2c7ea", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Xerox.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Xerox.json" )
            .name( "Xerox License" )
            .licenseId( "Xerox" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Xerox" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Xerox", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Xnet.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Xnet.json" )
            .name( "X.Net License" )
            .licenseId( "Xnet" )
            .seeAlso( "https://opensource.org/licenses/Xnet" )

            .urlInfo( "http://opensource.org/licenses/Xnet", "87f1d18fc34d493540e470d1ea57334e1b118fe3", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Xnet", "87f1d18fc34d493540e470d1ea57334e1b118fe3", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Xnet", "87f1d18fc34d493540e470d1ea57334e1b118fe3", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Xnet", "87f1d18fc34d493540e470d1ea57334e1b118fe3", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./YPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/YPL-1.0.json" )
            .name( "Yahoo! Public License v1.0" )
            .licenseId( "YPL-1.0" )
            .seeAlso( "http://www.zimbra.com/license/yahoo_public_license_1.0.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./YPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/YPL-1.1.json" )
            .name( "Yahoo! Public License v1.1" )
            .licenseId( "YPL-1.1" )
            .seeAlso( "http://www.zimbra.com/license/yahoo_public_license_1.1.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ZPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ZPL-1.1.json" )
            .name( "Zope Public License 1.1" )
            .licenseId( "ZPL-1.1" )
            .seeAlso( "http://old.zope.org/Resources/License/ZPL-1.1" )

            .urlInfo( "http://old.zope.org/Resources/License/ZPL-1.1", "545bd59cf22b63f4b3005a8e192382fadd409a80", "text/html", true, false )
            .urlInfo( "https://old.zope.org/Resources/License/ZPL-1.1", "545bd59cf22b63f4b3005a8e192382fadd409a80", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ZPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ZPL-2.0.json" )
            .name( "Zope Public License 2.0" )
            .licenseId( "ZPL-2.0" )
            .seeAlso( "http://old.zope.org/Resources/License/ZPL-2.0" )
            .seeAlso( "https://opensource.org/licenses/ZPL-2.0" )

            .urlInfo( "http://old.zope.org/Resources/License/ZPL-2.0", "48d0ce3d50083691ba056f531eab912596a2317d", null, true, false )
            .urlInfo( "https://old.zope.org/Resources/License/ZPL-2.0", "48d0ce3d50083691ba056f531eab912596a2317d", null, true, false )
            .urlInfo( "http://opensource.org/licenses/ZPL-2.0", "264d256fa5bf38a8d12dec9b84e294f7074c44cf", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/ZPL-2.0", "264d256fa5bf38a8d12dec9b84e294f7074c44cf", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/ZPL-2.0", "264d256fa5bf38a8d12dec9b84e294f7074c44cf", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/ZPL-2.0", "264d256fa5bf38a8d12dec9b84e294f7074c44cf", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ZPL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ZPL-2.1.json" )
            .name( "Zope Public License 2.1" )
            .licenseId( "ZPL-2.1" )
            .seeAlso( "http://old.zope.org/Resources/ZPL/" )

            .urlInfo( "http://old.zope.org/Resources/ZPL/", "a1553972c0c3eb546dbf4ea440f3723136e1f772", null, true, false )
            .urlInfo( "https://old.zope.org/Resources/ZPL/", "a1553972c0c3eb546dbf4ea440f3723136e1f772", null, true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zed.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Zed.json" )
            .name( "Zed License" )
            .licenseId( "Zed" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Zed" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Zed", "a65d2a1bce0fd52ce63797199a58056e2bf59f6b", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Zed", "a65d2a1bce0fd52ce63797199a58056e2bf59f6b", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Zed", "a65d2a1bce0fd52ce63797199a58056e2bf59f6b", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Zed", "a65d2a1bce0fd52ce63797199a58056e2bf59f6b", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zend-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Zend-2.0.json" )
            .name( "Zend License v2.0" )
            .licenseId( "Zend-2.0" )
            .seeAlso( "https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zimbra-1.3.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Zimbra-1.3.json" )
            .name( "Zimbra Public License v1.3" )
            .licenseId( "Zimbra-1.3" )
            .seeAlso( "http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zimbra-1.4.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Zimbra-1.4.json" )
            .name( "Zimbra Public License v1.4" )
            .licenseId( "Zimbra-1.4" )
            .seeAlso( "http://www.zimbra.com/legal/zimbra-public-license-1-4" )

            .urlInfo( "http://www.zimbra.com/legal/zimbra-public-license-1-4", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zlib.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Zlib.json" )
            .name( "zlib License" )
            .licenseId( "Zlib" )
            .seeAlso( "http://www.zlib.net/zlib_license.html" )
            .seeAlso( "https://opensource.org/licenses/Zlib" )

            .urlInfo( "http://www.zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "http://zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "https://www.zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "https://zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/Zlib", "b458ac76187129bac091a5a83dfd952c9e29f0f3", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/Zlib", "b458ac76187129bac091a5a83dfd952c9e29f0f3", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/Zlib", "b458ac76187129bac091a5a83dfd952c9e29f0f3", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/Zlib", "b458ac76187129bac091a5a83dfd952c9e29f0f3", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./bzip2-1.0.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/bzip2-1.0.5.json" )
            .name( "bzip2 and libbzip2 License v1.0.5" )
            .licenseId( "bzip2-1.0.5" )
            .seeAlso( "http://bzip.org/1.0.5/bzip2-manual-1.0.5.html" )

            .urlInfo( "http://bzip.org/1.0.5/bzip2-manual-1.0.5.html", "9ff709aa4250af8beccd87f1395023767058d32f", "text/html", true, false )
            .urlInfo( "http://www.bzip.org/1.0.5/bzip2-manual-1.0.5.html", "9ff709aa4250af8beccd87f1395023767058d32f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./bzip2-1.0.6.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/bzip2-1.0.6.json" )
            .name( "bzip2 and libbzip2 License v1.0.6" )
            .licenseId( "bzip2-1.0.6" )
            .seeAlso( "https://github.com/asimonov-im/bzip2/blob/master/LICENSE" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./copyleft-next-0.3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/copyleft-next-0.3.0.json" )
            .name( "copyleft-next 0.3.0" )
            .licenseId( "copyleft-next-0.3.0" )
            .seeAlso( "https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./copyleft-next-0.3.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/copyleft-next-0.3.1.json" )
            .name( "copyleft-next 0.3.1" )
            .licenseId( "copyleft-next-0.3.1" )
            .seeAlso( "https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./curl.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/curl.json" )
            .name( "curl License" )
            .licenseId( "curl" )
            .seeAlso( "https://github.com/bagder/curl/blob/master/COPYING" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./diffmark.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/diffmark.json" )
            .name( "diffmark license" )
            .licenseId( "diffmark" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/diffmark" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/diffmark", "83fe481632822e277ac95bb4ddd00f4d7b8f699a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/diffmark", "83fe481632822e277ac95bb4ddd00f4d7b8f699a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/diffmark", "83fe481632822e277ac95bb4ddd00f4d7b8f699a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/diffmark", "83fe481632822e277ac95bb4ddd00f4d7b8f699a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./dvipdfm.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/dvipdfm.json" )
            .name( "dvipdfm License" )
            .licenseId( "dvipdfm" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/dvipdfm" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/dvipdfm", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./eCos-2.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/eCos-2.0.json" )
            .name( "eCos license version 2.0" )
            .licenseId( "eCos-2.0" )
            .seeAlso( "https://www.gnu.org/licenses/ecos-license.html" )

            .urlInfo( "http://gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./eGenix.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/eGenix.json" )
            .name( "eGenix.com Public License 1.1.0" )
            .licenseId( "eGenix" )
            .seeAlso( "http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0" )

            .urlInfo( "http://egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "https://egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "https://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0", "467d7ed7c3fcb297afaa198075871d931dd93e73", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0", "467d7ed7c3fcb297afaa198075871d931dd93e73", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0", "467d7ed7c3fcb297afaa198075871d931dd93e73", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0", "467d7ed7c3fcb297afaa198075871d931dd93e73", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./gSOAP-1.3b.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/gSOAP-1.3b.json" )
            .name( "gSOAP Public License v1.3b" )
            .licenseId( "gSOAP-1.3b" )
            .seeAlso( "http://www.cs.fsu.edu/~engelen/license.html" )

            .urlInfo( "http://www.cs.fsu.edu/~engelen/license.html", "5f4878afcfa16971a9285ae461bf5c01f3f5989d", "text/html", true, false )
            .urlInfo( "https://www.cs.fsu.edu/~engelen/license.html", "5f4878afcfa16971a9285ae461bf5c01f3f5989d", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./gnuplot.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/gnuplot.json" )
            .name( "gnuplot License" )
            .licenseId( "gnuplot" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Gnuplot" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Gnuplot", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./iMatix.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/iMatix.json" )
            .name( "iMatix Standard Function Library Agreement" )
            .licenseId( "iMatix" )
            .seeAlso( "http://legacy.imatix.com/html/sfl/sfl4.htm#license" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./libtiff.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/libtiff.json" )
            .name( "libtiff License" )
            .licenseId( "libtiff" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/libtiff" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/libtiff", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./mpich2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/mpich2.json" )
            .name( "mpich2 License" )
            .licenseId( "mpich2" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./psfrag.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/psfrag.json" )
            .name( "psfrag License" )
            .licenseId( "psfrag" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/psfrag" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/psfrag", "222683436f3cef3f2ff17f00f68cb16c42a641a2", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/psfrag", "222683436f3cef3f2ff17f00f68cb16c42a641a2", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/psfrag", "222683436f3cef3f2ff17f00f68cb16c42a641a2", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/psfrag", "222683436f3cef3f2ff17f00f68cb16c42a641a2", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./psutils.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/psutils.json" )
            .name( "psutils License" )
            .licenseId( "psutils" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/psutils" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/psutils", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./wxWindows.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/wxWindows.json" )
            .name( "wxWindows Library License" )
            .licenseId( "wxWindows" )
            .seeAlso( "https://opensource.org/licenses/WXwindows" )

            .urlInfo( "http://opensource.org/licenses/WXwindows", "46e5939d23b7bde744849479ad16f7ab67237e7c", "text/html", true, true )
            .urlInfo( "http://www.opensource.org/licenses/WXwindows", "46e5939d23b7bde744849479ad16f7ab67237e7c", "text/html", true, true )
            .urlInfo( "https://opensource.org/licenses/WXwindows", "46e5939d23b7bde744849479ad16f7ab67237e7c", "text/html", true, true )
            .urlInfo( "https://www.opensource.org/licenses/WXwindows", "46e5939d23b7bde744849479ad16f7ab67237e7c", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./xinetd.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/xinetd.json" )
            .name( "xinetd License" )
            .licenseId( "xinetd" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Xinetd_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Xinetd_License", "6345858ba6ab8e66fd205908b8a8ebd66ec5093e", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Xinetd_License", "6345858ba6ab8e66fd205908b8a8ebd66ec5093e", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Xinetd_License", "6345858ba6ab8e66fd205908b8a8ebd66ec5093e", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Xinetd_License", "6345858ba6ab8e66fd205908b8a8ebd66ec5093e", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./xpp.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/xpp.json" )
            .name( "XPP License" )
            .licenseId( "xpp" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/xpp" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/xpp", "1087e4c3bad5ae17dbd55658ed505ff5107765a2", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/xpp", "1087e4c3bad5ae17dbd55658ed505ff5107765a2", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/xpp", "1087e4c3bad5ae17dbd55658ed505ff5107765a2", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/xpp", "1087e4c3bad5ae17dbd55658ed505ff5107765a2", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./zlib-acknowledgement.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/zlib-acknowledgement.json" )
            .name( "zlib/libpng License with Acknowledgement" )
            .licenseId( "zlib-acknowledgement" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.releaseDate( "2019-02-22" );

        builder.urlReplacement( "archive.org-0", "(archive\\.org/web/[0-9]+)/", "$1id_/" );
        builder.urlReplacement( "git.kernel.org-0", "https?://git\\.kernel\\.org/pub/scm/linux/([^/]+)/git/torvalds/linux\\.git/tree/(.*)", "https://git.kernel.org/pub/scm/linux/$1/git/torvalds/linux.git/plain/$2" );
        builder.urlReplacement( "git.savannah.gnu.org-0", "https?://git\\.savannah\\.gnu\\.org/cgit/(.*)\\.git/tree/(.*)", "http://git.savannah.gnu.org/cgit/$1.git/plain/$2" );
        builder.urlReplacement( "github.com-0", "https?://github\\.com/([^/]+)/([^/]+)/blob/(.*)", "https://raw.githubusercontent.com/$1/$2/$3" );
        builder.urlReplacement( "github.com/aws/mit-0", ".*github\\.com/aws/mit-0", "https://raw.githubusercontent.com/aws/mit-0/master/MIT-0" );
        builder.urlReplacement( "microsoft.com/opensource/licenses.mspx", ".*microsoft\\.com/opensource/licenses\\.mspx", "https://web.archive.org/web/20150619132250id_/http://www.microsoft.com/en-us/openness/licenses.aspx" );

        builder.contentSanitizer( "artlibre.org-0", ".*artlibre\\.org.*", "<!-- Dynamic page generated in [^\\-]+ -->", "" );
        builder.contentSanitizer( "artlibre.org-1", ".*artlibre\\.org.*", "<!-- Cached page generated by WP-Super-Cache on [^\\>]+ -->", "" );
        builder.contentSanitizer( "codeproject.com-0", ".*codeproject\\.com.*", ">[^<]+members<", "><" );
        builder.contentSanitizer( "codeproject.com-1", ".*codeproject\\.com.*", "<div class=\"promo\">[^\\n]+", "" );
        builder.contentSanitizer( "codeproject.com-2", ".*codeproject\\.com.*", "<div class=\"msg-728x90\"[^\\n]+", "" );
        builder.contentSanitizer( "codeproject.com-3", ".*codeproject\\.com.*", "<br />\\s*[^\\s]+\\s*\\|\\s*[^\\s]+\\s*\\|", "" );
        builder.contentSanitizer( "creativecommons.org-0", ".*creativecommons\\.org.*", "\\n ", "\\n" );
        builder.contentSanitizer( "data.norge.no-0", ".*data\\.norge\\.no.*", "jQuery\\.extend\\(Drupal\\.settings[^\\n]+", "" );
        builder.contentSanitizer( "data.norge.no-1", ".*data\\.norge\\.no.*", "value=\"form-[^\"]*\"", "" );
        builder.contentSanitizer( "data.norge.no-2", ".*data\\.norge\\.no.*", "view-dom-id-[0-9a-f]{12}", "" );
        builder.contentSanitizer( "directory.fsf.org-0", ".*directory\\.fsf\\.org.*", "\"wgRequestId\":\"[^\"]*\"", "\"wgRequestId\":\"\"" );
        builder.contentSanitizer( "directory.fsf.org-1", ".*directory\\.fsf\\.org.*", "\"wgBackendResponseTime\":[0-9]+", "\"wgBackendResponseTime\":0" );
        builder.contentSanitizer( "eu-datagrid.web.cern.ch-0", ".*eu-datagrid\\.web\\.cern\\.ch.*", "wct=[^&\"]+", "wct=" );
        builder.contentSanitizer( "fedoraproject.org-0", ".*fedoraproject\\.org.*", "\"wgRequestId\":\"[^\"]*\"", "\"wgRequestId\":\"\"" );
        builder.contentSanitizer( "fedoraproject.org-1", ".*fedoraproject\\.org.*", "\"wgBackendResponseTime\":[0-9]+", "\"wgBackendResponseTime\":0" );
        builder.contentSanitizer( "gianluca.dellavedova.org-0", ".*gianluca\\.dellavedova\\.org.*", "<script src='https://r-login\\.wordpress\\.com[^\\n]*", "" );
        builder.contentSanitizer( "gianluca.dellavedova.org-1", ".*gianluca\\.dellavedova\\.org.*", "type=\"[0-9a-f]+-text/javascript\"", "type=\"text/javascript\"" );
        builder.contentSanitizer( "gianluca.dellavedova.org-2", ".*gianluca\\.dellavedova\\.org.*", "data-cf-modified-[^\\-]+-", "data-cf-modified--" );
        builder.contentSanitizer( "gianluca.dellavedova.org-3", ".*gianluca\\.dellavedova\\.org.*", "atatags-[^\\-\"]+-[^\\-\"]+", "atatags--" );
        builder.contentSanitizer( "joinup.ec.europa.eu-0", ".*joinup\\.ec\\.europa\\.eu.*", "<script type=\"text/javascript\">window\\.NREUM[^\\n]*</script>", "" );
        builder.contentSanitizer( "opencascade.org-0", ".*opencascade\\.com.*", "jQuery\\.extend\\(Drupal\\.settings[^\\n]+", "" );
        builder.contentSanitizer( "opencascade.org-1", ".*opencascade\\.com.*", "value=\"form-[^\"]*\"", "" );
        builder.contentSanitizer( "opensource.org-0", ".*opensource\\.org.*", "jQuery\\.extend\\(Drupal\\.settings[^\\n]+", "" );
        builder.contentSanitizer( "opensource.org-1", ".*opensource\\.org.*", "value=\"form-[^\"]*\"", "" );
        builder.contentSanitizer( "opensource.org-2", ".*opensource\\.org.*", "<form action=\"/licenses/[^\"]*\"", "<form action=\"\"" );
        builder.contentSanitizer( "romanrm.net-0", ".*romanrm.net/mit-zero", "src=\"/lib/exe/indexer\\.php\\?id=mit-zero&amp;[0-9]+\"", "" );
        builder.contentSanitizer( "tcl.tk-0", ".*tcl\\.tk.*", "email-protection#[0-9a-f]+", "email-protection" );
        builder.contentSanitizer( "tcl.tk-1", ".*tcl\\.tk.*", "data-cfemail=\"[^\"]+\"", "data-cfemail=\"\"" );
        builder.contentSanitizer( "users.on.net/~triforce-0", ".*users\\.on\\.net/~triforce/glidexp/COPYING\\.txt", "[0-9]+ queries[^\\-]", "" );
        builder.contentSanitizer( "users.on.net/~triforce-1", ".*users\\.on\\.net/~triforce/glidexp/COPYING\\.txt", "<!-- [^\\-<>]+ in [^\\-<>]+ -->", "" );
        builder.contentSanitizer( "zimbra.com-0", ".*zimbra\\.com.*", "Compiled on [^D]+ - Do not edit", "" );

        return builder.build();
    }
}
