/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header;

import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.Copyright;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileHeaderFilter.class, hint="update-file-header")
public class UpdateFileHeaderFilter
extends FileHeaderFilter {
    protected boolean updateDescription;
    protected boolean updateLicense;
    protected boolean updateCopyright;

    protected FileHeader getNewHeader(FileHeader oldHeader) {
        FileHeader result = new FileHeader();
        FileHeader newHeader = this.getFileHeader();
        FileHeaderTransformer transformer = this.getTransformer();
        boolean modified = false;
        result.setDescription(oldHeader.getDescription());
        result.setCopyright(new Copyright(oldHeader.getCopyright()));
        result.setLicense(oldHeader.getLicense());
        if (this.isUpdateDescription() && !transformer.isDescriptionEquals(oldHeader, newHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("description has changed from [" + oldHeader.getDescription() + "] to [" + newHeader.getDescription() + "]"));
            }
            modified = true;
            result.setDescription(newHeader.getDescription());
        }
        if (this.isUpdateCopyright() && !transformer.isCopyrightEquals(oldHeader, newHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("copyright has changed from [" + oldHeader.getCopyright() + "] to [" + newHeader.getCopyright() + "]"));
            }
            modified = true;
            result.setCopyright(new Copyright(newHeader.getCopyright()));
        }
        if (this.isUpdateLicense() && !transformer.isLicenseEquals(oldHeader, newHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("license has changed from [" + oldHeader.getLicense() + "] to [" + newHeader.getLicense() + "]"));
            }
            modified = true;
            result.setLicense(newHeader.getLicense());
        }
        if (!modified) {
            result = null;
        }
        return result;
    }

    public boolean isUpdateCopyright() {
        return this.updateCopyright;
    }

    public void setUpdateCopyright(boolean updateCopyright) {
        this.updateCopyright = updateCopyright;
    }

    public boolean isUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(boolean updateDescription) {
        this.updateDescription = updateDescription;
    }

    public boolean isUpdateLicense() {
        return this.updateLicense;
    }

    public void setUpdateLicense(boolean updateLicense) {
        this.updateLicense = updateLicense;
    }
}

