package org.codehaus.mojo.license.spdx;

/*
 * #%L
 * License Maven Plugin
 * %%
 * Copyright (C) 2019 Codehaus
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * A class generated by GenerateSpdxLicenseList.groovy from
 * <a href="https://raw.githubusercontent.com/spdx/license-list-data/v3.5/json/licenses.json">
 * https://raw.githubusercontent.com/spdx/license-list-data/v3.5/json/licenses.json</a>
 */
class SpdxLicenseListData
{

    static SpdxLicenseList createList()
    {
        final SpdxLicenseList.Builder builder = SpdxLicenseList.builder();
        builder.licenseListVersion( "3.5" );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./0BSD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/0BSD.json" )
            .name( "BSD Zero Clause License" )
            .licenseId( "0BSD" )
            .seeAlso( "http://landley.net/toybox/license.html" )

            .urlInfo( "http://landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .urlInfo( "http://www.landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .urlInfo( "https://landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .urlInfo( "https://www.landley.net/toybox/license.html", "4b6f12065895f739dd7c82cb587520bdfa967a30", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AAL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AAL.json" )
            .name( "Attribution Assurance License" )
            .licenseId( "AAL" )
            .seeAlso( "https://opensource.org/licenses/attribution" )

            .urlInfo( "http://opensource.org/licenses/attribution", "3d2f40f1c2ba730a6448dcc327fc9720ee6017c3", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/attribution", "3d2f40f1c2ba730a6448dcc327fc9720ee6017c3", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/attribution", "3d2f40f1c2ba730a6448dcc327fc9720ee6017c3", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/attribution", "3d2f40f1c2ba730a6448dcc327fc9720ee6017c3", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ADSL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ADSL.json" )
            .name( "Amazon Digital Services License" )
            .licenseId( "ADSL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense", "bee57e8bbf4f0b6a69b18fedd1829cd886d327e4", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense", "bee57e8bbf4f0b6a69b18fedd1829cd886d327e4", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense", "bee57e8bbf4f0b6a69b18fedd1829cd886d327e4", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense", "bee57e8bbf4f0b6a69b18fedd1829cd886d327e4", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-1.1.json" )
            .name( "Academic Free License v1.1" )
            .licenseId( "AFL-1.1" )
            .seeAlso( "http://opensource.linux-mirror.org/licenses/afl-1.1.txt" )
            .seeAlso( "http://wayback.archive.org/web/20021004124254/http://www.opensource.org/licenses/academic.php" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-1.2.json" )
            .name( "Academic Free License v1.2" )
            .licenseId( "AFL-1.2" )
            .seeAlso( "http://opensource.linux-mirror.org/licenses/afl-1.2.txt" )
            .seeAlso( "http://wayback.archive.org/web/20021204204652/http://www.opensource.org/licenses/academic.php" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-2.0.json" )
            .name( "Academic Free License v2.0" )
            .licenseId( "AFL-2.0" )
            .seeAlso( "http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-2.1.json" )
            .name( "Academic Free License v2.1" )
            .licenseId( "AFL-2.1" )
            .seeAlso( "http://opensource.linux-mirror.org/licenses/afl-2.1.txt" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AFL-3.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AFL-3.0.json" )
            .name( "Academic Free License v3.0" )
            .licenseId( "AFL-3.0" )
            .seeAlso( "http://www.rosenlaw.com/AFL3.0.htm" )
            .seeAlso( "https://opensource.org/licenses/afl-3.0" )

            .urlInfo( "http://opensource.org/licenses/afl-3.0", "50b7352f72a53c100508fb0e04d96ebbe8e47391", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/afl-3.0", "50b7352f72a53c100508fb0e04d96ebbe8e47391", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/afl-3.0", "50b7352f72a53c100508fb0e04d96ebbe8e47391", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/afl-3.0", "50b7352f72a53c100508fb0e04d96ebbe8e47391", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-1.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-1.0.json" )
            .name( "Affero General Public License v1.0" )
            .licenseId( "AGPL-1.0" )
            .seeAlso( "http://www.affero.org/oagpl.html" )

            .urlInfo( "http://affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .urlInfo( "http://www.affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-1.0-only.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AGPL-1.0-only.json" )
            .name( "Affero General Public License v1.0 only" )
            .licenseId( "AGPL-1.0-only" )
            .seeAlso( "http://www.affero.org/oagpl.html" )

            .urlInfo( "http://affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .urlInfo( "http://www.affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-1.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AGPL-1.0-or-later.json" )
            .name( "Affero General Public License v1.0 or later" )
            .licenseId( "AGPL-1.0-or-later" )
            .seeAlso( "http://www.affero.org/oagpl.html" )

            .urlInfo( "http://affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .urlInfo( "http://www.affero.org/oagpl.html", "0ba5dd35099f6315cfdca991c0ebab4bc629dd14", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-3.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-3.0.json" )
            .name( "GNU Affero General Public License v3.0" )
            .licenseId( "AGPL-3.0" )
            .seeAlso( "https://www.gnu.org/licenses/agpl.txt" )
            .seeAlso( "https://opensource.org/licenses/AGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-3.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-3.0-only.json" )
            .name( "GNU Affero General Public License v3.0 only" )
            .licenseId( "AGPL-3.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/agpl.txt" )
            .seeAlso( "https://opensource.org/licenses/AGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AGPL-3.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/AGPL-3.0-or-later.json" )
            .name( "GNU Affero General Public License v3.0 or later" )
            .licenseId( "AGPL-3.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/agpl.txt" )
            .seeAlso( "https://opensource.org/licenses/AGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/agpl.txt", "4c665f87b5dc2e7d26279c4b48968d085e1ace32", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/AGPL-3.0", "be48d9bfd989e9e77f96dd28c7ccf601ed50f381", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AMDPLPA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AMDPLPA.json" )
            .name( "AMD's plpa_map.c License" )
            .licenseId( "AMDPLPA" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "cb0052100768dc7e52a3da34da946b34a3259b66", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "cb0052100768dc7e52a3da34da946b34a3259b66", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "cb0052100768dc7e52a3da34da946b34a3259b66", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/AMD_plpa_map_License", "cb0052100768dc7e52a3da34da946b34a3259b66", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AML.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AML.json" )
            .name( "Apple MIT License" )
            .licenseId( "AML" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Apple_MIT_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Apple_MIT_License", "c55e94054fba1dc49f41ff120388fb2c64554027", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Apple_MIT_License", "c55e94054fba1dc49f41ff120388fb2c64554027", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Apple_MIT_License", "c55e94054fba1dc49f41ff120388fb2c64554027", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Apple_MIT_License", "c55e94054fba1dc49f41ff120388fb2c64554027", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./AMPAS.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/AMPAS.json" )
            .name( "Academy of Motion Picture Arts and Sciences BSD" )
            .licenseId( "AMPAS" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ANTLR-PD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ANTLR-PD.json" )
            .name( "ANTLR Software Rights Notice" )
            .licenseId( "ANTLR-PD" )
            .seeAlso( "http://www.antlr2.org/license.html" )

            .urlInfo( "http://antlr2.org/license.html", "ff217bee0b3bec01a758737818bacb25dfbd6afe", "text/html", true, false )
            .urlInfo( "http://www.antlr2.org/license.html", "ff217bee0b3bec01a758737818bacb25dfbd6afe", "text/html", true, false )
            .urlInfo( "https://www.antlr2.org/license.html", "ff217bee0b3bec01a758737818bacb25dfbd6afe", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APAFML.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APAFML.json" )
            .name( "Adobe Postscript AFM License" )
            .licenseId( "APAFML" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "81ba32695de3c956d9890528ed12599b7eb1a250", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "81ba32695de3c956d9890528ed12599b7eb1a250", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "81ba32695de3c956d9890528ed12599b7eb1a250", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/AdobePostscriptAFM", "81ba32695de3c956d9890528ed12599b7eb1a250", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APL-1.0.json" )
            .name( "Adaptive Public License 1.0" )
            .licenseId( "APL-1.0" )
            .seeAlso( "https://opensource.org/licenses/APL-1.0" )

            .urlInfo( "http://opensource.org/licenses/APL-1.0", "4f473ae5e894bb26652a7511fb8c3b13da0362e7", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/APL-1.0", "4f473ae5e894bb26652a7511fb8c3b13da0362e7", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/APL-1.0", "4f473ae5e894bb26652a7511fb8c3b13da0362e7", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/APL-1.0", "4f473ae5e894bb26652a7511fb8c3b13da0362e7", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APSL-1.0.json" )
            .name( "Apple Public Source License 1.0" )
            .licenseId( "APSL-1.0" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "540db8bb93326a868af04c0bcd2a7d36de1d56e4", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "540db8bb93326a868af04c0bcd2a7d36de1d56e4", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "540db8bb93326a868af04c0bcd2a7d36de1d56e4", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0", "540db8bb93326a868af04c0bcd2a7d36de1d56e4", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APSL-1.1.json" )
            .name( "Apple Public Source License 1.1" )
            .licenseId( "APSL-1.1" )
            .seeAlso( "http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE" )

            .urlInfo( "http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE", "ee2b2438e398cfe8568a1826ff18fff4aff2b3a7", "text/plain", true, false )
            .urlInfo( "https://opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE", "ee2b2438e398cfe8568a1826ff18fff4aff2b3a7", "text/plain", true, false )
            .urlInfo( "https://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE", "ee2b2438e398cfe8568a1826ff18fff4aff2b3a7", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/APSL-1.2.json" )
            .name( "Apple Public Source License 1.2" )
            .licenseId( "APSL-1.2" )
            .seeAlso( "http://www.samurajdata.se/opensource/mirror/licenses/apsl.php" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./APSL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/APSL-2.0.json" )
            .name( "Apple Public Source License 2.0" )
            .licenseId( "APSL-2.0" )
            .seeAlso( "http://www.opensource.apple.com/license/apsl/" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Abstyles.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Abstyles.json" )
            .name( "Abstyles License" )
            .licenseId( "Abstyles" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Abstyles" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Abstyles", "c00b5519a8f317ed8aa53589c1d8445c3ef844ac", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Abstyles", "c00b5519a8f317ed8aa53589c1d8445c3ef844ac", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Abstyles", "c00b5519a8f317ed8aa53589c1d8445c3ef844ac", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Abstyles", "c00b5519a8f317ed8aa53589c1d8445c3ef844ac", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Adobe-2006.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Adobe-2006.json" )
            .name( "Adobe Systems Incorporated Source Code License Agreement" )
            .licenseId( "Adobe-2006" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/AdobeLicense" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/AdobeLicense", "2d1b5e03b12bcf28be788a3863fdf8f8fcf2dfba", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/AdobeLicense", "2d1b5e03b12bcf28be788a3863fdf8f8fcf2dfba", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/AdobeLicense", "2d1b5e03b12bcf28be788a3863fdf8f8fcf2dfba", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/AdobeLicense", "2d1b5e03b12bcf28be788a3863fdf8f8fcf2dfba", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Adobe-Glyph.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Adobe-Glyph.json" )
            .name( "Adobe Glyph List License" )
            .licenseId( "Adobe-Glyph" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Afmparse.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Afmparse.json" )
            .name( "Afmparse License" )
            .licenseId( "Afmparse" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Afmparse" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Afmparse", "f24d79e15fc8608636d2dbc15095444a25f63192", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Afmparse", "f24d79e15fc8608636d2dbc15095444a25f63192", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Afmparse", "f24d79e15fc8608636d2dbc15095444a25f63192", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Afmparse", "f24d79e15fc8608636d2dbc15095444a25f63192", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Aladdin.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Aladdin.json" )
            .name( "Aladdin Free Public License" )
            .licenseId( "Aladdin" )
            .seeAlso( "http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm" )

            .urlInfo( "http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm", "c38fdbb75a01231de6a9d8315fbdd2a4f897b0ee", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Apache-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Apache-1.0.json" )
            .name( "Apache License 1.0" )
            .licenseId( "Apache-1.0" )
            .seeAlso( "http://www.apache.org/licenses/LICENSE-1.0" )

            .urlInfo( "http://apache.org/licenses/LICENSE-1.0", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "http://apache.org/licenses/LICENSE-1.0.txt", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-1.0", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-1.0.txt", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-1.0", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-1.0.txt", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-1.0", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-1.0.txt", "07bcce2cb78c8cb063a5cd93ef19cf645e724462", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Apache-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Apache-1.1.json" )
            .name( "Apache License 1.1" )
            .licenseId( "Apache-1.1" )
            .seeAlso( "http://apache.org/licenses/LICENSE-1.1" )
            .seeAlso( "https://opensource.org/licenses/Apache-1.1" )

            .urlInfo( "http://apache.org/licenses/LICENSE-1.1", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "http://apache.org/licenses/LICENSE-1.1.txt", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-1.1", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-1.1.txt", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-1.1", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-1.1.txt", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-1.1", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-1.1.txt", "9bb549e965aa70ab30dbd2949a773f49099ae629", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/Apache-1.1", "18606c49f9b34512c4e45f05975259c137be5c56", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Apache-1.1", "18606c49f9b34512c4e45f05975259c137be5c56", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Apache-1.1", "18606c49f9b34512c4e45f05975259c137be5c56", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Apache-1.1", "18606c49f9b34512c4e45f05975259c137be5c56", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Apache-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Apache-2.0.json" )
            .name( "Apache License 2.0" )
            .licenseId( "Apache-2.0" )
            .seeAlso( "http://www.apache.org/licenses/LICENSE-2.0" )
            .seeAlso( "https://opensource.org/licenses/Apache-2.0" )

            .urlInfo( "http://apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "http://apache.org/licenses/LICENSE-2.0.txt", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "http://www.apache.org/licenses/LICENSE-2.0.txt", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "https://apache.org/licenses/LICENSE-2.0.txt", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-2.0", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "https://www.apache.org/licenses/LICENSE-2.0.txt", "2b8b815229aa8a61e483fb4ba0588b8b6c491890", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/Apache-2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/apache2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/apache2.0.html", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/apache2.0.php", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Apache-2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/apache2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/apache2.0.html", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/apache2.0.php", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Apache-2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/apache2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/apache2.0.html", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/apache2.0.php", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Apache-2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/apache2.0", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/apache2.0.html", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/apache2.0.php", "efbdca62537c501650377fe25a4b03e166d8c3b2", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Artistic-1.0.json" )
            .name( "Artistic License 1.0" )
            .licenseId( "Artistic-1.0" )
            .seeAlso( "https://opensource.org/licenses/Artistic-1.0" )

            .urlInfo( "http://opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-1.0-Perl.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Artistic-1.0-Perl.json" )
            .name( "Artistic License 1.0 (Perl)" )
            .licenseId( "Artistic-1.0-Perl" )
            .seeAlso( "http://dev.perl.org/licenses/artistic.html" )

            .urlInfo( "http://dev.perl.org/licenses/artistic.html", "10aab5372b3fde865b62d3c0047f824f17c49a8d", "text/html", true, false )
            .urlInfo( "https://dev.perl.org/licenses/artistic.html", "10aab5372b3fde865b62d3c0047f824f17c49a8d", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-1.0-cl8.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Artistic-1.0-cl8.json" )
            .name( "Artistic License 1.0 w/clause 8" )
            .licenseId( "Artistic-1.0-cl8" )
            .seeAlso( "https://opensource.org/licenses/Artistic-1.0" )

            .urlInfo( "http://opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Artistic-1.0", "65a6ca3a3a8d078cea781fbf4e21e71d022426f0", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Artistic-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Artistic-2.0.json" )
            .name( "Artistic License 2.0" )
            .licenseId( "Artistic-2.0" )
            .seeAlso( "http://www.perlfoundation.org/artistic_license_2_0" )
            .seeAlso( "https://opensource.org/licenses/artistic-license-2.0" )

            .urlInfo( "http://perlfoundation.org/artistic_license_2_0", "2aa74311fcf75af8005e37705f49552b9010a2db", "text/html", true, false )
            .urlInfo( "http://www.perlfoundation.org/artistic_license_2_0", "2aa74311fcf75af8005e37705f49552b9010a2db", "text/html", true, false )
            .urlInfo( "https://perlfoundation.org/artistic_license_2_0", "2aa74311fcf75af8005e37705f49552b9010a2db", "text/html", true, false )
            .urlInfo( "https://www.perlfoundation.org/artistic_license_2_0", "2aa74311fcf75af8005e37705f49552b9010a2db", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/artistic-license-2.0", "29e7bfae77279c8d36f6fb64c5b500dc3ee174b4", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/artistic-license-2.0", "29e7bfae77279c8d36f6fb64c5b500dc3ee174b4", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/artistic-license-2.0", "29e7bfae77279c8d36f6fb64c5b500dc3ee174b4", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/artistic-license-2.0", "29e7bfae77279c8d36f6fb64c5b500dc3ee174b4", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-1-Clause.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-1-Clause.json" )
            .name( "BSD 1-Clause License" )
            .licenseId( "BSD-1-Clause" )
            .seeAlso( "https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823" )

            .urlInfo( "http://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823", "0c025021376b31ef1c4920f5ae3428d3eeb1fa50", "text/plain", true, false )
            .urlInfo( "https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823", "0c025021376b31ef1c4920f5ae3428d3eeb1fa50", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause.json" )
            .name( "BSD 2-Clause \"Simplified\" License" )
            .licenseId( "BSD-2-Clause" )
            .seeAlso( "https://opensource.org/licenses/BSD-2-Clause" )

            .urlInfo( "http://opensource.org/licenses/BSD-2-Clause", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/bsd-license", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/bsd-license.html", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/bsd-license.php", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/BSD-2-Clause", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/bsd-license", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/bsd-license.html", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/bsd-license.php", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/BSD-2-Clause", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/bsd-license", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/bsd-license.html", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/bsd-license.php", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/BSD-2-Clause", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/bsd-license", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/bsd-license.html", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/bsd-license.php", "3691ecd9ecce87fd6b145a4de2d5aa63130ab3c9", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause-FreeBSD.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause-FreeBSD.json" )
            .name( "BSD 2-Clause FreeBSD License" )
            .licenseId( "BSD-2-Clause-FreeBSD" )
            .seeAlso( "http://www.freebsd.org/copyright/freebsd-license.html" )

            .urlInfo( "http://freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .urlInfo( "http://www.freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .urlInfo( "https://freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .urlInfo( "https://www.freebsd.org/copyright/freebsd-license.html", "3af3bbf5ed5334001ee30e7d2b81be1b043db629", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause-NetBSD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause-NetBSD.json" )
            .name( "BSD 2-Clause NetBSD License" )
            .licenseId( "BSD-2-Clause-NetBSD" )
            .seeAlso( "http://www.netbsd.org/about/redistribution.html#default" )

            .urlInfo( "http://netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .urlInfo( "http://www.netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .urlInfo( "https://netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .urlInfo( "https://www.netbsd.org/about/redistribution.html#default", "d1a528d65fffa3a4ac8bf9e30305b2b405007e46", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-2-Clause-Patent.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-2-Clause-Patent.json" )
            .name( "BSD-2-Clause Plus Patent License" )
            .licenseId( "BSD-2-Clause-Patent" )
            .seeAlso( "https://opensource.org/licenses/BSDplusPatent" )

            .urlInfo( "http://opensource.org/licenses/BSDplusPatent", "8a77f299f28986a93af128d28ce8292fa00a207b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/BSDplusPatent", "8a77f299f28986a93af128d28ce8292fa00a207b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/BSDplusPatent", "8a77f299f28986a93af128d28ce8292fa00a207b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/BSDplusPatent", "8a77f299f28986a93af128d28ce8292fa00a207b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause.json" )
            .name( "BSD 3-Clause \"New\" or \"Revised\" License" )
            .licenseId( "BSD-3-Clause" )
            .seeAlso( "https://opensource.org/licenses/BSD-3-Clause" )

            .urlInfo( "http://opensource.org/licenses/BSD-3-Clause", "b9a0fe3005500a72151d223684b818dd73bf3078", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/BSD-3-Clause", "b9a0fe3005500a72151d223684b818dd73bf3078", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/BSD-3-Clause", "b9a0fe3005500a72151d223684b818dd73bf3078", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/BSD-3-Clause", "b9a0fe3005500a72151d223684b818dd73bf3078", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-Attribution.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-Attribution.json" )
            .name( "BSD with attribution" )
            .licenseId( "BSD-3-Clause-Attribution" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-Clear.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-Clear.json" )
            .name( "BSD 3-Clause Clear License" )
            .licenseId( "BSD-3-Clause-Clear" )
            .seeAlso( "http://labs.metacarta.com/license-explanation.html#license" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-LBNL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-LBNL.json" )
            .name( "Lawrence Berkeley National Labs BSD variant license" )
            .licenseId( "BSD-3-Clause-LBNL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/LBNLBSD" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/LBNLBSD", "f107ca803195f4824e3bac77bc3d2ed75b16bee3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/LBNLBSD", "f107ca803195f4824e3bac77bc3d2ed75b16bee3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/LBNLBSD", "f107ca803195f4824e3bac77bc3d2ed75b16bee3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/LBNLBSD", "f107ca803195f4824e3bac77bc3d2ed75b16bee3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-No-Nuclear-License.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.json" )
            .name( "BSD 3-Clause No Nuclear License" )
            .licenseId( "BSD-3-Clause-No-Nuclear-License" )
            .seeAlso( "http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-No-Nuclear-License-2014.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.json" )
            .name( "BSD 3-Clause No Nuclear License 2014" )
            .licenseId( "BSD-3-Clause-No-Nuclear-License-2014" )
            .seeAlso( "https://java.net/projects/javaeetutorial/pages/BerkeleyLicense" )

            .urlInfo( "http://java.net/projects/javaeetutorial/pages/BerkeleyLicense", "75c018e5b34ba1adce64325cc1250a7689814c27", "text/html", true, false )
            .urlInfo( "https://java.net/projects/javaeetutorial/pages/BerkeleyLicense", "75c018e5b34ba1adce64325cc1250a7689814c27", "text/html", true, false )
            .urlInfo( "https://www.java.net/projects/javaeetutorial/pages/BerkeleyLicense", "75c018e5b34ba1adce64325cc1250a7689814c27", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-3-Clause-No-Nuclear-Warranty.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.json" )
            .name( "BSD 3-Clause No Nuclear Warranty" )
            .licenseId( "BSD-3-Clause-No-Nuclear-Warranty" )
            .seeAlso( "https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt" )

            .urlInfo( "http://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .urlInfo( "http://www.jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .urlInfo( "https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .urlInfo( "https://www.jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt", "f4a50b594d0dca2c631d5e803b971713e1b8aad2", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-4-Clause.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSD-4-Clause.json" )
            .name( "BSD 4-Clause \"Original\" or \"Old\" License" )
            .licenseId( "BSD-4-Clause" )
            .seeAlso( "http://directory.fsf.org/wiki/License:BSD_4Clause" )

            .urlInfo( "http://directory.fsf.org/wiki/License:BSD_4Clause", "0b20ca3cc475ced7071f8f137d5fb8c0020bbed3", "text/html", true, true )
            .urlInfo( "https://directory.fsf.org/wiki/License:BSD_4Clause", "0b20ca3cc475ced7071f8f137d5fb8c0020bbed3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-4-Clause-UC.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-4-Clause-UC.json" )
            .name( "BSD-4-Clause (University of California-Specific)" )
            .licenseId( "BSD-4-Clause-UC" )
            .seeAlso( "http://www.freebsd.org/copyright/license.html" )

            .urlInfo( "http://freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .urlInfo( "http://www.freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .urlInfo( "https://freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .urlInfo( "https://www.freebsd.org/copyright/license.html", "8c53ff4279202ca631c5538b0ba316d6bc95e1e3", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-Protection.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-Protection.json" )
            .name( "BSD Protection License" )
            .licenseId( "BSD-Protection" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/BSD_Protection_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/BSD_Protection_License", "b8e72b3aa43ded00f63d78806ebf14c72cd62302", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/BSD_Protection_License", "b8e72b3aa43ded00f63d78806ebf14c72cd62302", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/BSD_Protection_License", "b8e72b3aa43ded00f63d78806ebf14c72cd62302", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/BSD_Protection_License", "b8e72b3aa43ded00f63d78806ebf14c72cd62302", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSD-Source-Code.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BSD-Source-Code.json" )
            .name( "BSD Source Code Attribution" )
            .licenseId( "BSD-Source-Code" )
            .seeAlso( "https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BSL-1.0.json" )
            .name( "Boost Software License 1.0" )
            .licenseId( "BSL-1.0" )
            .seeAlso( "http://www.boost.org/LICENSE_1_0.txt" )
            .seeAlso( "https://opensource.org/licenses/BSL-1.0" )

            .urlInfo( "http://boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "http://www.boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "https://boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "https://www.boost.org/LICENSE_1_0.txt", "3cba29011be2b9d59f6204d6fa0a386b1b2dbd90", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/BSL-1.0", "ee439b84bb4b077bee9a4f9998c9a8b67858b3c5", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/BSL-1.0", "ee439b84bb4b077bee9a4f9998c9a8b67858b3c5", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/BSL-1.0", "ee439b84bb4b077bee9a4f9998c9a8b67858b3c5", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/BSL-1.0", "ee439b84bb4b077bee9a4f9998c9a8b67858b3c5", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Bahyph.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Bahyph.json" )
            .name( "Bahyph License" )
            .licenseId( "Bahyph" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Bahyph" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Bahyph", "575b493b013b9d8e0bb3f19462f00ee4704f9d6d", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Bahyph", "575b493b013b9d8e0bb3f19462f00ee4704f9d6d", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Bahyph", "575b493b013b9d8e0bb3f19462f00ee4704f9d6d", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Bahyph", "575b493b013b9d8e0bb3f19462f00ee4704f9d6d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Barr.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Barr.json" )
            .name( "Barr License" )
            .licenseId( "Barr" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Barr" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Barr", "8c941d32a6ff7d840410ca8fa5fee3bacd8d9946", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Barr", "8c941d32a6ff7d840410ca8fa5fee3bacd8d9946", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Barr", "8c941d32a6ff7d840410ca8fa5fee3bacd8d9946", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Barr", "8c941d32a6ff7d840410ca8fa5fee3bacd8d9946", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Beerware.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Beerware.json" )
            .name( "Beerware License" )
            .licenseId( "Beerware" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Beerware" )
            .seeAlso( "https://people.freebsd.org/~phk/" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Beerware", "4616e61ccf6f11e80210f8434eb2e5a44775dc67", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Beerware", "4616e61ccf6f11e80210f8434eb2e5a44775dc67", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Beerware", "4616e61ccf6f11e80210f8434eb2e5a44775dc67", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Beerware", "4616e61ccf6f11e80210f8434eb2e5a44775dc67", "text/html", true, true )
            .urlInfo( "http://people.freebsd.org/~phk/", "8941cb77388e1fc73ec5a714ae571103c101b4fd", "text/html", true, false )
            .urlInfo( "https://people.freebsd.org/~phk/", "8941cb77388e1fc73ec5a714ae571103c101b4fd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BitTorrent-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/BitTorrent-1.0.json" )
            .name( "BitTorrent Open Source License v1.0" )
            .licenseId( "BitTorrent-1.0" )
            .seeAlso( "http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s" )

            .urlInfo( "http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s", "9612e12cd880c1e835561e8a7557c2d1016a99bd", "text/html", true, false )
            .urlInfo( "https://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s", "9612e12cd880c1e835561e8a7557c2d1016a99bd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./BitTorrent-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/BitTorrent-1.1.json" )
            .name( "BitTorrent Open Source License v1.1" )
            .licenseId( "BitTorrent-1.1" )
            .seeAlso( "http://directory.fsf.org/wiki/License:BitTorrentOSL1.1" )

            .urlInfo( "http://directory.fsf.org/wiki/License:BitTorrentOSL1.1", "043ac5c3dc68984134f1209dd565165a4076047e", "text/html", true, true )
            .urlInfo( "https://directory.fsf.org/wiki/License:BitTorrentOSL1.1", "043ac5c3dc68984134f1209dd565165a4076047e", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Borceux.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Borceux.json" )
            .name( "Borceux license" )
            .licenseId( "Borceux" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Borceux" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Borceux", "b7222363c4ffc3706a2b79a372452594da1e967b", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Borceux", "b7222363c4ffc3706a2b79a372452594da1e967b", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CATOSL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CATOSL-1.1.json" )
            .name( "Computer Associates Trusted Open Source License 1.1" )
            .licenseId( "CATOSL-1.1" )
            .seeAlso( "https://opensource.org/licenses/CATOSL-1.1" )

            .urlInfo( "http://opensource.org/licenses/CATOSL-1.1", "ac48daa5f1d287b7676eaf5c23c2fd19e8ddd2a9", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/CATOSL-1.1", "ac48daa5f1d287b7676eaf5c23c2fd19e8ddd2a9", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/CATOSL-1.1", "ac48daa5f1d287b7676eaf5c23c2fd19e8ddd2a9", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/CATOSL-1.1", "ac48daa5f1d287b7676eaf5c23c2fd19e8ddd2a9", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-1.0.json" )
            .name( "Creative Commons Attribution 1.0 Generic" )
            .licenseId( "CC-BY-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by/1.0/legalcode", "1c63388d25afec934d6c52e6e6500a4354e4b361", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-2.0.json" )
            .name( "Creative Commons Attribution 2.0 Generic" )
            .licenseId( "CC-BY-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by/2.0/legalcode", "ed79ebf5fd886cbf0ec52bcda4f4c714c489805e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-2.5.json" )
            .name( "Creative Commons Attribution 2.5 Generic" )
            .licenseId( "CC-BY-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by/2.5/legalcode", "a3f15d06f44729420d7ab2d87ca9bee7cf2820fe", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-3.0.json" )
            .name( "Creative Commons Attribution 3.0 Unported" )
            .licenseId( "CC-BY-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/3.0/legalcode", "e835a69859b9fc6d35961a58e0e9b32e1d2dff5e", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by/3.0/legalcode", "e835a69859b9fc6d35961a58e0e9b32e1d2dff5e", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by/3.0/legalcode", "e835a69859b9fc6d35961a58e0e9b32e1d2dff5e", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by/3.0/legalcode", "e835a69859b9fc6d35961a58e0e9b32e1d2dff5e", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-4.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-4.0.json" )
            .name( "Creative Commons Attribution 4.0 International" )
            .licenseId( "CC-BY-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by/4.0/legalcode", "ed63d6dc37abf705c1435e481ff840c3279c6afe", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by/4.0/legalcode", "ed63d6dc37abf705c1435e481ff840c3279c6afe", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by/4.0/legalcode", "ed63d6dc37abf705c1435e481ff840c3279c6afe", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by/4.0/legalcode", "ed63d6dc37abf705c1435e481ff840c3279c6afe", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-1.0.json" )
            .name( "Creative Commons Attribution Non Commercial 1.0 Generic" )
            .licenseId( "CC-BY-NC-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/1.0/legalcode", "f1023e8a24e3a8c5b8029e9518c19bd70d231815", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-2.0.json" )
            .name( "Creative Commons Attribution Non Commercial 2.0 Generic" )
            .licenseId( "CC-BY-NC-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/2.0/legalcode", "35bfa32370d94a02d195222e876d48fe5e2bd58c", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/2.0/legalcode", "35bfa32370d94a02d195222e876d48fe5e2bd58c", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/2.0/legalcode", "35bfa32370d94a02d195222e876d48fe5e2bd58c", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/2.0/legalcode", "35bfa32370d94a02d195222e876d48fe5e2bd58c", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-2.5.json" )
            .name( "Creative Commons Attribution Non Commercial 2.5 Generic" )
            .licenseId( "CC-BY-NC-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/2.5/legalcode", "88ae72783ef4d55eb5eac0256fb9cbefee9d10cd", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/2.5/legalcode", "88ae72783ef4d55eb5eac0256fb9cbefee9d10cd", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/2.5/legalcode", "88ae72783ef4d55eb5eac0256fb9cbefee9d10cd", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/2.5/legalcode", "88ae72783ef4d55eb5eac0256fb9cbefee9d10cd", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-3.0.json" )
            .name( "Creative Commons Attribution Non Commercial 3.0 Unported" )
            .licenseId( "CC-BY-NC-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/3.0/legalcode", "7da12f32b86edbafa37e0e1ce8072271a5b99a33", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/3.0/legalcode", "7da12f32b86edbafa37e0e1ce8072271a5b99a33", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/3.0/legalcode", "7da12f32b86edbafa37e0e1ce8072271a5b99a33", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/3.0/legalcode", "7da12f32b86edbafa37e0e1ce8072271a5b99a33", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-4.0.json" )
            .name( "Creative Commons Attribution Non Commercial 4.0 International" )
            .licenseId( "CC-BY-NC-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc/4.0/legalcode", "44476cc5b9fcb74dd435a2d01a429d74dedca620", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc/4.0/legalcode", "44476cc5b9fcb74dd435a2d01a429d74dedca620", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc/4.0/legalcode", "44476cc5b9fcb74dd435a2d01a429d74dedca620", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc/4.0/legalcode", "44476cc5b9fcb74dd435a2d01a429d74dedca620", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-1.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic" )
            .licenseId( "CC-BY-NC-ND-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd-nc/1.0/legalcode", "b5dc8b5bce982bdb19ed4d29cd898017c34acd6e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-2.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic" )
            .licenseId( "CC-BY-NC-ND-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "83b8df6fd3e783805bb2ecbc2e435b66697d0e21", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "83b8df6fd3e783805bb2ecbc2e435b66697d0e21", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "83b8df6fd3e783805bb2ecbc2e435b66697d0e21", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/2.0/legalcode", "83b8df6fd3e783805bb2ecbc2e435b66697d0e21", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-2.5.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic" )
            .licenseId( "CC-BY-NC-ND-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "a24c08f634f31bf44e54167e1c7516fa693d7b16", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "a24c08f634f31bf44e54167e1c7516fa693d7b16", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "a24c08f634f31bf44e54167e1c7516fa693d7b16", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/2.5/legalcode", "a24c08f634f31bf44e54167e1c7516fa693d7b16", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-3.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported" )
            .licenseId( "CC-BY-NC-ND-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "905faafd2a41dcae56893ded471ce0ea6ff19122", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "905faafd2a41dcae56893ded471ce0ea6ff19122", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "905faafd2a41dcae56893ded471ce0ea6ff19122", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/3.0/legalcode", "905faafd2a41dcae56893ded471ce0ea6ff19122", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-ND-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-ND-4.0.json" )
            .name( "Creative Commons Attribution Non Commercial No Derivatives 4.0 International" )
            .licenseId( "CC-BY-NC-ND-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "8386ae9787526c0e4c8c5d8c404167635a73799b", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "8386ae9787526c0e4c8c5d8c404167635a73799b", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "8386ae9787526c0e4c8c5d8c404167635a73799b", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "8386ae9787526c0e4c8c5d8c404167635a73799b", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-1.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic" )
            .licenseId( "CC-BY-NC-SA-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/1.0/legalcode", "9c80e0343324f4db3bba0b878100bccca73340fa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-2.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic" )
            .licenseId( "CC-BY-NC-SA-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "9181e9056085ef74e0ba49016fc1a4cb7612ba6d", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "9181e9056085ef74e0ba49016fc1a4cb7612ba6d", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "9181e9056085ef74e0ba49016fc1a4cb7612ba6d", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/2.0/legalcode", "9181e9056085ef74e0ba49016fc1a4cb7612ba6d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-2.5.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic" )
            .licenseId( "CC-BY-NC-SA-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "4c4f5e5f2b0810f94da50c9847b7507d04019850", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "4c4f5e5f2b0810f94da50c9847b7507d04019850", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "4c4f5e5f2b0810f94da50c9847b7507d04019850", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/2.5/legalcode", "4c4f5e5f2b0810f94da50c9847b7507d04019850", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-3.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported" )
            .licenseId( "CC-BY-NC-SA-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "236903de80ec689d31a25a290e28127ec7ed5d35", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "236903de80ec689d31a25a290e28127ec7ed5d35", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "236903de80ec689d31a25a290e28127ec7ed5d35", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/3.0/legalcode", "236903de80ec689d31a25a290e28127ec7ed5d35", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-NC-SA-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-NC-SA-4.0.json" )
            .name( "Creative Commons Attribution Non Commercial Share Alike 4.0 International" )
            .licenseId( "CC-BY-NC-SA-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "d44a48e6b76e70dc0b07c108001ff32ab8e049ca", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "d44a48e6b76e70dc0b07c108001ff32ab8e049ca", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "d44a48e6b76e70dc0b07c108001ff32ab8e049ca", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "d44a48e6b76e70dc0b07c108001ff32ab8e049ca", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-1.0.json" )
            .name( "Creative Commons Attribution No Derivatives 1.0 Generic" )
            .licenseId( "CC-BY-ND-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/1.0/legalcode", "f42d2af0c110f153bc2dc0e807525485a281ecc4", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-2.0.json" )
            .name( "Creative Commons Attribution No Derivatives 2.0 Generic" )
            .licenseId( "CC-BY-ND-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/2.0/legalcode", "7efbd82e4f5c5d776b4719ed088932749783b3aa", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/2.0/legalcode", "7efbd82e4f5c5d776b4719ed088932749783b3aa", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/2.0/legalcode", "7efbd82e4f5c5d776b4719ed088932749783b3aa", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/2.0/legalcode", "7efbd82e4f5c5d776b4719ed088932749783b3aa", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-2.5.json" )
            .name( "Creative Commons Attribution No Derivatives 2.5 Generic" )
            .licenseId( "CC-BY-ND-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/2.5/legalcode", "3afdf363d0504cb517c1bc081804631e24e830f6", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/2.5/legalcode", "3afdf363d0504cb517c1bc081804631e24e830f6", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/2.5/legalcode", "3afdf363d0504cb517c1bc081804631e24e830f6", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/2.5/legalcode", "3afdf363d0504cb517c1bc081804631e24e830f6", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-3.0.json" )
            .name( "Creative Commons Attribution No Derivatives 3.0 Unported" )
            .licenseId( "CC-BY-ND-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/3.0/legalcode", "8d14e944cf055939e6904348c44c6694fcca7b83", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/3.0/legalcode", "8d14e944cf055939e6904348c44c6694fcca7b83", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/3.0/legalcode", "8d14e944cf055939e6904348c44c6694fcca7b83", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/3.0/legalcode", "8d14e944cf055939e6904348c44c6694fcca7b83", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-ND-4.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-ND-4.0.json" )
            .name( "Creative Commons Attribution No Derivatives 4.0 International" )
            .licenseId( "CC-BY-ND-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-nd/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-nd/4.0/legalcode", "2de28c0e56f9df3efba0478521b9954863ee7725", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-nd/4.0/legalcode", "2de28c0e56f9df3efba0478521b9954863ee7725", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-nd/4.0/legalcode", "2de28c0e56f9df3efba0478521b9954863ee7725", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-nd/4.0/legalcode", "2de28c0e56f9df3efba0478521b9954863ee7725", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-1.0.json" )
            .name( "Creative Commons Attribution Share Alike 1.0 Generic" )
            .licenseId( "CC-BY-SA-1.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/1.0/legalcode", "8748536485ffd39b12479949c42bbd0545e71f93", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-2.0.json" )
            .name( "Creative Commons Attribution Share Alike 2.0 Generic" )
            .licenseId( "CC-BY-SA-2.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/2.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/2.0/legalcode", "a6604d95391331067a17b697dc5f5571899119a2", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-2.5.json" )
            .name( "Creative Commons Attribution Share Alike 2.5 Generic" )
            .licenseId( "CC-BY-SA-2.5" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/2.5/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/2.5/legalcode", "4ed0178a9b2d773ffc849c18f5884c277d2a4e86", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-3.0.json" )
            .name( "Creative Commons Attribution Share Alike 3.0 Unported" )
            .licenseId( "CC-BY-SA-3.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/3.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/3.0/legalcode", "d0ac1cd99deeca8d3241f0cb1035b653cc947358", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/licenses/by-sa/3.0/legalcode", "d0ac1cd99deeca8d3241f0cb1035b653cc947358", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/3.0/legalcode", "d0ac1cd99deeca8d3241f0cb1035b653cc947358", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/3.0/legalcode", "d0ac1cd99deeca8d3241f0cb1035b653cc947358", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC-BY-SA-4.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CC-BY-SA-4.0.json" )
            .name( "Creative Commons Attribution Share Alike 4.0 International" )
            .licenseId( "CC-BY-SA-4.0" )
            .seeAlso( "https://creativecommons.org/licenses/by-sa/4.0/legalcode" )

            .urlInfo( "http://creativecommons.org/licenses/by-sa/4.0/legalcode", "2db7dade1d369cc2e1298a2d6d7c47410819682d", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/licenses/by-sa/4.0/legalcode", "2db7dade1d369cc2e1298a2d6d7c47410819682d", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/licenses/by-sa/4.0/legalcode", "2db7dade1d369cc2e1298a2d6d7c47410819682d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CC0-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CC0-1.0.json" )
            .name( "Creative Commons Zero v1.0 Universal" )
            .licenseId( "CC0-1.0" )
            .seeAlso( "https://creativecommons.org/publicdomain/zero/1.0/legalcode" )

            .urlInfo( "http://creativecommons.org/publicdomain/zero/1.0/legalcode", "21ad4b5a341800e1ece53b5fd9d7bd7b89692fbc", "text/html", true, true )
            .urlInfo( "http://www.creativecommons.org/publicdomain/zero/1.0/legalcode", "21ad4b5a341800e1ece53b5fd9d7bd7b89692fbc", "text/html", true, true )
            .urlInfo( "https://creativecommons.org/publicdomain/zero/1.0/legalcode", "21ad4b5a341800e1ece53b5fd9d7bd7b89692fbc", "text/html", true, true )
            .urlInfo( "https://www.creativecommons.org/publicdomain/zero/1.0/legalcode", "21ad4b5a341800e1ece53b5fd9d7bd7b89692fbc", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDDL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CDDL-1.0.json" )
            .name( "Common Development and Distribution License 1.0" )
            .licenseId( "CDDL-1.0" )
            .seeAlso( "https://opensource.org/licenses/cddl1" )

            .urlInfo( "http://opensource.org/licenses/cddl1", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/cddl1.html", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/cddl1.php", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/cddl1", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/cddl1.html", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/cddl1.php", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/cddl1", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/cddl1.html", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/cddl1.php", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/cddl1", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/cddl1.html", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/cddl1.php", "58bf0d7faa358fc2d7eb132448544100c4330264", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDDL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CDDL-1.1.json" )
            .name( "Common Development and Distribution License 1.1" )
            .licenseId( "CDDL-1.1" )
            .seeAlso( "http://glassfish.java.net/public/CDDL+GPL_1_1.html" )
            .seeAlso( "https://javaee.github.io/glassfish/LICENSE" )

            .urlInfo( "http://glassfish.java.net/public/CDDL+GPL_1_1.html", "047abb20f37c1629c82db23d99783e41207c2564", "text/html", true, false )
            .urlInfo( "https://glassfish.java.net/public/CDDL+GPL_1_1.html", "047abb20f37c1629c82db23d99783e41207c2564", "text/html", true, false )
            .urlInfo( "http://javaee.github.io/glassfish/LICENSE", "09e401981fad6a8cbeea3173b9ea9c4a2c95610a", "text/html", true, false )
            .urlInfo( "https://javaee.github.io/glassfish/LICENSE", "09e401981fad6a8cbeea3173b9ea9c4a2c95610a", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDLA-Permissive-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CDLA-Permissive-1.0.json" )
            .name( "Community Data License Agreement Permissive 1.0" )
            .licenseId( "CDLA-Permissive-1.0" )
            .seeAlso( "https://cdla.io/permissive-1-0" )

            .urlInfo( "https://cdla.io/permissive-1-0", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CDLA-Sharing-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CDLA-Sharing-1.0.json" )
            .name( "Community Data License Agreement Sharing 1.0" )
            .licenseId( "CDLA-Sharing-1.0" )
            .seeAlso( "https://cdla.io/sharing-1-0" )

            .urlInfo( "https://cdla.io/sharing-1-0", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CECILL-1.0.json" )
            .name( "CeCILL Free Software License Agreement v1.0" )
            .licenseId( "CECILL-1.0" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V1-fr.html", "f17da26e34780330205e0fccdda4f2804f58de0f", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html", "f17da26e34780330205e0fccdda4f2804f58de0f", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V1-fr.html", "f17da26e34780330205e0fccdda4f2804f58de0f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CECILL-1.1.json" )
            .name( "CeCILL Free Software License Agreement v1.1" )
            .licenseId( "CECILL-1.1" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V1.1-US.html", "aa6f3f6ec2ddea7c007f2a03c7388ce5b828e0d0", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html", "aa6f3f6ec2ddea7c007f2a03c7388ce5b828e0d0", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V1.1-US.html", "aa6f3f6ec2ddea7c007f2a03c7388ce5b828e0d0", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CECILL-2.0.json" )
            .name( "CeCILL Free Software License Agreement v2.0" )
            .licenseId( "CECILL-2.0" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V2-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V2-en.html", "93a69271faa4f031dc2ccde64140cb7743ab9e3e", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V2-en.html", "93a69271faa4f031dc2ccde64140cb7743ab9e3e", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V2-en.html", "93a69271faa4f031dc2ccde64140cb7743ab9e3e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CECILL-2.1.json" )
            .name( "CeCILL Free Software License Agreement v2.1" )
            .licenseId( "CECILL-2.1" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL_V2.1-en.html", "929cdbfd392146302d80a5d50b320c7912edd4e9", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html", "929cdbfd392146302d80a5d50b320c7912edd4e9", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL_V2.1-en.html", "929cdbfd392146302d80a5d50b320c7912edd4e9", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-B.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CECILL-B.json" )
            .name( "CeCILL-B Free Software License Agreement" )
            .licenseId( "CECILL-B" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL-B_V1-en.html", "886d89c8a46947091e395d6adeed081df0f04846", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html", "886d89c8a46947091e395d6adeed081df0f04846", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL-B_V1-en.html", "886d89c8a46947091e395d6adeed081df0f04846", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CECILL-C.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CECILL-C.json" )
            .name( "CeCILL-C Free Software License Agreement" )
            .licenseId( "CECILL-C" )
            .seeAlso( "http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html" )

            .urlInfo( "http://cecill.info/licences/Licence_CeCILL-C_V1-en.html", "273cc1c96fa23a8211f27876ed4b7f7b8e4285fd", "text/html", true, false )
            .urlInfo( "http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html", "273cc1c96fa23a8211f27876ed4b7f7b8e4285fd", "text/html", true, false )
            .urlInfo( "https://cecill.info/licences/Licence_CeCILL-C_V1-en.html", "273cc1c96fa23a8211f27876ed4b7f7b8e4285fd", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CERN-OHL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CERN-OHL-1.1.json" )
            .name( "CERN Open Hardware License v1.1" )
            .licenseId( "CERN-OHL-1.1" )
            .seeAlso( "https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1" )

            .urlInfo( "https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1", "a3a47f2aeda2a93024b9b05f6b8d0c0b63dfd177", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CERN-OHL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CERN-OHL-1.2.json" )
            .name( "CERN Open Hardware Licence v1.2" )
            .licenseId( "CERN-OHL-1.2" )
            .seeAlso( "https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2" )

            .urlInfo( "https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2", "ffa0b932fbebef003c8b498bce218e287a506686", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CNRI-Jython.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CNRI-Jython.json" )
            .name( "CNRI Jython License" )
            .licenseId( "CNRI-Jython" )
            .seeAlso( "http://www.jython.org/license.html" )

            .urlInfo( "http://jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .urlInfo( "http://www.jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .urlInfo( "https://jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .urlInfo( "https://www.jython.org/license.html", "810432eb0f42ead5997cbaed87dd8f8db0125319", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CNRI-Python.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CNRI-Python.json" )
            .name( "CNRI Python License" )
            .licenseId( "CNRI-Python" )
            .seeAlso( "https://opensource.org/licenses/CNRI-Python" )

            .urlInfo( "http://opensource.org/licenses/CNRI-Python", "35687aea838758505b7b1b8944efa0f4b1313298", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/CNRI-Python", "35687aea838758505b7b1b8944efa0f4b1313298", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/CNRI-Python", "35687aea838758505b7b1b8944efa0f4b1313298", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/CNRI-Python", "35687aea838758505b7b1b8944efa0f4b1313298", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CNRI-Python-GPL-Compatible.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CNRI-Python-GPL-Compatible.json" )
            .name( "CNRI Python Open Source GPL Compatible License Agreement" )
            .licenseId( "CNRI-Python-GPL-Compatible" )
            .seeAlso( "http://www.python.org/download/releases/1.6.1/download_win/" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CPAL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CPAL-1.0.json" )
            .name( "Common Public Attribution License 1.0" )
            .licenseId( "CPAL-1.0" )
            .seeAlso( "https://opensource.org/licenses/CPAL-1.0" )

            .urlInfo( "http://opensource.org/licenses/CPAL-1.0", "55783ad397acffef2f88373534f669319f2c542b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/CPAL-1.0", "55783ad397acffef2f88373534f669319f2c542b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/CPAL-1.0", "55783ad397acffef2f88373534f669319f2c542b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/CPAL-1.0", "55783ad397acffef2f88373534f669319f2c542b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/CPL-1.0.json" )
            .name( "Common Public License 1.0" )
            .licenseId( "CPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/CPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/CPL-1.0", "8a873c13bfa2848f82a9161aee2f63ea4a667799", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/CPL-1.0", "8a873c13bfa2848f82a9161aee2f63ea4a667799", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/CPL-1.0", "8a873c13bfa2848f82a9161aee2f63ea4a667799", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/CPL-1.0", "8a873c13bfa2848f82a9161aee2f63ea4a667799", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CPOL-1.02.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CPOL-1.02.json" )
            .name( "Code Project Open License 1.02" )
            .licenseId( "CPOL-1.02" )
            .seeAlso( "http://www.codeproject.com/info/cpol10.aspx" )

            .urlInfo( "http://www.codeproject.com/info/cpol10.aspx", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CUA-OPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CUA-OPL-1.0.json" )
            .name( "CUA Office Public License v1.0" )
            .licenseId( "CUA-OPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/CUA-OPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/CUA-OPL-1.0", "f74b77618705e3081b04500f34a2ad046efb6554", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/CUA-OPL-1.0", "f74b77618705e3081b04500f34a2ad046efb6554", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/CUA-OPL-1.0", "f74b77618705e3081b04500f34a2ad046efb6554", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/CUA-OPL-1.0", "f74b77618705e3081b04500f34a2ad046efb6554", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Caldera.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Caldera.json" )
            .name( "Caldera License" )
            .licenseId( "Caldera" )
            .seeAlso( "http://www.lemis.com/grog/UNIX/ancient-source-all.pdf" )

            .urlInfo( "http://lemis.com/grog/UNIX/ancient-source-all.pdf", "81d30f492d00e2f5b2be3750bd99e2feb4f0ca33", "application/pdf", true, false )
            .urlInfo( "http://www.lemis.com/grog/UNIX/ancient-source-all.pdf", "81d30f492d00e2f5b2be3750bd99e2feb4f0ca33", "application/pdf", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ClArtistic.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ClArtistic.json" )
            .name( "Clarified Artistic License" )
            .licenseId( "ClArtistic" )
            .seeAlso( "http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/" )
            .seeAlso( "http://www.ncftp.com/ncftp/doc/LICENSE.txt" )

            .urlInfo( "http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/", null, null, false, true )
            .urlInfo( "http://ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .urlInfo( "http://www.ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .urlInfo( "https://ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .urlInfo( "https://www.ncftp.com/ncftp/doc/LICENSE.txt", "f2c53f7a93b26c7f4d0589c907b31df168cea88f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Condor-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Condor-1.1.json" )
            .name( "Condor Public License v1.1" )
            .licenseId( "Condor-1.1" )
            .seeAlso( "http://research.cs.wisc.edu/condor/license.html#condor" )
            .seeAlso( "http://web.archive.org/web/20111123062036/http://research.cs.wisc.edu/condor/license.html#condor" )

            .urlInfo( "http://research.cs.wisc.edu/condor/license.html#condor", "a4ed29ffd7cc6114ebff053853c3ae196a4c0366", "text/html", true, false )
            .urlInfo( "https://research.cs.wisc.edu/condor/license.html#condor", "a4ed29ffd7cc6114ebff053853c3ae196a4c0366", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Crossword.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Crossword.json" )
            .name( "Crossword License" )
            .licenseId( "Crossword" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Crossword" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Crossword", "dca84c1772142dac70966243518b1c7be48f6fe6", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Crossword", "dca84c1772142dac70966243518b1c7be48f6fe6", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Crossword", "dca84c1772142dac70966243518b1c7be48f6fe6", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Crossword", "dca84c1772142dac70966243518b1c7be48f6fe6", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./CrystalStacker.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/CrystalStacker.json" )
            .name( "CrystalStacker License" )
            .licenseId( "CrystalStacker" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker", "35336ec539fe0a1ce6e050f62dcaf4dbf9b9c381", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker", "35336ec539fe0a1ce6e050f62dcaf4dbf9b9c381", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker", "35336ec539fe0a1ce6e050f62dcaf4dbf9b9c381", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker", "35336ec539fe0a1ce6e050f62dcaf4dbf9b9c381", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Cube.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Cube.json" )
            .name( "Cube License" )
            .licenseId( "Cube" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Cube" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Cube", "8624af85fc9a43bb2e4096f5049e4cd11b03fc3c", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Cube", "8624af85fc9a43bb2e4096f5049e4cd11b03fc3c", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Cube", "8624af85fc9a43bb2e4096f5049e4cd11b03fc3c", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Cube", "8624af85fc9a43bb2e4096f5049e4cd11b03fc3c", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./D-FSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/D-FSL-1.0.json" )
            .name( "Deutsche Freie Software Lizenz" )
            .licenseId( "D-FSL-1.0" )
            .seeAlso( "http://www.dipp.nrw.de/d-fsl/lizenzen/" )
            .seeAlso( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/de/D-FSL-1_0_de.txt" )
            .seeAlso( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/en/D-FSL-1_0_en.txt" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file" )
            .seeAlso( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file" )

            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/de/D-FSL-1_0_de.txt", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/en/D-FSL-1_0_en.txt", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.dipp.nrw.de/d-fsl/lizenzen/", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl", "a4b5f7f7d4bba587e24aea5554695dfc48f9fcd6", "text/html", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz", "728fc7525ea38a81b9a50ddd3d929dc514b642c8", "text/html", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz", "728fc7525ea38a81b9a50ddd3d929dc514b642c8", "text/html", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz", "728fc7525ea38a81b9a50ddd3d929dc514b642c8", "text/html", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license", "96713f02fd64b9a8899c8608afd2803d3632f16f", "text/html", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license", "96713f02fd64b9a8899c8608afd2803d3632f16f", "text/html", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license", "96713f02fd64b9a8899c8608afd2803d3632f16f", "text/html", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file", "030d427e3f2b5cae1bdc081839495e2226898a95", "text/plain", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file", "030d427e3f2b5cae1bdc081839495e2226898a95", "text/plain", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file", "030d427e3f2b5cae1bdc081839495e2226898a95", "text/plain", true, false )
            .urlInfo( "http://hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file", "e234377676a736aec560548b260c3d645f1adc40", "text/plain", true, false )
            .urlInfo( "http://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file", "e234377676a736aec560548b260c3d645f1adc40", "text/plain", true, false )
            .urlInfo( "https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file", "e234377676a736aec560548b260c3d645f1adc40", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./DOC.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/DOC.json" )
            .name( "DOC License" )
            .licenseId( "DOC" )
            .seeAlso( "http://www.cs.wustl.edu/~schmidt/ACE-copying.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./DSDP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/DSDP.json" )
            .name( "DSDP License" )
            .licenseId( "DSDP" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/DSDP" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/DSDP", "1a57976934ec53669f9159b8b3fd753ffec072b5", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/DSDP", "1a57976934ec53669f9159b8b3fd753ffec072b5", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/DSDP", "1a57976934ec53669f9159b8b3fd753ffec072b5", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/DSDP", "1a57976934ec53669f9159b8b3fd753ffec072b5", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Dotseqn.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Dotseqn.json" )
            .name( "Dotseqn License" )
            .licenseId( "Dotseqn" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Dotseqn" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Dotseqn", "78273d480140c6c3b631e44ed444bdd85c69162a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Dotseqn", "78273d480140c6c3b631e44ed444bdd85c69162a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Dotseqn", "78273d480140c6c3b631e44ed444bdd85c69162a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Dotseqn", "78273d480140c6c3b631e44ed444bdd85c69162a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ECL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ECL-1.0.json" )
            .name( "Educational Community License v1.0" )
            .licenseId( "ECL-1.0" )
            .seeAlso( "https://opensource.org/licenses/ECL-1.0" )

            .urlInfo( "http://opensource.org/licenses/ECL-1.0", "756d4f76316b94432bec61f253c229c79e1f0bed", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/ECL-1.0", "756d4f76316b94432bec61f253c229c79e1f0bed", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/ECL-1.0", "756d4f76316b94432bec61f253c229c79e1f0bed", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/ECL-1.0", "756d4f76316b94432bec61f253c229c79e1f0bed", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ECL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ECL-2.0.json" )
            .name( "Educational Community License v2.0" )
            .licenseId( "ECL-2.0" )
            .seeAlso( "https://opensource.org/licenses/ECL-2.0" )

            .urlInfo( "http://opensource.org/licenses/ECL-2.0", "423315e17ae0141c404a9400d8bb996940f1ca56", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/ECL-2.0", "423315e17ae0141c404a9400d8bb996940f1ca56", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/ECL-2.0", "423315e17ae0141c404a9400d8bb996940f1ca56", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/ECL-2.0", "423315e17ae0141c404a9400d8bb996940f1ca56", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EFL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/EFL-1.0.json" )
            .name( "Eiffel Forum License v1.0" )
            .licenseId( "EFL-1.0" )
            .seeAlso( "http://www.eiffel-nice.org/license/forum.txt" )
            .seeAlso( "https://opensource.org/licenses/EFL-1.0" )

            .urlInfo( "http://eiffel-nice.org/license/forum.txt", "0187bf4669b68a88a606fcc56026d42f6130a3b5", "text/plain", true, false )
            .urlInfo( "http://www.eiffel-nice.org/license/forum.txt", "0187bf4669b68a88a606fcc56026d42f6130a3b5", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/EFL-1.0", "aa8f11ea9d769a219fdd28e97c798887cc646217", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EFL-1.0", "aa8f11ea9d769a219fdd28e97c798887cc646217", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EFL-1.0", "aa8f11ea9d769a219fdd28e97c798887cc646217", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EFL-1.0", "aa8f11ea9d769a219fdd28e97c798887cc646217", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EFL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EFL-2.0.json" )
            .name( "Eiffel Forum License v2.0" )
            .licenseId( "EFL-2.0" )
            .seeAlso( "http://www.eiffel-nice.org/license/eiffel-forum-license-2.html" )
            .seeAlso( "https://opensource.org/licenses/EFL-2.0" )

            .urlInfo( "http://eiffel-nice.org/license/eiffel-forum-license-2.html", "11a3b6c48679ec916eee3ffbd2378355738cfc46", "text/html", true, false )
            .urlInfo( "http://www.eiffel-nice.org/license/eiffel-forum-license-2.html", "11a3b6c48679ec916eee3ffbd2378355738cfc46", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EFL-2.0", "c450a027fbe94e77932301d11a0bf8013372551b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EFL-2.0", "c450a027fbe94e77932301d11a0bf8013372551b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EFL-2.0", "c450a027fbe94e77932301d11a0bf8013372551b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EFL-2.0", "c450a027fbe94e77932301d11a0bf8013372551b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EPL-1.0.json" )
            .name( "Eclipse Public License 1.0" )
            .licenseId( "EPL-1.0" )
            .seeAlso( "http://www.eclipse.org/legal/epl-v10.html" )
            .seeAlso( "https://opensource.org/licenses/EPL-1.0" )

            .urlInfo( "http://eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "http://www.eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "https://eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "https://www.eclipse.org/legal/epl-v10.html", "35666c54f2406125707e63edab12f2914d85ca76", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EPL-1.0", "9a1b3f8639976267d5bf4da33be618fd572a2771", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EPL-1.0", "9a1b3f8639976267d5bf4da33be618fd572a2771", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EPL-1.0", "9a1b3f8639976267d5bf4da33be618fd572a2771", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EPL-1.0", "9a1b3f8639976267d5bf4da33be618fd572a2771", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EPL-2.0.json" )
            .name( "Eclipse Public License 2.0" )
            .licenseId( "EPL-2.0" )
            .seeAlso( "https://www.eclipse.org/legal/epl-2.0" )
            .seeAlso( "https://www.opensource.org/licenses/EPL-2.0" )

            .urlInfo( "https://eclipse.org/legal/epl-2.0", "a197dfd57211db1b0f035a87e4c5b5c9e459cfec", "text/html", true, false )
            .urlInfo( "https://www.eclipse.org/legal/epl-2.0", "a197dfd57211db1b0f035a87e4c5b5c9e459cfec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EPL-2.0", "fc5019e6631d9a8e913dccee572b11c8ac4f4404", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EPL-2.0", "fc5019e6631d9a8e913dccee572b11c8ac4f4404", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EPL-2.0", "fc5019e6631d9a8e913dccee572b11c8ac4f4404", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EPL-2.0", "fc5019e6631d9a8e913dccee572b11c8ac4f4404", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUDatagrid.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EUDatagrid.json" )
            .name( "EU DataGrid Software License" )
            .licenseId( "EUDatagrid" )
            .seeAlso( "http://eu-datagrid.web.cern.ch/eu-datagrid/license.html" )
            .seeAlso( "https://opensource.org/licenses/EUDatagrid" )

            .urlInfo( "http://eu-datagrid.web.cern.ch/eu-datagrid/license.html", "9ecab31e2f1f0e909e262d933486bef5066ca386", "text/html", true, true )
            .urlInfo( "https://eu-datagrid.web.cern.ch/eu-datagrid/license.html", "9ecab31e2f1f0e909e262d933486bef5066ca386", "text/html", true, true )
            .urlInfo( "http://opensource.org/licenses/EUDatagrid", "b530e1a24462b7256bcc6e08f92e504afd23f0fd", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EUDatagrid", "b530e1a24462b7256bcc6e08f92e504afd23f0fd", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EUDatagrid", "b530e1a24462b7256bcc6e08f92e504afd23f0fd", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EUDatagrid", "b530e1a24462b7256bcc6e08f92e504afd23f0fd", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/EUPL-1.0.json" )
            .name( "European Union Public License 1.0" )
            .licenseId( "EUPL-1.0" )
            .seeAlso( "http://ec.europa.eu/idabc/en/document/7330.html" )
            .seeAlso( "http://ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096" )

            .urlInfo( "http://ec.europa.eu/idabc/en/document/7330.html", "0d18bb9db4a45ad4cffefcc150ae07ce0bef9bd1", "text/html", true, false )
            .urlInfo( "http://www.ec.europa.eu/idabc/en/document/7330.html", "0d18bb9db4a45ad4cffefcc150ae07ce0bef9bd1", "text/html", true, false )
            .urlInfo( "http://ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096", "b5ce3f58aeb32c9d3f4d1d59d4c8a5579d1f345a", "application/pdf", true, false )
            .urlInfo( "http://www.ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096", "b5ce3f58aeb32c9d3f4d1d59d4c8a5579d1f345a", "application/pdf", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EUPL-1.1.json" )
            .name( "European Union Public License 1.1" )
            .licenseId( "EUPL-1.1" )
            .seeAlso( "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl" )
            .seeAlso( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf" )
            .seeAlso( "https://opensource.org/licenses/EUPL-1.1" )

            .urlInfo( "http://joinup.ec.europa.eu/page/eupl-text-11-12", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/page/eupl-text-11-12", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf", "b91481f1edd91d5fca56ccf4065b63c3269ac6fb", "application/pdf", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf", "b91481f1edd91d5fca56ccf4065b63c3269ac6fb", "application/pdf", true, false )
            .urlInfo( "http://opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./EUPL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/EUPL-1.2.json" )
            .name( "European Union Public License 1.2" )
            .licenseId( "EUPL-1.2" )
            .seeAlso( "https://joinup.ec.europa.eu/page/eupl-text-11-12" )
            .seeAlso( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf" )
            .seeAlso( "https://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt" )
            .seeAlso( "http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863" )
            .seeAlso( "https://opensource.org/licenses/EUPL-1.1" )

            .urlInfo( "http://joinup.ec.europa.eu/page/eupl-text-11-12", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/page/eupl-text-11-12", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl", "7121a05d5b7059a019e008a85e1568b1c6f707de", "text/html", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf", "e512a96949c79498ad1a59d6553ddf694ef44666", "application/pdf", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf", "e512a96949c79498ad1a59d6553ddf694ef44666", "application/pdf", true, false )
            .urlInfo( "http://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt", "0ecda5d95dd354eaad18d0e72f6560e70fc78f74", "text/plain", true, false )
            .urlInfo( "https://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt", "0ecda5d95dd354eaad18d0e72f6560e70fc78f74", "text/plain", true, false )
            .urlInfo( "http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863", "56d6faabaf70c78c28c825bf74fb82aaa82972ba", "text/html", true, false )
            .urlInfo( "http://www.eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863", "56d6faabaf70c78c28c825bf74fb82aaa82972ba", "text/html", true, false )
            .urlInfo( "https://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863", "56d6faabaf70c78c28c825bf74fb82aaa82972ba", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/EUPL-1.1", "a4f2685aac64b4442e5e2a22a2a8ce6ab638262e", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Entessa.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Entessa.json" )
            .name( "Entessa Public License v1.0" )
            .licenseId( "Entessa" )
            .seeAlso( "https://opensource.org/licenses/Entessa" )

            .urlInfo( "http://opensource.org/licenses/Entessa", "e0983f23de64af5f557bc25607b292e0de15e1d8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Entessa", "e0983f23de64af5f557bc25607b292e0de15e1d8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Entessa", "e0983f23de64af5f557bc25607b292e0de15e1d8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Entessa", "e0983f23de64af5f557bc25607b292e0de15e1d8", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ErlPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ErlPL-1.1.json" )
            .name( "Erlang Public License v1.1" )
            .licenseId( "ErlPL-1.1" )
            .seeAlso( "http://www.erlang.org/EPLICENSE" )

            .urlInfo( "http://erlang.org/EPLICENSE", "4f3186bd48be9b2cd3bc12bc7a4c9cba6d1ecf59", "text/plain", true, false )
            .urlInfo( "http://www.erlang.org/EPLICENSE", "4f3186bd48be9b2cd3bc12bc7a4c9cba6d1ecf59", "text/plain", true, false )
            .urlInfo( "https://www.erlang.org/EPLICENSE", "4f3186bd48be9b2cd3bc12bc7a4c9cba6d1ecf59", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Eurosym.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Eurosym.json" )
            .name( "Eurosym License" )
            .licenseId( "Eurosym" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Eurosym" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Eurosym", "27605ac5de8d1c17474be6a466ee6ecaaa2cd7a5", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Eurosym", "27605ac5de8d1c17474be6a466ee6ecaaa2cd7a5", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Eurosym", "27605ac5de8d1c17474be6a466ee6ecaaa2cd7a5", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Eurosym", "27605ac5de8d1c17474be6a466ee6ecaaa2cd7a5", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FSFAP.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/FSFAP.json" )
            .name( "FSF All Permissive License" )
            .licenseId( "FSFAP" )
            .seeAlso( "https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html" )

            .urlInfo( "http://gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .urlInfo( "https://gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html", "9b08601db9e28dc8d20c9f7fb1ab07c9f802446c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FSFUL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/FSFUL.json" )
            .name( "FSF Unlimited License" )
            .licenseId( "FSFUL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FSFULLR.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/FSFULLR.json" )
            .name( "FSF Unlimited License (with License Retention)" )
            .licenseId( "FSFULLR" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant", "92d6360f648278de21e329ae8bc5b9b8288c86c3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FTL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/FTL.json" )
            .name( "Freetype Project License" )
            .licenseId( "FTL" )
            .seeAlso( "http://freetype.fis.uniroma2.it/FTL.TXT" )
            .seeAlso( "http://git.savannah.gnu.org/cgit/freetype/freetype2.git/tree/docs/FTL.TXT" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Fair.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Fair.json" )
            .name( "Fair License" )
            .licenseId( "Fair" )
            .seeAlso( "http://fairlicense.org/" )
            .seeAlso( "https://opensource.org/licenses/Fair" )

            .urlInfo( "http://fairlicense.org/", "f458d76f7b9e27fdf2d9e407c504f8142d6e1037", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/Fair", "c2db99c6033406b81b84635a6af07ea7e1f5aa17", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Fair", "c2db99c6033406b81b84635a6af07ea7e1f5aa17", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Fair", "c2db99c6033406b81b84635a6af07ea7e1f5aa17", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Fair", "c2db99c6033406b81b84635a6af07ea7e1f5aa17", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Frameworx-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Frameworx-1.0.json" )
            .name( "Frameworx Open License 1.0" )
            .licenseId( "Frameworx-1.0" )
            .seeAlso( "https://opensource.org/licenses/Frameworx-1.0" )

            .urlInfo( "http://opensource.org/licenses/Frameworx-1.0", "4a1b6fe365763d63b5eb537c1de24145399222bd", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Frameworx-1.0", "4a1b6fe365763d63b5eb537c1de24145399222bd", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Frameworx-1.0", "4a1b6fe365763d63b5eb537c1de24145399222bd", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Frameworx-1.0", "4a1b6fe365763d63b5eb537c1de24145399222bd", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./FreeImage.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/FreeImage.json" )
            .name( "FreeImage Public License v1.0" )
            .licenseId( "FreeImage" )
            .seeAlso( "http://freeimage.sourceforge.net/freeimage-license.txt" )

            .urlInfo( "http://freeimage.sourceforge.net/freeimage-license.txt", "0ca251a586f81fb996e02f5391eff7c20f914fa6", "text/plain", true, false )
            .urlInfo( "http://www.freeimage.sourceforge.net/freeimage-license.txt", "0ca251a586f81fb996e02f5391eff7c20f914fa6", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.1.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.1.json" )
            .name( "GNU Free Documentation License v1.1" )
            .licenseId( "GFDL-1.1" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.1-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.1-only.json" )
            .name( "GNU Free Documentation License v1.1 only" )
            .licenseId( "GFDL-1.1-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.1-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.1-or-later.json" )
            .name( "GNU Free Documentation License v1.1 or later" )
            .licenseId( "GFDL-1.1-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt", "7205ad2e7451e9c4a518d105d5144987cdaf9bfa", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.2.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.2.json" )
            .name( "GNU Free Documentation License v1.2" )
            .licenseId( "GFDL-1.2" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.2-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.2-only.json" )
            .name( "GNU Free Documentation License v1.2 only" )
            .licenseId( "GFDL-1.2-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.2-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.2-or-later.json" )
            .name( "GNU Free Documentation License v1.2 or later" )
            .licenseId( "GFDL-1.2-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt", "e436bc68467a0ad3edc01af3189fa4aa04af9302", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.3.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.3.json" )
            .name( "GNU Free Documentation License v1.3" )
            .licenseId( "GFDL-1.3" )
            .seeAlso( "https://www.gnu.org/licenses/fdl-1.3.txt" )

            .urlInfo( "http://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.3-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.3-only.json" )
            .name( "GNU Free Documentation License v1.3 only" )
            .licenseId( "GFDL-1.3-only" )
            .seeAlso( "https://www.gnu.org/licenses/fdl-1.3.txt" )

            .urlInfo( "http://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GFDL-1.3-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GFDL-1.3-or-later.json" )
            .name( "GNU Free Documentation License v1.3 or later" )
            .licenseId( "GFDL-1.3-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/fdl-1.3.txt" )

            .urlInfo( "http://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/fdl-1.3.txt", "8bdbff3486abb874fd8870d5b6866ee6d1c44f0f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GL2PS.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/GL2PS.json" )
            .name( "GL2PS License" )
            .licenseId( "GL2PS" )
            .seeAlso( "http://www.geuz.org/gl2ps/COPYING.GL2PS" )

            .urlInfo( "http://geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .urlInfo( "http://www.geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .urlInfo( "https://geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .urlInfo( "https://www.geuz.org/gl2ps/COPYING.GL2PS", "c241b1d39ee2c7e49189ca75a5e8dabb35aa4173", null, true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0.json" )
            .name( "GNU General Public License v1.0 only" )
            .licenseId( "GPL-1.0" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0+.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0+.json" )
            .name( "GNU General Public License v1.0 or later" )
            .licenseId( "GPL-1.0+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0-only.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0-only.json" )
            .name( "GNU General Public License v1.0 only" )
            .licenseId( "GPL-1.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-1.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/GPL-1.0-or-later.json" )
            .name( "GNU General Public License v1.0 or later" )
            .licenseId( "GPL-1.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html", "539d8420132db2bb3773ead4cd77f948eed57b7f", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-1.0.txt", "18eaf66587c5eea277721d5e569a6e3cd869f855", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0.json" )
            .name( "GNU General Public License v2.0 only" )
            .licenseId( "GPL-2.0" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0+.json" )
            .name( "GNU General Public License v2.0 or later" )
            .licenseId( "GPL-2.0+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-only.json" )
            .name( "GNU General Public License v2.0 only" )
            .licenseId( "GPL-2.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-or-later.json" )
            .name( "GNU General Public License v2.0 or later" )
            .licenseId( "GPL-2.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-2.0" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html", "f4c15ee1715ae360eaac505fa32cb200565aad4b", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-2.0", "e42213d8b6a33520f82b0b1c38c3ada3c9ad064f", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt", "4cc77b90af91e615a64ae04893fdffa7939db84c", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-GCC-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-GCC-exception.json" )
            .name( "GNU General Public License v2.0 w/GCC Runtime Library exception" )
            .licenseId( "GPL-2.0-with-GCC-exception" )
            .seeAlso( "https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10" )

            .urlInfo( "http://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10", "a2cc775a5ba3b070baa11e1fa3be80026ec52f38", "text/html", true, false )
            .urlInfo( "https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10", "a2cc775a5ba3b070baa11e1fa3be80026ec52f38", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-autoconf-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-autoconf-exception.json" )
            .name( "GNU General Public License v2.0 w/Autoconf exception" )
            .licenseId( "GPL-2.0-with-autoconf-exception" )
            .seeAlso( "http://ac-archive.sourceforge.net/doc/copyright.html" )

            .urlInfo( "http://ac-archive.sourceforge.net/doc/copyright.html", "a84ee700564981a2fd26a0a3820d975b470cad3d", "text/html", true, false )
            .urlInfo( "http://www.ac-archive.sourceforge.net/doc/copyright.html", "a84ee700564981a2fd26a0a3820d975b470cad3d", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-bison-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-bison-exception.json" )
            .name( "GNU General Public License v2.0 w/Bison exception" )
            .licenseId( "GPL-2.0-with-bison-exception" )
            .seeAlso( "http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-classpath-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-classpath-exception.json" )
            .name( "GNU General Public License v2.0 w/Classpath exception" )
            .licenseId( "GPL-2.0-with-classpath-exception" )
            .seeAlso( "https://www.gnu.org/software/classpath/license.html" )

            .urlInfo( "http://gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .urlInfo( "https://gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/software/classpath/license.html", "f2aa58abadc943bfe830f1aaf00e54fb2f4a2f88", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-2.0-with-font-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-2.0-with-font-exception.json" )
            .name( "GNU General Public License v2.0 w/Font exception" )
            .licenseId( "GPL-2.0-with-font-exception" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-faq.html#FontException" )

            .urlInfo( "http://gnu.org/licenses/gpl-faq.html#FontException", "ca693f05e4340375bea8f86a0977cfd6232d8841", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-faq.html#FontException", "ca693f05e4340375bea8f86a0977cfd6232d8841", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-faq.html#FontException", "ca693f05e4340375bea8f86a0977cfd6232d8841", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-faq.html#FontException", "ca693f05e4340375bea8f86a0977cfd6232d8841", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0.json" )
            .name( "GNU General Public License v3.0 only" )
            .licenseId( "GPL-3.0" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0+.json" )
            .name( "GNU General Public License v3.0 or later" )
            .licenseId( "GPL-3.0+" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-only.json" )
            .name( "GNU General Public License v3.0 only" )
            .licenseId( "GPL-3.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-or-later.json" )
            .name( "GNU General Public License v3.0 or later" )
            .licenseId( "GPL-3.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/gpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/GPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0-standalone.html", "20c27b0c56d6f42af9917024ad1a12ccc66dde77", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/GPL-3.0", "7495048ef61372884b9904f9c5d9a70b15439bf8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gpl-3.0.txt", "31a3d460bb3c7d98845187c716a30db81c44b615", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-with-GCC-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-with-GCC-exception.json" )
            .name( "GNU General Public License v3.0 w/GCC Runtime Library exception" )
            .licenseId( "GPL-3.0-with-GCC-exception" )
            .seeAlso( "https://www.gnu.org/licenses/gcc-exception-3.1.html" )

            .urlInfo( "http://gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/gcc-exception-3.1.html", "17068db547b1170cbd73b970c489f97735005b22", "text/html", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./GPL-3.0-with-autoconf-exception.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/GPL-3.0-with-autoconf-exception.json" )
            .name( "GNU General Public License v3.0 w/Autoconf exception" )
            .licenseId( "GPL-3.0-with-autoconf-exception" )
            .seeAlso( "https://www.gnu.org/licenses/autoconf-exception-3.0.html" )

            .urlInfo( "http://gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/autoconf-exception-3.0.html", "ac3cdc23356a60d32cbb3468f26f280c28e7cad1", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Giftware.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Giftware.json" )
            .name( "Giftware License" )
            .licenseId( "Giftware" )
            .seeAlso( "http://liballeg.org/license.html#allegro-4-the-giftware-license" )

            .urlInfo( "http://liballeg.org/license.html#allegro-4-the-giftware-license", "18be1027c26d30dfcb4e438e3d72a6923e5b3726", "text/html", true, false )
            .urlInfo( "http://www.liballeg.org/license.html#allegro-4-the-giftware-license", "18be1027c26d30dfcb4e438e3d72a6923e5b3726", "text/html", true, false )
            .urlInfo( "https://liballeg.org/license.html#allegro-4-the-giftware-license", "18be1027c26d30dfcb4e438e3d72a6923e5b3726", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Glide.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Glide.json" )
            .name( "3dfx Glide License" )
            .licenseId( "Glide" )
            .seeAlso( "http://www.users.on.net/~triforce/glidexp/COPYING.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Glulxe.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Glulxe.json" )
            .name( "Glulxe License" )
            .licenseId( "Glulxe" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Glulxe" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Glulxe", "600d85936d36afb8036d6679cd6ff0b6cd866897", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Glulxe", "600d85936d36afb8036d6679cd6ff0b6cd866897", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./HPND.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/HPND.json" )
            .name( "Historical Permission Notice and Disclaimer" )
            .licenseId( "HPND" )
            .seeAlso( "https://opensource.org/licenses/HPND" )

            .urlInfo( "http://opensource.org/licenses/HPND", "6a2cd3da04b29962721bd04032669cd99654723e", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/HPND", "6a2cd3da04b29962721bd04032669cd99654723e", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/HPND", "6a2cd3da04b29962721bd04032669cd99654723e", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/HPND", "6a2cd3da04b29962721bd04032669cd99654723e", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./HPND-sell-variant.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/HPND-sell-variant.json" )
            .name( "Historical Permission Notice and Disclaimer - sell variant" )
            .licenseId( "HPND-sell-variant" )
            .seeAlso( "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./HaskellReport.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/HaskellReport.json" )
            .name( "Haskell Language Report License" )
            .licenseId( "HaskellReport" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License", "2143a9ff2a144a2b1e5f05cd2db753701b17aeb3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License", "2143a9ff2a144a2b1e5f05cd2db753701b17aeb3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IBM-pibs.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/IBM-pibs.json" )
            .name( "IBM PowerPC Initialization and Boot Software" )
            .licenseId( "IBM-pibs" )
            .seeAlso( "http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d" )

            .urlInfo( "http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d", "5fb6ed7cf5e7c925eb5f262b29acd6aefaf925fb", "text/html", true, false )
            .urlInfo( "https://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d", "5fb6ed7cf5e7c925eb5f262b29acd6aefaf925fb", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ICU.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ICU.json" )
            .name( "ICU License" )
            .licenseId( "ICU" )
            .seeAlso( "http://source.icu-project.org/repos/icu/icu/trunk/license.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IJG.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/IJG.json" )
            .name( "Independent JPEG Group License" )
            .licenseId( "IJG" )
            .seeAlso( "http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2" )

            .urlInfo( "http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2", "8501b4b302c4c2f6f67f82159b8e7c2388227e93", "text/html", true, false )
            .urlInfo( "https://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2", "8501b4b302c4c2f6f67f82159b8e7c2388227e93", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IPA.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/IPA.json" )
            .name( "IPA Font License" )
            .licenseId( "IPA" )
            .seeAlso( "https://opensource.org/licenses/IPA" )

            .urlInfo( "http://opensource.org/licenses/IPA", "c3c56e9482ac217c0898881a7eb2f41cd6e59449", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/IPA", "c3c56e9482ac217c0898881a7eb2f41cd6e59449", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/IPA", "c3c56e9482ac217c0898881a7eb2f41cd6e59449", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/IPA", "c3c56e9482ac217c0898881a7eb2f41cd6e59449", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./IPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/IPL-1.0.json" )
            .name( "IBM Public License v1.0" )
            .licenseId( "IPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/IPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/IPL-1.0", "c45cea256e89c3f37e029d04b9a973719c17c536", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/IPL-1.0", "c45cea256e89c3f37e029d04b9a973719c17c536", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/IPL-1.0", "c45cea256e89c3f37e029d04b9a973719c17c536", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/IPL-1.0", "c45cea256e89c3f37e029d04b9a973719c17c536", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ISC.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ISC.json" )
            .name( "ISC License" )
            .licenseId( "ISC" )
            .seeAlso( "https://www.isc.org/downloads/software-support-policy/isc-license/" )
            .seeAlso( "https://opensource.org/licenses/ISC" )

            .urlInfo( "https://isc.org/downloads/software-support-policy/isc-license/", "0ed942cb7331f4396a838bac42ff13ca72cf568c", "text/html", true, false )
            .urlInfo( "https://www.isc.org/downloads/software-support-policy/isc-license/", "0ed942cb7331f4396a838bac42ff13ca72cf568c", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/ISC", "6cd8a2cb39eb7f9f27fc68870341ba32c01d58d4", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/ISC", "6cd8a2cb39eb7f9f27fc68870341ba32c01d58d4", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/ISC", "6cd8a2cb39eb7f9f27fc68870341ba32c01d58d4", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/ISC", "6cd8a2cb39eb7f9f27fc68870341ba32c01d58d4", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ImageMagick.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ImageMagick.json" )
            .name( "ImageMagick License" )
            .licenseId( "ImageMagick" )
            .seeAlso( "http://www.imagemagick.org/script/license.php" )

            .urlInfo( "http://imagemagick.org/script/license.php", "af2eee0fc029843aa9886ed7cc299416cd38bfcc", "text/html", true, false )
            .urlInfo( "http://www.imagemagick.org/script/license.php", "af2eee0fc029843aa9886ed7cc299416cd38bfcc", "text/html", true, false )
            .urlInfo( "https://imagemagick.org/script/license.php", "af2eee0fc029843aa9886ed7cc299416cd38bfcc", "text/html", true, false )
            .urlInfo( "https://www.imagemagick.org/script/license.php", "af2eee0fc029843aa9886ed7cc299416cd38bfcc", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Imlib2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Imlib2.json" )
            .name( "Imlib2 License" )
            .licenseId( "Imlib2" )
            .seeAlso( "http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING" )
            .seeAlso( "https://git.enlightenment.org/legacy/imlib2.git/tree/COPYING" )

            .urlInfo( "http://git.enlightenment.org/legacy/imlib2.git/tree/COPYING", "8d76e9f6926b7a97f0d57efe16a9685e36e89995", "text/html", true, false )
            .urlInfo( "https://git.enlightenment.org/legacy/imlib2.git/tree/COPYING", "8d76e9f6926b7a97f0d57efe16a9685e36e89995", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Info-ZIP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Info-ZIP.json" )
            .name( "Info-ZIP License" )
            .licenseId( "Info-ZIP" )
            .seeAlso( "http://www.info-zip.org/license.html" )

            .urlInfo( "http://info-zip.org/license.html", "9596ecc43b8d17228cdf3f5658b9460f653e59ff", "text/html", true, false )
            .urlInfo( "http://www.info-zip.org/license.html", "9596ecc43b8d17228cdf3f5658b9460f653e59ff", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Intel.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Intel.json" )
            .name( "Intel Open Source License" )
            .licenseId( "Intel" )
            .seeAlso( "https://opensource.org/licenses/Intel" )

            .urlInfo( "http://opensource.org/licenses/Intel", "8869c958cebbb1314ccf8d9e3ef5e8b1a3ae6046", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Intel", "8869c958cebbb1314ccf8d9e3ef5e8b1a3ae6046", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Intel", "8869c958cebbb1314ccf8d9e3ef5e8b1a3ae6046", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Intel", "8869c958cebbb1314ccf8d9e3ef5e8b1a3ae6046", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Intel-ACPI.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Intel-ACPI.json" )
            .name( "Intel ACPI Software License Agreement" )
            .licenseId( "Intel-ACPI" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Interbase-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Interbase-1.0.json" )
            .name( "Interbase Public License v1.0" )
            .licenseId( "Interbase-1.0" )
            .seeAlso( "https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./JPNIC.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/JPNIC.json" )
            .name( "Japan Network Information Center License" )
            .licenseId( "JPNIC" )
            .seeAlso( "https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366" )

            .urlInfo( "https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./JSON.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/JSON.json" )
            .name( "JSON License" )
            .licenseId( "JSON" )
            .seeAlso( "http://www.json.org/license.html" )

            .urlInfo( "http://json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .urlInfo( "http://www.json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .urlInfo( "https://json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .urlInfo( "https://www.json.org/license.html", "9689700df3dd203628d104bb10834983685bf53a", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./JasPer-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/JasPer-2.0.json" )
            .name( "JasPer License" )
            .licenseId( "JasPer-2.0" )
            .seeAlso( "http://www.ece.uvic.ca/~mdadams/jasper/LICENSE" )

            .urlInfo( "http://ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .urlInfo( "http://www.ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .urlInfo( "https://ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .urlInfo( "https://www.ece.uvic.ca/~mdadams/jasper/LICENSE", "14b5d0210560128e1a5d5204698cf705011ef792", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LAL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LAL-1.2.json" )
            .name( "Licence Art Libre 1.2" )
            .licenseId( "LAL-1.2" )
            .seeAlso( "http://artlibre.org/licence/lal/licence-art-libre-12/" )

            .urlInfo( "http://artlibre.org/licence/lal/licence-art-libre-12/", "df23d3e0f1fca6107f079efe462314636f5c2641", "text/html", true, true )
            .urlInfo( "http://www.artlibre.org/licence/lal/licence-art-libre-12/", "df23d3e0f1fca6107f079efe462314636f5c2641", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LAL-1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LAL-1.3.json" )
            .name( "Licence Art Libre 1.3" )
            .licenseId( "LAL-1.3" )
            .seeAlso( "http://artlibre.org/" )

            .urlInfo( "http://artlibre.org/", "ccb30a10a3d0eae7a668ae6e711c55d000f6d7b3", "text/html", true, true )
            .urlInfo( "http://www.artlibre.org/", "ccb30a10a3d0eae7a668ae6e711c55d000f6d7b3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0.json" )
            .name( "GNU Library General Public License v2 only" )
            .licenseId( "LGPL-2.0" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0+.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0+.json" )
            .name( "GNU Library General Public License v2 or later" )
            .licenseId( "LGPL-2.0+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0-only.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0-only.json" )
            .name( "GNU Library General Public License v2 only" )
            .licenseId( "LGPL-2.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.0-or-later.json" )
            .name( "GNU Library General Public License v2 or later" )
            .licenseId( "LGPL-2.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html", "914d8333aaf7cdc7937142f1bb66972a98c2604b", "text/html", true, false )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.0.txt", "ba8966e2473a9969bdcab3dc82274c817cfd98a1", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1.json" )
            .name( "GNU Lesser General Public License v2.1 only" )
            .licenseId( "LGPL-2.1" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1+.json" )
            .name( "GNU Library General Public License v2.1 or later" )
            .licenseId( "LGPL-2.1+" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1-only.json" )
            .name( "GNU Lesser General Public License v2.1 only" )
            .licenseId( "LGPL-2.1-only" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-2.1-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-2.1-or-later.json" )
            .name( "GNU Lesser General Public License v2.1 or later" )
            .licenseId( "LGPL-2.1-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-2.1" )

            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html", "2f96f4fd713e61fb00bb9f3ba073f029afce2ace", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-2.1", "1fa1934d71abece4babf044b82e3a8ba0d534e35", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt", "01a6b4bf79aca9b556822601186afab86e8c4fbf", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0.json" )
            .name( "GNU Lesser General Public License v3.0 only" )
            .licenseId( "LGPL-3.0" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0+.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0+.json" )
            .name( "GNU Lesser General Public License v3.0 or later" )
            .licenseId( "LGPL-3.0+" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0-only.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0-only.json" )
            .name( "GNU Lesser General Public License v3.0 only" )
            .licenseId( "LGPL-3.0-only" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPL-3.0-or-later.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LGPL-3.0-or-later.json" )
            .name( "GNU Lesser General Public License v3.0 or later" )
            .licenseId( "LGPL-3.0-or-later" )
            .seeAlso( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html" )
            .seeAlso( "https://opensource.org/licenses/LGPL-3.0" )

            .urlInfo( "http://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0-standalone.html", "836ef8f5615224a0f967cfe45bae4fdec8cef5ec", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LGPL-3.0", "950ca7d7ca79b6f0924bd4638961cb6ea33b4fc8", "text/html", false, true )
            .urlInfo( "http://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "http://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.fsf.org/licensing/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .urlInfo( "https://www.gnu.org/licenses/lgpl-3.0.txt", "a8a12e6867d7ee39c21d9b11a984066099b6fb6b", "text/plain", true, false )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LGPLLR.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LGPLLR.json" )
            .name( "Lesser General Public License For Linguistic Resources" )
            .licenseId( "LGPLLR" )
            .seeAlso( "http://www-igm.univ-mlv.fr/~unitex/lgpllr.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPL-1.0.json" )
            .name( "Lucent Public License Version 1.0" )
            .licenseId( "LPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/LPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/LPL-1.0", "aef9ac68795f04ce50433263b6efb2f609260206", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LPL-1.0", "aef9ac68795f04ce50433263b6efb2f609260206", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LPL-1.0", "aef9ac68795f04ce50433263b6efb2f609260206", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LPL-1.0", "aef9ac68795f04ce50433263b6efb2f609260206", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPL-1.02.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LPL-1.02.json" )
            .name( "Lucent Public License v1.02" )
            .licenseId( "LPL-1.02" )
            .seeAlso( "http://plan9.bell-labs.com/plan9/license.html" )
            .seeAlso( "https://opensource.org/licenses/LPL-1.02" )

            .urlInfo( "http://opensource.org/licenses/LPL-1.02", "2b017f711d2a635a6c7a4e963f9559115d1be84a", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LPL-1.02", "2b017f711d2a635a6c7a4e963f9559115d1be84a", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LPL-1.02", "2b017f711d2a635a6c7a4e963f9559115d1be84a", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LPL-1.02", "2b017f711d2a635a6c7a4e963f9559115d1be84a", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.0.json" )
            .name( "LaTeX Project Public License v1.0" )
            .licenseId( "LPPL-1.0" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-0.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-0.txt", "9e9d71e01cc812a7687e88937b03bf32b05c2e2c", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.1.json" )
            .name( "LaTeX Project Public License v1.1" )
            .licenseId( "LPPL-1.1" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-1.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-1.txt", "19223302b3aa61c5217db535db4cdb076a78e986", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.2.json" )
            .name( "LaTeX Project Public License v1.2" )
            .licenseId( "LPPL-1.2" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-2.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-2.txt", "aca248747daf649ff8a701277dd67c55476eb982", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.3a.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.3a.json" )
            .name( "LaTeX Project Public License v1.3a" )
            .licenseId( "LPPL-1.3a" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-3a.txt" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-3a.txt", "2c40ed15717ba7ffcf1f93fa2d6f31b5d930237f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LPPL-1.3c.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LPPL-1.3c.json" )
            .name( "LaTeX Project Public License v1.3c" )
            .licenseId( "LPPL-1.3c" )
            .seeAlso( "http://www.latex-project.org/lppl/lppl-1-3c.txt" )
            .seeAlso( "https://opensource.org/licenses/LPPL-1.3c" )

            .urlInfo( "http://latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "http://www.latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "https://latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "https://www.latex-project.org/lppl/lppl-1-3c.txt", "47438d5b2ab351796b64b62da105432ab71369ab", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/LPPL-1.3c", "705d86fc7853fd43cca153606a98abfa56699d6d", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LPPL-1.3c", "705d86fc7853fd43cca153606a98abfa56699d6d", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LPPL-1.3c", "705d86fc7853fd43cca153606a98abfa56699d6d", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LPPL-1.3c", "705d86fc7853fd43cca153606a98abfa56699d6d", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Latex2e.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Latex2e.json" )
            .name( "Latex2e License" )
            .licenseId( "Latex2e" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Latex2e" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Latex2e", "0066fc8656056ea9b2ef1484d3756c777f73f1f6", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Latex2e", "0066fc8656056ea9b2ef1484d3756c777f73f1f6", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Latex2e", "0066fc8656056ea9b2ef1484d3756c777f73f1f6", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Latex2e", "0066fc8656056ea9b2ef1484d3756c777f73f1f6", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Leptonica.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Leptonica.json" )
            .name( "Leptonica License" )
            .licenseId( "Leptonica" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Leptonica" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Leptonica", "a346e354e8a0b57cfb128a55703c5cf1f6d2fff8", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Leptonica", "a346e354e8a0b57cfb128a55703c5cf1f6d2fff8", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Leptonica", "a346e354e8a0b57cfb128a55703c5cf1f6d2fff8", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Leptonica", "a346e354e8a0b57cfb128a55703c5cf1f6d2fff8", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LiLiQ-P-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LiLiQ-P-1.1.json" )
            .name( "Licence Libre du Québec – Permissive version 1.1" )
            .licenseId( "LiLiQ-P-1.1" )
            .seeAlso( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/" )
            .seeAlso( "http://opensource.org/licenses/LiLiQ-P-1.1" )

            .urlInfo( "http://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LiLiQ-P-1.1", "b60c7fd62b5cfdc339053985d37499e0a759c610", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LiLiQ-P-1.1", "b60c7fd62b5cfdc339053985d37499e0a759c610", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LiLiQ-P-1.1", "b60c7fd62b5cfdc339053985d37499e0a759c610", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LiLiQ-P-1.1", "b60c7fd62b5cfdc339053985d37499e0a759c610", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LiLiQ-R-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LiLiQ-R-1.1.json" )
            .name( "Licence Libre du Québec – Réciprocité version 1.1" )
            .licenseId( "LiLiQ-R-1.1" )
            .seeAlso( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/" )
            .seeAlso( "http://opensource.org/licenses/LiLiQ-R-1.1" )

            .urlInfo( "http://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LiLiQ-R-1.1", "480556fc34dc97fbeb6c5e11875878649b809a9e", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LiLiQ-R-1.1", "480556fc34dc97fbeb6c5e11875878649b809a9e", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LiLiQ-R-1.1", "480556fc34dc97fbeb6c5e11875878649b809a9e", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LiLiQ-R-1.1", "480556fc34dc97fbeb6c5e11875878649b809a9e", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./LiLiQ-Rplus-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/LiLiQ-Rplus-1.1.json" )
            .name( "Licence Libre du Québec – Réciprocité forte version 1.1" )
            .licenseId( "LiLiQ-Rplus-1.1" )
            .seeAlso( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/" )
            .seeAlso( "http://opensource.org/licenses/LiLiQ-Rplus-1.1" )

            .urlInfo( "http://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/licence/fr/liliq-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/", "343a5d92df234cbcd462c8b7a4cf17fcc22227c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/LiLiQ-Rplus-1.1", "6ef18e065862cd3ca4ba4ffe313c760d4133d121", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/LiLiQ-Rplus-1.1", "6ef18e065862cd3ca4ba4ffe313c760d4133d121", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/LiLiQ-Rplus-1.1", "6ef18e065862cd3ca4ba4ffe313c760d4133d121", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/LiLiQ-Rplus-1.1", "6ef18e065862cd3ca4ba4ffe313c760d4133d121", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Libpng.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Libpng.json" )
            .name( "libpng License" )
            .licenseId( "Libpng" )
            .seeAlso( "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt" )

            .urlInfo( "http://libpng.org/pub/png/src/libpng-LICENSE.txt", "e01ba244558d7a6b6729885beb54e9e561583101", "text/plain", true, false )
            .urlInfo( "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt", "e01ba244558d7a6b6729885beb54e9e561583101", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Linux-OpenIB.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Linux-OpenIB.json" )
            .name( "Linux Kernel Variant of OpenIB.org license" )
            .licenseId( "Linux-OpenIB" )
            .seeAlso( "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MIT.json" )
            .name( "MIT License" )
            .licenseId( "MIT" )
            .seeAlso( "https://opensource.org/licenses/MIT" )

            .urlInfo( "http://opensource.org/licenses/MIT", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/mit-license", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/mit-license.html", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://opensource.org/licenses/mit-license.php", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MIT", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/mit-license", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/mit-license.html", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/mit-license.php", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MIT", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/mit-license", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/mit-license.html", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/mit-license.php", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MIT", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/mit-license", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/mit-license.html", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/mit-license.php", "8b1421deee0354c1f9b222e29b54eab50ae2aab3", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-0.json" )
            .name( "MIT No Attribution" )
            .licenseId( "MIT-0" )
            .seeAlso( "https://github.com/aws/mit-0" )
            .seeAlso( "https://romanrm.net/mit-zero" )
            .seeAlso( "https://github.com/awsdocs/aws-cloud9-user-guide/blob/master/LICENSE-SAMPLECODE" )

            .urlInfo( "http://romanrm.net/mit-zero", "55f98e9956fa88358c1ece191b8ba14dbc0f44ef", "text/html", true, true )
            .urlInfo( "https://romanrm.net/mit-zero", "55f98e9956fa88358c1ece191b8ba14dbc0f44ef", "text/html", true, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-CMU.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-CMU.json" )
            .name( "CMU License" )
            .licenseId( "MIT-CMU" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style" )
            .seeAlso( "https://github.com/python-pillow/Pillow/blob/fffb426092c8db24a5f4b6df243a8a3c01fb63cd/LICENSE" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-advertising.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-advertising.json" )
            .name( "Enlightenment License (e16)" )
            .licenseId( "MIT-advertising" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "9d60fdaa27de956f7d28dcfdec9b4de7920c7f22", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "9d60fdaa27de956f7d28dcfdec9b4de7920c7f22", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "9d60fdaa27de956f7d28dcfdec9b4de7920c7f22", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT_With_Advertising", "9d60fdaa27de956f7d28dcfdec9b4de7920c7f22", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-enna.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-enna.json" )
            .name( "enna License" )
            .licenseId( "MIT-enna" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT#enna" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MIT-feh.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MIT-feh.json" )
            .name( "feh License" )
            .licenseId( "MIT-feh" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT#feh" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MITNFA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MITNFA.json" )
            .name( "MIT +no-false-attribs license" )
            .licenseId( "MITNFA" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MITNFA" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MITNFA", "77ae78dbb8de0913de66c4fdcc4a587f8318daeb", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MITNFA", "77ae78dbb8de0913de66c4fdcc4a587f8318daeb", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MITNFA", "77ae78dbb8de0913de66c4fdcc4a587f8318daeb", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MITNFA", "77ae78dbb8de0913de66c4fdcc4a587f8318daeb", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MPL-1.0.json" )
            .name( "Mozilla Public License 1.0" )
            .licenseId( "MPL-1.0" )
            .seeAlso( "http://www.mozilla.org/MPL/MPL-1.0.html" )
            .seeAlso( "https://opensource.org/licenses/MPL-1.0" )

            .urlInfo( "http://mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/MPL-1.0.html", "ea7ac7d1a5d6a61095e8513045f789e695739ab4", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-1.0", "80429e50a57da7e83d1ebc0e92a7407195b0edf9", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-1.0", "80429e50a57da7e83d1ebc0e92a7407195b0edf9", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MPL-1.0", "80429e50a57da7e83d1ebc0e92a7407195b0edf9", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-1.0", "80429e50a57da7e83d1ebc0e92a7407195b0edf9", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MPL-1.1.json" )
            .name( "Mozilla Public License 1.1" )
            .licenseId( "MPL-1.1" )
            .seeAlso( "http://www.mozilla.org/MPL/MPL-1.1.html" )
            .seeAlso( "https://opensource.org/licenses/MPL-1.1" )

            .urlInfo( "http://mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/MPL-1.1.html", "9e1fce8c91325bc318442713e4884137370e9147", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-1.1", "16e335a43c3f7ade9aed1f91e052f660a90e42c1", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-1.1", "16e335a43c3f7ade9aed1f91e052f660a90e42c1", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MPL-1.1", "16e335a43c3f7ade9aed1f91e052f660a90e42c1", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-1.1", "16e335a43c3f7ade9aed1f91e052f660a90e42c1", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MPL-2.0.json" )
            .name( "Mozilla Public License 2.0" )
            .licenseId( "MPL-2.0" )
            .seeAlso( "http://www.mozilla.org/MPL/2.0/" )
            .seeAlso( "https://opensource.org/licenses/MPL-2.0" )

            .urlInfo( "http://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MPL-2.0-no-copyleft-exception.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MPL-2.0-no-copyleft-exception.json" )
            .name( "Mozilla Public License 2.0 (no copyleft exception)" )
            .licenseId( "MPL-2.0-no-copyleft-exception" )
            .seeAlso( "http://www.mozilla.org/MPL/2.0/" )
            .seeAlso( "https://opensource.org/licenses/MPL-2.0" )

            .urlInfo( "http://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/2.0/", "39842cd17d783d2a49035cdb59bf800a79df0d4e", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MPL-2.0", "9fd2b073513bc1b9cde16c3d1321ef54f30dc98b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MS-PL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MS-PL.json" )
            .name( "Microsoft Public License" )
            .licenseId( "MS-PL" )
            .seeAlso( "http://www.microsoft.com/opensource/licenses.mspx" )
            .seeAlso( "https://opensource.org/licenses/MS-PL" )

            .urlInfo( "http://opensource.org/licenses/MS-PL", "189e532febe1cd9cfeb7c8b56b8049de43f94317", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MS-PL", "189e532febe1cd9cfeb7c8b56b8049de43f94317", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MS-PL", "189e532febe1cd9cfeb7c8b56b8049de43f94317", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MS-PL", "189e532febe1cd9cfeb7c8b56b8049de43f94317", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MS-RL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/MS-RL.json" )
            .name( "Microsoft Reciprocal License" )
            .licenseId( "MS-RL" )
            .seeAlso( "http://www.microsoft.com/opensource/licenses.mspx" )
            .seeAlso( "https://opensource.org/licenses/MS-RL" )

            .urlInfo( "http://opensource.org/licenses/MS-RL", "079a7e50ad644e15382dae28d51fc71bb73c3f5b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MS-RL", "079a7e50ad644e15382dae28d51fc71bb73c3f5b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MS-RL", "079a7e50ad644e15382dae28d51fc71bb73c3f5b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MS-RL", "079a7e50ad644e15382dae28d51fc71bb73c3f5b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MTLL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MTLL.json" )
            .name( "Matrix Template Library License" )
            .licenseId( "MTLL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "e779f5af14f0e2b439bc2c1085aa853ad2c0eab0", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "e779f5af14f0e2b439bc2c1085aa853ad2c0eab0", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "e779f5af14f0e2b439bc2c1085aa853ad2c0eab0", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License", "e779f5af14f0e2b439bc2c1085aa853ad2c0eab0", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MakeIndex.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MakeIndex.json" )
            .name( "MakeIndex License" )
            .licenseId( "MakeIndex" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MakeIndex" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MakeIndex", "15f6eb6ff20e78fc7622405ad1998ed2c83c2d3e", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MakeIndex", "15f6eb6ff20e78fc7622405ad1998ed2c83c2d3e", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MakeIndex", "15f6eb6ff20e78fc7622405ad1998ed2c83c2d3e", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MakeIndex", "15f6eb6ff20e78fc7622405ad1998ed2c83c2d3e", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./MirOS.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/MirOS.json" )
            .name( "MirOS License" )
            .licenseId( "MirOS" )
            .seeAlso( "https://opensource.org/licenses/MirOS" )

            .urlInfo( "http://opensource.org/licenses/MirOS", "9e09375730143747ce1086fbbf48737c05f39a2e", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/MirOS", "9e09375730143747ce1086fbbf48737c05f39a2e", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/MirOS", "9e09375730143747ce1086fbbf48737c05f39a2e", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/MirOS", "9e09375730143747ce1086fbbf48737c05f39a2e", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Motosoto.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Motosoto.json" )
            .name( "Motosoto License" )
            .licenseId( "Motosoto" )
            .seeAlso( "https://opensource.org/licenses/Motosoto" )

            .urlInfo( "http://opensource.org/licenses/Motosoto", "f75ccbf1997379673ac1375318e9ef1e17ecd2a6", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Motosoto", "f75ccbf1997379673ac1375318e9ef1e17ecd2a6", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Motosoto", "f75ccbf1997379673ac1375318e9ef1e17ecd2a6", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Motosoto", "f75ccbf1997379673ac1375318e9ef1e17ecd2a6", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Multics.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Multics.json" )
            .name( "Multics License" )
            .licenseId( "Multics" )
            .seeAlso( "https://opensource.org/licenses/Multics" )

            .urlInfo( "http://opensource.org/licenses/Multics", "acba80ae79da50677054d03fd656904a2562f46f", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Multics", "acba80ae79da50677054d03fd656904a2562f46f", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Multics", "acba80ae79da50677054d03fd656904a2562f46f", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Multics", "acba80ae79da50677054d03fd656904a2562f46f", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Mup.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Mup.json" )
            .name( "Mup License" )
            .licenseId( "Mup" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Mup" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Mup", "f9ce2914ce453db5f9b436b5f663b147cbbfbd11", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Mup", "f9ce2914ce453db5f9b436b5f663b147cbbfbd11", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Mup", "f9ce2914ce453db5f9b436b5f663b147cbbfbd11", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Mup", "f9ce2914ce453db5f9b436b5f663b147cbbfbd11", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NASA-1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NASA-1.3.json" )
            .name( "NASA Open Source Agreement 1.3" )
            .licenseId( "NASA-1.3" )
            .seeAlso( "http://ti.arc.nasa.gov/opensource/nosa/" )
            .seeAlso( "https://opensource.org/licenses/NASA-1.3" )

            .urlInfo( "http://ti.arc.nasa.gov/opensource/nosa/", "11e8aeb6176bf4bcc52cbef177c081bf099cccae", "text/html", true, false )
            .urlInfo( "https://ti.arc.nasa.gov/opensource/nosa/", "11e8aeb6176bf4bcc52cbef177c081bf099cccae", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/NASA-1.3", "29681c7ddf72b212da244a0102e5bfdd37949661", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/NASA-1.3", "29681c7ddf72b212da244a0102e5bfdd37949661", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/NASA-1.3", "29681c7ddf72b212da244a0102e5bfdd37949661", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/NASA-1.3", "29681c7ddf72b212da244a0102e5bfdd37949661", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NBPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NBPL-1.0.json" )
            .name( "Net Boolean Public License v1" )
            .licenseId( "NBPL-1.0" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894", "59fd5b5f04cbeef07405d2459c0016d9fd334d7d", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894", "59fd5b5f04cbeef07405d2459c0016d9fd334d7d", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894", "59fd5b5f04cbeef07405d2459c0016d9fd334d7d", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NCSA.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NCSA.json" )
            .name( "University of Illinois/NCSA Open Source License" )
            .licenseId( "NCSA" )
            .seeAlso( "http://otm.illinois.edu/uiuc_openSource" )
            .seeAlso( "https://opensource.org/licenses/NCSA" )

            .urlInfo( "http://opensource.org/licenses/NCSA", "3141b0642cf9e6e44ca952c0df2805d1394d5072", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/NCSA", "3141b0642cf9e6e44ca952c0df2805d1394d5072", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/NCSA", "3141b0642cf9e6e44ca952c0df2805d1394d5072", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/NCSA", "3141b0642cf9e6e44ca952c0df2805d1394d5072", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NGPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NGPL.json" )
            .name( "Nethack General Public License" )
            .licenseId( "NGPL" )
            .seeAlso( "https://opensource.org/licenses/NGPL" )

            .urlInfo( "http://opensource.org/licenses/NGPL", "9a429cbf18343b339a7414c0bcc7a5999b9bd3ec", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/NGPL", "9a429cbf18343b339a7414c0bcc7a5999b9bd3ec", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/NGPL", "9a429cbf18343b339a7414c0bcc7a5999b9bd3ec", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/NGPL", "9a429cbf18343b339a7414c0bcc7a5999b9bd3ec", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NLOD-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NLOD-1.0.json" )
            .name( "Norwegian Licence for Open Government Data" )
            .licenseId( "NLOD-1.0" )
            .seeAlso( "http://data.norge.no/nlod/en/1.0" )

            .urlInfo( "http://data.norge.no/nlod/en/1.0", "3df89100286eb8f646295e602b440b889edfe1da", "text/html", true, true )
            .urlInfo( "http://www.data.norge.no/nlod/en/1.0", "3df89100286eb8f646295e602b440b889edfe1da", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NLPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NLPL.json" )
            .name( "No Limit Public License" )
            .licenseId( "NLPL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/NLPL" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/NLPL", "7b9bbe8df25314d0b33a26631f1cb64b41c55628", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/NLPL", "7b9bbe8df25314d0b33a26631f1cb64b41c55628", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NOSL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NOSL.json" )
            .name( "Netizen Open Source License" )
            .licenseId( "NOSL" )
            .seeAlso( "http://bits.netizen.com.au/licenses/NOSL/nosl.txt" )

            .urlInfo( "http://bits.netizen.com.au/licenses/NOSL/nosl.txt", "5468229b50c59c46a173a76abbca76bba8943b2a", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NPL-1.0.json" )
            .name( "Netscape Public License v1.0" )
            .licenseId( "NPL-1.0" )
            .seeAlso( "http://www.mozilla.org/MPL/NPL/1.0/" )

            .urlInfo( "http://mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/NPL/1.0/", "2d48e993387d4f0129ea1d2a3823c642dfffbbea", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/NPL-1.1.json" )
            .name( "Netscape Public License v1.1" )
            .licenseId( "NPL-1.1" )
            .seeAlso( "http://www.mozilla.org/MPL/NPL/1.1/" )

            .urlInfo( "http://mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .urlInfo( "http://www.mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .urlInfo( "https://mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .urlInfo( "https://www.mozilla.org/MPL/NPL/1.1/", "b4f7d615c5c6be87e982daca7276bddb0b3aa1e8", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NPOSL-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NPOSL-3.0.json" )
            .name( "Non-Profit Open Software License 3.0" )
            .licenseId( "NPOSL-3.0" )
            .seeAlso( "https://opensource.org/licenses/NOSL3.0" )

            .urlInfo( "http://opensource.org/licenses/NOSL3.0", "3aa334e9eba1c77cc197cd922a4f6527e58232ce", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/NOSL3.0", "3aa334e9eba1c77cc197cd922a4f6527e58232ce", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/NOSL3.0", "3aa334e9eba1c77cc197cd922a4f6527e58232ce", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/NOSL3.0", "3aa334e9eba1c77cc197cd922a4f6527e58232ce", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NRL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NRL.json" )
            .name( "NRL License" )
            .licenseId( "NRL" )
            .seeAlso( "http://web.mit.edu/network/isakmp/nrllicense.html" )

            .urlInfo( "http://web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .urlInfo( "http://www.web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .urlInfo( "https://web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .urlInfo( "https://www.web.mit.edu/network/isakmp/nrllicense.html", "0edd2bba1c9c88cc21d6300ed0572528e9c55970", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NTP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NTP.json" )
            .name( "NTP License" )
            .licenseId( "NTP" )
            .seeAlso( "https://opensource.org/licenses/NTP" )

            .urlInfo( "http://opensource.org/licenses/NTP", "aedbe014257dedfc949723821731ad7736b54956", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/NTP", "aedbe014257dedfc949723821731ad7736b54956", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/NTP", "aedbe014257dedfc949723821731ad7736b54956", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/NTP", "aedbe014257dedfc949723821731ad7736b54956", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Naumen.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Naumen.json" )
            .name( "Naumen Public License" )
            .licenseId( "Naumen" )
            .seeAlso( "https://opensource.org/licenses/Naumen" )

            .urlInfo( "http://opensource.org/licenses/Naumen", "83a7381f252c5a90fb736d1025f53923f699766b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Naumen", "83a7381f252c5a90fb736d1025f53923f699766b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Naumen", "83a7381f252c5a90fb736d1025f53923f699766b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Naumen", "83a7381f252c5a90fb736d1025f53923f699766b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Net-SNMP.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Net-SNMP.json" )
            .name( "Net-SNMP License" )
            .licenseId( "Net-SNMP" )
            .seeAlso( "http://net-snmp.sourceforge.net/about/license.html" )

            .urlInfo( "http://net-snmp.sourceforge.net/about/license.html", "25bfbfe536d41d2cbe8666ba72875696e13597ef", "text/html", true, false )
            .urlInfo( "http://www.net-snmp.sourceforge.net/about/license.html", "25bfbfe536d41d2cbe8666ba72875696e13597ef", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./NetCDF.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/NetCDF.json" )
            .name( "NetCDF license" )
            .licenseId( "NetCDF" )
            .seeAlso( "http://www.unidata.ucar.edu/software/netcdf/copyright.html" )

            .urlInfo( "http://unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .urlInfo( "http://www.unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .urlInfo( "https://unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .urlInfo( "https://www.unidata.ucar.edu/software/netcdf/copyright.html", "51ecd7daa1a158a4eaffe3143ebaaeb8d113af4b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Newsletr.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Newsletr.json" )
            .name( "Newsletr License" )
            .licenseId( "Newsletr" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Newsletr" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Newsletr", "b5f0913b2bdce15c3ae466bdd6a7e59f6904ab05", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Newsletr", "b5f0913b2bdce15c3ae466bdd6a7e59f6904ab05", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Newsletr", "b5f0913b2bdce15c3ae466bdd6a7e59f6904ab05", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Newsletr", "b5f0913b2bdce15c3ae466bdd6a7e59f6904ab05", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Nokia.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Nokia.json" )
            .name( "Nokia Open Source License" )
            .licenseId( "Nokia" )
            .seeAlso( "https://opensource.org/licenses/nokia" )

            .urlInfo( "http://opensource.org/licenses/nokia", "36bb5004517048de1274fedc881e5c490679f9b0", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/nokia", "36bb5004517048de1274fedc881e5c490679f9b0", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/nokia", "36bb5004517048de1274fedc881e5c490679f9b0", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/nokia", "36bb5004517048de1274fedc881e5c490679f9b0", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Noweb.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Noweb.json" )
            .name( "Noweb License" )
            .licenseId( "Noweb" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Noweb" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Noweb", "2c5e531960095d86cef306683e4488075aca726d", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Noweb", "2c5e531960095d86cef306683e4488075aca726d", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Noweb", "2c5e531960095d86cef306683e4488075aca726d", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Noweb", "2c5e531960095d86cef306683e4488075aca726d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Nunit.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Nunit.json" )
            .name( "Nunit License" )
            .licenseId( "Nunit" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Nunit" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Nunit", "664c48dfa630b006f31aad9f43cf8e0c2012ead9", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Nunit", "664c48dfa630b006f31aad9f43cf8e0c2012ead9", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Nunit", "664c48dfa630b006f31aad9f43cf8e0c2012ead9", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Nunit", "664c48dfa630b006f31aad9f43cf8e0c2012ead9", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OCCT-PL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OCCT-PL.json" )
            .name( "Open CASCADE Technology Public License" )
            .licenseId( "OCCT-PL" )
            .seeAlso( "http://www.opencascade.com/content/occt-public-license" )

            .urlInfo( "http://opencascade.com/content/occt-public-license", "127bdd9849acb8993f245aab7fd8b7e4dd0b9f72", "text/html", true, true )
            .urlInfo( "http://www.opencascade.com/content/occt-public-license", "127bdd9849acb8993f245aab7fd8b7e4dd0b9f72", "text/html", true, true )
            .urlInfo( "https://opencascade.com/content/occt-public-license", "127bdd9849acb8993f245aab7fd8b7e4dd0b9f72", "text/html", true, true )
            .urlInfo( "https://www.opencascade.com/content/occt-public-license", "127bdd9849acb8993f245aab7fd8b7e4dd0b9f72", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OCLC-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OCLC-2.0.json" )
            .name( "OCLC Research Public License 2.0" )
            .licenseId( "OCLC-2.0" )
            .seeAlso( "http://www.oclc.org/research/activities/software/license/v2final.htm" )
            .seeAlso( "https://opensource.org/licenses/OCLC-2.0" )

            .urlInfo( "http://opensource.org/licenses/OCLC-2.0", "2f94ac172687877d3cb3786f4865c67965ba1647", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OCLC-2.0", "2f94ac172687877d3cb3786f4865c67965ba1647", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OCLC-2.0", "2f94ac172687877d3cb3786f4865c67965ba1647", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OCLC-2.0", "2f94ac172687877d3cb3786f4865c67965ba1647", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ODC-By-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ODC-By-1.0.json" )
            .name( "Open Data Commons Attribution License v1.0" )
            .licenseId( "ODC-By-1.0" )
            .seeAlso( "https://opendatacommons.org/licenses/by/1.0/" )

            .urlInfo( "http://opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .urlInfo( "http://www.opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .urlInfo( "https://opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .urlInfo( "https://www.opendatacommons.org/licenses/by/1.0/", "afbfbf7f0ebef15843a2bffabc45243e3f4d0a89", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ODbL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ODbL-1.0.json" )
            .name( "ODC Open Database License v1.0" )
            .licenseId( "ODbL-1.0" )
            .seeAlso( "http://www.opendatacommons.org/licenses/odbl/1.0/" )

            .urlInfo( "http://opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .urlInfo( "http://www.opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .urlInfo( "https://opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .urlInfo( "https://www.opendatacommons.org/licenses/odbl/1.0/", "fd9b1b8dd63fa929e82acf8b30dc2dd28077017c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OFL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OFL-1.0.json" )
            .name( "SIL Open Font License 1.0" )
            .licenseId( "OFL-1.0" )
            .seeAlso( "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web" )

            .urlInfo( "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OFL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OFL-1.1.json" )
            .name( "SIL Open Font License 1.1" )
            .licenseId( "OFL-1.1" )
            .seeAlso( "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web" )
            .seeAlso( "https://opensource.org/licenses/OFL-1.1" )

            .urlInfo( "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web", null, null, false, false )
            .urlInfo( "http://opensource.org/licenses/OFL-1.1", "e58cf9e0ec535d4fa242ab36f92aded54ec57f7b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OFL-1.1", "e58cf9e0ec535d4fa242ab36f92aded54ec57f7b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OFL-1.1", "e58cf9e0ec535d4fa242ab36f92aded54ec57f7b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OFL-1.1", "e58cf9e0ec535d4fa242ab36f92aded54ec57f7b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGL-UK-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGL-UK-1.0.json" )
            .name( "Open Government Licence v1.0" )
            .licenseId( "OGL-UK-1.0" )
            .seeAlso( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/" )

            .urlInfo( "http://nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .urlInfo( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .urlInfo( "https://nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .urlInfo( "https://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/", "fb10be2a7968aff1d6c094384adf6e6c875e1001", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGL-UK-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGL-UK-2.0.json" )
            .name( "Open Government Licence v2.0" )
            .licenseId( "OGL-UK-2.0" )
            .seeAlso( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/" )

            .urlInfo( "http://nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .urlInfo( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .urlInfo( "https://nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .urlInfo( "https://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/", "491b72fdcbe84e13e1f58266c7d3776835a26ed0", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGL-UK-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGL-UK-3.0.json" )
            .name( "Open Government Licence v3.0" )
            .licenseId( "OGL-UK-3.0" )
            .seeAlso( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/" )

            .urlInfo( "http://nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .urlInfo( "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .urlInfo( "https://nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .urlInfo( "https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/", "0d03730a8e2941b08068cad5647fa372b78b290b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OGTSL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OGTSL.json" )
            .name( "Open Group Test Suite License" )
            .licenseId( "OGTSL" )
            .seeAlso( "http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt" )
            .seeAlso( "https://opensource.org/licenses/OGTSL" )

            .urlInfo( "http://opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "https://opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "https://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt", "526e91e6d907dcb644d5e3c72e6d889250fd4cb4", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/OGTSL", "e01f75444a4577ecddfaa220cada37fcaa80605a", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OGTSL", "e01f75444a4577ecddfaa220cada37fcaa80605a", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OGTSL", "e01f75444a4577ecddfaa220cada37fcaa80605a", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OGTSL", "e01f75444a4577ecddfaa220cada37fcaa80605a", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.1.json" )
            .name( "Open LDAP Public License v1.1" )
            .licenseId( "OLDAP-1.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f", "cc3609bf4dfaeff579d26ad8a4745e46b40d9e39", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f", "cc3609bf4dfaeff579d26ad8a4745e46b40d9e39", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f", "cc3609bf4dfaeff579d26ad8a4745e46b40d9e39", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.2.json" )
            .name( "Open LDAP Public License v1.2" )
            .licenseId( "OLDAP-1.2" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7", "36e686a2fb48ace983206f9b8b1b1d96b84ebf35", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7", "36e686a2fb48ace983206f9b8b1b1d96b84ebf35", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7", "36e686a2fb48ace983206f9b8b1b1d96b84ebf35", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.3.json" )
            .name( "Open LDAP Public License v1.3" )
            .licenseId( "OLDAP-1.3" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1", "dd41669825e0d0a99ab82a10b850f07c28ca163b", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1", "dd41669825e0d0a99ab82a10b850f07c28ca163b", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1", "dd41669825e0d0a99ab82a10b850f07c28ca163b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-1.4.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-1.4.json" )
            .name( "Open LDAP Public License v1.4" )
            .licenseId( "OLDAP-1.4" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941", "7f9996c5ccda375682c2888c1443b2d88a095ae2", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941", "7f9996c5ccda375682c2888c1443b2d88a095ae2", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941", "7f9996c5ccda375682c2888c1443b2d88a095ae2", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.0.json" )
            .name( "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)" )
            .licenseId( "OLDAP-2.0" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea", "4143bc62158eddba55ece8e86c696da95431be52", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea", "4143bc62158eddba55ece8e86c696da95431be52", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea", "4143bc62158eddba55ece8e86c696da95431be52", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.0.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.0.1.json" )
            .name( "Open LDAP Public License v2.0.1" )
            .licenseId( "OLDAP-2.0.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e", "0ad6d8ce330110b0a598a1db41e95f07f867ae8f", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e", "0ad6d8ce330110b0a598a1db41e95f07f867ae8f", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e", "0ad6d8ce330110b0a598a1db41e95f07f867ae8f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.1.json" )
            .name( "Open LDAP Public License v2.1" )
            .licenseId( "OLDAP-2.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715", "d1c12b87b84ccb94fbe3ee404bc47363a59ae457", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715", "d1c12b87b84ccb94fbe3ee404bc47363a59ae457", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715", "d1c12b87b84ccb94fbe3ee404bc47363a59ae457", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.2.json" )
            .name( "Open LDAP Public License v2.2" )
            .licenseId( "OLDAP-2.2" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3", "a2d5f10f30009baefde6908b1f1b91c5e056ad0e", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3", "a2d5f10f30009baefde6908b1f1b91c5e056ad0e", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3", "a2d5f10f30009baefde6908b1f1b91c5e056ad0e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.2.1.json" )
            .name( "Open LDAP Public License v2.2.1" )
            .licenseId( "OLDAP-2.2.1" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e", "47f9ffa3cc4cddb9a0a460c899f5ed78a98693ed", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e", "47f9ffa3cc4cddb9a0a460c899f5ed78a98693ed", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e", "47f9ffa3cc4cddb9a0a460c899f5ed78a98693ed", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.2.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.2.2.json" )
            .name( "Open LDAP Public License 2.2.2" )
            .licenseId( "OLDAP-2.2.2" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188", "91a4bcf746a90ec19b5915cf6f440e137220fc65", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188", "91a4bcf746a90ec19b5915cf6f440e137220fc65", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188", "91a4bcf746a90ec19b5915cf6f440e137220fc65", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.3.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.3.json" )
            .name( "Open LDAP Public License v2.3" )
            .licenseId( "OLDAP-2.3" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3", "e7edc1d7ffb7a8c5687151ebe8db8d8084459fa6", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3", "e7edc1d7ffb7a8c5687151ebe8db8d8084459fa6", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3", "e7edc1d7ffb7a8c5687151ebe8db8d8084459fa6", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.4.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.4.json" )
            .name( "Open LDAP Public License v2.4" )
            .licenseId( "OLDAP-2.4" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386", "859351b167aeb994a2bdb83474c446831891cdeb", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386", "859351b167aeb994a2bdb83474c446831891cdeb", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386", "859351b167aeb994a2bdb83474c446831891cdeb", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.5.json" )
            .name( "Open LDAP Public License v2.5" )
            .licenseId( "OLDAP-2.5" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf", "10bc14c8710f1abd9a9fbe92ef733b9b52727c11", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf", "10bc14c8710f1abd9a9fbe92ef733b9b52727c11", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf", "10bc14c8710f1abd9a9fbe92ef733b9b52727c11", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.6.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.6.json" )
            .name( "Open LDAP Public License v2.6" )
            .licenseId( "OLDAP-2.6" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205", "ad139a7d2daff170319dc950d7a9d6ce72f2cbd5", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205", "ad139a7d2daff170319dc950d7a9d6ce72f2cbd5", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205", "ad139a7d2daff170319dc950d7a9d6ce72f2cbd5", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.7.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.7.json" )
            .name( "Open LDAP Public License v2.7" )
            .licenseId( "OLDAP-2.7" )
            .seeAlso( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2" )

            .urlInfo( "http://openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2", "e2a208598e075a07706faad2af61b85983f95c93", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2", "e2a208598e075a07706faad2af61b85983f95c93", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2", "e2a208598e075a07706faad2af61b85983f95c93", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OLDAP-2.8.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OLDAP-2.8.json" )
            .name( "Open LDAP Public License v2.8" )
            .licenseId( "OLDAP-2.8" )
            .seeAlso( "http://www.openldap.org/software/release/license.html" )

            .urlInfo( "http://openldap.org/software/release/license.html", "fc5f8da10a6a57b8475f3dff52475367c692de76", "text/html", true, false )
            .urlInfo( "http://www.openldap.org/software/release/license.html", "fc5f8da10a6a57b8475f3dff52475367c692de76", "text/html", true, false )
            .urlInfo( "https://www.openldap.org/software/release/license.html", "fc5f8da10a6a57b8475f3dff52475367c692de76", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OML.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OML.json" )
            .name( "Open Market License" )
            .licenseId( "OML" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Open_Market_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Open_Market_License", "397e02bdd0af54afd96b9949bb190ba0b12c37e6", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Open_Market_License", "397e02bdd0af54afd96b9949bb190ba0b12c37e6", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Open_Market_License", "397e02bdd0af54afd96b9949bb190ba0b12c37e6", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Open_Market_License", "397e02bdd0af54afd96b9949bb190ba0b12c37e6", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OPL-1.0.json" )
            .name( "Open Public License v1.0" )
            .licenseId( "OPL-1.0" )
            .seeAlso( "http://old.koalateam.com/jackaroo/OPL_1_0.TXT" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Open_Public_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Open_Public_License", "cb4b0b31f46f10cba3184639c08ea0d3455a360f", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Open_Public_License", "cb4b0b31f46f10cba3184639c08ea0d3455a360f", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Open_Public_License", "cb4b0b31f46f10cba3184639c08ea0d3455a360f", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Open_Public_License", "cb4b0b31f46f10cba3184639c08ea0d3455a360f", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSET-PL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/OSET-PL-2.1.json" )
            .name( "OSET Public License version 2.1" )
            .licenseId( "OSET-PL-2.1" )
            .seeAlso( "http://www.osetfoundation.org/public-license" )
            .seeAlso( "https://opensource.org/licenses/OPL-2.1" )

            .urlInfo( "http://osetfoundation.org/public-license", "77e788702ad7b34ccc822a6c41b4021fc4ba68c0", "text/html", true, false )
            .urlInfo( "http://www.osetfoundation.org/public-license", "77e788702ad7b34ccc822a6c41b4021fc4ba68c0", "text/html", true, false )
            .urlInfo( "https://www.osetfoundation.org/public-license", "77e788702ad7b34ccc822a6c41b4021fc4ba68c0", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/OPL-2.1", "3abf914cd1d74443540f2758324d6c0cef89c8cc", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OPL-2.1", "3abf914cd1d74443540f2758324d6c0cef89c8cc", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OPL-2.1", "3abf914cd1d74443540f2758324d6c0cef89c8cc", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OPL-2.1", "3abf914cd1d74443540f2758324d6c0cef89c8cc", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-1.0.json" )
            .name( "Open Software License 1.0" )
            .licenseId( "OSL-1.0" )
            .seeAlso( "https://opensource.org/licenses/OSL-1.0" )

            .urlInfo( "http://opensource.org/licenses/OSL-1.0", "4e314550f233137ff794d989f5910ce239b911f7", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OSL-1.0", "4e314550f233137ff794d989f5910ce239b911f7", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OSL-1.0", "4e314550f233137ff794d989f5910ce239b911f7", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OSL-1.0", "4e314550f233137ff794d989f5910ce239b911f7", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-1.1.json" )
            .name( "Open Software License 1.1" )
            .licenseId( "OSL-1.1" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/OSL1.1" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/OSL1.1", "31807dcec6a012bc946d634200c5cea56a37304a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/OSL1.1", "31807dcec6a012bc946d634200c5cea56a37304a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/OSL1.1", "31807dcec6a012bc946d634200c5cea56a37304a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/OSL1.1", "31807dcec6a012bc946d634200c5cea56a37304a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-2.0.json" )
            .name( "Open Software License 2.0" )
            .licenseId( "OSL-2.0" )
            .seeAlso( "http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html" )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-2.1.json" )
            .name( "Open Software License 2.1" )
            .licenseId( "OSL-2.1" )
            .seeAlso( "http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm" )
            .seeAlso( "https://opensource.org/licenses/OSL-2.1" )

            .urlInfo( "http://opensource.org/licenses/OSL-2.1", "b42a3577ba5d2ce662ecc77d93999d8fb5b127cc", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OSL-2.1", "b42a3577ba5d2ce662ecc77d93999d8fb5b127cc", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OSL-2.1", "b42a3577ba5d2ce662ecc77d93999d8fb5b127cc", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OSL-2.1", "b42a3577ba5d2ce662ecc77d93999d8fb5b127cc", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OSL-3.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OSL-3.0.json" )
            .name( "Open Software License 3.0" )
            .licenseId( "OSL-3.0" )
            .seeAlso( "https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm" )
            .seeAlso( "https://opensource.org/licenses/OSL-3.0" )

            .urlInfo( "http://opensource.org/licenses/OSL-3.0", "9da420e5815662ff8685bc7904baf02e35bf5e0b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/OSL-3.0", "9da420e5815662ff8685bc7904baf02e35bf5e0b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/OSL-3.0", "9da420e5815662ff8685bc7904baf02e35bf5e0b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/OSL-3.0", "9da420e5815662ff8685bc7904baf02e35bf5e0b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./OpenSSL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/OpenSSL.json" )
            .name( "OpenSSL License" )
            .licenseId( "OpenSSL" )
            .seeAlso( "http://www.openssl.org/source/license.html" )

            .urlInfo( "http://openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .urlInfo( "http://www.openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .urlInfo( "https://openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .urlInfo( "https://www.openssl.org/source/license.html", "fdbb76640b239aafe4b4efdacac25cdf1427418f", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PDDL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/PDDL-1.0.json" )
            .name( "ODC Public Domain Dedication & License 1.0" )
            .licenseId( "PDDL-1.0" )
            .seeAlso( "http://opendatacommons.org/licenses/pddl/1.0/" )

            .urlInfo( "http://opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .urlInfo( "http://www.opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .urlInfo( "https://opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .urlInfo( "https://www.opendatacommons.org/licenses/pddl/1.0/", "c73695b2fe15a85ceb8f147bf02c41b3624eaa00", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PHP-3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/PHP-3.0.json" )
            .name( "PHP License v3.0" )
            .licenseId( "PHP-3.0" )
            .seeAlso( "http://www.php.net/license/3_0.txt" )
            .seeAlso( "https://opensource.org/licenses/PHP-3.0" )

            .urlInfo( "http://php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "http://www.php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "https://php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "https://www.php.net/license/3_0.txt", "b568098fecaddcee5626728c874c3d3bebcbb83f", "text/plain", true, false )
            .urlInfo( "http://opensource.org/licenses/PHP-3.0", "93c68f06d0a7a0da92b01b3bed063b537166d04b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/PHP-3.0", "93c68f06d0a7a0da92b01b3bed063b537166d04b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/PHP-3.0", "93c68f06d0a7a0da92b01b3bed063b537166d04b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/PHP-3.0", "93c68f06d0a7a0da92b01b3bed063b537166d04b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PHP-3.01.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/PHP-3.01.json" )
            .name( "PHP License v3.01" )
            .licenseId( "PHP-3.01" )
            .seeAlso( "http://www.php.net/license/3_01.txt" )

            .urlInfo( "http://php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .urlInfo( "http://www.php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .urlInfo( "https://php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .urlInfo( "https://www.php.net/license/3_01.txt", "27b46923d7341b6bb717d06db4850b1180d565b2", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Plexus.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Plexus.json" )
            .name( "Plexus Classworlds License" )
            .licenseId( "Plexus" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "f50c771b67fe86c08ce0932e2bb67290ce29c3a0", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "f50c771b67fe86c08ce0932e2bb67290ce29c3a0", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "f50c771b67fe86c08ce0932e2bb67290ce29c3a0", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License", "f50c771b67fe86c08ce0932e2bb67290ce29c3a0", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./PostgreSQL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/PostgreSQL.json" )
            .name( "PostgreSQL License" )
            .licenseId( "PostgreSQL" )
            .seeAlso( "http://www.postgresql.org/about/licence" )
            .seeAlso( "https://opensource.org/licenses/PostgreSQL" )

            .urlInfo( "http://postgresql.org/about/licence", "8fe3616ebbaa6f0880dfc7201b28251d8a89e042", "text/html", true, false )
            .urlInfo( "http://www.postgresql.org/about/licence", "8fe3616ebbaa6f0880dfc7201b28251d8a89e042", "text/html", true, false )
            .urlInfo( "https://postgresql.org/about/licence", "8fe3616ebbaa6f0880dfc7201b28251d8a89e042", "text/html", true, false )
            .urlInfo( "https://www.postgresql.org/about/licence", "8fe3616ebbaa6f0880dfc7201b28251d8a89e042", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/PostgreSQL", "f02b9183b2efdec12ba7b1ee7c1f386356e3693a", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/PostgreSQL", "f02b9183b2efdec12ba7b1ee7c1f386356e3693a", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/PostgreSQL", "f02b9183b2efdec12ba7b1ee7c1f386356e3693a", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/PostgreSQL", "f02b9183b2efdec12ba7b1ee7c1f386356e3693a", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Python-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Python-2.0.json" )
            .name( "Python License 2.0" )
            .licenseId( "Python-2.0" )
            .seeAlso( "https://opensource.org/licenses/Python-2.0" )

            .urlInfo( "http://opensource.org/licenses/Python-2.0", "156935145768e0f81d179b4ae7e87165d9abfab8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Python-2.0", "156935145768e0f81d179b4ae7e87165d9abfab8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Python-2.0", "156935145768e0f81d179b4ae7e87165d9abfab8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Python-2.0", "156935145768e0f81d179b4ae7e87165d9abfab8", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./QPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/QPL-1.0.json" )
            .name( "Q Public License 1.0" )
            .licenseId( "QPL-1.0" )
            .seeAlso( "http://doc.qt.nokia.com/3.3/license.html" )
            .seeAlso( "https://opensource.org/licenses/QPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/QPL-1.0", "0834befe868efb1cc2e3614ac22b3f5c1c23ae4a", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/QPL-1.0", "0834befe868efb1cc2e3614ac22b3f5c1c23ae4a", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/QPL-1.0", "0834befe868efb1cc2e3614ac22b3f5c1c23ae4a", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/QPL-1.0", "0834befe868efb1cc2e3614ac22b3f5c1c23ae4a", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Qhull.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Qhull.json" )
            .name( "Qhull License" )
            .licenseId( "Qhull" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Qhull" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Qhull", "df46e4c9d0e38d78a7e70f93622e3662f18ec285", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Qhull", "df46e4c9d0e38d78a7e70f93622e3662f18ec285", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Qhull", "df46e4c9d0e38d78a7e70f93622e3662f18ec285", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Qhull", "df46e4c9d0e38d78a7e70f93622e3662f18ec285", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RHeCos-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RHeCos-1.1.json" )
            .name( "Red Hat eCos Public License v1.1" )
            .licenseId( "RHeCos-1.1" )
            .seeAlso( "http://ecos.sourceware.org/old-license.html" )

            .urlInfo( "http://ecos.sourceware.org/old-license.html", "7144b1739e30b52df1020dff8866c352babc9460", "text/html", true, false )
            .urlInfo( "http://www.ecos.sourceware.org/old-license.html", "7144b1739e30b52df1020dff8866c352babc9460", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RPL-1.1.json" )
            .name( "Reciprocal Public License 1.1" )
            .licenseId( "RPL-1.1" )
            .seeAlso( "https://opensource.org/licenses/RPL-1.1" )

            .urlInfo( "http://opensource.org/licenses/RPL-1.1", "34007674968ba1b06171f2e6448bc6c361840e2e", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/RPL-1.1", "34007674968ba1b06171f2e6448bc6c361840e2e", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/RPL-1.1", "34007674968ba1b06171f2e6448bc6c361840e2e", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/RPL-1.1", "34007674968ba1b06171f2e6448bc6c361840e2e", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RPL-1.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RPL-1.5.json" )
            .name( "Reciprocal Public License 1.5" )
            .licenseId( "RPL-1.5" )
            .seeAlso( "https://opensource.org/licenses/RPL-1.5" )

            .urlInfo( "http://opensource.org/licenses/RPL-1.5", "b61c1bd2f64d111ce6dd812d47c9b454d9ab7de8", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/RPL-1.5", "b61c1bd2f64d111ce6dd812d47c9b454d9ab7de8", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/RPL-1.5", "b61c1bd2f64d111ce6dd812d47c9b454d9ab7de8", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/RPL-1.5", "b61c1bd2f64d111ce6dd812d47c9b454d9ab7de8", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RPSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/RPSL-1.0.json" )
            .name( "RealNetworks Public Source License v1.0" )
            .licenseId( "RPSL-1.0" )
            .seeAlso( "https://helixcommunity.org/content/rpsl" )
            .seeAlso( "https://opensource.org/licenses/RPSL-1.0" )

            .urlInfo( "http://opensource.org/licenses/RPSL-1.0", "c288846f50aea248ff3cc6f236902bddea441445", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/RPSL-1.0", "c288846f50aea248ff3cc6f236902bddea441445", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/RPSL-1.0", "c288846f50aea248ff3cc6f236902bddea441445", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/RPSL-1.0", "c288846f50aea248ff3cc6f236902bddea441445", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RSA-MD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RSA-MD.json" )
            .name( "RSA Message-Digest License" )
            .licenseId( "RSA-MD" )
            .seeAlso( "http://www.faqs.org/rfcs/rfc1321.html" )

            .urlInfo( "http://faqs.org/rfcs/rfc1321.html", "c6576de398f1121635a137c8335d9dd548170311", "text/html", true, false )
            .urlInfo( "http://www.faqs.org/rfcs/rfc1321.html", "c6576de398f1121635a137c8335d9dd548170311", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./RSCPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/RSCPL.json" )
            .name( "Ricoh Source Code Public License" )
            .licenseId( "RSCPL" )
            .seeAlso( "http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml" )
            .seeAlso( "https://opensource.org/licenses/RSCPL" )

            .urlInfo( "http://opensource.org/licenses/RSCPL", "da1b642ae80c4837d8a423b4b4ca8bc8e53bfb59", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/RSCPL", "da1b642ae80c4837d8a423b4b4ca8bc8e53bfb59", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/RSCPL", "da1b642ae80c4837d8a423b4b4ca8bc8e53bfb59", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/RSCPL", "da1b642ae80c4837d8a423b4b4ca8bc8e53bfb59", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Rdisc.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Rdisc.json" )
            .name( "Rdisc License" )
            .licenseId( "Rdisc" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Rdisc_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Rdisc_License", "ed7eb23ca6a2897407c60e8ff92e326428deb803", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Rdisc_License", "ed7eb23ca6a2897407c60e8ff92e326428deb803", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Rdisc_License", "ed7eb23ca6a2897407c60e8ff92e326428deb803", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Rdisc_License", "ed7eb23ca6a2897407c60e8ff92e326428deb803", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Ruby.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Ruby.json" )
            .name( "Ruby License" )
            .licenseId( "Ruby" )
            .seeAlso( "http://www.ruby-lang.org/en/LICENSE.txt" )

            .urlInfo( "http://ruby-lang.org/en/LICENSE.txt", "f1d4e2e57f37d52f9d2ec0443c5305ad882b73ce", "text/plain", true, false )
            .urlInfo( "http://www.ruby-lang.org/en/LICENSE.txt", "f1d4e2e57f37d52f9d2ec0443c5305ad882b73ce", "text/plain", true, false )
            .urlInfo( "https://www.ruby-lang.org/en/LICENSE.txt", "f1d4e2e57f37d52f9d2ec0443c5305ad882b73ce", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SAX-PD.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SAX-PD.json" )
            .name( "Sax Public Domain Notice" )
            .licenseId( "SAX-PD" )
            .seeAlso( "http://www.saxproject.org/copying.html" )

            .urlInfo( "http://www.saxproject.org/copying.html", "b5045f54ee707e82e7c89ed51a53ba60bb993fd5", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SCEA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SCEA.json" )
            .name( "SCEA Shared Source License" )
            .licenseId( "SCEA" )
            .seeAlso( "http://research.scea.com/scea_shared_source_license.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SGI-B-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SGI-B-1.0.json" )
            .name( "SGI Free Software License B v1.0" )
            .licenseId( "SGI-B-1.0" )
            .seeAlso( "http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SGI-B-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SGI-B-1.1.json" )
            .name( "SGI Free Software License B v1.1" )
            .licenseId( "SGI-B-1.1" )
            .seeAlso( "http://oss.sgi.com/projects/FreeB/" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SGI-B-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SGI-B-2.0.json" )
            .name( "SGI Free Software License B v2.0" )
            .licenseId( "SGI-B-2.0" )
            .seeAlso( "http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SISSL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SISSL.json" )
            .name( "Sun Industry Standards Source License v1.1" )
            .licenseId( "SISSL" )
            .seeAlso( "http://www.openoffice.org/licenses/sissl_license.html" )
            .seeAlso( "https://opensource.org/licenses/SISSL" )

            .urlInfo( "http://openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "http://www.openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "https://openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "https://www.openoffice.org/licenses/sissl_license.html", "d9c2f90c94811005c80c24e2b08349be0e5ea527", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/SISSL", "c71b77c3d7f17c86d03b966cb86f800c595fdb95", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/SISSL", "c71b77c3d7f17c86d03b966cb86f800c595fdb95", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/SISSL", "c71b77c3d7f17c86d03b966cb86f800c595fdb95", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/SISSL", "c71b77c3d7f17c86d03b966cb86f800c595fdb95", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SISSL-1.2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SISSL-1.2.json" )
            .name( "Sun Industry Standards Source License v1.2" )
            .licenseId( "SISSL-1.2" )
            .seeAlso( "http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html" )

            .urlInfo( "http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html", "38ef0c536157be42d18d16002c02893d814e1516", "text/html", true, false )
            .urlInfo( "http://www.gridscheduler.sourceforge.net/Gridengine_SISSL_license.html", "38ef0c536157be42d18d16002c02893d814e1516", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SMLNJ.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SMLNJ.json" )
            .name( "Standard ML of New Jersey License" )
            .licenseId( "SMLNJ" )
            .seeAlso( "https://www.smlnj.org/license.html" )

            .urlInfo( "http://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SMPPL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SMPPL.json" )
            .name( "Secure Messaging Protocol Public License" )
            .licenseId( "SMPPL" )
            .seeAlso( "https://github.com/dcblake/SMP/blob/master/Documentation/License.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SNIA.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SNIA.json" )
            .name( "SNIA Public License 1.1" )
            .licenseId( "SNIA" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/SNIA_Public_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/SNIA_Public_License", "fb6eab8505c7cbb80424dd411870302f0ab34f39", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/SNIA_Public_License", "fb6eab8505c7cbb80424dd411870302f0ab34f39", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/SNIA_Public_License", "fb6eab8505c7cbb80424dd411870302f0ab34f39", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/SNIA_Public_License", "fb6eab8505c7cbb80424dd411870302f0ab34f39", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/SPL-1.0.json" )
            .name( "Sun Public License v1.0" )
            .licenseId( "SPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/SPL-1.0" )

            .urlInfo( "http://opensource.org/licenses/SPL-1.0", "86b253647f6f49a17ff49f5692ae2972f1086fce", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/SPL-1.0", "86b253647f6f49a17ff49f5692ae2972f1086fce", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/SPL-1.0", "86b253647f6f49a17ff49f5692ae2972f1086fce", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/SPL-1.0", "86b253647f6f49a17ff49f5692ae2972f1086fce", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SWL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SWL.json" )
            .name( "Scheme Widget Library (SWL) Software License Agreement" )
            .licenseId( "SWL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/SWL" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/SWL", "8e8f3b2a9fd241df8fa624581f6b69ca155e388d", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/SWL", "8e8f3b2a9fd241df8fa624581f6b69ca155e388d", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/SWL", "8e8f3b2a9fd241df8fa624581f6b69ca155e388d", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/SWL", "8e8f3b2a9fd241df8fa624581f6b69ca155e388d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Saxpath.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Saxpath.json" )
            .name( "Saxpath License" )
            .licenseId( "Saxpath" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Saxpath_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Saxpath_License", "0b6034499b7fcfea80c6ef0b0782b83a876c8a85", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Saxpath_License", "0b6034499b7fcfea80c6ef0b0782b83a876c8a85", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Saxpath_License", "0b6034499b7fcfea80c6ef0b0782b83a876c8a85", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Saxpath_License", "0b6034499b7fcfea80c6ef0b0782b83a876c8a85", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Sendmail.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Sendmail.json" )
            .name( "Sendmail License" )
            .licenseId( "Sendmail" )
            .seeAlso( "http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf" )
            .seeAlso( "https://web.archive.org/web/20160322142305/https://www.sendmail.com/pdfs/open_source/sendmail_license.pdf" )

            .urlInfo( "http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Sendmail-8.23.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Sendmail-8.23.json" )
            .name( "Sendmail License 8.23" )
            .licenseId( "Sendmail-8.23" )
            .seeAlso( "https://www.proofpoint.com/sites/default/files/sendmail-license.pdf" )
            .seeAlso( "https://web.archive.org/web/20181003101040/https://www.proofpoint.com/sites/default/files/sendmail-license.pdf" )

            .urlInfo( "http://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "http://web.archive.org/web/20181003101040id_/http://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "http://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://web.archive.org/web/20181003101040id_/https://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .urlInfo( "https://www.proofpoint.com/sites/default/files/sendmail-license.pdf", "2f0605b00214d85158c4bc503e72c02033d09916", "application/pdf", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SimPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SimPL-2.0.json" )
            .name( "Simple Public License 2.0" )
            .licenseId( "SimPL-2.0" )
            .seeAlso( "https://opensource.org/licenses/SimPL-2.0" )

            .urlInfo( "http://opensource.org/licenses/SimPL-2.0", "af8be541951c6b28afc2a96398135bf898998417", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/SimPL-2.0", "af8be541951c6b28afc2a96398135bf898998417", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/SimPL-2.0", "af8be541951c6b28afc2a96398135bf898998417", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/SimPL-2.0", "af8be541951c6b28afc2a96398135bf898998417", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Sleepycat.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Sleepycat.json" )
            .name( "Sleepycat License" )
            .licenseId( "Sleepycat" )
            .seeAlso( "https://opensource.org/licenses/Sleepycat" )

            .urlInfo( "http://opensource.org/licenses/Sleepycat", "a2612720cb52ed4c913e12821bb8915ea40a49e6", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Sleepycat", "a2612720cb52ed4c913e12821bb8915ea40a49e6", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Sleepycat", "a2612720cb52ed4c913e12821bb8915ea40a49e6", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Sleepycat", "a2612720cb52ed4c913e12821bb8915ea40a49e6", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Spencer-86.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Spencer-86.json" )
            .name( "Spencer License 86" )
            .licenseId( "Spencer-86" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Spencer-94.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Spencer-94.json" )
            .name( "Spencer License 94" )
            .licenseId( "Spencer-94" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License", "130fcd36be8fe164eb68d951ba73ae3efdb846da", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Spencer-99.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Spencer-99.json" )
            .name( "Spencer License 99" )
            .licenseId( "Spencer-99" )
            .seeAlso( "http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c" )

            .urlInfo( "http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c", null, null, false, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./StandardML-NJ.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/StandardML-NJ.json" )
            .name( "Standard ML of New Jersey License" )
            .licenseId( "StandardML-NJ" )
            .seeAlso( "http://www.smlnj.org//license.html" )

            .urlInfo( "http://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "http://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org//license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .urlInfo( "https://www.smlnj.org/license.html", "01211dfcce36969c53f75500005301922763b9aa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./SugarCRM-1.1.3.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/SugarCRM-1.1.3.json" )
            .name( "SugarCRM Public License v1.1.3" )
            .licenseId( "SugarCRM-1.1.3" )
            .seeAlso( "http://www.sugarcrm.com/crm/SPL" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TAPR-OHL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TAPR-OHL-1.0.json" )
            .name( "TAPR Open Hardware License v1.0" )
            .licenseId( "TAPR-OHL-1.0" )
            .seeAlso( "https://www.tapr.org/OHL" )

            .urlInfo( "http://www.tapr.org/OHL", "c9cba9d51f8396452294954cdff210240cff931e", "text/html", true, false )
            .urlInfo( "https://www.tapr.org/OHL", "c9cba9d51f8396452294954cdff210240cff931e", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TCL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TCL.json" )
            .name( "TCL/TK License" )
            .licenseId( "TCL" )
            .seeAlso( "http://www.tcl.tk/software/tcltk/license.html" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/TCL" )

            .urlInfo( "http://tcl.tk/software/tcltk/license.html", "00499b931c93319beea913277403178316f62b01", "text/html", true, true )
            .urlInfo( "http://www.tcl.tk/software/tcltk/license.html", "00499b931c93319beea913277403178316f62b01", "text/html", true, true )
            .urlInfo( "https://tcl.tk/software/tcltk/license.html", "00499b931c93319beea913277403178316f62b01", "text/html", true, true )
            .urlInfo( "https://www.tcl.tk/software/tcltk/license.html", "00499b931c93319beea913277403178316f62b01", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/TCL", "344bc2a95f4a4908c643babe16d62f4ef9700a0a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/TCL", "344bc2a95f4a4908c643babe16d62f4ef9700a0a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/TCL", "344bc2a95f4a4908c643babe16d62f4ef9700a0a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/TCL", "344bc2a95f4a4908c643babe16d62f4ef9700a0a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TCP-wrappers.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TCP-wrappers.json" )
            .name( "TCP Wrappers License" )
            .licenseId( "TCP-wrappers" )
            .seeAlso( "http://rc.quest.com/topics/openssh/license.php#tcpwrappers" )

            .urlInfo( "http://rc.quest.com/topics/openssh/license.php#tcpwrappers", "361b2df10b2db8b7f9635890ca8b41ea0f9cba6c", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TMate.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TMate.json" )
            .name( "TMate Open Source License" )
            .licenseId( "TMate" )
            .seeAlso( "http://svnkit.com/license.html" )

            .urlInfo( "http://svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .urlInfo( "http://www.svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .urlInfo( "https://svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .urlInfo( "https://www.svnkit.com/license.html", "90cb7e333fa2228df75be9b09b1b8933cddfeddc", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TORQUE-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TORQUE-1.1.json" )
            .name( "TORQUE v2.5+ Software License v1.1" )
            .licenseId( "TORQUE-1.1" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/TORQUEv1.1" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/TORQUEv1.1", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TOSL.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TOSL.json" )
            .name( "Trusster Open Source License" )
            .licenseId( "TOSL" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/TOSL" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/TOSL", "3ad0c21abb7f1caef2e40e6e035df4077333d1d3", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/TOSL", "3ad0c21abb7f1caef2e40e6e035df4077333d1d3", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/TOSL", "3ad0c21abb7f1caef2e40e6e035df4077333d1d3", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/TOSL", "3ad0c21abb7f1caef2e40e6e035df4077333d1d3", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TU-Berlin-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TU-Berlin-1.0.json" )
            .name( "Technische Universitaet Berlin License 1.0" )
            .licenseId( "TU-Berlin-1.0" )
            .seeAlso( "https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./TU-Berlin-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/TU-Berlin-2.0.json" )
            .name( "Technische Universitaet Berlin License 2.0" )
            .licenseId( "TU-Berlin-2.0" )
            .seeAlso( "https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./UPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/UPL-1.0.json" )
            .name( "Universal Permissive License v1.0" )
            .licenseId( "UPL-1.0" )
            .seeAlso( "https://opensource.org/licenses/UPL" )

            .urlInfo( "http://opensource.org/licenses/UPL", "8cdb2dda66095220c953ae7ad85ab705eb910562", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/UPL", "8cdb2dda66095220c953ae7ad85ab705eb910562", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/UPL", "8cdb2dda66095220c953ae7ad85ab705eb910562", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/UPL", "8cdb2dda66095220c953ae7ad85ab705eb910562", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unicode-DFS-2015.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Unicode-DFS-2015.json" )
            .name( "Unicode License Agreement - Data Files and Software (2015)" )
            .licenseId( "Unicode-DFS-2015" )
            .seeAlso( "https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unicode-DFS-2016.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Unicode-DFS-2016.json" )
            .name( "Unicode License Agreement - Data Files and Software (2016)" )
            .licenseId( "Unicode-DFS-2016" )
            .seeAlso( "http://www.unicode.org/copyright.html" )

            .urlInfo( "http://unicode.org/copyright.html", "616802fe8277aa08324ee4f77d9f57bddb1b4f1b", "text/html", true, false )
            .urlInfo( "http://www.unicode.org/copyright.html", "616802fe8277aa08324ee4f77d9f57bddb1b4f1b", "text/html", true, false )
            .urlInfo( "https://unicode.org/copyright.html", "616802fe8277aa08324ee4f77d9f57bddb1b4f1b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unicode-TOU.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Unicode-TOU.json" )
            .name( "Unicode Terms of Use" )
            .licenseId( "Unicode-TOU" )
            .seeAlso( "http://www.unicode.org/copyright.html" )

            .urlInfo( "http://unicode.org/copyright.html", "616802fe8277aa08324ee4f77d9f57bddb1b4f1b", "text/html", true, false )
            .urlInfo( "http://www.unicode.org/copyright.html", "616802fe8277aa08324ee4f77d9f57bddb1b4f1b", "text/html", true, false )
            .urlInfo( "https://unicode.org/copyright.html", "616802fe8277aa08324ee4f77d9f57bddb1b4f1b", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Unlicense.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Unlicense.json" )
            .name( "The Unlicense" )
            .licenseId( "Unlicense" )
            .seeAlso( "http://unlicense.org/" )

            .urlInfo( "http://unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .urlInfo( "http://www.unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .urlInfo( "https://unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .urlInfo( "https://www.unlicense.org/", "2793aa722410d051088cb60cdf13fb5cf68f8b16", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./VOSTROM.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/VOSTROM.json" )
            .name( "VOSTROM Public License for Open Source" )
            .licenseId( "VOSTROM" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/VOSTROM" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/VOSTROM", "b0ca9206e99414f2d226278eb6b43c4249e1162d", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/VOSTROM", "b0ca9206e99414f2d226278eb6b43c4249e1162d", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/VOSTROM", "b0ca9206e99414f2d226278eb6b43c4249e1162d", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/VOSTROM", "b0ca9206e99414f2d226278eb6b43c4249e1162d", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./VSL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/VSL-1.0.json" )
            .name( "Vovida Software License v1.0" )
            .licenseId( "VSL-1.0" )
            .seeAlso( "https://opensource.org/licenses/VSL-1.0" )

            .urlInfo( "http://opensource.org/licenses/VSL-1.0", "30566b653cd4b94e1885055dcc9024a3cfac3e4b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/VSL-1.0", "30566b653cd4b94e1885055dcc9024a3cfac3e4b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/VSL-1.0", "30566b653cd4b94e1885055dcc9024a3cfac3e4b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/VSL-1.0", "30566b653cd4b94e1885055dcc9024a3cfac3e4b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Vim.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Vim.json" )
            .name( "Vim License" )
            .licenseId( "Vim" )
            .seeAlso( "http://vimdoc.sourceforge.net/htmldoc/uganda.html" )

            .urlInfo( "http://vimdoc.sourceforge.net/htmldoc/uganda.html", "03dc2a471da404470ef443a26d08bfaf12a629aa", "text/html", true, false )
            .urlInfo( "http://www.vimdoc.sourceforge.net/htmldoc/uganda.html", "03dc2a471da404470ef443a26d08bfaf12a629aa", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./W3C.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/W3C.json" )
            .name( "W3C Software Notice and License (2002-12-31)" )
            .licenseId( "W3C" )
            .seeAlso( "http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html" )
            .seeAlso( "https://opensource.org/licenses/W3C" )

            .urlInfo( "http://w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "https://w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "https://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html", "e9caaa14c2ed4bfe41608e3d865811423707bbe5", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/W3C", "9957c74acaf9412fcab9f768382a879bf6f5bd9a", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/W3C", "9957c74acaf9412fcab9f768382a879bf6f5bd9a", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/W3C", "9957c74acaf9412fcab9f768382a879bf6f5bd9a", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/W3C", "9957c74acaf9412fcab9f768382a879bf6f5bd9a", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./W3C-19980720.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/W3C-19980720.json" )
            .name( "W3C Software Notice and License (1998-07-20)" )
            .licenseId( "W3C-19980720" )
            .seeAlso( "http://www.w3.org/Consortium/Legal/copyright-software-19980720.html" )

            .urlInfo( "http://w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .urlInfo( "http://www.w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .urlInfo( "https://w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .urlInfo( "https://www.w3.org/Consortium/Legal/copyright-software-19980720.html", "9bca94cc5985c5c1fa93f64ab74c32dbe270ff40", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./W3C-20150513.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/W3C-20150513.json" )
            .name( "W3C Software Notice and Document License (2015-05-13)" )
            .licenseId( "W3C-20150513" )
            .seeAlso( "https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document" )

            .urlInfo( "http://w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .urlInfo( "http://www.w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .urlInfo( "https://w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .urlInfo( "https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document", "b6483f77e4ea82c472b1006e5e49323deb569c37", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./WTFPL.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/WTFPL.json" )
            .name( "Do What The F*ck You Want To Public License" )
            .licenseId( "WTFPL" )
            .seeAlso( "http://sam.zoy.org/wtfpl/COPYING" )

            .urlInfo( "http://sam.zoy.org/wtfpl/COPYING", "337ece375beddfdb7392699fd00eb9b3e823d03f", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Watcom-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Watcom-1.0.json" )
            .name( "Sybase Open Watcom Public License 1.0" )
            .licenseId( "Watcom-1.0" )
            .seeAlso( "https://opensource.org/licenses/Watcom-1.0" )

            .urlInfo( "http://opensource.org/licenses/Watcom-1.0", "4300d9560c127e25505e855e7ee103b378f29d6b", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Watcom-1.0", "4300d9560c127e25505e855e7ee103b378f29d6b", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Watcom-1.0", "4300d9560c127e25505e855e7ee103b378f29d6b", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Watcom-1.0", "4300d9560c127e25505e855e7ee103b378f29d6b", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Wsuipa.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Wsuipa.json" )
            .name( "Wsuipa License" )
            .licenseId( "Wsuipa" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Wsuipa" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Wsuipa", "ff7b66840ab0914bbf3ba00a284a8eca93d8b2fc", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Wsuipa", "ff7b66840ab0914bbf3ba00a284a8eca93d8b2fc", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Wsuipa", "ff7b66840ab0914bbf3ba00a284a8eca93d8b2fc", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Wsuipa", "ff7b66840ab0914bbf3ba00a284a8eca93d8b2fc", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./X11.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/X11.json" )
            .name( "X11 License" )
            .licenseId( "X11" )
            .seeAlso( "http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3" )

            .urlInfo( "http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .urlInfo( "http://xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .urlInfo( "https://www.xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .urlInfo( "https://xfree86.org/3.3.6/COPYRIGHT2.html#3", "af17279d4b362c0421337bac10272977c3cba3e3", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./XFree86-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/XFree86-1.1.json" )
            .name( "XFree86 License 1.1" )
            .licenseId( "XFree86-1.1" )
            .seeAlso( "http://www.xfree86.org/current/LICENSE4.html" )

            .urlInfo( "http://www.xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .urlInfo( "http://xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .urlInfo( "https://www.xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .urlInfo( "https://xfree86.org/current/LICENSE4.html", "5ad8574c481e3d9f1c527a4a49f4042ac65cc964", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./XSkat.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/XSkat.json" )
            .name( "XSkat License" )
            .licenseId( "XSkat" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/XSkat_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/XSkat_License", "76f97550c044e523e4e850c50800295d796d3390", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/XSkat_License", "76f97550c044e523e4e850c50800295d796d3390", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Xerox.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Xerox.json" )
            .name( "Xerox License" )
            .licenseId( "Xerox" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Xerox" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Xerox", "bc96822269ec4cebf103a898c5ef433a39e9c071", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Xerox", "bc96822269ec4cebf103a898c5ef433a39e9c071", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Xerox", "bc96822269ec4cebf103a898c5ef433a39e9c071", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Xerox", "bc96822269ec4cebf103a898c5ef433a39e9c071", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Xnet.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Xnet.json" )
            .name( "X.Net License" )
            .licenseId( "Xnet" )
            .seeAlso( "https://opensource.org/licenses/Xnet" )

            .urlInfo( "http://opensource.org/licenses/Xnet", "10d9f75626a7edd79c98333c59555bfee7ae33f1", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Xnet", "10d9f75626a7edd79c98333c59555bfee7ae33f1", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Xnet", "10d9f75626a7edd79c98333c59555bfee7ae33f1", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Xnet", "10d9f75626a7edd79c98333c59555bfee7ae33f1", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./YPL-1.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/YPL-1.0.json" )
            .name( "Yahoo! Public License v1.0" )
            .licenseId( "YPL-1.0" )
            .seeAlso( "http://www.zimbra.com/license/yahoo_public_license_1.0.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./YPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/YPL-1.1.json" )
            .name( "Yahoo! Public License v1.1" )
            .licenseId( "YPL-1.1" )
            .seeAlso( "http://www.zimbra.com/license/yahoo_public_license_1.1.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ZPL-1.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/ZPL-1.1.json" )
            .name( "Zope Public License 1.1" )
            .licenseId( "ZPL-1.1" )
            .seeAlso( "http://old.zope.org/Resources/License/ZPL-1.1" )

            .urlInfo( "http://old.zope.org/Resources/License/ZPL-1.1", "545bd59cf22b63f4b3005a8e192382fadd409a80", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ZPL-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ZPL-2.0.json" )
            .name( "Zope Public License 2.0" )
            .licenseId( "ZPL-2.0" )
            .seeAlso( "http://old.zope.org/Resources/License/ZPL-2.0" )
            .seeAlso( "https://opensource.org/licenses/ZPL-2.0" )

            .urlInfo( "http://old.zope.org/Resources/License/ZPL-2.0", "48d0ce3d50083691ba056f531eab912596a2317d", null, true, false )
            .urlInfo( "http://opensource.org/licenses/ZPL-2.0", "b372551d0be3732638e91d36be17da95b7578f16", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/ZPL-2.0", "b372551d0be3732638e91d36be17da95b7578f16", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/ZPL-2.0", "b372551d0be3732638e91d36be17da95b7578f16", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/ZPL-2.0", "b372551d0be3732638e91d36be17da95b7578f16", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./ZPL-2.1.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/ZPL-2.1.json" )
            .name( "Zope Public License 2.1" )
            .licenseId( "ZPL-2.1" )
            .seeAlso( "http://old.zope.org/Resources/ZPL/" )

            .urlInfo( "http://old.zope.org/Resources/ZPL/", "a1553972c0c3eb546dbf4ea440f3723136e1f772", null, true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zed.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Zed.json" )
            .name( "Zed License" )
            .licenseId( "Zed" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Zed" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Zed", "31ffd6238e9db0b71f200c74856a16af1bf6e602", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Zed", "31ffd6238e9db0b71f200c74856a16af1bf6e602", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Zed", "31ffd6238e9db0b71f200c74856a16af1bf6e602", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Zed", "31ffd6238e9db0b71f200c74856a16af1bf6e602", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zend-2.0.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Zend-2.0.json" )
            .name( "Zend License v2.0" )
            .licenseId( "Zend-2.0" )
            .seeAlso( "https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zimbra-1.3.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Zimbra-1.3.json" )
            .name( "Zimbra Public License v1.3" )
            .licenseId( "Zimbra-1.3" )
            .seeAlso( "http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zimbra-1.4.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/Zimbra-1.4.json" )
            .name( "Zimbra Public License v1.4" )
            .licenseId( "Zimbra-1.4" )
            .seeAlso( "http://www.zimbra.com/legal/zimbra-public-license-1-4" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./Zlib.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/Zlib.json" )
            .name( "zlib License" )
            .licenseId( "Zlib" )
            .seeAlso( "http://www.zlib.net/zlib_license.html" )
            .seeAlso( "https://opensource.org/licenses/Zlib" )

            .urlInfo( "http://www.zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "http://zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "https://zlib.net/zlib_license.html", "42ebabf4a661ae8b089652de5063ef17275045e7", "text/html", true, false )
            .urlInfo( "http://opensource.org/licenses/Zlib", "8f86bc16ae0e29f31f80a9652b027c7f3b372209", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/Zlib", "8f86bc16ae0e29f31f80a9652b027c7f3b372209", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/Zlib", "8f86bc16ae0e29f31f80a9652b027c7f3b372209", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/Zlib", "8f86bc16ae0e29f31f80a9652b027c7f3b372209", "text/html", false, true )
            .isOsiApproved( true )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./bzip2-1.0.5.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/bzip2-1.0.5.json" )
            .name( "bzip2 and libbzip2 License v1.0.5" )
            .licenseId( "bzip2-1.0.5" )
            .seeAlso( "http://bzip.org/1.0.5/bzip2-manual-1.0.5.html" )

            .urlInfo( "http://bzip.org/1.0.5/bzip2-manual-1.0.5.html", "6adfa86e0a55bdeebac130b7f6d9d145597ee949", "text/html", true, false )
            .urlInfo( "http://www.bzip.org/1.0.5/bzip2-manual-1.0.5.html", "6adfa86e0a55bdeebac130b7f6d9d145597ee949", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./bzip2-1.0.6.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/bzip2-1.0.6.json" )
            .name( "bzip2 and libbzip2 License v1.0.6" )
            .licenseId( "bzip2-1.0.6" )
            .seeAlso( "https://github.com/asimonov-im/bzip2/blob/master/LICENSE" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./copyleft-next-0.3.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/copyleft-next-0.3.0.json" )
            .name( "copyleft-next 0.3.0" )
            .licenseId( "copyleft-next-0.3.0" )
            .seeAlso( "https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./copyleft-next-0.3.1.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/copyleft-next-0.3.1.json" )
            .name( "copyleft-next 0.3.1" )
            .licenseId( "copyleft-next-0.3.1" )
            .seeAlso( "https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./curl.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/curl.json" )
            .name( "curl License" )
            .licenseId( "curl" )
            .seeAlso( "https://github.com/bagder/curl/blob/master/COPYING" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./diffmark.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/diffmark.json" )
            .name( "diffmark license" )
            .licenseId( "diffmark" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/diffmark" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/diffmark", "c0491051a1b905d7c4d1af938e9b2c440c127147", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/diffmark", "c0491051a1b905d7c4d1af938e9b2c440c127147", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/diffmark", "c0491051a1b905d7c4d1af938e9b2c440c127147", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/diffmark", "c0491051a1b905d7c4d1af938e9b2c440c127147", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./dvipdfm.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/dvipdfm.json" )
            .name( "dvipdfm License" )
            .licenseId( "dvipdfm" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/dvipdfm" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/dvipdfm", "11ea8b2544554e53e3e4dbc94e236f123c082fbe", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/dvipdfm", "11ea8b2544554e53e3e4dbc94e236f123c082fbe", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/dvipdfm", "11ea8b2544554e53e3e4dbc94e236f123c082fbe", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/dvipdfm", "11ea8b2544554e53e3e4dbc94e236f123c082fbe", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./eCos-2.0.html" )
            .isDeprecatedLicenseId( true )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/eCos-2.0.json" )
            .name( "eCos license version 2.0" )
            .licenseId( "eCos-2.0" )
            .seeAlso( "https://www.gnu.org/licenses/ecos-license.html" )

            .urlInfo( "http://gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .urlInfo( "http://www.gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .urlInfo( "https://gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .urlInfo( "https://www.gnu.org/licenses/ecos-license.html", "75f4827b2f7314ac26a345b750eff70fd32ba663", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./eGenix.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/eGenix.json" )
            .name( "eGenix.com Public License 1.1.0" )
            .licenseId( "eGenix" )
            .seeAlso( "http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0" )

            .urlInfo( "http://egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "https://egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "https://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf", "c49b063afe6f7390cf5603d84d4f71e23a4cbf12", "application/pdf", true, false )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./gSOAP-1.3b.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/gSOAP-1.3b.json" )
            .name( "gSOAP Public License v1.3b" )
            .licenseId( "gSOAP-1.3b" )
            .seeAlso( "http://www.cs.fsu.edu/~engelen/license.html" )

            .urlInfo( "http://www.cs.fsu.edu/~engelen/license.html", "5f4878afcfa16971a9285ae461bf5c01f3f5989d", "text/html", true, false )
            .urlInfo( "https://www.cs.fsu.edu/~engelen/license.html", "5f4878afcfa16971a9285ae461bf5c01f3f5989d", "text/html", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./gnuplot.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/gnuplot.json" )
            .name( "gnuplot License" )
            .licenseId( "gnuplot" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Gnuplot" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Gnuplot", "ea5f748372b5d14642ce2b1c2f901c18a8cc9c3a", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Gnuplot", "ea5f748372b5d14642ce2b1c2f901c18a8cc9c3a", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Gnuplot", "ea5f748372b5d14642ce2b1c2f901c18a8cc9c3a", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Gnuplot", "ea5f748372b5d14642ce2b1c2f901c18a8cc9c3a", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./iMatix.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/iMatix.json" )
            .name( "iMatix Standard Function Library Agreement" )
            .licenseId( "iMatix" )
            .seeAlso( "http://legacy.imatix.com/html/sfl/sfl4.htm#license" )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./libpng-2.0.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/libpng-2.0.json" )
            .name( "PNG Reference Library version 2" )
            .licenseId( "libpng-2.0" )
            .seeAlso( "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt" )

            .urlInfo( "http://libpng.org/pub/png/src/libpng-LICENSE.txt", "e01ba244558d7a6b6729885beb54e9e561583101", "text/plain", true, false )
            .urlInfo( "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt", "e01ba244558d7a6b6729885beb54e9e561583101", "text/plain", true, false )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./libtiff.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/libtiff.json" )
            .name( "libtiff License" )
            .licenseId( "libtiff" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/libtiff" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/libtiff", "708e759486fc725e1b0851aa81832ca930809130", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/libtiff", "708e759486fc725e1b0851aa81832ca930809130", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/libtiff", "708e759486fc725e1b0851aa81832ca930809130", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/libtiff", "708e759486fc725e1b0851aa81832ca930809130", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./mpich2.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/mpich2.json" )
            .name( "mpich2 License" )
            .licenseId( "mpich2" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/MIT" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#enna", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/MIT#feh", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style", "5f9907fe0ec229349cae07b4f774844c18f36698", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./psfrag.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/psfrag.json" )
            .name( "psfrag License" )
            .licenseId( "psfrag" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/psfrag" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/psfrag", "32d44b278ce3c316d8b5b7e2c7dda675cc3f0bfb", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/psfrag", "32d44b278ce3c316d8b5b7e2c7dda675cc3f0bfb", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/psfrag", "32d44b278ce3c316d8b5b7e2c7dda675cc3f0bfb", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/psfrag", "32d44b278ce3c316d8b5b7e2c7dda675cc3f0bfb", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./psutils.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/psutils.json" )
            .name( "psutils License" )
            .licenseId( "psutils" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/psutils" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/psutils", "97bcc435e87889c737af7f96f12b8f9215f19df5", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/psutils", "97bcc435e87889c737af7f96f12b8f9215f19df5", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/psutils", "97bcc435e87889c737af7f96f12b8f9215f19df5", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/psutils", "97bcc435e87889c737af7f96f12b8f9215f19df5", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./wxWindows.html" )
            .isDeprecatedLicenseId( true )
            .detailsUrl( "http://spdx.org/licenses/wxWindows.json" )
            .name( "wxWindows Library License" )
            .licenseId( "wxWindows" )
            .seeAlso( "https://opensource.org/licenses/WXwindows" )

            .urlInfo( "http://opensource.org/licenses/WXwindows", "854619e2b00190d2ef8d92df89d3feace947ae00", "text/html", false, true )
            .urlInfo( "http://www.opensource.org/licenses/WXwindows", "854619e2b00190d2ef8d92df89d3feace947ae00", "text/html", false, true )
            .urlInfo( "https://opensource.org/licenses/WXwindows", "854619e2b00190d2ef8d92df89d3feace947ae00", "text/html", false, true )
            .urlInfo( "https://www.opensource.org/licenses/WXwindows", "854619e2b00190d2ef8d92df89d3feace947ae00", "text/html", false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./xinetd.html" )
            .isDeprecatedLicenseId( false )
            .isFsfLibre( true )
            .detailsUrl( "http://spdx.org/licenses/xinetd.json" )
            .name( "xinetd License" )
            .licenseId( "xinetd" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/Xinetd_License" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/Xinetd_License", "fb9fc73d5d1c4396206b11262ba3114cc5ca8f00", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/Xinetd_License", "fb9fc73d5d1c4396206b11262ba3114cc5ca8f00", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/Xinetd_License", "fb9fc73d5d1c4396206b11262ba3114cc5ca8f00", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/Xinetd_License", "fb9fc73d5d1c4396206b11262ba3114cc5ca8f00", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./xpp.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/xpp.json" )
            .name( "XPP License" )
            .licenseId( "xpp" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/xpp" )

            .urlInfo( "https://fedoraproject.org/wiki/Licensing/xpp", null, null, false, true )
            .isOsiApproved( false )
            .build()
        );

        builder.license( SpdxLicenseInfo.builder()
            .reference( "./zlib-acknowledgement.html" )
            .isDeprecatedLicenseId( false )
            .detailsUrl( "http://spdx.org/licenses/zlib-acknowledgement.json" )
            .name( "zlib/libpng License with Acknowledgement" )
            .licenseId( "zlib-acknowledgement" )
            .seeAlso( "https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement" )

            .urlInfo( "http://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement", "2b8e20ff3942ce7e2e743ce7433caa87cc7fce3e", "text/html", true, true )
            .urlInfo( "http://www.fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement", "2b8e20ff3942ce7e2e743ce7433caa87cc7fce3e", "text/html", true, true )
            .urlInfo( "https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement", "2b8e20ff3942ce7e2e743ce7433caa87cc7fce3e", "text/html", true, true )
            .urlInfo( "https://www.fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement", "2b8e20ff3942ce7e2e743ce7433caa87cc7fce3e", "text/html", true, true )
            .isOsiApproved( false )
            .build()
        );

        builder.releaseDate( "2019-04-02" );

        builder.urlReplacement( "archive.org-0", "(archive\\.org/web/[0-9]+)/", "$1id_/" );
        builder.urlReplacement( "git.kernel.org-0", "https?://git\\.kernel\\.org/pub/scm/linux/([^/]+)/git/torvalds/linux\\.git/tree/(.*)", "https://git.kernel.org/pub/scm/linux/$1/git/torvalds/linux.git/plain/$2" );
        builder.urlReplacement( "git.savannah.gnu.org-0", "https?://git\\.savannah\\.gnu\\.org/cgit/(.*)\\.git/tree/(.*)", "http://git.savannah.gnu.org/cgit/$1.git/plain/$2" );
        builder.urlReplacement( "github.com-0", "https?://github\\.com/([^/]+)/([^/]+)/blob/(.*)", "https://raw.githubusercontent.com/$1/$2/$3" );
        builder.urlReplacement( "github.com/aws/mit-0", ".*github\\.com/aws/mit-0", "https://raw.githubusercontent.com/aws/mit-0/master/MIT-0" );
        builder.urlReplacement( "microsoft.com/opensource/licenses.mspx", ".*microsoft\\.com/opensource/licenses\\.mspx", "https://web.archive.org/web/20150619132250id_/http://www.microsoft.com/en-us/openness/licenses.aspx" );
        builder.urlReplacement( "mozilla.org/MPL/MPL-1.1.txt", ".*\\Q.mozilla.org/MPL/MPL-1.1.txt\\E", "https://www.mozilla.org/media/MPL/1.1/index.0c5913925d40.txt" );
        builder.urlReplacement( "repository.jboss.com/licenses", "https?://repository\\.jboss\\.com/licenses/(.*)", "https://web.archive.org/web/20171202125112id_/http://repository.jboss.com/licenses/$1" );

        builder.contentSanitizer( "artlibre.org-0", ".*artlibre\\.org.*", "<!-- Dynamic page generated in [^\\-]+ -->", "" );
        builder.contentSanitizer( "artlibre.org-1", ".*artlibre\\.org.*", "<!-- Cached page generated by WP-Super-Cache on [^\\>]+ -->", "" );
        builder.contentSanitizer( "codeproject.com-0", ".*codeproject\\.com.*", ">[^<]+members<", "><" );
        builder.contentSanitizer( "codeproject.com-1", ".*codeproject\\.com.*", "<div class=\"promo\">[^\\n]+", "" );
        builder.contentSanitizer( "codeproject.com-2", ".*codeproject\\.com.*", "<div class=\"msg-728x90\"[^\\n]+", "" );
        builder.contentSanitizer( "codeproject.com-3", ".*codeproject\\.com.*", "<br />\\s*[^\\s]+\\s*\\|\\s*[^\\s]+\\s*\\|", "" );
        builder.contentSanitizer( "creativecommons.org-0", ".*creativecommons\\.org.*", "\\n ", "\\n" );
        builder.contentSanitizer( "data.norge.no-0", ".*data\\.norge\\.no.*", "jQuery\\.extend\\(Drupal\\.settings[^\\n]+", "" );
        builder.contentSanitizer( "data.norge.no-1", ".*data\\.norge\\.no.*", "value=\"form-[^\"]*\"", "" );
        builder.contentSanitizer( "data.norge.no-2", ".*data\\.norge\\.no.*", "view-dom-id-[0-9a-f]{12}", "" );
        builder.contentSanitizer( "directory.fsf.org-0", ".*directory\\.fsf\\.org.*", "\"wgRequestId\":\"[^\"]*\"", "\"wgRequestId\":\"\"" );
        builder.contentSanitizer( "directory.fsf.org-1", ".*directory\\.fsf\\.org.*", "\"wgBackendResponseTime\":[0-9]+", "\"wgBackendResponseTime\":0" );
        builder.contentSanitizer( "eu-datagrid.web.cern.ch-0", ".*eu-datagrid\\.web\\.cern\\.ch.*", "wct=[^&\"]+", "wct=" );
        builder.contentSanitizer( "fedoraproject.org-0", ".*fedoraproject\\.org.*", "\"wgRequestId\":\"[^\"]*\"", "\"wgRequestId\":\"\"" );
        builder.contentSanitizer( "fedoraproject.org-1", ".*fedoraproject\\.org.*", "\"wgBackendResponseTime\":[0-9]+", "\"wgBackendResponseTime\":0" );
        builder.contentSanitizer( "gianluca.dellavedova.org-0", ".*gianluca\\.dellavedova\\.org.*", "<script src='https://r-login\\.wordpress\\.com[^\\n]*", "" );
        builder.contentSanitizer( "gianluca.dellavedova.org-1", ".*gianluca\\.dellavedova\\.org.*", "type=\"[0-9a-f]+-text/javascript\"", "type=\"text/javascript\"" );
        builder.contentSanitizer( "gianluca.dellavedova.org-2", ".*gianluca\\.dellavedova\\.org.*", "data-cf-modified-[^\\-]+-", "data-cf-modified--" );
        builder.contentSanitizer( "gianluca.dellavedova.org-3", ".*gianluca\\.dellavedova\\.org.*", "atatags-[^\\-\"]+-[^\\-\"]+", "atatags--" );
        builder.contentSanitizer( "joinup.ec.europa.eu-0", ".*joinup\\.ec\\.europa\\.eu.*", "<script type=\"text/javascript\">window\\.NREUM[^\\n]*</script>", "" );
        builder.contentSanitizer( "ohwr.org-0", ".*ohwr\\.org.*", "<meta name=\"csrf-token\"[^\\n]+", "" );
        builder.contentSanitizer( "opencascade.org-0", ".*opencascade\\.com.*", "jQuery\\.extend\\(Drupal\\.settings[^\\n]+", "" );
        builder.contentSanitizer( "opencascade.org-1", ".*opencascade\\.com.*", "value=\"form-[^\"]*\"", "" );
        builder.contentSanitizer( "opensource.org-0", ".*opensource\\.org.*", "jQuery\\.extend\\(Drupal\\.settings[^\\n]+", "" );
        builder.contentSanitizer( "opensource.org-1", ".*opensource\\.org.*", "value=\"form-[^\"]*\"", "" );
        builder.contentSanitizer( "opensource.org-2", ".*opensource\\.org.*", "<form action=\"/licenses/[^\"]*\"", "<form action=\"\"" );
        builder.contentSanitizer( "romanrm.net-0", ".*romanrm.net/mit-zero", "src=\"/lib/exe/indexer\\.php\\?id=mit-zero&amp;[0-9]+\"", "" );
        builder.contentSanitizer( "tcl.tk-0", ".*tcl\\.tk.*", "email-protection#[0-9a-f]+", "email-protection" );
        builder.contentSanitizer( "tcl.tk-1", ".*tcl\\.tk.*", "data-cfemail=\"[^\"]+\"", "data-cfemail=\"\"" );
        builder.contentSanitizer( "users.on.net/~triforce-0", ".*users\\.on\\.net/~triforce/glidexp/COPYING\\.txt", "[0-9]+ queries[^\\-]", "" );
        builder.contentSanitizer( "users.on.net/~triforce-1", ".*users\\.on\\.net/~triforce/glidexp/COPYING\\.txt", "<!-- [^\\-<>]+ in [^\\-<>]+ -->", "" );
        builder.contentSanitizer( "zimbra.com-0", ".*zimbra\\.com.*", "Compiled on [^D]+ - Do not edit", "" );

        return builder.build();
    }
}
