/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.FileState;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderProcessor;
import org.codehaus.mojo.license.header.InvalideFileHeaderException;
import org.codehaus.mojo.license.header.UpdateFileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.JavaFileHeaderTransformer;
import org.codehaus.mojo.license.model.Copyright;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileHeaderMojo
extends AbstractLicenseNameMojo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileHeaderMojo.class);
    @Parameter(property="license.processStartTag")
    private String processStartTag;
    @Parameter(property="license.processEndTag")
    private String processEndTag;
    @Parameter(property="license.sectionDelimiter")
    private String sectionDelimiter;
    @Parameter(property="license.lineSeparator")
    private String lineSeparator;
    @Parameter(property="license.addSvnKeyWords", defaultValue="false")
    private boolean addSvnKeyWords;
    @Parameter(property="license.canUpdateDescription", defaultValue="false")
    private boolean canUpdateDescription;
    @Parameter(property="license.canUpdateCopyright", defaultValue="false")
    private boolean canUpdateCopyright;
    @Parameter(property="license.canUpdateLicense", defaultValue="true")
    private boolean canUpdateLicense;
    @Parameter(property="license.ignoreTag")
    private String ignoreTag;
    @Parameter(property="license.addJavaLicenseAfterPackage", defaultValue="true")
    private boolean addJavaLicenseAfterPackage;
    @Parameter(property="license.useJavaNoReformatCommentStartTag", defaultValue="true")
    private boolean useJavaNoReformatCommentStartTag;
    @Parameter(property="license.emptyLineAfterHeader", defaultValue="false")
    private boolean emptyLineAfterHeader;
    @Parameter(property="license.trimHeaderLine", defaultValue="false")
    private boolean trimHeaderLine;
    @Parameter(property="license.ignoreNoFileToScan", defaultValue="false")
    private boolean ignoreNoFileToScan;
    @Parameter(property="license.roots")
    private String[] roots;
    @Parameter(property="license.includes")
    private String[] includes;
    @Parameter(property="license.excludes")
    private String[] excludes;
    @Parameter
    private Map<String, String> extraExtensions;
    @Parameter
    private Map<String, String> extraFiles;
    @Parameter(property="license.descriptionTemplate", defaultValue="/org/codehaus/mojo/license/default-file-header-description.ftl")
    private String descriptionTemplate;
    @Component(role=FileHeaderTransformer.class)
    private Map<String, FileHeaderTransformer> transformers;
    private long timestamp;
    private Map<String, String> extensionToCommentStyle;
    private Template descriptionTemplate0;
    private Set<File> processedFiles;
    EnumMap<FileState, Set<File>> result;
    private Map<String, List<File>> filesToTreatByCommentStyle;
    private FreeMarkerHelper freeMarkerHelper = FreeMarkerHelper.newDefaultHelper();

    protected abstract boolean isDryRun();

    protected abstract boolean isFailOnMissingHeader();

    protected abstract boolean isFailOnNotUptodateHeader();

    @Override
    public void init() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ignoreTag)) {
            this.ignoreTag = "%%Ignore-License";
        }
        if (!this.isDryRun()) {
            if (this.isFailOnMissingHeader()) {
                LOG.warn("The failOnMissingHeader has no effect if the property dryRun is not set.");
            }
            if (this.isFailOnNotUptodateHeader()) {
                LOG.warn("The failOnNotUptodateHeader has no effect if the property dryRun is not set.");
            }
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String string = "\n  * %1$s (%2$s)";
            for (String transformerName : this.transformers.keySet()) {
                FileHeaderTransformer aTransformer = this.getTransformer(this.transformers, transformerName);
                String str = String.format(string, aTransformer.getName(), aTransformer.getDescription());
                buffer.append(str);
            }
            LOG.info("{}", (Object)buffer);
        }
        this.timestamp = System.nanoTime();
        super.init();
        if (this.roots == null || this.roots.length == 0) {
            this.roots = DEFAULT_ROOTS;
            if (this.isVerbose()) {
                LOG.info("Will use default roots {}", (Object)this.roots);
            }
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
            if (this.isVerbose()) {
                LOG.info("Will use default includes {}", (Object)this.includes);
            }
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            if (this.isVerbose()) {
                LOG.info("Will use default excludes {}", (Object)this.excludes);
            }
        }
        this.extensionToCommentStyle = new TreeMap<String, String>();
        this.processStartTag = this.cleanHeaderConfiguration(this.processStartTag, "#%L");
        if (this.isVerbose()) {
            LOG.info("Will use processStartTag: {}", (Object)this.processStartTag);
        }
        this.processEndTag = this.cleanHeaderConfiguration(this.processEndTag, "#L%");
        if (this.isVerbose()) {
            LOG.info("Will use processEndTag: {}", (Object)this.processEndTag);
        }
        this.sectionDelimiter = this.cleanHeaderConfiguration(this.sectionDelimiter, "%%");
        if (this.isVerbose()) {
            LOG.info("Will use sectionDelimiter: {}", (Object)this.sectionDelimiter);
        }
        for (Map.Entry<String, FileHeaderTransformer> entry : this.transformers.entrySet()) {
            String[] extensions;
            String commentStyle = entry.getKey();
            FileHeaderTransformer aTransformer = entry.getValue();
            aTransformer.setProcessStartTag(this.processStartTag);
            aTransformer.setProcessEndTag(this.processEndTag);
            aTransformer.setSectionDelimiter(this.sectionDelimiter);
            aTransformer.setEmptyLineAfterHeader(this.emptyLineAfterHeader);
            aTransformer.setTrimHeaderLine(this.trimHeaderLine);
            aTransformer.setLineSeparator(this.lineSeparator);
            if (aTransformer instanceof JavaFileHeaderTransformer) {
                JavaFileHeaderTransformer javaFileHeaderTransformer = (JavaFileHeaderTransformer)aTransformer;
                javaFileHeaderTransformer.setAddJavaLicenseAfterPackage(this.addJavaLicenseAfterPackage);
                javaFileHeaderTransformer.setUseNoReformatCommentStartTag(this.useJavaNoReformatCommentStartTag);
            }
            for (String extension : extensions = aTransformer.getDefaultAcceptedExtensions()) {
                if (this.isVerbose()) {
                    LOG.info("Associate extension '{}' to comment style '{}'", (Object)extension, (Object)commentStyle);
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraExtensions != null) {
            for (Map.Entry<String, Object> entry : this.extraExtensions.entrySet()) {
                String extension = entry.getKey();
                if (this.extensionToCommentStyle.containsKey(extension)) {
                    LOG.warn("The extension '{}' is already accepted for comment style '{}'", (Object)extension, (Object)this.extensionToCommentStyle.get(extension));
                }
                String commentStyle = (String)entry.getValue();
                this.getTransformer(this.transformers, commentStyle);
                if (this.isVerbose()) {
                    LOG.info("Associate extension '{}' to comment style '{}'", (Object)extension, (Object)commentStyle);
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraFiles == null) {
            this.extraFiles = Collections.emptyMap();
        }
        this.filesToTreatByCommentStyle = this.obtainFilesToProcessByCommentStyle(this.extraFiles, this.roots, this.includes, this.excludes, this.extensionToCommentStyle, this.transformers);
        if (this.isVerbose()) {
            LOG.info("Use description template: {}", (Object)this.descriptionTemplate);
        }
        this.descriptionTemplate0 = this.freeMarkerHelper.getTemplate(this.descriptionTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        long t0 = System.nanoTime();
        this.processedFiles = new HashSet<File>();
        this.result = new EnumMap(FileState.class);
        try {
            for (Map.Entry<String, List<File>> commentStyleFiles : this.filesToTreatByCommentStyle.entrySet()) {
                String commentStyle = commentStyleFiles.getKey();
                List<File> files = commentStyleFiles.getValue();
                this.processCommentStyle(commentStyle, files);
            }
        }
        catch (Throwable throwable) {
            this.checkResults(this.result);
            int nbFiles = this.processedFiles.size();
            if (nbFiles == 0 && !this.ignoreNoFileToScan) {
                LOG.warn("No file to scan.");
            } else {
                String delay = MojoHelper.convertTime(System.nanoTime() - t0);
                String message = String.format("Scan %s file%s header done in %s.", nbFiles, nbFiles > 1 ? "s" : "", delay);
                LOG.info(message);
            }
            Set<FileState> states = this.result.keySet();
            if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
                LOG.info("All files are up-to-date.");
            } else {
                StringBuilder buffer = new StringBuilder();
                for (FileState state : FileState.values()) {
                    this.reportType(this.result, state, buffer);
                }
                LOG.info(buffer.toString());
            }
            throw throwable;
        }
        this.checkResults(this.result);
        int nbFiles = this.processedFiles.size();
        if (nbFiles == 0 && !this.ignoreNoFileToScan) {
            LOG.warn("No file to scan.");
        } else {
            String delay = MojoHelper.convertTime(System.nanoTime() - t0);
            String message = String.format("Scan %s file%s header done in %s.", nbFiles, nbFiles > 1 ? "s" : "", delay);
            LOG.info(message);
        }
        Set<FileState> states = this.result.keySet();
        if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
            LOG.info("All files are up-to-date.");
        } else {
            StringBuilder buffer = new StringBuilder();
            for (FileState state : FileState.values()) {
                this.reportType(this.result, state, buffer);
            }
            LOG.info(buffer.toString());
        }
    }

    private void checkResults(EnumMap<FileState, Set<File>> result) throws MojoFailureException {
        String message;
        List<File> files;
        Set<FileState> states = result.keySet();
        StringBuilder builder = new StringBuilder();
        if (this.isDryRun() && this.isFailOnMissingHeader() && states.contains((Object)FileState.add)) {
            files = FileUtil.orderFiles((Collection<File>)result.get((Object)FileState.add));
            builder.append("There are ").append(files.size()).append(" file(s) with no header :");
            for (File file : files) {
                builder.append("\n").append(file);
            }
        }
        if (this.isDryRun() && this.isFailOnNotUptodateHeader() && states.contains((Object)FileState.update)) {
            files = FileUtil.orderFiles((Collection<File>)result.get((Object)FileState.update));
            builder.append("\nThere are ").append(files.size()).append(" file(s) with header to update:");
            for (File file : files) {
                builder.append("\n").append(file);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(message = builder.toString()))) {
            throw new MojoFailureException(builder.toString());
        }
    }

    private void processCommentStyle(String commentStyle, List<File> filesToTreat) throws IOException {
        License license = this.getLicense(this.getLicenseName(), true);
        if (this.isVerbose()) {
            LOG.info("Process header '{}'", (Object)commentStyle);
            LOG.info(" - using {}", (Object)license.getDescription());
        }
        FileHeaderTransformer transformer = this.getTransformer(this.transformers, commentStyle);
        FileHeaderProcessor processor = this.getFileHeaderProcessor(license, transformer);
        for (File file : filesToTreat) {
            this.processFile(processor, file);
        }
        filesToTreat.clear();
    }

    private FileHeaderProcessor getFileHeaderProcessor(License license, FileHeaderTransformer transformer) throws IOException {
        FileHeader header = new FileHeader();
        if (this.inceptionYear == null) {
            LOG.warn("No inceptionYear defined (will use current year)");
        }
        Copyright copyright = this.getCopyright(this.getCopyrightOwners());
        header.setCopyright(copyright);
        String licenseContent = license.getHeaderContent(this.getEncoding());
        if (license.isHeaderContentTemplateAware()) {
            licenseContent = this.processLicenseContext(licenseContent);
        }
        header.setLicense(licenseContent);
        UpdateFileHeaderFilter filter = new UpdateFileHeaderFilter();
        filter.setUpdateCopyright(this.canUpdateCopyright);
        filter.setUpdateDescription(this.canUpdateDescription);
        filter.setUpdateLicense(this.canUpdateLicense);
        return new FileHeaderProcessor(filter, header, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(FileHeaderProcessor processor, File file) throws IOException {
        if (this.processedFiles.contains(file)) {
            LOG.info(" - skip already processed file {}", (Object)file);
            return;
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
        boolean doFinalize = false;
        try {
            doFinalize = this.processFile(processor, file, processFile);
        }
        catch (Exception e) {
            LOG.warn("skip failed file: " + e.getMessage() + (e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage()), (Throwable)e);
            FileState.fail.addFile(file, this.result);
            doFinalize = false;
        }
        finally {
            this.processedFiles.add(file);
            if (doFinalize) {
                this.finalizeFile(file, processFile);
            } else {
                FileUtil.deleteFile(processFile);
            }
        }
    }

    private boolean processFile(FileHeaderProcessor processor, File file, File processFile) throws IOException {
        String content;
        if (this.getLog().isDebugEnabled()) {
            LOG.debug(" - process file {}", (Object)file);
            LOG.debug(" - will process into file {}", (Object)processFile);
        }
        HashMap<String, Object> descriptionParameters = new HashMap<String, Object>();
        descriptionParameters.put("project", this.getProject());
        descriptionParameters.put("addSvnKeyWords", this.addSvnKeyWords);
        descriptionParameters.put("projectName", this.projectName);
        descriptionParameters.put("inceptionYear", this.inceptionYear);
        descriptionParameters.put("organizationName", this.organizationName);
        descriptionParameters.put("file", file);
        LOG.debug("Description parameters: {}", descriptionParameters);
        String description = this.freeMarkerHelper.renderTemplate(this.descriptionTemplate0, descriptionParameters);
        processor.updateDescription(description);
        LOG.debug("header description : " + processor.getFileHeaderDescription());
        try {
            content = FileUtil.readAsString(file, this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.ignoreTag)) {
            LOG.info(" - ignore file (detected {}) {}", (Object)this.ignoreTag, (Object)file);
            FileState.ignore.addFile(file, this.result);
            return false;
        }
        try {
            processor.process(content, processFile, this.getEncoding());
        }
        catch (IllegalStateException e) {
            throw new InvalideFileHeaderException("Could not extract header on file " + file + " for reason " + e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof InvalideFileHeaderException) {
                throw (InvalideFileHeaderException)e;
            }
            throw new IOException("Could not process file " + file + " for reason " + e.getMessage());
        }
        if (processor.isTouched()) {
            if (this.isVerbose()) {
                LOG.info(" - header was updated for {}", (Object)file);
            }
            if (processor.isModified()) {
                FileState.update.addFile(file, this.result);
                return true;
            }
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        if (processor.isDetectHeader()) {
            throw new InvalideFileHeaderException("Could not find header end on file " + file);
        }
        if (this.isVerbose()) {
            LOG.info(" - adding license header on file {}", (Object)file);
        }
        content = processor.addHeader(content);
        if (!this.isDryRun()) {
            FileUtil.printString(processFile, content, this.getEncoding());
        }
        FileState.add.addFile(file, this.result);
        return true;
    }

    private void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.isDryRun()) {
            File backupFile = FileUtil.getBackupFile(file);
            if (backupFile.exists()) {
                FileUtil.deleteFile(backupFile);
            }
            LOG.debug(" - backup original file {}", (Object)file);
            Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (this.isDryRun()) {
            FileUtil.deleteFile(processFile);
        } else {
            try {
                String updatedContent = FileUtil.readAsString(processFile, this.getEncoding());
                FileUtil.printString(file, updatedContent, this.getEncoding());
                FileUtil.deleteFile(processFile);
            }
            catch (IOException e) {
                LOG.warn("Error updating {} -> {}", new Object[]{processFile, file, e});
            }
        }
    }
}

