/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.download.License;
import org.codehaus.mojo.license.download.LicensedArtifact;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class LicensedArtifactResolver {
    private static final Logger LOG = LoggerFactory.getLogger(LicensedArtifactResolver.class);
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Inject
    private ProjectBuilder mavenProjectBuilder;
    @Inject
    private Provider<MavenSession> mavenSessionProvider;

    public void loadProjectDependencies(ResolvedProjectDependencies artifacts, MavenProjectDependenciesConfigurator configuration, List<ArtifactRepository> remoteRepositories, Map<String, LicensedArtifact> result) {
        ArtifactFilters artifactFilters = configuration.getArtifactFilters();
        boolean excludeTransitiveDependencies = configuration.isExcludeTransitiveDependencies();
        Set<Artifact> depArtifacts = configuration.isIncludeTransitiveDependencies() ? artifacts.getAllDependencies() : artifacts.getDirectDependencies();
        boolean verbose = configuration.isVerbose();
        HashMap<String, Artifact> excludeArtifacts = new HashMap<String, Artifact>();
        HashMap<String, Artifact> includeArtifacts = new HashMap<String, Artifact>();
        ProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(((MavenSession)this.mavenSessionProvider.get()).getProjectBuildingRequest()).setRemoteRepositories(remoteRepositories).setValidationLevel(0).setResolveDependencies(false).setProcessPlugins(false);
        for (Artifact artifact : depArtifacts) {
            LicensedArtifact depMavenProject;
            excludeArtifacts.put(artifact.getId(), artifact);
            if ("license.properties".equals(artifact.getType())) continue;
            if (!artifactFilters.isIncluded(artifact)) {
                LOG.debug("Excluding artifact {}", (Object)artifact);
                continue;
            }
            String id = MojoHelper.getArtifactId(artifact);
            if (verbose) {
                LOG.info("detected artifact {}", (Object)id);
            }
            if ((depMavenProject = result.get(id)) != null) {
                LOG.debug("Dependency [{}] already present in the result", (Object)id);
            } else {
                LicensedArtifact.Builder laBuilder = LicensedArtifact.builder(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                try {
                    MavenProject project = this.mavenProjectBuilder.build(artifact, true, projectBuildingRequest).getProject();
                    List lics = project.getLicenses();
                    if (lics != null) {
                        for (org.apache.maven.model.License lic : lics) {
                            laBuilder.license(new License(lic.getName(), lic.getUrl(), lic.getDistribution(), lic.getComments()));
                        }
                    }
                }
                catch (ProjectBuildingException e) {
                    laBuilder.errorMessage("Could not create effective POM for '" + id + "': " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage());
                }
                depMavenProject = laBuilder.build();
                if (verbose) {
                    LOG.info("add dependency [{}]", (Object)id);
                }
                result.put(id, depMavenProject);
            }
            excludeArtifacts.remove(artifact.getId());
            includeArtifacts.put(artifact.getId(), artifact);
        }
        if (excludeTransitiveDependencies) {
            for (Map.Entry entry : includeArtifacts.entrySet()) {
                List dependencyTrail = ((Artifact)entry.getValue()).getDependencyTrail();
                boolean remove = false;
                for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
                    if (!excludeArtifacts.containsKey(dependencyTrail.get(i))) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                result.remove(MojoHelper.getArtifactId((Artifact)entry.getValue()));
            }
        }
    }
}

