/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractThirdPartyReport;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="aggregate-third-party-report", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AggregatorThirdPartyReport
extends AbstractThirdPartyReport {
    @Parameter(property="license.skipAggregateThirdPartyReport", defaultValue="false")
    private boolean skipAggregateThirdPartyReport;
    @Parameter(property="license.executeOnlyOnRootModule", alias="aggregateThirdPartyReport.executeOnlyOnRootModule", defaultValue="true")
    private boolean executeOnlyOnRootModule;

    @Inject
    public AggregatorThirdPartyReport(I18N i18n, DependenciesTool dependenciesTool, ThirdPartyTool thirdPartyTool) {
        super(i18n, dependenciesTool, thirdPartyTool);
    }

    @Deprecated
    public String getOutputName() {
        return "aggregate-third-party-report";
    }

    public boolean canGenerateReport() {
        return !this.skipAggregateThirdPartyReport && (!this.executeOnlyOnRootModule || this.getProject().isExecutionRoot());
    }

    @Override
    protected Collection<ThirdPartyDetails> createThirdPartyDetails() throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException, DependenciesToolException, MojoExecutionException {
        LinkedHashSet<ThirdPartyDetails> details = new LinkedHashSet<ThirdPartyDetails>();
        for (MavenProject reactorProject : this.reactorProjects) {
            Collection<ThirdPartyDetails> thirdPartyDetails = this.createThirdPartyDetails(reactorProject, true);
            details.addAll(thirdPartyDetails);
        }
        return details;
    }
}

