/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make.util;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ChownMojo
extends AbstractMojo {
    private String user;
    private String group;
    private boolean recursive;
    private List<String> chownPaths;
    private CommandLineManager cliManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Commandline chown = new Commandline();
        chown.setExecutable("sudo");
        chown.createArg().setLine("chown");
        if (this.recursive) {
            chown.createArg().setLine("-R");
        }
        String ownership = this.user;
        if (this.group != null) {
            ownership = ownership + ":" + this.group;
        }
        chown.createArg().setLine(ownership);
        String aggregatedPaths = StringUtils.join(this.chownPaths.iterator(), (String)" ");
        chown.createArg().setLine(aggregatedPaths);
        try {
            StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
            int result = this.cliManager.execute(chown, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("chown command returned an exit value != 0. Aborting build; see command output above for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to execute chown with ownership: " + ownership + " on files:\n" + this.chownPaths + "\n\nReason: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

