/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.api;

import java.util.Stack;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileSystem;

public abstract class AbstractEntry
implements Entry {
    private static final long serialVersionUID = 1L;
    private final FileSystem fileSystem;
    private final DirectoryEntry parent;
    private final String name;

    protected AbstractEntry(FileSystem fileSystem, DirectoryEntry parent, String name) {
        this.fileSystem = fileSystem;
        this.parent = parent;
        this.name = name;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public DirectoryEntry getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEntry)) {
            return false;
        }
        AbstractEntry abstractEntry = (AbstractEntry)o;
        if (!this.fileSystem.equals(abstractEntry.fileSystem)) {
            return false;
        }
        if (!this.name.equals(abstractEntry.name)) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(abstractEntry.parent) : abstractEntry.parent != null);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entry[");
        sb.append(this.fileSystem);
        sb.append(':').append(this.toPath()).append(']');
        return sb.toString();
    }

    public final String toPath() {
        Stack<String> stack = new Stack<String>();
        DirectoryEntry root = this.getFileSystem().getRoot();
        for (Entry entry = this; entry != null && !root.equals(entry); entry = entry.getParent()) {
            stack.push(entry.getName());
        }
        StringBuffer buf = new StringBuffer();
        while (!stack.empty()) {
            buf.append('/');
            buf.append(stack.pop());
        }
        return buf.toString();
    }
}

