/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.util.ArrayList;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.impl.digest.AutoDigestFileSystem;
import org.codehaus.mojo.mrm.impl.maven.ArtifactStoreFileSystem;
import org.codehaus.mojo.mrm.impl.maven.CompositeArtifactStore;
import org.codehaus.mojo.mrm.plugin.AbstractMRMMojo;
import org.codehaus.mojo.mrm.plugin.ArtifactStoreFactory;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;
import org.codehaus.mojo.mrm.plugin.FactoryHelperRequired;
import org.codehaus.mojo.mrm.plugin.FileSystemServer;
import org.codehaus.mojo.mrm.plugin.ProxyRepo;

public abstract class AbstractStartMojo
extends AbstractMRMMojo {
    @Parameter(property="mrm.port")
    private int port;
    @Parameter
    private ArtifactStoreFactory[] repositories;

    protected FileSystemServer createFileSystemServer(ArtifactStore artifactStore) {
        return new FileSystemServer(ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId()), Math.max(0, Math.min(this.port, 65535)), (FileSystem)new AutoDigestFileSystem((FileSystem)new ArtifactStoreFileSystem(artifactStore)), this.getSettingsServletPath());
    }

    protected String getSettingsServletPath() {
        return null;
    }

    protected ArtifactStore createArtifactStore() throws MojoExecutionException {
        if (this.repositories == null) {
            this.getLog().info((CharSequence)"Configuring Mock Repository Manager to proxy through this Maven instance");
            return this.createProxyArtifactStore();
        }
        this.getLog().info((CharSequence)"Configuring Mock Repository Manager...");
        ArrayList<ArtifactStore> stores = new ArrayList<ArtifactStore>();
        if (this.repositories == null || this.repositories.length == 0) {
            this.repositories = new ArtifactStoreFactory[]{new ProxyRepo()};
        }
        FactoryHelper helper = this.createFactoryHelper();
        for (ArtifactStoreFactory artifactStoreFactory : this.repositories) {
            if (artifactStoreFactory instanceof FactoryHelperRequired) {
                ((FactoryHelperRequired)artifactStoreFactory).setFactoryHelper(helper);
            }
            this.getLog().info((CharSequence)("  " + artifactStoreFactory.toString()));
            stores.add(artifactStoreFactory.newInstance());
        }
        ArtifactStore[] artifactStores = stores.toArray(new ArtifactStore[stores.size()]);
        return artifactStores.length == 1 ? artifactStores[0] : new CompositeArtifactStore(artifactStores);
    }
}

