/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.net.UnknownHostException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.mrm.plugin.AbstractStartMojo;
import org.codehaus.mojo.mrm.plugin.ConsoleScanner;
import org.codehaus.mojo.mrm.plugin.FileSystemServer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="run", requiresProject=false, requiresDirectInvocation=true, threadSafe=true)
public class RunMojo
extends AbstractStartMojo {
    @Parameter(property="mrm.settingsServletPath", defaultValue="settings-mrm.xml")
    private String settingsServletPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.session.getSettings().isInteractiveMode()) {
            throw new MojoExecutionException("Cannot run a mock repository in batch mode (as there is no way to signal shutdown) use mrm:start instead");
        }
        FileSystemServer mrm = this.createFileSystemServer(this.createArtifactStore());
        this.getLog().info((CharSequence)"Starting Mock Repository Manager");
        mrm.ensureStarted();
        String url = mrm.getUrl();
        try {
            this.getLog().info((CharSequence)("Mock Repository Manager " + url + " is started."));
            if (StringUtils.isNotEmpty((String)this.settingsServletPath)) {
                String downloadUrl;
                try {
                    downloadUrl = mrm.getRemoteUrl();
                }
                catch (UnknownHostException e) {
                    downloadUrl = mrm.getUrl();
                }
                String settings = FileUtils.filename((String)this.settingsServletPath);
                this.getLog().info((CharSequence)("To share this repository manager, let users download " + downloadUrl + "/" + this.settingsServletPath));
                this.getLog().info((CharSequence)("Maven should be started as 'mvn --settings " + settings + " [phase|goal]'"));
            }
            ConsoleScanner consoleScanner = new ConsoleScanner();
            consoleScanner.start();
            this.getLog().info((CharSequence)"Hit ENTER on the console to stop the Mock Repository Manager and continue the build.");
            consoleScanner.waitForFinished();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.getLog().info((CharSequence)("Stopping Mock Repository Manager " + url));
            mrm.finish();
            try {
                mrm.waitForFinished();
                this.getLog().info((CharSequence)("Mock Repository Manager " + url + " is stopped."));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected String getSettingsServletPath() {
        return this.settingsServletPath;
    }
}

