/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.TreeMap;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.LinkFileEntry;

public class CompositeFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private final FileSystem[] delegates;
    private final DirectoryEntry root = new DefaultDirectoryEntry((FileSystem)this, null, "");

    public CompositeFileSystem(FileSystem[] delegates) {
        delegates.getClass();
        this.delegates = delegates;
    }

    public Entry[] listEntries(DirectoryEntry directory) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (int i = 0; i < this.delegates.length; ++i) {
            Entry[] entries = this.delegates[i].listEntries(DefaultDirectoryEntry.equivalent((FileSystem)this.delegates[i], (DirectoryEntry)directory));
            if (entries == null) continue;
            for (int j = 0; j < entries.length; ++j) {
                if (result.containsKey(entries[j].getName())) continue;
                if (entries[j] instanceof DirectoryEntry) {
                    result.put(entries[j].getName(), new DefaultDirectoryEntry((FileSystem)this, directory, entries[j].getName()));
                    continue;
                }
                if (!(entries[j] instanceof FileEntry)) continue;
                result.put(entries[j].getName(), (Object)new LinkFileEntry(this, directory, (FileEntry)entries[j]));
            }
        }
        return result.values().toArray(new Entry[result.size()]);
    }

    public Entry get(String path) {
        for (int i = 0; i < this.delegates.length; ++i) {
            Entry entry = this.delegates[i].get(path);
            if (entry == null) continue;
            if (entry instanceof DirectoryEntry) {
                return DefaultDirectoryEntry.equivalent((FileSystem)this, (DirectoryEntry)((DirectoryEntry)entry));
            }
            return entry;
        }
        return null;
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        long lastModified = 0L;
        for (int i = 0; i < this.delegates.length; ++i) {
            try {
                lastModified = Math.max(lastModified, this.delegates[i].getLastModified(entry));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return lastModified;
    }

    public DirectoryEntry getRoot() {
        return this.root;
    }

    public DirectoryEntry mkdir(DirectoryEntry parent, String name) {
        throw new UnsupportedOperationException();
    }

    public FileEntry put(DirectoryEntry parent, String name, InputStream content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileEntry put(DirectoryEntry parent, String name, byte[] content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void remove(Entry entry) {
        throw new UnsupportedOperationException();
    }
}

